.386

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: SrcBLT 8BPP source bitmap to 8BPP destination bitmap             ;
;                                                                            ;
;       8BPP source BLT copies a rectangular region of a source bitmap       ;
;       to a same sized rectangular region on a destiantion bitmap using     ;
;       a binary ROP to combine source pixels with destination pixels.       ;
;       The case of source and destination being the same is handled         ;
;       correclty by BLTting up or down, left or right.  The procedure uses  ;
;       a generic main loop that calls individual scanline BLT procedures    ;
;       based upon the ROP and the horizontal BLT direction.                 ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       05/07/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

                INCLUDE BITBLT.INC

_TEXT           SEGMENT PUBLIC WORD USE16 'CODE'

pDst            EQU     [bp + 34]
pDstSegmnt      EQU     [bp + 36]
pDstOffset      EQU     [bp + 34]
dyDst           EQU     [bp + 32]
cDstScanSeg     EQU     [bp + 30]
cDstFillBytes   EQU     [bp + 28]
xDst            EQU     [bp + 26]
yDst            EQU     [bp + 24]
pSrc            EQU     [bp + 20]
pSrcSegmnt      EQU     [bp + 22]
pSrcOffset      EQU     [bp + 20]
dySrc           EQU     [bp + 18]
cSrcScanSeg     EQU     [bp + 16]
cSrcFillBytes   EQU     [bp + 14]
xSrc            EQU     [bp + 12]
ySrc            EQU     [bp + 10]
xSize           EQU     [bp + 8]
ySize           EQU     [bp + 6]
rop             EQU     [bp + 4]

pSrcScan        EQU     [bp - 2]
pDstScan        EQU     [bp - 4]
cSrcScan        EQU     [bp - 6]
cDstScan        EQU     [bp - 8]
cDstByte        EQU     [bp - 10]
pfnScanBlt      EQU     [bp - 12]
Flags           EQU     [bp - 14]

mempBltSD88Tbl  DW      0000h,        mempBltSD88r1, mempBltSD88r2, mempBltSD88r3
                DW      mempBltSD88r4, 0000h,        mempBltSD88r6, mempBltSD88r7
                DW      mempBltSD88r8, mempBltSD88r9, 0000h,        mempBltSD88rB
                DW      mempBltSD88rC, mempBltSD88rD, mempBltSD88rE, 0000h

memBltSD_ColorToColor   PROC NEAR
        
        push    bp
        mov     bp, sp
        sub     sp, 16
        push    ds
        push    es
        push    si
        push    di
;
; Check vertical BLT direction.
;
CheckYDir:
        mov     ax, ySrc
        mov     bx, yDst
        cmp     ax, bx
        jb      @F
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     BYTE PTR Flags, bTopToBottom
        bmScanAddrInc cSrcScanSeg, dySrc, cSrcScan, pSrcSegmnt, pSrcOffset
        mov     ds, dx
        mov     si, ax
;
; Get pointer to first destination scanline.
;
        mov     ax, bx
        bmScanAddrInc cDstScanSeg, dyDst, cDstScan, pDstSegmnt, pDstOffset
        mov     es, dx
        mov     di, ax
        jmp     CalcConst
;
; BLT from bottom to top.
; Get pointer to first source scanline.
;
@@:     mov     BYTE PTR Flags, bBottomToTop
        mov     cx, ySize
        dec     cx
        add     ax, cx
        bmScanAddrDec cSrcScanSeg, dySrc, cSrcScan, pSrcSegmnt, pSrcOffset
        mov     ds, dx
        mov     si, ax
;
; Get pointer to first destination scanline.
;
        mov     ax, bx
        add     ax, cx
        bmScanAddrDec cDstScanSeg, dyDst, cDstScan, pDstSegmnt, pDstOffset
        mov     es, dx
        mov     di, ax
;
; Calculate destination constants.
;
CalcConst:
        mov     bx, xDst                ; ax = xDstLeft
        mov     dx, xSize
        mov     cx, dx                  ; cx = xSize
        dec     dx
;
; Check x direction and do BLT.
;
CheckXDir:
        mov     ax, xSrc
        add     si, ax
        add     di, bx
        cmp     ax, bx
        jb      XDirRL
;
; BLT from left to right.
;
XDirLR:
;        or      BYTE PTR Flags, bLeftToRight
;
; Increment scanline pointer to first pixel WORD.
;
        jmp     RopFunc
;
; BLT from right to left.
;
XDirRL:
;       or      BYTE PTR Flags, bRightToLeft    ; bRightToLeft == 0
;
; Increment scanline pointer to first pixel WORD.
;
        add     si, dx
        add     di, dx
        std
;
; Initialize pointer to scanline BLT routine and preload register values.
;
;bx = rop
;si = pSrcScan
;di = pDstScan
;
RopFunc:
        mov     cDstByte, cx
        mov     pSrcScan, si
        mov     pDstScan, di
        mov     bx, rop
        add     bx, bx
        mov     bx, mempBltSD88Tbl[bx]
        jmp     bx
memBltSD_ColorToColor   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 8BPP, rop = 1                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD88r1   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanBlt:
        mov     cx, cDstByte
ScanLoop:
        lodsb
        mov     bl, es:[di]
        or      al, bl
        not     al
        stosb
        dec     cx
        jnz     ScanLoop
;
; Decrement scanline count and xchg rotate counts.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        test    BYTE PTR Flags, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD88r1   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 8BPP, rop = 2                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD88r2   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanBlt:
        mov     cx, cDstByte
ScanLoop:
        lodsb
        not     al
        and     al, es:[di]
        stosb
        dec     cx
        jnz     ScanLoop
;
; Decrement scanline count and xchg rotate counts.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        test    BYTE PTR Flags, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD88r2   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 8BPP, rop = 3                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD88r3   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanBlt:
        mov     cx, cDstByte
ScanLoop:
        lodsb
        not     al
        stosb
        dec     cx
        jnz     ScanLoop
;
; Decrement scanline count and xchg rotate counts.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        test    BYTE PTR Flags, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD88r3   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 8BPP, rop = 4                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD88r4   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanBlt:
        mov     cx, cDstByte
ScanLoop:
        lodsb
        mov     bl, es:[di]
        not     bl
        and     al, bl
        stosb
        dec     cx
        jnz     ScanLoop
;
; Decrement scanline count and xchg rotate counts.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        test    BYTE PTR Flags, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD88r4   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 8BPP, rop = 6                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD88r6   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanBlt:
        mov     cx, cDstByte
ScanLoop:
        lodsb
        xor     al, es:[di]
        stosb
        dec     cx
        jnz     ScanLoop
;
; Decrement scanline count and xchg rotate counts.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        test    BYTE PTR Flags, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD88r6   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 8BPP, rop = 7                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD88r7   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanBlt:
        mov     cx, cDstByte
ScanLoop:
        lodsb
        and     al, es:[di]
        not     al
        stosb
        dec     cx
        jnz     ScanLoop
;
; Decrement scanline count and xchg rotate counts.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        test    BYTE PTR Flags, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD88r7   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 8BPP, rop = 8                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD88r8   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanBlt:
        mov     cx, cDstByte
ScanLoop:
        lodsb
        and     al, es:[di]
        stosb
        dec     cx
        jnz     ScanLoop
;
; Decrement scanline count and xchg rotate counts.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        test    BYTE PTR Flags, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD88r8   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 8BPP, rop = 9                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD88r9   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanBlt:
        mov     cx, cDstByte
ScanLoop:
        lodsb
        xor     al, es:[di]
        not     al
        stosb
        dec     cx
        jnz     ScanLoop
;
; Decrement scanline count and xchg rotate counts.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        test    BYTE PTR Flags, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD88r9   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 8BPP, rop = B                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD88rB   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanBlt:
        mov     cx, cDstByte
ScanLoop:
        lodsb
        not     al
        or      al, es:[di]
        stosb
        dec     cx
        jnz     ScanLoop
;
; Decrement scanline count and xchg rotate counts.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        test    BYTE PTR Flags, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD88rB   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 8BPP, rop = C                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD88rC   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanBlt:
        mov     cx, cDstByte
    rep movsb
;
; Decrement scanline count and xchg rotate counts.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        test    BYTE PTR Flags, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD88rC   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 8BPP, rop = D                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD88rD   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanBlt:
        mov     cx, cDstByte
ScanLoop:
        lodsb
        mov     bl, es:[di]
        not     bl
        or      al, bl
        stosb
        dec     cx
        jnz     ScanLoop
;
; Decrement scanline count and xchg rotate counts.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        test    BYTE PTR Flags, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD88rD   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 8BPP, rop = E                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD88rE   PROC NEAR
;
; Top of main scanline BLT loop.
;
ScanBlt:
        mov     cx, cDstByte
ScanLoop:
        lodsb
        or      al, es:[di]
        stosb
        dec     cx
        jnz     ScanLoop
;
; Decrement scanline count and xchg rotate counts.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        test    BYTE PTR Flags, bTopToBottom
        jz      @F
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        cld
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     34
mempBltSD88rE   ENDP


_TEXT           ENDS
                END
