.386

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Convert 8BPP source into 1BPP destination bitmap                 ;
;                                                                            ;
;       A background color maps 8BPP pixels into 0 or 1 in a 1BPP bitmap.    ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       07/20/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

                INCLUDE BITBLT.INC

_TEXT           SEGMENT PUBLIC WORD USE16 'CODE'

pDst            EQU     [bp + 32]
pDstSegmnt      EQU     [bp + 34]
pDstOffset      EQU     [bp + 32]
dyDst           EQU     [bp + 30]
cDstScanSeg     EQU     [bp + 28]
cDstFillBytes   EQU     [bp + 26]
pSrc            EQU     [bp + 22]
pSrcSegmnt      EQU     [bp + 24]
pSrcOffset      EQU     [bp + 22]
dySrc           EQU     [bp + 20]
cSrcScanSeg     EQU     [bp + 18]
cSrcFillBytes   EQU     [bp + 16]
xSrc            EQU     [bp + 14]
ySrc            EQU     [bp + 12]
xSize           EQU     [bp + 10]
ySize           EQU     [bp + 8]
clrBack         EQU     [bp + 4]

pSrcScan        EQU     [bp - 2]
pDstScan        EQU     [bp - 4]
cSrcScan        EQU     [bp - 6]
cDstScan        EQU     [bp - 8]
cDstByte        EQU     [bp - 10]

memConvertColorBitmap   PROC NEAR

        push    bp
        mov     bp, sp
        sub     sp, 12
        push    ds
        push    es
        push    si
        push    di
;
; Convert from top to bottom.
; Get pointer to first source scanline.
;
        mov     ax, ySrc
        bmScanAddrInc cSrcScanSeg, dySrc, cSrcScan, pSrcSegmnt, pSrcOffset
        mov     ds, dx
        mov     si, ax
;
; Get pointer to first destination scanline.
;
        xor     ax, ax
        bmScanAddrInc cDstScanSeg, dyDst, cDstScan, pDstSegmnt, pDstOffset
        mov     es, dx
        mov     di, ax
;
; BLT from left to right.
;
; Increment scanline pointer to first pixel.
;
        add     si, xSrc
;
; Save scanline pointers.
;
        mov     pSrcScan, si
        mov     pDstScan, di
ScanLoopTop:
;ds:[si] = source
;es:[di] = destination
;
; Convert scanline.
;

        mov     cx, xSize
        mov     dl, clrBack
        xor     al, al
        mov     dh, 8
ScanLoop:
        cmp     dl, [si]
        jne     @F
        or      al, 1
@@:     inc     si
        dec     dh
        je      WriteMonoByte
        shl     al, 1
        dec     cx
        jnz     ScanLoop
        mov     cl, dh
        dec     cl
        shl     al, cl
        mov     es:[di], al
        jmp     NextScan
WriteMonoByte:
        mov     es:[di], al
        xor     al, al
        inc     di
        mov     dh, 8
        dec     cx
        jnz     ScanLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source, pattern, and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanLoopTop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     32

memConvertColorBitmap   ENDP


_TEXT           ENDS
                END
