;----------------------------------------------------------------------------;
;                                                                            ;
; Function: General purpose DIB translation routine                          ;
;                                                                            ;
;       Converting between device bitmap and DIBs involves passing a pointer ;
;       to a scanline translation routine that will carry out the respective ;
;       operation.  Two routines are made, one for translating DIBs to       ;
;       device bitmaps, the other for translating device bitmaps to DIBs.    ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/09/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

                INCLUDE COMMON.INC           
                INCLUDE BITBLT.INC

_DATA	        SEGMENT WORD PUBLIC 'DATA'

GDIModuleName   DB 'GDI', 0

_DATA	        ENDS
CONST	        SEGMENT WORD PUBLIC 'CONST'
CONST	        ENDS
_BSS	        SEGMENT WORD PUBLIC 'BSS'
_BSS	        ENDS
DGROUP	        GROUP CONST, _BSS, _DATA

_TEXT           SEGMENT PUBLIC WORD 'CODE'
.386

EXTERN GetModuleHandle : FAR
EXTERN GetProcAddress  : FAR

dibInfo         EQU     [bp + 30]
dibInfoSegmnt   EQU     [bp + 32]
dibInfoOffset   EQU     [bp + 30]
dibBits         EQU     [bp + 26]
dibSegmnt       EQU     [bp + 28]
dibOffset       EQU     [bp + 26]
dibWidthBytes   EQU     [bp + 24]
bmBits          EQU     [bp + 20]
bmSegmnt        EQU     [bp + 22]
bmOffset        EQU     [bp + 20]
bmWidthBytes    EQU     [bp + 18]
bmScanSeg       EQU     [bp + 16]
bmFillBytes     EQU     [bp + 14]
cWidth          EQU     [bp + 12]
iStart          EQU     [bp + 10]
cScans          EQU     [bp + 8]
lpXlate         EQU     [bp + 4]
XlateSegmnt     EQU     [bp + 6]
XlateOffset     EQU     [bp + 4]

bmScanOffset    EQU     [bp - 2]
bmScanCount     EQU     [bp - 4]
pfnXlateScan    EQU     [bp - 6]
AndMask         EQU     [bp - 8]
XorMask         EQU     [bp - 9]
clrFore         EQU     [bp - 8]
clrBack         EQU     [bp - 9]
pfnMatch24      EQU     [bp - 14]
clrPrev         EQU     [bp - 18]

memMonoToDib1   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        mov     ax, cWidth
        add     ax, 7
        shr     ax, 3
        mov     cWidth, ax
        mov     fs, XlateSegmnt
        mov     bx, XlateOffset
        mov     ah, fs:[bx]
        shr     ah, 1
        sbb     al, al
        mov     XorMask, al
        mov     ah, fs:[bx + 1]
        shr     ah, 1
        sbb     ah, ah
        xor     al, ah
        mov     AndMask, al
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:
        mov     al, [si]
        and     al, AndMask
        xor     al, XorMask
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     si
        inc     di                              ; Segment wrap?
        jnz     XlateLoop
        mov     ax, es
        add     ax, __AHIncr
        mov     es, ax
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memMonoToDib1   ENDP

memMonoToDib4   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        mov     fs, XlateSegmnt
        mov     bx, XlateOffset
        mov     al, fs:[bx]
        mov     clrBack, al
        xor     al, fs:[bx + 1]
        mov     clrFore, al
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:
        mov     ah, [si]
        mov     dl, 4
        inc     si
ByteLoop:
        lea     bx, clrBack
        add     ah, ah
        adc     bx, 0
        mov     al, [bx]
        shl     al, 4
        dec     cx
        jz      StoreLast
        lea     bx, clrBack
        add     ah, ah
        adc     bx, 0
        or      al, ss:[bx]
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di                              ; Segment wrap?
        jz      UpdateSegment
NewSegment:
        dec     dl
        jnz     ByteLoop
        jmp     XlateLoop
StoreLast:
        mov     es:[di], al
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
UpdateSegment:
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
        jmp     NewSegment
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memMonoToDib4   ENDP

memMonoToDib8   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        mov     fs, XlateSegmnt
        mov     bx, XlateOffset
        mov     al, fs:[bx]
        mov     clrBack, al
        xor     al, fs:[bx + 1]
        mov     clrFore, al
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:
        mov     ah, [si]
        mov     dl, 8
        inc     si
ByteLoop:
        lea     bx, clrBack
        add     ah, ah
        adc     bx, 0
        mov     al, ss:[bx]
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di                              ; Segment wrap?
        jz      UpdateSegment
NewSegment:
        dec     dl
        jnz     ByteLoop
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
UpdateSegment:
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
        jmp     NewSegment
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memMonoToDib8   ENDP

memMonoToDib24  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        mov     fs, XlateSegmnt
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:
        mov     ah, [si]
        mov     dl, 8
        inc     si
ByteLoop:
        add     ah, ah
        sbb     al, al
        mov     es:[di], al
        inc     di                              ; Segment wrap?
        jnz     @F
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
@@:     mov     es:[di], al
        inc     di                              ; Segment wrap?
        jnz     @F
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
@@:     mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di                              ; Segment wrap?
        jnz     @F
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
@@:     dec     dl
        jnz     ByteLoop
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memMonoToDib24  ENDP

memColorToDib1  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        mov     fs, XlateSegmnt
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
        mov     dl, 8
XlateLoop:
        mov     bl, [si]
        xor     bh, bh
        add     bx, XlateOffset
        mov     ah, fs:[bx]
        shr     ah, 1
        adc     dh, dh
        dec     cx
        jz      StoreLast
        inc     si
        dec     dl
        jnz     XlateLoop
        mov     es:[di], dh
        mov     dl, 8
        inc     di                              ; Segment wrap?
        jnz     XlateLoop
        mov     ax, es
        add     ax, __AHIncr
        mov     es, ax
        jmp     XlateLoop
StoreLast:
        dec     dl
        mov     cl, dl
        shl     dh, cl
        mov     es:[di], dh
        ret
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memColorToDib1  ENDP

memColorToDib4  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        mov     fs, XlateSegmnt
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:
        mov     bl, [si]
        xor     bh, bh
        add     bx, XlateOffset
        mov     al, fs:[bx]
        shl     al, 4
        dec     cx
        jz      StoreLast
        mov     bl, [si + 1]
        xor     bh, bh
        add     bx, XlateOffset
        or      al, fs:[bx]
        mov     es:[di], al
        dec     cx
        jz      NextScan
        add     si, 2
        inc     di                              ; Segment wrap?
        jnz     XlateLoop
        mov     ax, es
        add     ax, __AHIncr
        mov     es, ax
        jmp     XlateLoop
StoreLast:
        mov     es:[di], al
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memColorToDib4  ENDP

memColorToDib8  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        mov     fs, XlateSegmnt
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:
        mov     al, [si]
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     si
        inc     di                              ; Segment wrap?
        jnz     XlateLoop
        mov     ax, es
        add     ax, __AHIncr
        mov     es, ax
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memColorToDib8  ENDP

memColorToDib24 PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        mov     fs, XlateSegmnt
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:
        mov     bl, [si]
        xor     bh, bh
        shl     bx, 2
        add     bx, XlateOffset
        mov     ax, fs:[bx]
        mov     dl, fs:[bx + 2]
        mov     es:[di], al
        inc     si
        inc     di                              ; Segment wrap?
        jnz     @F
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
@@:     mov     es:[di], ah
        inc     di                              ; Segment wrap?
        jnz     @F
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
@@:     mov     es:[di], dl
        dec     cx
        jz      NextScan
        inc     di                              ; Segment wrap?
        jnz     XlateLoop
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memColorToDib24 ENDP

memDib1ToMono   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        mov     ax, cWidth
        add     ax, 7
        shr     ax, 3
        mov     cWidth, ax
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     dibInfoOffset, bx
        mov     al, fs:[bx]
        mov     XorMask, al
        xor     al, fs:[bx + 2]
        mov     AndMask, al
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
XlateLoop:
        mov     al, [si]
        and     al, AndMask
        xor     al, XorMask
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        inc     si                              ; Segment wrap?
        jnz     XlateLoop
        mov     ax, ds
        add     ax, __AHIncr
        mov     ds, ax
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib1ToMono   ENDP

memDib4ToMono   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     dibInfoOffset, bx
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
        mov     dl, 4
XlateLoop:
        mov     bl, [si]
        shr     bl, 4
        xor     bh, bh
        add     bx, bx
        add     bx, dibInfoOffset
        mov     ah, fs:[bx]
        shr     ah, 1
        adc     dh, dh
        dec     cx
        jz      StoreLastPartial
        mov     bl, [si]
        and     bx, 0Fh
        add     bx, bx
        add     bx, dibInfoOffset
        mov     ah, fs:[bx]
        shr     ah, 1
        adc     dh, dh
        dec     cx
        jz      StoreLast
        inc     si                              ; Segment wrap?
        jz      UpdateSegment
NewSegment:
        dec     dl
        jnz     XlateLoop
        mov     es:[di], dh
        mov     dl, 4
        inc     di
        jmp     XlateLoop
StoreLastPartial:
        mov     cl, dl
        add     cl, cl
        dec     cl
        shl     dh, cl
        mov     es:[di], dh
        jmp     NextScan
StoreLast:
        mov     cl, dl
        dec     cl
        add     cl, cl
        shl     dh, cl
        mov     es:[di], dh
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
UpdateSegment:
        mov     bx, ds
        add     bx, __AHIncr
        mov     ds, bx
        jmp     NewSegment
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib4ToMono   ENDP

memDib8ToMono   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     dibInfoOffset, bx
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
        mov     dl, 8
XlateLoop:
        mov     bl, [si]
        xor     bh, bh
        add     bx, bx
        add     bx, dibInfoOffset
        mov     ah, fs:[bx]
        shr     ah, 1
        adc     dh, dh
        dec     cx
        jz      StoreLast
        inc     si                              ; Segment wrap?
        jz      UpdateSegment
NewSegment:
        dec     dl
        jnz     XlateLoop
        mov     es:[di], dh
        mov     dl, 8
        inc     di
        jmp     XlateLoop
StoreLast:
        dec     dl
        mov     cl, dl
        shl     dh, cl
        mov     es:[di], dh
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
UpdateSegment:
        mov     ax, ds
        add     ax, __AHIncr
        mov     ds, ax
        jmp     NewSegment
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib8ToMono   ENDP

memDib24ToMono  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        push    ds
        push    OFFSET GDIModuleName
        call    GetModuleHandle
        push    ax
        push    0
        push    449                             ; Ordinal # of DeviceColorMatch
        call    GetProcAddress
        mov     pfnMatch24 + 2, dx
        mov     pfnMatch24, ax
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
        mov     bx, 0800h
XlateLoop:
        mov     al, [si]
        inc     si
        jnz     @F
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     mov     ah, [si]
        inc     si
        jnz     @F
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     mov     dl, [si]
        xor     dh, dh
        push    si
        push    di
        push    cx
        push    es
        push    dx
        push    ax
        push    ss
        push    WORD PTR lpXlate + 2
        push    WORD PTR lpXlate
        call    DWORD PTR pfnMatch24
        pop     es
        pop     cx
        pop     di
        pop     si
        shr     al, 1
        rol     bl, 1
        dec     cx
        jz      NextScan
        dec     bh
        jnz     @F
        mov     es:[di], bl
        mov     bx, 0800h
        inc     di
@@:     inc     si                              ; Segment wrap?
        jnz     XlateLoop
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
        jmp     XlateLoop
NextScan:
        dec     bh
        mov     cl, bh                          ; Update last monochrome byte
        shl     bh, cl
        mov     es:[di], bl
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib24ToMono  ENDP

memDib1ToColor  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     dibInfoOffset, bx
        mov     al, fs:[bx]
        mov     ah, fs:[bx + 2]
        mov     clrBack, ax
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
XlateLoop:
        mov     ah, [si]
        mov     dl, 8
        inc     si                              ; Segment wrap?
        jz      UpdateSegment
ByteLoop:
        lea     bx, clrBack
        add     ah, ah
        adc     bx, 0
        mov     al, ss:[bx]
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        dec     dl
        jnz     ByteLoop
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
UpdateSegment:
        mov     bx, ds
        add     bx, __AHIncr
        mov     ds, bx
        jmp     ByteLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib1ToColor  ENDP

memDib4ToColor  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     dibInfoOffset, bx
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
XlateLoop:
        mov     dl, [si]
        mov     bl, dl
        shr     bl, 4
        xor     bh, bh
        add     bx, bx
        add     bx, dibInfoOffset
        mov     al, fs:[bx]
        dec     cx
        jz      StoreLast
        mov     bl, dl
        and     bx, 0Fh
        add     bx, bx
        add     bx, dibInfoOffset
        mov     ah, fs:[bx]
        mov     es:[di], ax
        dec     cx
        jz      NextScan
        add     di, 2
        inc     si                              ; Segment Wrap?
        jnz     XlateLoop
        mov     ax, ds
        add     ax, __AHIncr
        mov     ds, ax
        jmp     XlateLoop
StoreLast:
        mov     es:[di], al
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib4ToColor  ENDP

memDib8ToColor  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     dibInfoOffset, bx
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
XlateLoop:
        mov     bl, [si]
        xor     bh, bh
        add     bx, bx
        add     bx, dibInfoOffset
        mov     al, fs:[bx]
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        inc     si                              ; Segment wrap?
        jnz     XlateLoop
        mov     ax, ds
        add     ax, __AHIncr
        mov     ds, ax
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib8ToColor  ENDP

memDib24ToColor PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        push    ds
        push    OFFSET GDIModuleName
        call    GetModuleHandle
        push    ax
        push    0
        push    449                             ; Ordinal # of DeviceColorMatch
        call    GetProcAddress
        mov     pfnMatch24 + 2, dx
        mov     pfnMatch24, ax
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
        mov     al, [si]
        inc     si
        jnz     @F
        mov     bx, ds
        add     bx, __AHIncr
        mov     ds, bx
@@:     mov     ah, [si]
        inc     si
        jnz     @F
        mov     bx, ds
        add     bx, __AHIncr
        mov     ds, bx
@@:     mov     dl, [si]
        mov     clrPrev, ax
        mov     clrPrev + 2, dl
        xor     dh, dh
        push    si
        push    di
        push    cx
        push    es
        push    dx
        push    ax
        push    WORD PTR lpXlate + 2
        push    WORD PTR lpXlate
        call    DWORD PTR pfnMatch24
        pop     es
        pop     cx
        pop     di
        pop     si
        mov     clrPrev + 3, al
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        inc     si                              ; Segment wrap?
        jnz     XlateLoop
        mov     bx, ds
        add     bx, __AHIncr
        mov     ds, bx
XlateLoop:
        mov     al, [si]
        inc     si
        jnz     @F
        mov     bx, ds
        add     bx, __AHIncr
        mov     ds, bx
@@:     mov     ah, [si]
        inc     si
        jnz     @F
        mov     bx, ds
        add     bx, __AHIncr
        mov     ds, bx
@@:     mov     dl, [si]
        cmp     ax, clrPrev
        jne     @F
        cmp     dl, clrPrev + 2
        jne     @F
        mov     al, clrPrev + 3
        jmp     GotIndex
@@:     xor     dh, dh
        mov     clrPrev, ax
        mov     clrPrev + 2, dl
        push    si
        push    di
        push    cx
        push    es
        push    dx
        push    ax
        push    WORD PTR lpXlate + 2
        push    WORD PTR lpXlate
        call    DWORD PTR pfnMatch24
        pop     es
        pop     cx
        pop     di
        pop     si
        mov     clrPrev + 3, al
GotIndex:
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        inc     si                              ; Segment wrap?
        jnz     XlateLoop
        mov     bx, ds
        add     bx, __AHIncr
        mov     ds, bx
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib24ToColor ENDP

_TEXT           ENDS
                END
