.386

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: BitBLT 1BPP source and pattern to 8BPP destination bitmap        ;
;                                                                            ;
;       8BPP BitBLT combines a rectangular region of a source bitmap,        ;
;       pattern, and destination bitmap using a ternary ROP.  The ternary    ;
;       ROP is broken down into terms used to evaluate a polynomial that     ;
;       describes the ROP.  This procedure is written for functionality,     ;
;       not for performance.  Cases when only a pattern and destination or   ;
;       a source and destination are handled in other procedures using       ;
;       hard-coded routines for each ROP combination.  The theory being      ;
;       that calls using all three components of a ternary ROP are very      ;
;       rare and infrequent.                                                 ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       05/10/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

                INCLUDE COMMON.INC
                INCLUDE BITBLT.INC

_TEXT           SEGMENT PUBLIC WORD USE16 'CODE'

EXTERN xlateRop : BYTE

pDst            EQU     [bp + 46]
pDstSegmnt      EQU     [bp + 48]
pDstOffset      EQU     [bp + 46]
dyDst           EQU     [bp + 44]
cDstScanSeg     EQU     [bp + 42]
cDstFillBytes   EQU     [bp + 40]
xDst            EQU     [bp + 38]
yDst            EQU     [bp + 36]
pSrc            EQU     [bp + 32]
pSrcSegmnt      EQU     [bp + 34]
pSrcOffset      EQU     [bp + 32]
dySrc           EQU     [bp + 30]
cSrcScanSeg     EQU     [bp + 28]
cSrcFillBytes   EQU     [bp + 26]
xSrc            EQU     [bp + 24]
ySrc            EQU     [bp + 22]
pPat            EQU     [bp + 18]
pPatSegmnt      EQU     [bp + 20]
pPatOffset      EQU     [bp + 18]
xPat            EQU     [bp + 20]
yPat            EQU     [bp + 18]
xSize           EQU     [bp + 16]
ySize           EQU     [bp + 14]
clrFore         EQU     [bp + 10]
clrBack         EQU     [bp + 6]
rop             EQU     [bp + 4]

pSrcScan        EQU     [bp - 2]
pDstScan        EQU     [bp - 4]
pPatBegin       EQU     [bp - 6]
pPatEnd         EQU     [bp - 8]
cSrcScan        EQU     [bp - 10]
cDstScan        EQU     [bp - 12]
xDstRight       EQU     [bp - 14]
AndMask         EQU     [bp - 15]
XorMask         EQU     [bp - 16]
FirstShift      EQU     [bp - 18]

memBltPSD_MonoToColor   PROC NEAR
        
        push    bp
        mov     bp, sp
        sub     sp, 20
        push    ds
        push    es
        push    fs
        push    si
        push    di
;
; Get pattern segment.
;
        mov     fs, pPatSegmnt
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     ax, ySrc
        bmScanAddrInc cSrcScanSeg, dySrc, cSrcScan, pSrcSegmnt, pSrcOffset
        mov     ds, dx
        mov     si, ax
;
; Get pointer to first destination scanline.
;
        mov     ax, yDst
        bmScanAddrInc cDstScanSeg, dyDst, cDstScan, pDstSegmnt, pDstOffset
        mov     es, dx
        mov     di, ax
;
; Calculate source constants.
;
CalcConst:
        mov     ax, xSrc                ; ax = xSrcLeft
        mov     bx, ax
        and     al, 7                   ; al = shift count to first pixel
        mov     ah, 8
        sub     ah, al                  ; ah = pixel count in first byte
        mov     FirstShift, ax
;
; BLT from left to right.
; Increment scanline pointer to first pixel BYTE.
;
        shr     bx, 3
        add     si, bx
        add     di, xDst
;
; Calculate the color masks to convert 0x00 -> background and 0xFF to foregound.
;
        mov     dh, clrFore
        mov     dl, clrBack
        xor     dl, dh
        mov     AndMask, dl
        mov     XorMask, dh
        cld
;
; Initialize pointer to scanline BLT routine and preload register values.
;
;bx = rop
;si = pSrcScan
;di = pDstScan
;
ScanLoop:
        mov     pSrcScan, si
        mov     pDstScan, di
        mov     bx, rop
        mov     bl, xlateRop[bx]
        mov     rop, bx
        mov     ax, yDst
ScanLoopTop:
;
;fs:[bx] = pattern
;ds:[si] = source
;es:[di] = destination
;ch      = source byte pixel count
;
; Get scanline of pattern.
;
        mov     bx, pPatOffset
        sub     ax, fs:[bx][BRUSH_Y]            ; Align pattern vertically
        and     ax, 7
        shl     ax, 3
        mov     dx, xDst
        sub     dx, fs:[bx][BRUSH_X]
        and     dx, 7
        add     bx, ax
        add     bx, BRUSH_COLOR
        mov     pPatBegin, bx
        mov     ax, dx
        mov     dx, bx
        add     dx, 7
        mov     pPatEnd, dx
        add     bx, ax                          ; Align pattern horizontally
        mov     dx, di
        add     dx, xSize
        mov     xDstRight, dx
        mov     cx, FirstShift
        mov     dh, [si]
        inc     si
        shl     dh, cl
InnerLoop:
        add     dh, dh
        sbb     cl, cl
        and     cl, AndMask
        xor     cl, XorMask
        rop3    cl, BYTE PTR fs:[bx], BYTE PTR rop
        mov     es:[di], al
        inc     di
        cmp     di, xDstRight
        je      NextScan
        cmp     bx, pPatEnd
        je      ReloadPat
        inc     bx
        dec     ch
        jnz     InnerLoop
        mov     dh, [si]
        inc     si
        mov     ch, 8
        jmp     InnerLoop
ReloadPat:
        mov     bx, pPatBegin
        dec     ch
        jnz     InnerLoop
        mov     dh, [si]
        inc     si
        mov     ch, 8
        jmp     InnerLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source, pattern, and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     ax, yDst
        inc     ax
        mov     yDst, ax
        jmp     ScanLoopTop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     46

memBltPSD_MonoToColor   ENDP

_TEXT           ENDS
                END
