.386

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: SrcBLT 1BPP source bitmap to 8BPP destination bitmap             ;
;                                                                            ;
;       1BPP source BLT copies a rectangular region of a source bitmap       ;
;       to a same sized rectangular region on a destiantion bitmap using     ;
;       a binary ROP to combine source pixels with destination pixels.       ;
;       The source and destination cannot be the same so the direction is    ;
;       always top to bottom, left to right.  The procedure uses a generic   ;
;       main loop that calls individual scanline BLT procedures based upon   ;
;       the ROP.                                                             ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       05/21/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

                INCLUDE BITBLT.INC

_TEXT           SEGMENT PUBLIC WORD USE16 'CODE'

EXTERN LeftMask1  : BYTE
EXTERN RightMask1 : BYTE

pDst            EQU     [bp + 42]
pDstSegmnt      EQU     [bp + 44]
pDstOffset      EQU     [bp + 42]
dyDst           EQU     [bp + 40]
cDstScanSeg     EQU     [bp + 38]
cDstFillBytes   EQU     [bp + 36]
xDst            EQU     [bp + 34]
yDst            EQU     [bp + 32]
pSrc            EQU     [bp + 28]
pSrcSegmnt      EQU     [bp + 30]
pSrcOffset      EQU     [bp + 28]
dySrc           EQU     [bp + 26]
cSrcScanSeg     EQU     [bp + 24]
cSrcFillBytes   EQU     [bp + 22]
xSrc            EQU     [bp + 20]
ySrc            EQU     [bp + 18]
xSize           EQU     [bp + 16]
ySize           EQU     [bp + 14]
clrFore         EQU     [bp + 10]
clrBack         EQU     [bp + 6]
rop             EQU     [bp + 4]

pSrcScan        EQU     [bp - 2]
pDstScan        EQU     [bp - 4]
cSrcScan        EQU     [bp - 6]
cDstScan        EQU     [bp - 8]
FirstShift      EQU     [bp - 10]
clrMask         EQU     [bp - 12]
cDstByte        EQU     [bp - 14]
pfnScanBlt      EQU     [bp - 16]

mempBltSD18Tbl   DW      0000h,        mempBltSD18r1, mempBltSD18r2, mempBltSD18r3
                DW      mempBltSD18r4, 0000h,        mempBltSD18r6, mempBltSD18r7
                DW      mempBltSD18r8, mempBltSD18r9, 0000h,        mempBltSD18rB
                DW      mempBltSD18rC, mempBltSD18rD, mempBltSD18rE, 0000h

memBltSD_MonoToColor    PROC NEAR
        
        push    bp
        mov     bp, sp
        sub     sp, 18
        push    ds
        push    es
        push    si
        push    di
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     ax, ySrc
        bmScanAddrInc cSrcScanSeg, dySrc, cSrcScan, pSrcSegmnt, pSrcOffset
        mov     ds, dx
        mov     si, ax
;
; Get pointer to first destination scanline.
;
        mov     ax, yDst
        bmScanAddrInc cDstScanSeg, dyDst, cDstScan, pDstSegmnt, pDstOffset
        mov     es, dx
        mov     di, ax
;
;
; Calculate source constants.
;
CalcConst:
        mov     ax, xSrc                ; ax = xSrcLeft
        mov     bx, ax
        and     al, 7                   ; al = shift count to first pixel
        mov     ah, 8
        sub     ah, al                  ; ah = pixel count in first byte
        mov     FirstShift, ax
;
; BLT from left to right.
;
; Increment scanline pointer to first pixel BYTE.
;
        shr     bx, 3
        add     si, bx
        add     di, xDst
;
; Calculate the color masks to convert 0x00 -> background and 0xFF to foregound.
;

        mov     dl, clrBack
        mov     dh, clrFore
        xor     dl, dh
;
; Initialize pointer to scanline BLT routine and preload register values.
;
;si = pSrcScan
;di = pDstScan
;
ScanLoop:
        mov     pSrcScan, si
        mov     pDstScan, di
        mov     clrMask, dx
        mov     bx, rop
        add     bx, bx
        mov     rop, bx
        mov     bx, mempBltSD18Tbl[bx]
        jmp     bx
memBltSD_MonoToColor    ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 1                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD18r1   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dx, clrMask
        mov     ah, [si]
        inc     si
        shl     ah, cl
        mov     cx, xSize
TopLoop:
        add     ah, ah
        sbb     al, al
        and     al, dl
        xor     al, dh
        mov     bh, es:[di]
        or      al, bl
        not     al
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        dec     bl
        jnz     TopLoop
        mov     ah, [si]
        mov     bl, 8
        inc     si
        jmp     TopLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
mempBltSD18r1   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 2                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD18r2   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dx, clrMask
        mov     ah, [si]
        inc     si
        shl     ah, cl
        mov     cx, xSize
TopLoop:
        add     ah, ah
        sbb     al, al
        and     al, dl
        xor     al, dh
        not     al
        and     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        dec     bl
        jnz     TopLoop
        mov     ah, [si]
        mov     bl, 8
        inc     si
        jmp     TopLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
mempBltSD18r2   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 3                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD18r3   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dx, clrMask
        mov     ah, [si]
        inc     si
        shl     ah, cl
        mov     cx, xSize
TopLoop:
        add     ah, ah
        sbb     al, al
        and     al, dl
        xor     al, dh
        not     al
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        dec     bl
        jnz     TopLoop
        mov     ah, [si]
        mov     bl, 8
        inc     si
        jmp     TopLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
mempBltSD18r3   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 4                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD18r4   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dx, clrMask
        mov     ah, [si]
        inc     si
        shl     ah, cl
        mov     cx, xSize
TopLoop:
        add     ah, ah
        sbb     al, al
        and     al, dl
        xor     al, dh
        mov     bh, es:[di]
        not     bh
        and     al, bh
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        dec     bl
        jnz     TopLoop
        mov     ah, [si]
        mov     bl, 8
        inc     si
        jmp     TopLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
mempBltSD18r4   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 6                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD18r6   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dx, clrMask
        mov     ah, [si]
        inc     si
        shl     ah, cl
        mov     cx, xSize
TopLoop:
        add     ah, ah
        sbb     al, al
        and     al, dl
        xor     al, dh
        xor     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        dec     bl
        jnz     TopLoop
        mov     ah, [si]
        mov     bl, 8
        inc     si
        jmp     TopLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
mempBltSD18r6   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 7                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD18r7   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dx, clrMask
        mov     ah, [si]
        inc     si
        shl     ah, cl
        mov     cx, xSize
TopLoop:
        add     ah, ah
        sbb     al, al
        and     al, dl
        xor     al, dh
        and     al, es:[di]
        not     al
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        dec     bl
        jnz     TopLoop
        mov     ah, [si]
        mov     bl, 8
        inc     si
        jmp     TopLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
mempBltSD18r7   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 8                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD18r8   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dx, clrMask
        mov     ah, [si]
        inc     si
        shl     ah, cl
        mov     cx, xSize
TopLoop:
        add     ah, ah
        sbb     al, al
        and     al, dl
        xor     al, dh
        and     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        dec     bl
        jnz     TopLoop
        mov     ah, [si]
        mov     bl, 8
        inc     si
        jmp     TopLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
mempBltSD18r8   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 9                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD18r9   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dx, clrMask
        mov     ah, [si]
        inc     si
        shl     ah, cl
        mov     cx, xSize
TopLoop:
        add     ah, ah
        sbb     al, al
        and     al, dl
        xor     al, dh
        xor     al, es:[di]
        not     al
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        dec     bl
        jnz     TopLoop
        mov     ah, [si]
        mov     bl, 8
        inc     si
        jmp     TopLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
mempBltSD18r9   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = B                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD18rB   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dx, clrMask
        mov     ah, [si]
        inc     si
        shl     ah, cl
        mov     cx, xSize
TopLoop:
        add     ah, ah
        sbb     al, al
        and     al, dl
        xor     al, dh
        not     al
        or      es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        dec     bl
        jnz     TopLoop
        mov     ah, [si]
        mov     bl, 8
        inc     si
        jmp     TopLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
mempBltSD18rB   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = C                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD18rC   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dx, clrMask
        mov     ah, [si]
        inc     si
        shl     ah, cl
        mov     cx, xSize
TopLoop:
        add     ah, ah
        sbb     al, al
        and     al, dl
        xor     al, dh
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        dec     bl
        jnz     TopLoop
        mov     ah, [si]
        mov     bl, 8
        inc     si
        jmp     TopLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
mempBltSD18rC   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = D                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD18rD   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dx, clrMask
        mov     ah, [si]
        inc     si
        shl     ah, cl
        mov     cx, xSize
TopLoop:
        add     ah, ah
        sbb     al, al
        and     al, dl
        xor     al, dh
        mov     bh, es:[di]
        not     bh
        or      al, bh
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        dec     bl
        jnz     TopLoop
        mov     ah, [si]
        mov     bl, 8
        inc     si
        jmp     TopLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
mempBltSD18rD   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = E                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltSD18rE   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dx, clrMask
        mov     ah, [si]
        inc     si
        shl     ah, cl
        mov     cx, xSize
TopLoop:
        add     ah, ah
        sbb     al, al
        and     al, dl
        xor     al, dh
        or      es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        dec     bl
        jnz     TopLoop
        mov     ah, [si]
        mov     bl, 8
        inc     si
        jmp     TopLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
mempBltSD18rE   ENDP

_TEXT           ENDS
                END
