.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Convert between monochrome and color brushes.                    ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       09/21/93 Dave Schmenk - converted from C code.                       ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
           
.CODE
.386

memConvertMonoBrush     PROC NEAR USES ds si di  \
                                lpBrush : DWORD

        lds     si, lpBrush
        xor     bh, bh
        mov     al, [si][BRUSH_CLR_FORE + 1]
        shr     al, 1
        sbb     dl, dl
        mov     al, BYTE PTR [si][BRUSH_CLR_BACK + 1]
        shr     al, 1
        sbb     dh, dh
        xor     dl, dh
        mov     al, [si][BRUSH_PAT]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO], al
        mov     al, [si][BRUSH_PAT + 1]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 1], al
        mov     al, [si][BRUSH_PAT + 2]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 2], al
        mov     al, [si][BRUSH_PAT + 3]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 3], al
        mov     al, [si][BRUSH_PAT + 4]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 4], al
        mov     al, [si][BRUSH_PAT + 5]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 5], al
        mov     al, [si][BRUSH_PAT + 6]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 6], al
        mov     al, [si][BRUSH_PAT + 7]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 7], al
        mov     dl, [si][BRUSH_CLR_FORE]
        mov     dh, [si][BRUSH_CLR_BACK]
        xor     dl, dh
        mov     di, si
        add     si, BRUSH_PAT
        add     di, BRUSH_COLOR
        mov     cx, 8
ConvertColorLoop:
        mov     bl, [si]
        inc     si
        add     bl, bl
        sbb     al, al
        and     al, dl
        xor     al, dh
        add     bl, bl
        sbb     ah, ah
        and     ah, dl
        xor     ah, dh
        mov     [di], ax
        add     bl, bl
        sbb     al, al
        and     al, dl
        xor     al, dh
        add     bl, bl
        sbb     ah, ah
        and     ah, dl
        xor     ah, dh
        mov     [di + 2], ax
        add     bl, bl
        sbb     al, al
        and     al, dl
        xor     al, dh
        add     bl, bl
        sbb     ah, ah
        and     ah, dl
        xor     ah, dh
        mov     [di + 4], ax
        add     bl, bl
        sbb     al, al
        and     al, dl
        xor     al, dh
        add     bl, bl
        sbb     ah, ah
        and     ah, dl
        xor     ah, dh
        mov     [di + 6], ax
        add     di, 8
        dec     cx
        jnz     ConvertColorLoop
        ret
memConvertMonoBrush     ENDP

memConvertColorBrush    PROC NEAR USES ds si di \
                                lpBrush : DWORD

        lds     si, lpBrush
        mov     al, [si][BRUSH_CLR_BACK]
        mov     di, si
        add     si, BRUSH_MONO
        add     di, BRUSH_COLOR
        mov     cx, 8
ConvertMonoLoop:
        xor     ah, ah
        cmp     al, [di]
        jne     @F
        or      ah, 080h
@@:     cmp     al, [di + 1]
        jne     @F
        or      ah, 040h
@@:     cmp     al, [di + 2]
        jne     @F
        or      ah, 020h
@@:     cmp     al, [di + 3]
        jne     @F
        or      ah, 010h
@@:     cmp     al, [di + 4]
        jne     @F
        or      ah, 008h
@@:     cmp     al, [di + 5]
        jne     @F
        or      ah, 004h
@@:     cmp     al, [di + 6]
        jne     @F
        or      ah, 002h
@@:     cmp     al, [di + 7]
        jne     @F
        or      ah, 001h
@@:     mov     [si], ah
        inc     si
        add     di, 8
        dec     cx
        jnz     ConvertMonoLoop
        ret
memConvertColorBrush    ENDP
 
        END
