.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC
        INCLUDE BITBLT.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Set and get RLE Dibs to color bitmaps.                           ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       07/28/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
           
.CODE
.386

memRLE8ToColor  PROC NEAR USES fs es ds si di, dibInfo   : DWORD, dibBits      : DWORD,\
                                               bmBits    : DWORD, bmWidthBytes : WORD,\
                                               bmScanSeg : WORD,  bmFillBytes  : WORD,\
                                               iStart    : WORD,  cScans       : WORD,\
                                               cWidth    : WORD,  lpXlate      : DWORD
                LOCAL bmScanCount  : WORD,\
                      bmScanOffset : WORD
                        
;
; Get pointer to first scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, WORD PTR bmBits + 2, WORD PTR bmBits
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Get pointer to compressed information.
;
        lds     si, dibBits
;
; Get pointer to color translation array.
;
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     WORD PTR dibInfo, bx
;
; Start decoding RLE bitmap.
;
Decode:
        mov     cl, [si]
        inc     si
        cmp     cl, 0
        je      Escape
;
; Do run length decode.
;
        mov     bl, [si]
        xor     bh, bh
        add     bx, bx
        add     bx, WORD PTR dibInfo
        mov     al, fs:[bx]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     mov     es:[di], al
        inc     di
        dec     cl
        jnz     @B
        jmp     Decode
Escape:
        mov     cl, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     cmp     cl, 2
        ja      Absolute
        je      DeltaSkip
        cmp     cl, 1
        je      EndOfBitmap
;
; End of current scanline.
;
        dec     cScans
        jz      EndOfBitmap
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
        jmp     Decode
;
; This is absolute mode, just copy the raw pixels into the bitmap.
;
Absolute:
        mov     bl, [si]
        xor     bh, bh
        add     bx, bx
        add     bx, WORD PTR dibInfo
        mov     al, fs:[bx]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     mov     es:[di], al
        inc     di
        dec     cl
        jnz     Absolute
        test    si, 1                   ; Start decoding on word boundry
        jz      Decode
        inc     si
        jnz     Decode                  ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
        jmp     Decode
;
; Skip pixels.
;
DeltaSkip:
        sub     di, bmScanOffset
        push    di
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        xor     ah, ah
        mov     al, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     push    ax
        mov     cl, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     or      cl, cl
        jz      SkipHorizontal
;
; Skip vertical scanlines.
;        
SkipVertical:
        dec     cScans
        jz      SkipExit
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        dec     cl
        jnz     SkipVertical
        mov     bmScanOffset, di
;
; Skip horizontal scanlines
;
SkipHorizontal:
        pop     ax
        add     di, ax
        pop     ax
        add     di, ax
        jmp     Decode
SkipExit:
        pop     ax
        pop     ax
;
; End of bitmap.
;
EndOfBitmap:
        ret        
memRLE8ToColor  ENDP                                

memColorToRLE8  PROC NEAR USES fs es ds si di, dibInfo   : DWORD, dibBits      : DWORD,\
                                               bmBits    : DWORD, bmWidthBytes : WORD,\
                                               bmScanSeg : WORD,  bmFillBytes  : WORD,\
                                               iStart    : WORD,  cScans       : WORD,\
                                               cWidth    : WORD,  lpXlate      : DWORD
                LOCAL bmScanCount  : WORD,\
                      bmScanOffset : WORD,\
                      bmScanEnd    : WORD,\
                      dibSize      : DWORD
;
; Get pointer to first scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, WORD PTR bmBits + 2, WORD PTR bmBits
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Get pointer to compressed information.
;
        lds     si, dibBits
;
; Get pointer to color translation array.
;
;        mov     fs, WORD PTR lpXlate + 2
;
; Zero out DIB size.
;
        mov     dibSize, 0
EncodeScanLine:
        mov     ax, di
        add     ax, cWidth
        mov     bmScanEnd, ax
EncodeNextField:
        cmp     di, bmScanEnd
        je      EndOfScanLine
        mov     ah, es:[di]                     ; Load starting pixel
        inc     di
        cmp     di, bmScanEnd
        je      Encode1Pixel                    ; 1 pixel left
        mov     al, es:[di]                     ; Get next pixel
        cmp     al, ah
        jne     EncodeAbsolute                  ; Not run length
        mov     dl, 1
EncodeRunLength:
        cmp     dl, 0FFh                        ; Runs can only be 255 long
        je      SaveRunLength
        inc     dl
        inc     di
        cmp     di, bmScanEnd                   ; Don't go past end of scanline
        je      SaveRunLength
        cmp     ah, es:[di]                     ; Get next pixel
        je      EncodeRunLength
SaveRunLength:
        mov     al, dl
        call    mempStoreRLE
        inc     dibSize
        jmp     EncodeNextField
Encode2Pixels:
        push    ax
        mov     al, 1
        call    mempStoreRLE
        inc     dibSize
        pop     ax
        mov     ah, al
Encode1Pixel:
        mov     al, 1
        call    mempStoreRLE
        inc     dibSize
        jmp     EndOfScanLine
;
; Look for two identical pixels before ending the absolute run.
;
EncodeAbsolute:
        dec     di                              ; Move back to first pixel
        push    di                              ; Save it
        inc     di
        mov     dl, 1
ScanAbsolute:
        cmp     dl, 0FFh
        je      SaveAbsoluteRun
        inc     dl
        inc     di
        cmp     di, bmScanEnd
        je      SaveAbsoluteRun
        mov     ah, al
        mov     al, es:[di]
        cmp     al, ah
        jne     ScanAbsolute
        cmp     dl, 3                           ; Need at least 3 pixels in absolute run
        jb      ScanAbsolute
SaveAbsoluteRun:
        pop     di                              ; Return to beginning of run
        cmp     dl, 2
        ja      @F
        jmp     Encode2Pixels                   ; Premature end of scanline
@@:     xor     al, al
        mov     ah, dl
        call    mempStoreRLE
        inc     dibSize
StoreAbsolute:
        mov     al, es:[di]
        inc     di
        cmp     dl, 1
        je      @F                              ; Check for odd absolute run size
        dec     dl
        mov     ah, es:[di]
        inc     di
@@:     call    mempStoreRLE
        inc     dibSize
        dec     dl
        jnz     StoreAbsolute
        jmp     EncodeNextField
;
; End of scanline - put escape code.
;
EndOfScanLine:
        xor     ax, ax
        call    mempStoreRLE
        inc     dibSize
        dec     cScans
        jz      EndOfBitmap
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
        jmp     EncodeScanLine
;
; End of bitmap - put escape code.
;
EndOfBitmap:
        mov     WORD PTR [si], 0100h
        inc     dibSize
;
; Return image size in ax:dx
;
        mov     ax, WORD PTR dibSize
        mov     dx, WORD PTR dibSize+2
        shl     ax, 1                           ; Mul by 2 to get byte size
        rcl     dx, 1
        ret        
memColorToRLE8  ENDP                                

memRLE4ToColor  PROC NEAR USES fs es ds si di, dibInfo   : DWORD, dibBits      : DWORD,\
                                               bmBits    : DWORD, bmWidthBytes : WORD,\
                                               bmScanSeg : WORD,  bmFillBytes  : WORD,\
                                               iStart    : WORD,  cScans       : WORD,\
                                               cWidth    : WORD,  lpXlate      : DWORD
                LOCAL bmScanCount  : WORD,\
                      bmScanOffset : WORD
                        
;
; Get pointer to first scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, WORD PTR bmBits + 2, WORD PTR bmBits
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Get pointer to compressed information.
;
        lds     si, dibBits
;
; Get pointer to color translation array.
;
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     WORD PTR dibInfo, bx
;
; Start decoding RLE bitmap.
;
Decode:
        mov     cl, [si]
        inc     si
        cmp     cl, 0
        je      Escape
;
; Do run length.
;
        mov     bl, [si]
        shr     bx, 4
        and     bx, 000Fh
        add     bx, bx
        add     bx, WORD PTR dibInfo
        mov     ah, fs:[bx]
        mov     bl, [si]
        and     bx, 000Fh
        add     bx, bx
        add     bx, WORD PTR dibInfo
        mov     al, fs:[bx]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     mov     es:[di], ah
        inc     di
        dec     cl
        jz      Decode
        mov     es:[di], al
        inc     di
        dec     cl
        jnz     @B
        jmp     Decode
Escape:
        mov     cl, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     cmp     cl, 2
        ja      Absolute
        je      DeltaSkip
        cmp     cl, 1
        je      EndOfBitmap
;
; End of current scanline.
;
        dec     cScans
        jz      EndOfBitmap
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
        jmp     Decode
;
; This is absolute mode, just copy the raw pixels into the bitmap.
;
Absolute:
        mov     bl, [si]
        shr     bx, 4
        and     bx, 000Fh
        add     bx, bx
        add     bx, WORD PTR dibInfo
        mov     ah, fs:[bx]
        mov     es:[di], ah
        inc     di
        mov     bl, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     dec     cl
        jz      @F
        and     bx, 000Fh
        add     bx, bx
        add     bx, WORD PTR dibInfo
        mov     al, fs:[bx]
        mov     es:[di], al
        inc     di
        dec     cl
        jnz     Absolute
@@:     test    si, 1                   ; Start decoding on word boundry
        jz      Decode
        inc     si
        jnz     Decode                  ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
        jmp     Decode
;
; Skip pixels.
;
DeltaSkip:
        sub     di, bmScanOffset
        push    di
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        xor     ah, ah
        mov     al, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     push    ax
        mov     cl, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     or      cl, cl
        jz      SkipHorizontal
;
; Skip vertical scanlines.
;        
SkipVertical:
        dec     cScans
        jz      SkipExit
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        dec     cl
        jnz     SkipVertical
        mov     bmScanOffset, di
;
; Skip horizontal scanlines
;
SkipHorizontal:
        pop     ax
        add     di, ax
        pop     ax
        add     di, ax
        jmp     Decode
SkipExit:
        pop     ax
        pop     ax
;
; End of bitmap.
;
EndOfBitmap:
        ret        

memRLE4ToColor  ENDP

memColorToRLE4  PROC NEAR USES fs es ds si di, dibInfo   : DWORD, dibBits      : DWORD,\
                                               bmBits    : DWORD, bmWidthBytes : WORD,\
                                               bmScanSeg : WORD,  bmFillBytes  : WORD,\
                                               iStart    : WORD,  cScans       : WORD,\
                                               cWidth    : WORD,  lpXlate      : DWORD
                LOCAL bmScanCount  : WORD,\
                      bmScanOffset : WORD,\
                      bmScanEnd    : WORD,\
                      dibSize      : DWORD
;
; Get pointer to first scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, WORD PTR bmBits + 2, WORD PTR bmBits
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Get pointer to compressed information.
;
        lds     si, dibBits
;
; Get pointer to color translation array.
;
        mov     fs, WORD PTR lpXlate + 2
;
; Zero out DIB size.
;
        mov     dibSize, 0

EncodeScanLine:
        mov     ax, di
        add     ax, cWidth
        mov     bmScanEnd, ax
EncodeNextField:
        cmp     di, bmScanEnd
        je      EndOfScanLine
        mov     ah, es:[di]                     ; Load starting pixel
        inc     di
        cmp     di, bmScanEnd
        je      Encode1Pixel                    ; 1 pixel left in scanline
        mov     al, es:[di]                     ; Get next pixel
        cmp     al, ah
        jne     EncodeAbsolute                  ; Not run length
        mov     dl, 1
EncodeRunLength:
        cmp     dl, 0FFh                        ; Runs can only be 255 long
        je      SaveRunLength
        inc     dl
        inc     di
        cmp     di, bmScanEnd                   ; Don't go past end of scanline
        je      SaveRunLength
        cmp     ah, es:[di]                     ; Get next pixel
        je      EncodeRunLength
SaveRunLength:
        mov     al, dl
        xor     bh, bh                          ; Load translated pixel
        mov     bl, ah
        add     bx, WORD PTR lpXlate
        mov     ah, fs:[bx]
        shl     ah, 4
        or      ah, fs:[bx]
        call    mempStoreRLE
        inc     dibSize
        jmp     EncodeNextField
Encode2Pixels:
        push    ax
        xor     bh, bh                          ; Load translated pixel
        mov     bl, ah
        add     bx, WORD PTR lpXlate
        mov     ah, fs:[bx]
        shl     ah, 4
        pop     bx
        xor     bh, bh                          ; Load translated pixel
        add     bx, WORD PTR lpXlate
        or      ah, fs:[bx]
        mov     al, 2
        call    mempStoreRLE
        inc     dibSize
        jmp     EndOfScanLine
Encode1Pixel:
        mov     al, 1
        xor     bh, bh                          ; Load translated pixel
        mov     bl, ah
        add     bx, WORD PTR lpXlate
        mov     ah, fs:[bx]
        shl     ah, 4
        call    mempStoreRLE
        inc     dibSize
        jmp     EndOfScanLine
;
; Look for two identical pixels before ending the absolute run.
;
EncodeAbsolute:
        dec     di                              ; Move back to first pixel
        push    di                              ; Save it
        inc     di
        mov     dl, 1
ScanAbsolute:
        cmp     dl, 0FFh
        je      SaveAbsoluteRun
        inc     dl
        inc     di
        cmp     di, bmScanEnd
        je      SaveAbsoluteRun
        mov     ah, al
        mov     al, es:[di]
        cmp     al, ah
        jne     ScanAbsolute
        cmp     dl, 3                           ; Need at least 3 pixels in absolute run
        jb      ScanAbsolute
SaveAbsoluteRun:
        pop     di                              ; Return to beginning of run
        cmp     dl, 2
        ja      @F
        jmp     Encode2Pixels                   ; Premature end of scanline
@@:     xor     al, al
        mov     ah, dl
        call    mempStoreRLE
        inc     dibSize
StoreAbsolute:
        xor     bh, bh                          ; Load translated pixel
        mov     bl, es:[di]
        inc     di
        add     bx, WORD PTR lpXlate
        mov     al, fs:[bx]
        shl     al, 4
        cmp     dl, 1
        je      @F                              ; Check for odd absolute run size
        dec     dl
        xor     bh, bh                          ; Load translated pixel
        mov     bl, es:[di]
        inc     di
        add     bx, WORD PTR lpXlate
        or      al, fs:[bx]
        cmp     dl, 1
        je      @F                              ; Check for odd absolute run size
        dec     dl
        xor     bh, bh                          ; Load translated pixel
        mov     bl, es:[di]
        inc     di
        add     bx, WORD PTR lpXlate
        mov     ah, fs:[bx]
        shl     ah, 4
        cmp     dl, 1
        je      @F                              ; Check for odd absolute run size
        dec     dl
        xor     bh, bh                          ; Load translated pixel
        mov     bl, es:[di]
        inc     di
        add     bx, WORD PTR lpXlate
        or      ah, fs:[bx]
@@:     call    mempStoreRLE
        inc     dibSize
        dec     dl
        jnz     StoreAbsolute
        jmp     EncodeNextField
;
; End of scanline - put escape code.
;
EndOfScanLine:
        xor     ax, ax
        call    mempStoreRLE
        inc     dibSize
        dec     cScans
        jz      EndOfBitmap
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
        jmp     EncodeScanLine
;
; End of bitmap - put escape code.
;
EndOfBitmap:
        mov     WORD PTR [si], 0100h
        inc     dibSize
;
; Return image size in ax:dx
;
        mov     ax, WORD PTR dibSize
        mov     dx, WORD PTR dibSize+2
        shl     ax, 1                           ; Mul by 2 to get byte size
        rcl     dx, 1
        ret        

memColorToRLE4  ENDP                                

mempStoreRLE    PROC
        mov     [si], ax
        add     si, 2
        jnz     @F
        mov     ax, ds
        add     ax, __AHIncr
        mov     ds, ax
@@:     ret
mempStoreRLE    ENDP

        END


