/****************************************************************************\
*                                                                            *
* Function: DIBitmap entrypoints                                             *
*                                                                            *
*       Handles all reading and writing of DIBs to memory and device.        *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/11/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"
#include "dibitmap.h"

DIBPROC memDIB[] =
{
    memMonoToDIB1,  memColorToDIB1,
    memMonoToDIB4,  memColorToDIB4,
    memMonoToDIB8,  memColorToDIB8,
    memMonoToDIB24, memColorToDIB24,
    memDIB1ToMono,  memDIB1ToColor, 
    memDIB4ToMono,  memDIB4ToColor, 
    memDIB8ToMono,  memDIB8ToColor, 
    memDIB24ToMono, memDIB24ToColor
};

WORD WINAPI DeviceBitmap
(
    LPBITMAP lpDst,
    WORD     wCommand,
    LPBITMAP lpBitmap,
    LPSTR    lpBits
)
{
    DBGMSG("DeviceBitmap\n\r");

    return(0);
}
    
WORD WINAPI DeviceBitmapBits
(
    LPBITMAP           lpDeviceBitmap,
    WORD               fGet,
    WORD               iStart,
    WORD               cScans,
    LPBYTE             dibBits,
    LPBITMAPINFOHEADER lpBitmapInfo,
    LPDRAWMODE         lpDrawMode,
    LPWORD             lpXlate
)
{
    USHORT   index;
    USHORT   dibWidthBytes;
    USHORT   width;
    LPBITMAP lpTmpBitmap;

    DBGMSG("DeviceBitmapBits\n\r");

    //
    // If lpDeviceBitmap is a device, exit with error.
    //

    if (lpDeviceBitmap->bmType != 0)
        return(0);

    //
    // Only handle DIBs of 1 plane.
    //

    if (lpBitmapInfo->biPlanes != 1)
        return(0);

    index = (lpDeviceBitmap->bmBitsPixel == 1) ? 0 : 1;

    //
    // Clip to minimum of DIB or bitmap.
    //
    if (cScans > lpDeviceBitmap->bmHeight)
        cScans = lpDeviceBitmap->bmHeight;
    iStart = (USHORT)lpBitmapInfo->biHeight - iStart - 1;
    width = lpDeviceBitmap->bmWidth;
    if (width > (WORD)lpBitmapInfo->biWidth)
        width = (WORD)lpBitmapInfo->biWidth;

    switch ((WORD)lpBitmapInfo->biCompression)
    {
        case BI_RGB:
            switch (lpBitmapInfo->biBitCount)
            {
                case 1:
                    dibWidthBytes = (((USHORT)lpBitmapInfo->biWidth + 31) / 8) & ~3;
                    if (!fGet) index += 8;
                    break;

                case 4:
                    dibWidthBytes = (((USHORT)lpBitmapInfo->biWidth + 7 ) / 2) & ~3;
                    index += 2;
                    if (!fGet) index += 8;
                    break;

                case 8:
                    dibWidthBytes = ((USHORT)lpBitmapInfo->biWidth + 3) & ~3;
                    index += 4;
                    if (!fGet) index += 8;
                    break;

                case 24:
                    dibWidthBytes = (((USHORT)lpBitmapInfo->biWidth * 3) + 3) & ~3;
                    index += 6;
                    if (!fGet) index += 8;
                    break;

                default:
                    return(0);
            }

            if (dibBits)
            {
                (*memDIB[index])(lpBitmapInfo,
                                 dibBits,
                                 dibWidthBytes,
                                 lpDeviceBitmap->bmBits,
                                 lpDeviceBitmap->bmWidthBytes,
                                 lpDeviceBitmap->bmSegmentIndex ? lpDeviceBitmap->bmScanSegment : 0x7FFF,
                                 lpDeviceBitmap->bmFillBytes,
                                 width,
                                 iStart,
                                 cScans,
                                 lpXlate);
            }
            else
            {
                lpBitmapInfo->biSizeImage = (ULONG)dibWidthBytes * (ULONG)cScans;
            }
            break;

        case BI_RLE8:
            if (dibBits)
            {
                //
                // Only RLEs to color bitmaps is supported in the memory code
                // so translations to and from mono bitmaps must be handled
                // from temporary color bitmaps.
                //

                if (lpDeviceBitmap->bmBitsPixel == 1)
                {
                    lpTmpBitmap = CreateColorBitmap(lpDeviceBitmap->bmWidth, lpDeviceBitmap->bmHeight);
                    memBltSD_MonoToColor(lpTmpBitmap->bmBits,
                                         lpTmpBitmap->bmWidthBytes,
                                         lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                                         lpTmpBitmap->bmFillBytes,
                                         0,
                                         0,
                                         lpDeviceBitmap->bmBits,
                                         lpDeviceBitmap->bmWidthBytes,
                                         lpDeviceBitmap->bmSegmentIndex ? lpDeviceBitmap->bmScanSegment : 0x7FFF,
                                         lpDeviceBitmap->bmFillBytes,
                                         0,
                                         0,
                                         lpDeviceBitmap->bmWidth,
                                         lpDeviceBitmap->bmHeight,
                                         lpDrawMode->TextColor,
                                         lpDrawMode->bkColor,
                                         0x0C); // R2_COPYPEN
                }
                else
                {
                    lpTmpBitmap = lpDeviceBitmap;
                }
                if (fGet)
                {
                    lpBitmapInfo->biSizeImage = memColorToRLE8(lpBitmapInfo,
                                                               dibBits,
                                                               lpTmpBitmap->bmBits,
                                                               lpTmpBitmap->bmWidthBytes,
                                                               lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                                                               lpTmpBitmap->bmFillBytes,
                                                               iStart,
                                                               cScans,
                                                               width,
                                                               lpXlate);
                }
                else
                {
                    memRLE8ToColor(lpBitmapInfo,
                                   dibBits,
                                   lpTmpBitmap->bmBits,
                                   lpTmpBitmap->bmWidthBytes,
                                   lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                                   lpTmpBitmap->bmFillBytes,
                                   iStart,
                                   cScans,
                                   width,
                                   lpXlate);
                    if (lpTmpBitmap != lpDeviceBitmap)
                    {
                        memConvertColorBitmap(lpDeviceBitmap->bmBits,
                                              lpDeviceBitmap->bmWidthBytes,
                                              lpDeviceBitmap->bmSegmentIndex ? lpDeviceBitmap->bmScanSegment : 0x7FFF,
                                              lpDeviceBitmap->bmFillBytes,
                                              lpTmpBitmap->bmBits,
                                              lpTmpBitmap->bmWidthBytes,
                                              lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                                              lpTmpBitmap->bmFillBytes,
                                              0,
                                              0,
                                              lpDeviceBitmap->bmWidth,
                                              lpDeviceBitmap->bmHeight,
                                              lpDrawMode->bkColor);
                    }
                }
                if (lpTmpBitmap != lpDeviceBitmap)
                    DestroyBitmap(lpTmpBitmap);
            }
            else
            {
                lpBitmapInfo->biSizeImage = (ULONG)width * (ULONG)cScans * 2 + ((ULONG)cScans + 1) * 2;
            }
            break;
        case BI_RLE4:
            if (dibBits)
            {
                //
                // Only RLEs to color bitmaps is supported in the memory code
                // so translations to and from mono bitmaps must be handled
                // from temporary color bitmaps.
                //

                if (lpDeviceBitmap->bmBitsPixel == 1)
                {
                    lpTmpBitmap = CreateColorBitmap(lpDeviceBitmap->bmWidth, lpDeviceBitmap->bmHeight);
                    memBltSD_MonoToColor(lpTmpBitmap->bmBits,
                                         lpTmpBitmap->bmWidthBytes,
                                         lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                                         lpTmpBitmap->bmFillBytes,
                                         0,
                                         0,
                                         lpDeviceBitmap->bmBits,
                                         lpDeviceBitmap->bmWidthBytes,
                                         lpDeviceBitmap->bmSegmentIndex ? lpDeviceBitmap->bmScanSegment : 0x7FFF,
                                         lpDeviceBitmap->bmFillBytes,
                                         0,
                                         0,
                                         lpDeviceBitmap->bmWidth,
                                         lpDeviceBitmap->bmHeight,
                                         lpDrawMode->TextColor,
                                         lpDrawMode->bkColor,
                                         0x0C); // R2_COPYPEN
                }
                else
                {
                    lpTmpBitmap = lpDeviceBitmap;
                }
                if (fGet)
                {
                    lpBitmapInfo->biSizeImage = memColorToRLE4(lpBitmapInfo,
                                                               dibBits,
                                                               lpTmpBitmap->bmBits,
                                                               lpTmpBitmap->bmWidthBytes,
                                                               lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                                                               lpTmpBitmap->bmFillBytes,
                                                               iStart,
                                                               cScans,
                                                               width,
                                                               lpXlate);
                }
                else
                {
                    memRLE4ToColor(lpBitmapInfo,
                                   dibBits,
                                   lpTmpBitmap->bmBits,
                                   lpTmpBitmap->bmWidthBytes,
                                   lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                                   lpTmpBitmap->bmFillBytes,
                                   iStart,
                                   cScans,
                                   width,
                                   lpXlate);
                    if (lpTmpBitmap != lpDeviceBitmap)
                    {
                        memConvertColorBitmap(lpDeviceBitmap->bmBits,
                                              lpDeviceBitmap->bmWidthBytes,
                                              lpDeviceBitmap->bmSegmentIndex ? lpDeviceBitmap->bmScanSegment : 0x7FFF,
                                              lpDeviceBitmap->bmFillBytes,
                                              lpTmpBitmap->bmBits,
                                              lpTmpBitmap->bmWidthBytes,
                                              lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                                              lpTmpBitmap->bmFillBytes,
                                              0,
                                              0,
                                              lpDeviceBitmap->bmWidth,
                                              lpDeviceBitmap->bmHeight,
                                              lpDrawMode->bkColor);
                    }
                }
                if (lpTmpBitmap != lpDeviceBitmap)
                    DestroyBitmap(lpTmpBitmap);
            }
            else
            {
                lpBitmapInfo->biSizeImage = (ULONG)width * (ULONG)cScans + ((ULONG)cScans + 1) * 2;
            }
            break;
        default:
            return(0);
    }
    return(cScans);
}

WORD WINAPI CreateBitmap
(
    VOID
)
{
    DBGMSG("CreateBitmap\n\r");

    return(0);
}

