/****************************************************************************\
*                                                                            *
* Function: Enable/Disable entrypoints                                       *
*                                                                            *
*       Enable and disable the display driver.                               *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/11/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"
#include "enable.h"

GDIINFO gdiInfo =
{
    0x030A,                             // dpVersion
    DT_RASDISPLAY,                      // dpTechnology
    0,                                  // dpHorzSize
    0,                                  // dpVertSize
    0,                                  // dpHorzRes
    0,                                  // dpVertRes
    0,                                  // dpBitsPixel
    1,                                  // dpPlanes
    0xFFFF,                             // dpNumBrushes
    0,                                  // dpNumPens
    0,                                  // future use
    0,                                  // dpNumFonts
    0,                                  // dpNumColors
    sizeof(DEVICE),                     // dpDeviceSize
    CC_NONE,                            // dpCurves
    LC_POLYLINE,                        // dpLines
    PC_POLYGON      |
    PC_SCANLINE     |
    PC_INTERIORS,                       // dpPolygonals
    TC_CP_STROKE    |
    TC_RA_ABLE,                         // dpText
    CP_RECTANGLE,                       // dpClip
    RC_BITBLT       |
    RC_BITMAP64     |
    RC_GDI20_OUTPUT |
    RC_SAVEBITMAP   |
    RC_DI_BITMAP    |
    RC_DIBTODEV     |
    RC_OP_DX_OUTPUT |
    RC_BIGFONT,                         // dpRaster
    10,                                 // dpAspectX
    10,                                 // dpAspectY
    14,                                 // dpAspectXY
    28,                                 // dpStylePen
    {0, 0},                             // dpMLoWin
    {0, 0},                             // dpMLoVpt
    {0, 0},                             // dpMHiWin
    {0, 0},                             // dpMHiVpt
    {0, 0},                             // dpELoWin
    {0, 0},                             // dpELoVpt
    {0, 0},                             // dpEHiWin
    {0, 0},                             // dpEHiVpt
    {0, 0},                             // dpTwpWin
    {0, 0},                             // dpTwpVpt
    0,                                  // dpLogPixelsX
    0,                                  // dpLogPixelsY
    DC_IgnoreDFNP,                      // dpDCManage
    0,                                  // dpCaps1
    0,                                  // dpSpotSizeX
    0,                                  // dpSpotSizeY
    0,                                  
    0,                                  
    0,                                  // dpPalColors
    20,                                 // dpPalReserved
    24,                                 // dpPalResolution
};

WORD WINAPI Enable
(
    LPVOID  lpDevInfo,
    WORD    wStyle,
    LPSTR   lpDevType,
    LPSTR   lpOutputFile,
    LPVOID  lpData
)
{
    DBGMSG("Enable\n\r");

    if (wStyle & 0x0001)
    {
        //
        // Have the hardware specifec code fill in any applicable values in
        // the GDIINGO structure before passing it back to GDI. Only do
        // this once.
        //

        devGdiInfo(&gdiInfo);
        FarMemMove((LPSTR)&gdiInfo, (LPSTR)lpDevInfo, sizeof(GDIINFO));
        return(sizeof(GDIINFO));
    }
    else 
    {
        //
        // Get device specific information into PDEV.
        //

        devDevInfo(lpDevInfo);
        if (!(wStyle & 0x8000))
        {
            //
            // Use this opportunity to allocate temporary bitmaps.
            //

            AllocTmpBitmaps();

            //
            // Have the hardware specific code initialize the hardware to the
            // correct mode.
            //

            return(devEnableHW());
        }
    }
}

VOID WINAPI Disable
(
    LPDEVICE lpDst
)
{
    DBGMSG("Disable\n\r");

    //
    // Free temporary bitmaps.
    //

    FreeTmpBitmaps();

    //
    // Disable hardware specific features.
    //

    devDisableHW();
}

