/****************************************************************************\
*                                                                            *
* Function: Enumeration entrypoints                                          *
*                                                                            *
*       Enumerate fonts or objects.                                          *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/11/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"
#include "enum.h"

WORD WINAPI EnumDFonts
(
    LPBITMAP lpDst,
    LPSTR    lpFaceName,
    FARPROC  lpCallbackFunc,
    LPVOID   lpClientData
)
{
    DBGMSG("EnumDFonts\n\r");

    //
    // We ain't got no device fonts.
    //

    return(1);
}

WORD WINAPI EnumObj
(
    LPBITMAP lpDst,
    WORD     wStyle,
    FARPROC  lpCallbackFunc,
    LPVOID   lpClientData
)
{
    LOGBRUSH lobr;
    LOGPEN   lopn;
    USHORT   ii;
    USHORT   jj;

    WORD    retval;

    DBGMSG("EnumObj\n\r");

    switch (wStyle)
    {
        case 1:

            //
            // Enumerate pens.
            //

            lopn.lopnStyle        = LS_SOLID;
            lopn.lopnWidth.xcoord = 1;
            lopn.lopnWidth.ycoord = 1;

            for (ii = 0; ii < gdiInfo.dpPalReserved; ii++)
            {
                lopn.lopnColor = devSystemPalette[ii] & 0x00FFFFFF;
                if ((retval=(WORD)(*lpCallbackFunc)((LPLOGPEN)&lopn, lpClientData)) == 0)
                    return(0);
            }
            return(retval);
            break;

        case 2:

            //
            // Enumerate solid brushes.
            //

            lobr.lbStyle   = BS_SOLID;
            lobr.lbHatch   = 0;
            lobr.lbBkColor = 0;

            for (ii = 0; ii < gdiInfo.dpPalReserved; ii++)
            {
                lobr.lbColor = devSystemPalette[ii] & 0x00FFFFFF;
                if ((retval=(WORD)(*lpCallbackFunc)((LPLOGBRUSH)&lobr, lpClientData)) == 0)
                    return(0);
            }

            //
            // Enumerate the 6 hatch brushes.
            //

            lobr.lbStyle = BS_HATCHED;

            for (jj = 0; jj < 6; jj++)
            {
                lobr.lbHatch = jj;
                for (ii = 0; ii < gdiInfo.dpPalReserved; ii++)
                {
                    lobr.lbColor = devSystemPalette[ii] & 0x00FFFFFF;
                    if ((retval=(WORD)(*lpCallbackFunc)((LPLOGBRUSH)&lobr, lpClientData)) == 0)
                        return(0);
                }
            }
            return(retval);
            break;

        default:

            //
            // Return with error.
            //

            return(1);
    }

    return(0);
}

