/****************************************************************************\
*                                                                            *
* Function: Pixel and ColorInfo entrypoints                                  *
*                                                                            *
*       Gets, sets, and converts colors and pixels.                          *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/11/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"
#include "pixel.h"

DWORD WINAPI Pixel
(
    LPBITMAP   lpDst,
    WORD       X,
    WORD       Y,
    DWORD      dwColor,
    LPDRAWMODE lpDrawMode
)
{
    DBGMSG("Pixel\n\r");

    if ((X >= lpDst->bmWidth) || (Y >= lpDst->bmHeight))
    {
        //
        // Return error.
        //

        return(0x80000000L);
    }

    if (lpDrawMode)
    {
        //
        // Set pixel
        //

        if (lpDst->bmType == 0)
        {
            SetBitmapPixel(lpDst, X, Y, dwColor, lpDrawMode->Rop2 - 1);
        }
        else
        {
            devSetPixel(X, Y, dwColor, lpDrawMode->Rop2 - 1);
        }
                  
        return(TRUE);
    }
    else
    {
        //
        // Get pixel
        //

        if (lpDst->bmType == 0)
        {
            return(GetBitmapPixel(lpDst, X, Y));
        }
        else
        {
            return(devGetPixel(X, Y));
        }
    }
}

WORD WINAPI ScanLR
(
    LPBITMAP lpDst,
    WORD     X,
    WORD     Y,
    DWORD    dwPhysColor,
    WORD     Style
)
{
    WORD     retVal;
    LPBITMAP lpTmpBitmap;

    DBGMSG("ScanLR\n\r");

    if ((X >= lpDst->bmWidth) || (Y >= lpDst->bmHeight))
    {
        //
        // Return error.
        //

        return(0x8000);
    }

    lpTmpBitmap = lpDst;

    if (lpDst->bmType != 0)
    {
        //
        // If this is a device, get the scanline into memory.
        //

        lpTmpBitmap = CreateColorBitmap(lpDst->bmWidth, 1);
        devBltSD_ToColor(lpTmpBitmap->bmBits,
                         lpTmpBitmap->bmWidthBytes,
                         lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                         lpTmpBitmap->bmFillBytes,
                         0,
                         0,
                         0,
                         Y,
                         lpDst->bmWidth,
                         1);
        Y = 0;
    }
    
    if (lpTmpBitmap->bmBitsPixel == 1)
    {
        //
        // Convert a monochrome scanline into a color scanline.
        //

        lpTmpBitmap = CreateColorBitmap(lpDst->bmWidth, 1);
        memBltSD_MonoToColor(lpDst->bmBits,
                                lpTmpBitmap->bmWidthBytes,
                                lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                                lpTmpBitmap->bmFillBytes,
                                0,
                                0,
                                lpDst->bmBits,
                                lpDst->bmWidthBytes,
                                lpDst->bmSegmentIndex ? lpDst->bmScanSegment : 0x7FFF,
                                lpDst->bmFillBytes,
                                0,
                                Y,
                                lpDst->bmWidth,
                                1,
                                0xFF000000L,
                                0xFFFFFFFFL,
                                0x0C); // R2_COPYPEN
        Y = 0;
    }

    //
    // Scan a color scanline.
    //

    retVal = memScanColorLR(lpTmpBitmap->bmBits,
                            lpTmpBitmap->bmWidthBytes,
                            lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                            lpTmpBitmap->bmFillBytes,
                            lpTmpBitmap->bmWidth,
                            X,
                            Y,
                            dwPhysColor,
                            Style);

    if (lpDst != lpTmpBitmap)
    {
        //
        // Destroy temporary memory if this was a device scanline.
        //

        DestroyBitmap(lpTmpBitmap);
    }

    return(retVal);
}

DWORD WINAPI ColorInfo
(
    LPBITMAP lpDst,
    DWORD    dwColor,
    LPDWORD  lpColor
)
{
    DBGMSG("ColorInfo\n\r");

    if (lpColor)
    {
        //
        // Match to a physical color.
        //

        *lpColor = dwColor = devMatchPhysicalColor(dwColor);
    }

    //
    // Return logical color of matched or passed in color.
    //

    if (lpDst->bmBitsPixel == 1)
        return(devMonoMatchLogicalColor(dwColor) & 0x00FFFFFFL);
    else 
        return(devColorMatchLogicalColor(dwColor) & 0x00FFFFFFL);
}

