/****************************************************************************\
*                                                                            *
* Function: RealizeObject entrypoint                                         *
*                                                                            *
*       Create or destroy physical object.                                   *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/11/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"
#include "realize.h"
#include "bitblt.h"

extern DWORD devBrushSize;
extern WORD  memBytesPerPixel;

BYTE brHatch[6][8] =
{
    { 0x00,                                 // ........     HS_HORIZONTAL 0
      0x00,                                 // ........
      0x00,                                 // ........
      0xff,                                 // ********
      0x00,                                 // ........
      0x00,                                 // ........
      0x00,                                 // ........
      0x00},                                // ........

    { 0x08,                                 // ....*...     HS_VERTICAL 1
      0x08,                                 // ....*...
      0x08,                                 // ....*...
      0x08,                                 // ....*...
      0x08,                                 // ....*...
      0x08,                                 // ....*...
      0x08,                                 // ....*...
      0x08},                                // ....*...

    { 0x01,                                 // .......*     HS_FDIAGONAL 2
      0x02,                                 // ......*.
      0x04,                                 // .....*..
      0x08,                                 // ....*...
      0x10,                                 // ...*....
      0x20,                                 // ..*.....
      0x40,                                 // .*......
      0x80},                                // *.......

    { 0x80,                                 // *.......     HS_BDIAGONAL 3
      0x40,                                 // .*......
      0x20,                                 // ..*.....
      0x10,                                 // ...*....
      0x08,                                 // ....*...
      0x04,                                 // .....*..
      0x02,                                 // ......*.
      0x01},                                // .......*

    { 0x08,                                 // ....*...     HS_CROSS 4
      0x08,                                 // ....*...
      0x08,                                 // ....*...
      0xff,                                 // ********
      0x08,                                 // ....*...
      0x08,                                 // ....*...
      0x08,                                 // ....*...
      0x08},                                // ....*...

    { 0x81,                                 // *......*     HS_DIAGCROSS 5
      0x42,                                 // .*....*.
      0x24,                                 // ..*..*..
      0x18,                                 // ...**...
      0x18,                                 // ...**...
      0x24,                                 // ..*..*..
      0x42,                                 // .*....*.
      0x81}                                 // *......*
};

DWORD WINAPI RealizeObject
(
    LPBITMAP lpDst,
    WORD     wStyle,
    LPVOID   lpInObj,
    LPVOID   lpOutObj,
    WORD     BrushOrgY,
    WORD     BrushOrgX
)
{
    LPBITMAP lpBrushPattern;

    DBGMSG("RealizeObject\n\r");

    if (wStyle > 0)
    {
        switch (wStyle)
        {
            case 1:

                DBGMSG("RealizePen\n\r");

                //
                // Realize a pen.
                //

                if (lpOutObj == NULL)
                {
                    //
                    // Just return the size of the physical pen.
                    //

                    return(sizeof(PEN));
                }

                //
                // Fill in the rest of the physical structure.
                // Get physical color of logical pen.
                //

                ((LPPEN)lpOutObj)->pnColor = devMatchPhysicalColor(((LPLOGPEN)lpInObj)->lopnColor);
                ((LPPEN)lpOutObj)->pnFlags = ((LPLOGPEN)lpInObj)->lopnStyle;

                return(1L);

            case 2:

                DBGMSG("RealizeBrush\n\r");

                //
                // Realize a brush.
                //

                if (lpOutObj == NULL)
                {
                    //
                    // Return size of device brush plus size of color bitmap bits array 
                    // minus one from the structures array definition.
                    //

                    return(devBrushSize);
                }
                switch (((LPLOGBRUSH)lpInObj)->lbStyle)
                {
                    case BS_SOLID:

                        //
                        // A solid brush has both a monochrome and a color
                        // component unless it is a color index.
                        //

                        ((LPBRUSH)lpOutObj)->brFlags = BRUSH_COLOR;
                        devDitherBrush((LPBRUSH)lpOutObj, ((LPLOGBRUSH)lpInObj)->lbColor);
                        break;

                    case BS_HOLLOW:

                        //
                        // A hollow brush is just a place holder for Rops altering
                        // the destination only.
                        //

                        ((LPBRUSH)lpOutObj)->brFlags    = BRUSH_HOLLOW;
                        ((LPBRUSH)lpOutObj)->brClrSolid = 0;
                        break;

                    case BS_HATCHED:

                        //
                        // Copy hatched brush bits into device brush structure.
                        //

                        ((LPBRUSH)lpOutObj)->brFlags             = BRUSH_HATCHED;
                        ((LPBRUSH)lpOutObj)->brClrFore           = devMatchPhysicalColor(((LPLOGBRUSH)lpInObj)->lbColor);
                        ((LPBRUSH)lpOutObj)->brClrBack           = ((LPLOGBRUSH)lpInObj)->lbBkColor;
                        *((LPULONG)(((LPBRUSH)lpOutObj)->brPatBits)) = *((PULONG)brHatch[((LPLOGBRUSH)lpInObj)->lbHatch]);
                        *((LPULONG)(((LPBRUSH)lpOutObj)->brPatBits) + 1) = *((PULONG)brHatch[((LPLOGBRUSH)lpInObj)->lbHatch] + 1);
                        memConvertMonoBrush((LPBRUSH)lpOutObj);
                        break;

                    case BS_PATTERN:

                        //
                        // User defined brush.
                        //

                        lpBrushPattern = (LPBITMAP)((LPLOGBRUSH)lpInObj)->lbColor;
                        if (lpBrushPattern->bmBitsPixel == 1)
                        {
                            //
                            // Monochrome bitmap pattern.
                            //

                            ((LPBRUSH)lpOutObj)->brFlags = BRUSH_MONO | BRUSH_PATTERN;

                            //
                            // Must swap the definition between bitmap bits 
                            // and brush bits.
                            //

                            ((LPBRUSH)lpOutObj)->brPatBits[0] = (BYTE)~lpBrushPattern->bmBits[0];
                            ((LPBRUSH)lpOutObj)->brPatBits[1] = (BYTE)~lpBrushPattern->bmBits[lpBrushPattern->bmWidthBytes];
                            ((LPBRUSH)lpOutObj)->brPatBits[2] = (BYTE)~lpBrushPattern->bmBits[lpBrushPattern->bmWidthBytes * 2];
                            ((LPBRUSH)lpOutObj)->brPatBits[3] = (BYTE)~lpBrushPattern->bmBits[lpBrushPattern->bmWidthBytes * 3];
                            ((LPBRUSH)lpOutObj)->brPatBits[4] = (BYTE)~lpBrushPattern->bmBits[lpBrushPattern->bmWidthBytes * 4];
                            ((LPBRUSH)lpOutObj)->brPatBits[5] = (BYTE)~lpBrushPattern->bmBits[lpBrushPattern->bmWidthBytes * 5];
                            ((LPBRUSH)lpOutObj)->brPatBits[6] = (BYTE)~lpBrushPattern->bmBits[lpBrushPattern->bmWidthBytes * 6];
                            ((LPBRUSH)lpOutObj)->brPatBits[7] = (BYTE)~lpBrushPattern->bmBits[lpBrushPattern->bmWidthBytes * 7];
                        }
                        else
                        {
                            //
                            // Color bitmap pattern.
                            //

                            ((LPBRUSH)lpOutObj)->brFlags = BRUSH_COLOR | BRUSH_PATTERN;
                            memBltSD_ColorToColor(((LPBRUSH)lpOutObj)->brColorBits,
                                                  8 * memBytesPerPixel,
                                                  0x7FFF,
                                                  0,
                                                  0,
                                                  0,
                                                  lpBrushPattern->bmBits,
                                                  lpBrushPattern->bmWidthBytes,
                                                  lpBrushPattern->bmSegmentIndex ? lpBrushPattern->bmScanSegment : 0x7FFF,
                                                  lpBrushPattern->bmFillBytes,
                                                  0,
                                                  0,
                                                  8,
                                                  8,
                                                  0x0C);
                        }

                        //
                        // Zero out the foreground and background colors
                        // so the actual mono bits will be calculated with
                        // the user defined colors.
                        //

                        ((LPBRUSH)lpOutObj)->brClrFore     = 0x00000000L;
                        ((LPBRUSH)lpOutObj)->brClrBack     = 0x00000000L;
                        break;

                    default:
                        DBGMSG("Realizing unknown brush type!\n\r");
                        ((LPBRUSH)lpOutObj)->brFlags = 0;
                }

                //
                // Record brush origin.
                //

                ((LPBRUSH)lpOutObj)->brX = BrushOrgX;
                ((LPBRUSH)lpOutObj)->brY = BrushOrgY;

                //
                // Return success.
                //

                return(1L);

            default:

                //
                // Realize a font or bitmap.
                //

                return(0L);
        }
    }
    return(1L);
}
