.MODEL SMALL, PASCAL

incDrawMode     EQU     1
incFont         EQU     1

        INCLUDE COMMON.INC
        INCLUDE TEXTOUT.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Calculate extent of a string and fill position array             ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/18/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
           
.DATA

EXTERN  _GlyphInfo   : WORD
EXTERN  _BreakErrExt : WORD

.CODE
.386

GetCharWidth    PROC FAR USES esi edi ds es,            \
                        lpDst        : DWORD,           \
                        lpBuffer     : DWORD,           \
                        wFirstChar   : WORD,            \
                        wLastChar    : WORD,            \
                        lpFontInfo   : DWORD,           \
                        lpDrawMode   : DWORD,           \
                        lpTextXForm  : DWORD
                LOCAL                                   \
                        CharExtra     : WORD,           \
                        TtlBreakExtra : WORD,           \
                        BreakExtra    : WORD,           \
                        BreakErr      : WORD,           \
                        BreakRem      : WORD,           \
                        BreakCount    : WORD,           \
                        FontLastChar  : BYTE

        les     bx, lpDrawMode
        mov     ax, es:[bx][DRAWMODE.CharExtra]
        mov     CharExtra, ax
        mov     ax, es:[bx][DRAWMODE.TBreakExtra]
        mov     TtlBreakExtra, ax
        mov     ax, es:[bx][DRAWMODE.BreakExtra]
        mov     BreakExtra, ax
        mov     ax, es:[bx][DRAWMODE.BreakRem]
        mov     BreakRem, ax
        mov     ax, es:[bx][DRAWMODE.BreakCount]
        mov     BreakCount, ax
        mov     ax, es:[bx][DRAWMODE.BreakErr]
        mov     BreakErr, ax
        les     di, lpBuffer
        lds     si, lpFontInfo
        mov     cx, wFirstChar
        mov     al, [si][FONTINFO.dfLastChar]
        sub     al, [si][FONTINFO.dfFirstChar]
        mov     FontLastChar, al
CharWidthLoop:
        mov     dl, cl
        sub     dl, [si][FONTINFO.dfFirstChar]
        cmp     dl, FontLastChar
        jbe     @F
        mov     dl, [si][FONTINFO.dfDefaultChar]
@@:     xor     ax, ax
        cmp     dl, [si][FONTINFO.dfBreakChar]
        jne     CharWidthCalcBreakReturn
        cmp     TtlBreakExtra, 0
        jne     CharWidthCalcBreak
CharWidthCalcBreakReturn:

;
; Get character width from font table.
;
        xor     dh, dh
        add     dx, dx
        add     si, dx
        add     dx, dx
        add     si, dx
        add     ax, [si][FONTINFO.dfCharOffset]
        mov     si, WORD PTR lpFontInfo         ; Reload si
        add     ax, CharExtra
        mov     es:[di], ax
        add     di, 2
        cmp     cx, wLastChar
        jz      Exit
        inc     cx
        jmp     CharWidthLoop
CharWidthCalcBreak:
        add     ax, BreakExtra
        mov     dx, BreakErr
        sub     dx, BreakRem
        jns     @F
        inc     ax
        add     dx, BreakCount
@@:     mov     BreakErr, dx
        jmp     CharWidthCalcBreakReturn
Exit:
        ret
GetCharWidth    ENDP

;
; This routine calculates the extents of a string. The BreakErr in DrawMode
; is updated.
;

CalcTextExtent  PROC NEAR USES esi edi ds es fs,        \
                        lpString     : DWORD,           \
                        lpFontInfo   : DWORD,           \
                        lpCharWidths : DWORD,           \
                        lpDrawMode   : DWORD,           \
                        wCount       : WORD
                LOCAL                                   \
                        CharExtra     : WORD,           \
                        TtlBreakExtra : WORD,           \
                        LastChar      : BYTE

        mov     di, WORD PTR lpCharWidths
        mov     ax, WORD PTR lpCharWidths+2
        or      ax, di
        jz      GetFontInfo

;
; Fill position array with user defined spacing.
;
        mov     es, lpCharWidths + 2
        mov     cx, wCount
        xor     ax, ax
CharWidthLoop:
        add     ax, es:[di]
        add     di, 2
        dec     cx
        jnz     CharWidthLoop
        lds     si, lpFontInfo
        sub     di, 2
        cmp     WORD PTR es:[di], 0
        jne     Exit
        les     di, lpString
        add     di, wCount
        dec     di
        mov     dl, es:[di]
        sub     dl, [si][FONTINFO.dfFirstChar]
        xor     dh, dh
        add     dx, dx
        mov     di, si
        add     di, dx
        add     dx, dx
        add     di, dx
        add     ax, [di][FONTINFO.dfCharOffset]
        jmp     Exit
;
; Get interesting data out of the font structure.
;
GetFontInfo:
        push    ds
        pop     es

        ASSUME  ds : NOTHING, es :@DATA

        lds     si, lpFontInfo
        mov     al, [si][FONTINFO.dfLastChar]
        sub     al, [si][FONTINFO.dfFirstChar]
        mov     LastChar, al
        les     di, lpDrawMode
        mov     ax, es:[di][DRAWMODE.CharExtra]
        mov     dx, es:[di][DRAWMODE.TBreakExtra]
        mov     cx, ax
        or      cx, dx
        jz      StdWidth
        mov     CharExtra, ax
        mov     TtlBreakExtra, dx
;
; Do proporional width spacing.
;
        lfs     bx, lpString
        mov     cx, wCount
        xor     ax, ax
;
; Load character and calculate width with proportional spacing.
;
PropWidthLoop:
        mov     dl, fs:[bx]
        inc     bx
        sub     dl, [si][FONTINFO.dfFirstChar]
        cmp     dl, LastChar
        ja      PropGetDefault
PropGetDefaultReturn:
        cmp     dl, [si][FONTINFO.dfBreakChar]
        je      PropCalcBreak
;
; Get character width from font table.
;
        xor     dh, dh
        add     dx, dx
        add     si, dx
        add     dx, dx
        add     si, dx
        add     ax, [si][FONTINFO.dfCharOffset]
        mov     si, WORD PTR lpFontInfo         ; Restore si
        add     ax, CharExtra
        dec     cx
        jnz     PropWidthLoop
        jmp     Exit
PropGetDefault:
        mov     dl, [si][FONTINFO.dfDefaultChar]
        jmp     PropGetDefaultReturn
PropCalcBreak:
;
; Get character width from font table.
;
        xor     dh, dh
        add     dx, dx
        add     si, dx
        add     dx, dx
        add     si, dx
        add     ax, [si][FONTINFO.dfCharOffset]
        mov     si, WORD PTR lpFontInfo         ; Restore si
        add     ax, CharExtra
        cmp     TtlBreakExtra, 0
        jne     @F
        dec     cx
        jnz     PropWidthLoop
        jmp     Exit
@@:     add     ax, es:[di][DRAWMODE.BreakExtra]
        mov     dx, es:[di][DRAWMODE.BreakErr]
        sub     dx, es:[di][DRAWMODE.BreakRem]
        js      PropBreakWrap
        mov     es:[di][DRAWMODE.BreakErr], dx
        dec     cx
        jnz     PropWidthLoop
        jmp     Exit
PropBreakWrap:
        inc     ax
        add     dx, es:[di][DRAWMODE.BreakCount]
        mov     es:[di][DRAWMODE.BreakErr], dx
        dec     cx
        jnz     PropWidthLoop
        jmp     Exit
;
; Do standard width spacing.
;
StdWidth:
        mov     cx, wCount
        xor     ax, ax
        mov     dx, [si][FONTINFO.dfPixWidth]
        or      dx, dx
        jnz     MonoWidth
        lfs     bx, lpString
VarWidthLoop:
        mov     dl, fs:[bx]
        inc     bx
        sub     dl, [si][FONTINFO.dfFirstChar]
        cmp     dl, LastChar
        ja      VarGetDefault
VarGetDefaultReturn:
;
; Get character width from font table.
;
        xor     dh, dh
        add     dx, dx
        mov     di, si
        add     di, dx
        add     dx, dx
        add     di, dx
        add     ax, [di][FONTINFO.dfCharOffset]
        dec     cx
        jnz     VarWidthLoop
        jmp     Exit
VarGetDefault:
        mov     dl, [si][FONTINFO.dfDefaultChar]
        jmp     VarGetDefaultReturn
;
; This is a mono spaced font - easy as pie.
;
MonoWidth:
        imul    dx, cx
        mov     ax, dx
Exit:
        mov     dx, [si][FONTINFO.dfPixHeight]
        ret
CalcTextExtent   ENDP

;
; This routine is just like CalcTextExtent except that it also fills in a
; horizontal position array.  The X extent is biased by xDst.
;

GetGlyphInfo    PROC NEAR USES esi edi ds es fs,        \
                        lpString     : DWORD,           \
                        lpFontInfo   : DWORD,           \
                        lpCharWidths : DWORD,           \
                        lpDrawMode   : DWORD,           \
                        wCount       : WORD,            \
                        lpOptions    : DWORD
                LOCAL   GlyphOffset : WORD, GlyphHeight : WORD, CharExtra : WORD, TtlBreakExtra : WORD, \
                        BreakErr    : WORD, BreakExtra  : WORD, BreakRem  : WORD, BreakCount : WORD,    \
                        BreakChar   : BYTE, DefaultChar : BYTE, FirstChar   : BYTE, LastChar  : BYTE

        push    ds
        pop     es

        ASSUME  ds : NOTHING, es :@DATA

        lds     si, lpFontInfo
        mov     ax, si
        add     ax, FONTINFO.dfCharOffset
        mov     GlyphOffset, ax
        mov     ax, [si][FONTINFO.dfPixHeight]
        mov     GlyphHeight, ax
        mov     al, [si][FONTINFO.dfDefaultChar]
        mov     DefaultChar, al
        mov     al, [si][FONTINFO.dfBreakChar]
        mov     BreakChar, al
        mov     al, [si][FONTINFO.dfLastChar]
        mov     ah, [si][FONTINFO.dfFirstChar]
        sub     al, ah
        mov     LastChar, al
        mov     FirstChar, ah
        mov     di, WORD PTR lpCharWidths
        mov     ax, WORD PTR lpCharWidths+2
        or      ax, di
        jz      GetDrawMode
;
; Fill position array with user defined spacing.
;
        lfs     bx, lpOptions
        or      WORD PTR fs:[bx], ETO_USERWIDTH
        mov     ds, WORD PTR lpCharWidths + 2
        mov     di, OFFSET _GlyphInfo
        lfs     bx, lpString
        xor     cx, cx
        xor     ax, ax
CharWidthLoop:
        mov     dl, fs:[bx]
        inc     bx
        sub     dl, FirstChar
        cmp     dl, LastChar
        ja      CharWidthGetDefault
CharWidthGetDefaultReturn:
;
; Calculate offset into font structure.
;
        xor     dh, dh
        add     dx, dx
        mov     si, dx
        add     dx, dx
        add     si, dx
        add     si, GlyphOffset
        cmp     di, OFFSET _GlyphInfo + MAX_CHAR_COUNT * 4
        ja      CharWidthNextGlyph
        mov     es:[di], ax             ; Save glyph info
        mov     es:[di][2], si
        add     di, 4
CharWidthNextGlyph:
        mov     dx, si                  ; Might need later
        mov     si, cx
        add     si, si
        add     si, WORD PTR lpCharWidths
        add     ax, [si]                ; Add user defined spacing
        inc     cx
        cmp     cx, wCount
        jne     CharWidthLoop
        cmp     WORD PTR [si], 0
        jne     Exit
        mov     si, dx                  ; Restore pointer to glyph
        mov     fs, WORD PTR lpFontInfo + 2
        add     ax, fs:[si]             ; Add actual character width
        jmp     Exit
CharWidthGetDefault:
        mov     dl, DefaultChar
        jmp     CharWidthGetDefaultReturn
;
; Get interesting data out of the font structure.
;
GetDrawMode:
        lfs     bx, lpDrawMode
        mov     ax, fs:[bx][DRAWMODE.CharExtra]
        mov     dx, fs:[bx][DRAWMODE.TBreakExtra]
        mov     cx, ax
        or      cx, dx
        jz      StdWidth
        mov     CharExtra, ax
        mov     TtlBreakExtra, dx
;
; Do proporional width spacing.
;
        mov     ax, fs:[bx][DRAWMODE.BreakExtra]
        mov     BreakExtra, ax
        mov     ax, fs:[bx][DRAWMODE.BreakRem]
        mov     BreakRem, ax
        mov     ax, fs:[bx][DRAWMODE.BreakCount]
        mov     BreakCount, ax
        mov     ax, es:_BreakErrExt
        mov     BreakErr, ax
        lfs     bx, lpOptions
        or      WORD PTR fs:[bx], ETO_PROPWIDTH
        lfs     bx, lpString
        mov     di, OFFSET _GlyphInfo
        mov     cx, wCount
        xor     ax, ax
;
; Load character and calculate width with proportional spacing.
;
PropWidthLoop:
        mov     dl, fs:[bx]
        inc     bx
        sub     dl, FirstChar
        cmp     dl, LastChar
        ja      PropGetDefault
PropGetDefaultReturn:
        cmp     dl, BreakChar
        je      PropCalcBreak
        xor     dh, dh
        add     dx, dx
        mov     si, dx
        add     dx, dx
        add     si, dx
        add     si, GlyphOffset
        cmp     di, OFFSET _GlyphInfo + MAX_CHAR_COUNT * 4
        ja      PropNextGlyph1
        je      PropSaveBreak1
PropSaveBreakReturn1:
        mov     es:[di], ax
        mov     es:[di][2], si
        add     di, 4
PropNextGlyph1:
        add     ax, [si]
        add     ax, CharExtra
        dec     cx
        jnz     PropWidthLoop
        jmp     Exit
PropSaveBreak1:
        mov     dx, BreakErr
        mov     es:_BreakErrExt, dx
        jmp     PropSaveBreakReturn1
PropSaveBreak2:
        mov     dx, BreakErr
        mov     es:_BreakErrExt, dx
        jmp     PropSaveBreakReturn2
PropGetDefault:
        mov     dl, DefaultChar
        jmp     PropGetDefaultReturn
PropCalcBreak:
        xor     dh, dh
        add     dx, dx
        mov     si, dx
        add     dx, dx
        add     si, dx
        add     si, GlyphOffset
        cmp     di, OFFSET _GlyphInfo + MAX_CHAR_COUNT * 4
        ja      PropNextGlyph2
        je      PropSaveBreak2
PropSaveBreakReturn2:
        mov     es:[di], ax
        mov     WORD PTR es:[di][2], si
        add     di, 4
PropNextGlyph2:
        add     ax, [si]
        add     ax, CharExtra
        cmp     TtlBreakExtra, 0
        jne     @F
        dec     cx
        jnz     PropWidthLoop
        jmp     Exit
@@:     add     ax, BreakExtra
        mov     dx, BreakErr
        sub     dx, BreakRem
        js      PropBreakWrap
        mov     BreakErr, dx
        dec     cx
        jnz     PropWidthLoop
        jmp     Exit
PropBreakWrap:
        inc     ax
        add     dx, BreakCount
        mov     BreakErr, dx
        dec     cx
        jnz     PropWidthLoop
        jmp     Exit
;
; Do standard width spacing.
;
StdWidth:
        lfs     bx, lpOptions
        mov     di, OFFSET _GlyphInfo
        mov     dx, [si][FONTINFO.dfPixWidth]
        mov     ax, ETO_MONOWIDTH
        or      dx, dx
        jz      @F
        mov     ax, ETO_VARWIDTH
@@:     or      WORD PTR fs:[bx], ax
        lfs     bx, lpString
        mov     cx, wCount
        xor     ax, ax
StdWidthLoop:
        mov     dl, fs:[bx]
        inc     bx
        sub     dl, FirstChar
        cmp     dl, LastChar
        ja      StdGetDefault
StdGetDefaultReturn:
        xor     dh, dh
        add     dx, dx
        mov     si, dx
        add     dx, dx
        add     si, dx
        add     si, GlyphOffset
        cmp     di, OFFSET _GlyphInfo + MAX_CHAR_COUNT * 4
        ja      StdNextGlyph
        mov     es:[di], ax
        mov     es:[di][2], si
        add     di, 4
StdNextGlyph:
        add     ax, [si]
        dec     cx
        jnz     StdWidthLoop
        jmp     Exit
StdGetDefault:
        mov     dl, DefaultChar
        jmp     StdGetDefaultReturn
Exit:
        cmp     di, OFFSET _GlyphInfo + MAX_CHAR_COUNT * 4
        ja      @F
        mov     es:[di], ax                     ; Save glyph width
@@:     mov     dx, GlyphHeight
        ret
GetGlyphInfo    ENDP

        END
