.386
                INCLUDE WINDEFS.INC

_TEXT           SEGMENT WORD PUBLIC USE16 'CODE'

;
; memcpy is called to copy cByte bytes of memory from lpSrc to lpDst
; It is called as:
;
;       VOID FAR PASCAL MemMove((LPVOID)lpSrc, (LPVOID)lpDst, (USHORT)cByte);
;

lpSrc   EQU     [bp + 10]
lpDst   EQU     [bp + 6]
cByte   EQU     [bp + 4]

MEMMOVE         PROC NEAR
        push    bp
        mov     bp, sp
        push    es
        push    ds
        push    si
        push    di

        lds     si, lpSrc
        les     di, lpDst
        mov     cx, cByte
;
; Compute move direction based on relative source and destiantion addresses.
; Assume forward.
;
        cld
        cmp     si, di
        ja      @F
        std
        add     si, cx
        dec     si
        add     di, cx
        dec     di
@@: rep movsb

        cld
        pop     di
        pop     si
        pop     ds
        pop     es
        leave
        ret     10

MEMMOVE         ENDP

;
; ClipRect will clip two source rectangles and fill the result into a 
; destination rectangle.  If the second source rectangle is wholly inside the
; first source rectangle, zero is returned, else 1 is returned.
;
lpSrc2Rect      EQU     [bp + 12]
lpSrc1Rect      EQU     [bp + 8]
lpDstRect       EQU     [bp + 4]

CLIPRECT        PROC NEAR
        push    bp
        mov     bp, sp
        push    ds
        push    si
        push    di
;
; Load source rect 2
;
        lds     si, lpSrc2Rect
        mov     ax, [si]
        mov     bx, [si][2]
        mov     cx, [si][4]
        mov     dx, [si][6]

        lds     si, lpSrc1Rect
        xor     di, di
;
; Clip to left.
;
        cmp     ax, [si]
        jge     @F
        mov     ax, [si]
        mov     di, 1
;
; Clip to top.
;
@@:     cmp     bx, [si][2]
        jge     @F
        mov     bx, [si][2]
        mov     di, 1
;
; Clip to right.
;
@@:     cmp     cx, [si][4]
        jle     @F
        mov     cx, [si][4]
        mov     di, 1
;
; Clip to bottom.
;
@@:     cmp     dx, [si][6]
        jle     @F
        mov     dx, [si][6]
        mov     di, 1
;
; Save clipped rect.
;
@@:     lds     si, lpDstRect
        mov     [si]   , ax
        mov     [si][2], bx
        mov     [si][4], cx
        mov     [si][6], dx
        mov     ax, di
        pop     di
        pop     si
        pop     ds
        leave
        ret     12

CLIPRECT        ENDP
_TEXT           ENDS
                END
