/****************************************************************************\
*                                                                            *
* Defines: Common defines for driver                                         *
*                                                                            *
*       Include general include files and define driver wide values.         *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/12/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#define NOGDI
#define BUILDDLL

#include <display.h>
#include <gdidefs.inc>
#include "bitmap.h"
#include "physical.h"
#include "device.h"

//
// Debug macros.
//

#ifdef DBG
#define DBGMSG(pstr)  OutputDebugString(pstr)
#else
#define DBGMSG(pstr)
#endif

#ifdef DBG
#define DBGBP() _asm    int 3
#else
#define DBGBP()
#endif

//
// Handy macros.
//

#define SWIZZLE_RGB(rgb)    ((((rgb) & 0x0000FF) << 16) | ((rgb) & 0x00FF00) | (((rgb) & 0xFF0000) >> 16))
#define SWIZZLE_DWORD(dw)   ((((dw) & 0xFF000000) >> 24) | (((dw) & 0x00FF0000) >> 8) \
                             (((dw) & 0x0000FF00) << 8)  | (((dw) & 0x000000FF) << 24))
#define SWIZZLE_WORD(w)     ((((w) & 0xFF00) >> 8) | (((w) & 0x00FF) << 8))

//
// Utility routines prototypes.
//

VOID FAR  PASCAL FarMemMove(LPSTR, LPSTR, USHORT);
VOID NEAR PASCAL MemMove(LPSTR, LPSTR, USHORT);
BOOL NEAR PASCAL ClipRect(LPRECT, LPRECT, LPRECT);

