;----------------------------------------------------------------------------;
;                                                                            ;
; Defines: Common defines for driver                                         ;
;                                                                            ;
;       Include general include files and define driver wide values.         ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       05/12/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1992 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

        INCLUDE GDIDEFS.INC
        INCLUDE WINDEFS.INC
;
; Physical brush structure offsets.
;
BRUSH_FLAGS     EQU     0
BRUSH_X         EQU     4
BRUSH_Y         EQU     6
BRUSH_CLR_SOLID EQU     8
BRUSH_CLR_FORE  EQU     12
BRUSH_CLR_BACK  EQU     16
BRUSH_MONO      EQU     20
BRUSH_PAT       EQU     28
BRUSH_COLOR     EQU     36
;
; Physical pen structure offsets.
;
PEN_COLOR       EQU     0
PEN_FLAGS       EQU     4
;
; Handy RGB to mono macro.  This adds the intensity bits of each RGB component.
; If two or more have high intensity, the color is considered white. Trashes
; AH and AL, leaves mono bit in CARRY flag.
;
RGB2Mono        MACRO rgb
        mov     al, BYTE PTR rgb
        xor     ah, ah
        add     al, BYTE PTR rgb[1]
        adc     ah, 0
        add     al, BYTE PTR rgb[2]
        adc     ah, 0
        add     ah, 255
                ENDM

