/****************************************************************************\
*                                                                            *
* Defines: Device specific defines                                           *
*                                                                            *
*       Define values and function prototypes for hardware specific code.    *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/15/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1993 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/


//
// Device Enable/disable routines.
//

VOID PASCAL devGdiInfo(GDIINFO *);
VOID PASCAL devDevInfo(LPDEVICE);
WORD PASCAL devEnableHW(VOID);
VOID PASCAL devDisableHW(VOID);

//
// Device RealizeObject routines.
//

VOID  PASCAL devDitherBrush(LPBRUSH, DWORD);

//
// Device color matching routines.
//

DWORD PASCAL devMatchPhysicalColor(DWORD);
DWORD PASCAL devMonoMatchLogicalColor(DWORD);
DWORD PASCAL devColorMatchLogicalColor(DWORD);

//
// Bitmap format specific routines.
//

LPBRUSH  PASCAL memGetTmpBrush(VOID);
VOID     PASCAL memConvertColorBrush(LPBRUSH);
VOID     PASCAL memConvertMonoBrush(LPBRUSH);
VOID     PASCAL memConvertColorBitmap(LPBYTE, USHORT, USHORT, USHORT, LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, SHORT, SHORT, DWORD);

//
// Memory bitmap BitBlt routines.
//

VOID PASCAL memBltPD_ToMono(LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, LPBRUSH, SHORT, SHORT, SHORT, USHORT);
VOID PASCAL memBltPD_ToColor(LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, LPBRUSH, SHORT, SHORT, SHORT, USHORT);
VOID PASCAL memBltSD_MonoToMono(LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, SHORT, SHORT, USHORT);
VOID PASCAL memBltSD_ColorToColor(LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, SHORT, SHORT, USHORT);
VOID PASCAL memBltPSD_MonoToMono(LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, LPBRUSH, SHORT, SHORT, USHORT);
VOID PASCAL memBltPSD_ColorToColor(LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, LPBRUSH, SHORT, SHORT, USHORT);
VOID PASCAL memBltSD_MonoToColor(LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, SHORT, SHORT, DWORD, DWORD, USHORT);
VOID PASCAL memBltPSD_MonoToColor(LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, LPBRUSH, SHORT, SHORT, DWORD, DWORD, USHORT);

//
// Device BitBlt routines.
//

VOID PASCAL devBltPD_Solid(SHORT, SHORT, SHORT, SHORT, DWORD, USHORT);
VOID PASCAL devBltPD_Color(SHORT, SHORT, LPBRUSH, SHORT, SHORT, USHORT);
VOID PASCAL devBltPD_Mono(SHORT, SHORT, LPBRUSH, SHORT, SHORT, DWORD, DWORD, SHORT, USHORT);
VOID PASCAL devBltSD_Mono(SHORT, SHORT, LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, SHORT, SHORT, DWORD, DWORD, SHORT, USHORT);
VOID PASCAL devBltSD_Color(SHORT, SHORT, LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, SHORT, SHORT, DWORD, SHORT, USHORT);
VOID PASCAL devBltPSD_Mono(SHORT, SHORT, LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, LPBRUSH, SHORT, SHORT, DWORD, DWORD, SHORT, USHORT);
VOID PASCAL devBltPSD_Color(SHORT, SHORT, LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, LPBRUSH, SHORT, SHORT, DWORD, SHORT, USHORT);
VOID PASCAL devBltSD_ToColor(LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, SHORT, SHORT, SHORT, SHORT);
VOID PASCAL devBltSD_DevToDev(SHORT, SHORT, SHORT, SHORT, SHORT, SHORT, DWORD, SHORT, USHORT);

//
// Memory bitmap DIB routines.
//

VOID PASCAL memMonoToDIB1(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memMonoToDIB4(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memMonoToDIB8(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memMonoToDIB24(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memColorToDIB1(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memColorToDIB4(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memColorToDIB8(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memColorToDIB24(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);

VOID PASCAL memDIB1ToMono(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memDIB4ToMono(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memDIB8ToMono(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memDIB24ToMono(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memDIB1ToColor(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memDIB4ToColor(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memDIB8ToColor(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID PASCAL memDIB24ToColor(LPBITMAPINFOHEADER, LPBYTE, WORD, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);

DWORD PASCAL memColorToRLE4(LPBITMAPINFOHEADER, LPBYTE, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
DWORD PASCAL memColorToRLE8(LPBITMAPINFOHEADER, LPBYTE, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID  PASCAL memRLE4ToColor(LPBITMAPINFOHEADER, LPBYTE, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);
VOID  PASCAL memRLE8ToColor(LPBITMAPINFOHEADER, LPBYTE, LPBYTE, SHORT, SHORT, SHORT, WORD, WORD, WORD, LPWORD);

//
// Device text routines.
//

WORD PASCAL devTextFunc(LPRECT, LPRECT, LPDRAWMODE, WORD);

//
// Device pixel routines.
//

VOID  PASCAL devSetPixel(SHORT, SHORT, DWORD, USHORT);
DWORD PASCAL devGetPixel(SHORT, SHORT);        
VOID  PASCAL devClippedLine(SHORT, SHORT, SHORT, SHORT, LPRECT, DWORD, USHORT);
VOID  PASCAL devLine(SHORT, SHORT, SHORT, SHORT, DWORD, USHORT);

//
// ScanLR routines.
//

WORD PASCAL memScanColorLR(LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, SHORT, DWORD, USHORT);

