/****************************************************************************\
*                                                                            *
* Defines: Physical object defines                                           *
*                                                                            *
*       Physical object structures and definitions.                          *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/12/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

//
// Physical device structure.
//

typedef struct
{
    WORD devType;
    WORD devWidth;
    WORD devHeight;
    WORD devWidthBytes;
    BYTE devPlanes;
    BYTE devBitsPixel;
} DEVICE;
typedef DEVICE FAR * LPDEVICE;
typedef DEVICE     * PDEVICE;

//
// Physical brush structure.  The actual size of the brColorBits member
// is returned by the memory bitmap format module.
//

typedef struct
{
    WORD     brFlags;
    WORD     brReserved;
    WORD     brX;
    WORD     brY;
    DWORD    brClrSolid;
    DWORD    brClrFore;
    DWORD    brClrBack;
    BYTE     brMonoBits[8];
    BYTE     brPatBits[8];
    BYTE     brColorBits[1];
} BRUSH;
typedef BRUSH FAR * LPBRUSH;
typedef BRUSH     * PBRUSH;

#define BRUSH_MONO      0x01
#define BRUSH_COLOR     0x02
#define BRUSH_SOLID     0x04
#define BRUSH_HATCHED   0x08
#define BRUSH_HOLLOW    0x10
#define BRUSH_PATTERN   0x20

//
// Physical pen structure.
//

typedef struct
{
    DWORD pnColor;
    WORD  pnFlags;
} PEN;
typedef PEN FAR * LPPEN;
typedef PEN     * PPEN;

#define PEN_SOLID   0x01
#define PEN_NULL    0x02
