/****************************************************************************\
*                                                                            *
* Defines: TextOut defines                                                   *
*                                                                            *
*       Driver escape defines for text output routines.                      *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/12/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

//
// Typedef of glyph info structure.
//

typedef struct
{
    SHORT xPos;
    WORD  FontOffset;
} GLYPHINFO, * PGLYPHINFO, FAR * LPGLYPHINFO;

//
// Typedef of pointer to glyph drawing routine.
//

typedef SHORT (PASCAL *GLYPHPROC)(LPFONTINFO, LPGLYPHINFO, SHORT, SHORT, SHORT);

//
// Memory bitmap text routines.
//

WORD PASCAL memDrawGlyphs(LPBYTE, USHORT, USHORT, USHORT, LPFONTINFO, LPGLYPHINFO, SHORT);

//
// Options passed to ExtTextOut.
//

#define ETO_OPAQUE      0x02
#define ETO_CLIPPED     0x04

//
// More options passed to DrawGlyphs.
//

#define ETO_USERWIDTH   0x08
#define ETO_PROPWIDTH   0x10
#define ETO_MONOWIDTH   0x20
#define ETO_VARWIDTH    0x40

//
// Maximum number of characters to draw at a time.  This is the maximum size
// of the vCharX array filled in by TextExtent.  If this is changed, be sure
// to update TEXTOUT.INC as well.
//

#define MAX_CHAR_COUNT  256



