/********************************************************************/
/*         MGA OS/2 PM drivers installation batch file              */
/********************************************************************/

'@ECHO OFF'
say 'INSTALLING MGA POWER DRIVER'

/********************************************************************/
/* Get arguments if any                                             */
/********************************************************************/

Parse Arg all

Srcdrv = 'A:'           /* default value */
Dstdrv = 'C:'           /* default value */

If words(all) > 0 then do
    Srcdrv = translate(word(all,1))
    If words(all) > 1 then
	Dstdrv = translate(word(all,2))
end
else do                 /* Seach for Installation disk */
    FileName=Srcdrv'\OS2\MGA.DSC'
    Ret = stream(FileName, 'C', 'query exists')
    if Ret = "" then do
	FileName='B:\OS2\MGA.DSC'
	Ret = stream(FileName, 'C', 'query exists')
	if Ret = "" then nop
	else Srcdrv = 'B:'
    end
end

Windrv = Dstdrv         /* default value */
WinExt= 'WOS'           /* default value    assumes regular WinOS2 */

CurDir=directory()

/********************************************************************/
/* Seach for OS2 system path in PATH environement                   */
/********************************************************************/

env = 'OS2ENVIRONMENT'
Path = value('PATH',,env)
if Path = '' then signal ENDSEARCH

ntmp = pos(':\OS2;', Path)
if ntmp = 0 then signal ENDSEARCH

Dstdrv=substr(Path, ntmp-1,2)

/********************************************************************/
/* Seach for WinOS2 path in OS2.INI                                 */
/********************************************************************/

Windrv=Dstdrv                           /* default value */
WinDir=Windrv'\OS2\MDOS\WINOS2'         /* default value */
FoundWindir=0                           /* not found yet */

IniFile='USER'
Apps='PM_INSTALL'
AppsKeys='WINOS2_LOCATION'

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

call SysIni IniFile, Apps, AppsKeys
if Result \= 'ERROR:' then
do
    val = SysIni(IniFile, Apps, AppsKeys)
    NewDir=directory(val)
    if NewDir\= '' then do
	WinDir=NewDir
	Windrv=Left(WinDir,2)
	FoundWindir=1                       /* found it     */
	signal ENDSEARCH
    end
end

/********************************************************************/
/* Seach for WinOS2 path in PATH Evironement                        */
/********************************************************************/

ntmp = pos(':\OS2\MDOS\WINOS2', Path)
if ntmp > 0 then do
    Windrv=substr(Path, ntmp-1,2)
    WinDir=substr(Path, ntmp-1,18)
    FoundWindir=1                           /* found it     */
    signal ENDSEARCH
end

ntmp = pos(':\WINDOWS', Path)
if ntmp > 0 then do
    Windrv=substr(Path, ntmp-1,2)
    WinDir=substr(Path, ntmp-1,10)
    FoundWindir=1                           /* found it     */
    signal ENDSEARCH
end

ntmp = pos(':\WIN31', Path)
if ntmp > 0 then do
    Windrv=substr(Path, ntmp-1,2)
    WinDir=substr(Path, ntmp-1,8)
    FoundWindir=1                           /* found it     */
    signal ENDSEARCH
end

ENDSEARCH:

/*****************************************************************************/
/*                 Checking the default values                               */
/*****************************************************************************/

FileName=Srcdrv'\OS2\MGA.DSC'		       /* checking source      */
Ret = stream(FileName, 'C', 'query exists')
if Ret = "" then signal RESUME

FileName=Dstdrv'\OS2KRNL'                       /* checking target      */
'attrib -r -s -h 'FileName
Ret = stream(FileName, 'C', 'query exists')
if Ret = "" then signal RESUME
'attrib +h +s +r 'FileName

NewDir=directory(WinDir)                        /* checking win target  */

if NewDir=WinDir then do
    test='ok'

    FileName=WinDir'\SYSTEM.INI'
    Ret = stream(FileName, 'C', 'query exists')
    if Ret = "" then test='fail'
    FileName=WinDir'\WIN.COM'
    Ret = stream(FileName, 'C', 'query exists')
    if Ret = "" then test='fail'

    if test='ok' then signal StartInstall         /* go ahead without asking */
end

/********************/
/* Ask the User     */
/********************/

RESUME:
cls
say ''
say ''
say 'Source drive will be:' Srcdrv
say 'Destination drive will be:' Dstdrv
say 'Win/OS2 or Windows Directory is:' WinDir
say 'Is the above information correct? (Y/N): Y'
pull answer
if answer = 'N' then signal askdrives

FileName=Srcdrv'\OS2\MGA.DSC'
Ret = stream(FileName, 'C', 'query exists')
if Ret = "" then signal usage0

FileName=Dstdrv'\OS2KRNL'
'attrib -r -s -h 'FileName
Ret = stream(FileName, 'C', 'query exists')
if Ret = "" then signal usage0
'attrib +h +s +r 'FileName

NewDir=directory(WinDir)

if NewDir=WinDir then do
    test='ok'
    FileName=WinDir'\SYSTEM.INI'
    Ret = stream(FileName, 'C', 'query exists')
    if Ret = "" then test='fail'
    FileName=WinDir'\WIN.COM'
    Ret = stream(FileName, 'C', 'query exists')
    if Ret = "" then test='fail'
end

if test='ok' then signal OK

askagain:

say 'Do you have OS/2 for Windows? (Y/N): N'
pull answer
if answer = 'Y' then do
    say 'Enter directory of Windows 3.1 ('Windrv'\WINDOWS)'
    pull answer
    if answer = '' then WinDir=Windrv'\WINDOWS'
    else WinDir=answer
    if directory(WinDir) = '' then do
	say WinDir ' does not exist'
	say 'Do you want to exit and check again? (Y/N): N'
	pull answer
	if answer = 'Y' then signal end
	else signal askagain
    end
    else WinExt='WIN'      /* OS2 for Windows*/
end
else do /*(WINOS2)*/
    say 'Did you install WINOS2 on a different drive? (Y/N): Y'
    pull answer
    if answer='N' then do
	say WinDir ' not found but we will install WinOS2 drivers to 'WinDir ' anyway.'
    end
    else do
	say 'Enter drive where WinOS2 was installed ('Windrv')'
	pull answer
	if answer = '' then WinDir=Windrv'\OS2\MDOS\WINOS2'
	else WinDir=answer'\OS2\MDOS\WINOS2'
	if directory(WinDir) = '' then do
	    say WinDir ' does not exist'
	    say 'Do you want to exit and check again? (Y/N): N'
	    pull answer
	    if answer = 'Y' then signal end
	    else signal askagain
	end
    end
end
signal RESUME

OK:

say 'Source Directory will be 'Srcdrv'\OS2'
say 'Win/OS2 drivers will be installed on 'Windir'\SYSTEM'
say 'Ready to install? (Y/N): Y'
pull answer
if answer = '' then signal StartInstall
if answer = 'Y' then signal StartInstall
say 'INSTALLATION ABORT'
signal end

StartInstall:
say 'PLEASE WAIT ...'

NewDir=directory(Dstdrv'\')             /* go to root off OS/2 drive */

/********************************************/
/* remove any MGA statement from CONFIG.SYS */
/********************************************/

InnF=Dstdrv'\CONFIG.MGA'
OutF=Dstdrv'\CONFIG.SYS'
'copy 'OutF' 'InnF' >nul'
'del 'OutF

do until lines(InnF) = 0
    InStr = linein(InnF)
    select
	when pos('MGAKRNL.SYS', InStr) > 0  then nop
	when pos('VVGA.SYS', InStr) > 0  then nop
	when pos('VSVGA.SYS', InStr) > 0  then nop
	when pos('MGA=', InStr) > 0         then nop
	when pos('MGARES=', InStr) > 0      then nop
	when pos('VIO_MGA', InStr) > 0      then nop
	when pos('RAMBIOS.SYS', InStr) > 0  then nop
	when pos('VMGA.SYS', InStr) > 0     then nop
	otherwise
	do
	    if pos('LIBPATH=', InStr) > 0   then        do
		itmp = pos(':\MGA\OS', InStr)
		if itmp > 0 then stmp=delstr(InStr, itmp-1, 11)
		else stmp=InStr
		call lineout OutF, stmp
	    end
	    else do
		itmp = pos(':\MGA\OS2', InStr)
		if itmp = 0 then  call lineout OutF, InStr
		end
	end
    end
end

call stream OutF, 'c', 'close'
call stream InnF, 'c', 'close'

/**********************************************/
/* remove any MGA statement from autoexec.bat */
/**********************************************/

'call 'Srcdrv'\OS2\FIXAUTO.CMD 'Dstdrv' ON'

/**********************************************/
/* clean older version			      */
/**********************************************/
NewDir=directory(Dstdrv'\MGA\OS2')
'if exist MGA8_640.DSP del *.dsp > nul'

NewDir=directory(Dstdrv'\OS2\DLL')
'if exist MGAKRNL.SYS del MGAKRNL.SYS > nul'

/**********************************/
/* Call OS/2 Installation process */
/**********************************/

NewDir=directory(Dstdrv'\OS2\INSTALL')
'if exist MGA8.DSC del MGA8.DSC > nul'
'unpack 'Srcdrv'\OS2\MGAINSTL.DL@ .>nul'
'copy 'Srcdrv'\OS2\MGA.DSC .>nul'

if WinExt='WOS' then OthExt='WIN'
else                 OthExt='WOS'

/* save OS2's Keyboard driver */
NewDir=directory(Dstdrv'\OS2')
'if not exist KBD01.OS2 ren KBD01.SYS KBD01.OS2 > nul'

NewDir=directory(WinDir'\SYSTEM')
'call 'Srcdrv'\OS2\MGAVER.CMD'
'call 'Srcdrv'\OS2\DRVPMI.CMD 'Dstdrv' 'WinDir' 'WinExt' 'OthExt

/* restore OS2's Keyboard driver if abort */
NewDir=directory(Dstdrv'\OS2')
'if not exist KBD01.SYS ren KBD01.OS2 KBD01.SYS > nul'

signal end

ASKDRIVES:
say 'Enter source drive ('Srcdrv')'
pull answer
if   answer = "" then nop
else Srcdrv = answer
say 'Enter destination drive ('Dstdrv')'
pull answer
if   answer = "" then nop
else Dstdrv = answer
signal askagain

USAGE0:
say 'File' FileName ' does not exist'
USAGE:
say ''
say 'Usage:'
say '   install src: dst:'
say '   Where src is the drive from which you are installing the driver'
say '   and dst is your OS/2 boot drive.'
say 'Example:'
say '   b:install b: d:'
say '   a:install'

end:
call directory CurDir
exit
