/* P/390 Service Install program                             3/14/96 JAH        */
beta = 'N'
fix_level = '2021'   /* Fix code will be 2.2.1 */
base_level = '2001'  /* Must install on this base or higher, but less than fix level */
newicon_level = '2011'  /* New icons were introduced at the level  */
base_lvl = '2.0.1'   /* Same, in diskette label format */
nline = 'P/390 LIC Version 1.2 (c) Copyright IBM Corporation 1988, 1996.'
/*                                                                              */
/*                                                                              */
/*                                                                              */
/*                                                                              */
trace o
"@ECHO OFF"
card = 'P/390';subd = 'P390';  /* Assume this is for P/390 */
Parse upper arg x .            /* Unless user passes P370 parameter */
If x = 'P/370' | x = 'P370' then do
   card = 'P/370';subd = 'P370'; End;
serv_file = 'P390'||fix_level'.FIX'  /* e.g. P3902021.FIX (this is a ZIP file) */
back_dir  = '\BACK'fix_level       /* e.g. \BACK2021      */
title = card 'Service'
text.1 = 'Install Service'
text.2 = 'Remove Service'
r_name = 'REGRESS.CMD' /* If CMD file has this name, skip menu for INSTALL */

Parse upper arg x .
If x = '?' then do
Say 'Correct Form is:'
Say '                P390FIX [d:]'
Say '                        P370'
Say ''
Say 'Use this command to install service for the' card 'program.'
Say '  "d:" is the destination drive letter of the' subd 'subdirectory.'
Say 'The old versions of the files will be saved in d:\'subd||back_dir'.'
Say ''
Say 'If after applying service you wish to go back to the old versions,'
Say 'run d:\'subd'\REGRESS.CMD'
Say ''
Say 'Personal/370 users must pass the parameter "P370" to use this fix program.'
   Exit
   End

/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

Parse upper Source . . srcname .  /* Info on the program as called */
sletter = Filespec('Drive',srcname) /* e.g. C:            */
ssubd = Filespec('Path',srcname)    /* e.g. \P390\        */
spath = sletter||ssubd              /* e.g. C:\P390\      */
sname = Filespec('Name',srcname)    /* e.g. P390FIX.EXE or REGRESS.EXE */
Parse var srcname cmdname '.' .     /* e.g. C:\P390FIX  */

complete=0  /* non-zero if OK */
Error=0     /* non-zero if any errors */

/*--------------------------------------------------------------------*/
/* Display top-level menu for choosing Service install or regress     */
/*--------------------------------------------------------------------*/

If sname <> r_name then do /* Don't display menu if called as "REGRESS" */
   Top_menu:
   Do until key = '1' | key = '2' | key = '3'
   Say ''
   Say 'Ŀ'
   Say '  'title' selection:                                                   '
   Say 'Ĵ'
   Say '   1. 'text.1'                                                        '
   Say '   2. 'text.2'                                                         '
   Say '   3. Exit.                                                                  '
   Say ''

   Parse upper value SysGetKey('NOECHO') with key
      Select;
         When key = '1' then choice = '1'
         When key = '2' then choice = '2'
         When key = '3' then Signal Exit;
         Otherwise Call SysCLS
      End; /* Select */
   End; /* Look for 1,2,3 keys */
End; /* display menu */
Else choice = '2'  /* Force to be Regress */

If choice <> 1 then Signal Regress

/*------**********************----------------------------------------*/
/*----- INSTALL new fixes     ----------------------------------------*/
/*------**********************----------------------------------------*/
Install:
/*--------------------------------------------------------------------*/
/* Check for a drive letter(s) passed as parameter to INSTALL         */
/*--------------------------------------------------------------------*/
   parse upper arg tletter .   /* to drive */
   parse var tletter tletter ':' .  /* strip off : if provided */

If x = 'P/370' | x = 'P370' then tletter = '';

Call GetP390  /* Find the P390 drive letter in CONFIG.SYS. Sets "dletter" */

If tletter='' then do
   Say '';
   Say 'What is the drive letter of the \'subd' subdirectory?'
   Say 'Type in the letter of the destination disk (To accept default = 'dletter', press ENTER).';
   parse upper value SysGetKey('NOECHO') with key
   If key='0D'x Then Do
                    tpath=dletter':\'subd
                    tletter=dletter;
                    end;
                Else Do
                    tpath=key':\'subd
                    tletter=key;
                    end;
   end
   Else tpath=tletter':\'subd

If (length(tletter)<>1 | Datatype(tletter,'U')<>1) Then do
   Say "Invalid parameter: '"tletter"'. It must be a valid OS/2 drive letter."
   Say '*** Nothing done. ***'
   Exit 1;
   End;

Call ChkP390 /* Make sure the fix_level is higher than current P/390 code level */

If beta = 'Y' then
     Say 'To install service package' fix_level' (### BETA ###) on' tpath', type Y'
Else Say 'To install service package' fix_level 'on' tpath', type Y'
Say '(any other key to EXIT).';
parse upper value SysGetKey('NOECHO') with key
If key<>'Y' Then do
   Say '*** Nothing done. ***'
   Exit
   End;

Call ChkPgm  /* check to see is any P/390 programs or CM/2 are running */

back_dir = tpath||back_dir       /* d:\P390\BACK000n                  */
back_new = back_dir'\P390.NEW'  /* Place to remember NEW files for REGRESS time */
Log = tpath'\'subd'SERV.LOG'  /* Log for Service Installation errors  */
Log2 = tpath'\AWSERROR.LOG' /* Standard P/390 runtime error log       */
list = tletter':\AWSTEMP.LST'  /* List of files to be copied          */
cmsg  = tletter':\AWSTEMP.MSG' /* Output file for messages from XCOPY & PKUNZIP2 */
rc=SysFileDelete(list); rc=SysFileDelete(cmsg)

/* Start the message log entry */
msg='0D0A'x||'===== P390FIX install started' Date() Time() '=============================='
x=Lineout(Log,msg); x=Lineout(Log);

/*                                          */
/* Check free space on the destination disk */
/*                                          */
tinfo = SysDriveInfo(tletter':')
If tinfo = '' then Signal NodiskT
Parse var tinfo . tfree . .
Numeric Digits 16  /* Allows whole numbers up to 16 digits */

/*                                                       */
/* Make sure we haven't already installed this level fix */
/*                                                       */
rc=SysMkDir(back_dir) /* Try to create the backup subdirectory */
If rc = 5 then do     /* Already exists - check for files */
   totsize = 0
   "DIR /N" back_dir ">" list
   Do While Lines(list)
      w = Linein(list)            /* Read a line from the DIR results */
      If Datatype(word(w,3),'N') & Substr(w,1,3)<>'   ' then do /* Is it a file line? */
         Parse upper var w date time size attr name .
         If Datatype(size,'W')=1 then nop         /* Yes, a real file */
            Else Iterate                          /* Not a file line  */
         totsize = totsize + size                 /* Add the size in  */
         End;
      End; /* lines */
   Call Stream list,'C','CLOSE'
   rc=SysFileDelete(list)
   If totsize > 0 then do  /* Files were found in the backup subdir */
      Say ''               /* Must be a partial install */
      msg='Backup subdirectory' back_dir 'already exists.'
      Say msg; x=Lineout(Log,msg); x=Lineout(Log);
      msg='Cannot install this level of service.'
      Say msg; x=Lineout(Log,msg); x=Lineout(Log);
      msg='If you interrupted a previous install of this level, you must remove it'
      Say msg; x=Lineout(Log,msg); x=Lineout(Log);
      msg='by typing' cmdname 'and selecting the "Remove Service" menu selection.'
      Say msg; x=Lineout(Log,msg); x=Lineout(Log);
      Exit 4
      End;
   End; /* Check for files */

/*--------------------------------------------------------------------*/
/*  Check source file                                                 */
/*--------------------------------------------------------------------*/
filename = spath||serv_file
ee = Stream(filename,'C','QUERY EXISTS')
If ee = '' then do
   Say ''
   msg='***' filename 'not found. 'title' installation not done. ***'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   Exit 5
   End

/* Make sure we have the unzip program */
z2 = stream(tpath'\PKUNZIP2.EXE','C','QUERY EXISTS')
If z2 <> '' then zpath = tpath'\'
Else Do
   z3=SysSearchPath('PATH','PKUNZIP2.EXE')
   If z3 = '' then do
      Say 'Required program PKUNZIP2.EXE not found. P/390 Program diskettes must be installed.'
      Say '*** Nothing done. ***'
      Exit 3;
      End
   Else zpath = ''
   End; /* Search for a unzip */

Call Qzip   /* See how much space we need; this sets "total" */
total = total * 3 /* Need about 3 times this for work area */
If tfree < total then Signal NoSpace

msg='Installing' serv_file'...'
Say msg; x=Lineout(Log,msg); x=Lineout(Log);

/*--------------------------------------------------------------------*/
/* Unzip the new files to a temporary directory                       */
/*--------------------------------------------------------------------*/
temp_dir = SysTempFileName(tletter':\????.')
"MD" temp_dir

msg= 'Unzipping' filename 'to temporary work area' temp_dir
x=Lineout(Log,msg); x=Lineout(Log);
zpath"PKUNZIP2 -o -d" filename temp_dir"\ > " cmsg
zrc=rc
"COPY" Log"+"cmsg Log">NUL:"  /* append messages to Log */
rc=SysFileDelete(cmsg)
If zrc <> 0 then Do
   Say '** ERROR unzipping' filename'. Check' log ' for messages.'
   msg='** ERROR unzipping' filename'. See "(xnn)" messages, below.'
   x=Lineout(Log,msg); x=Lineout(Log);
   error = error+1
   Exit 6  /* QUIT */
   End; /* error */
msg= '0A'x||Copies('-',54)||'0A'x /* Log separator */
x=Lineout(Log,msg); x=Lineout(Log);

/*--------------------------------------------------------------------*/
/* If any of the loaded files were also ZIP files, AND they are NOT   */
/* present in the user's current d:\P390 subdirectory, then we assume */
/* that either this is a brand new ZIP file, or the user had already  */
/* unzipped an older one. In either case, we will explode the ZIP file*/
/* If the ZIP file IS present in d:\P390, then don't explode it, just */
/* replace it with the updated ZIP file. It is up to user to unzip it.*/
/*--------------------------------------------------------------------*/
"DIR /N" temp_dir"\*.ZIP >" list
If rc = 0 then do while Lines(list)
   w = Linein(list)   /* Read a line from the DIR results */
   If Datatype(word(w,3),'N') & Substr(w,1,3)<>'   ' then do /* Is it a file line? */
      Parse upper var w date time size attr name .
      If Datatype(size,'W')=1 then nop         /* Yes, a real file */
         Else Iterate                          /* Not a file line  */
      Parse var name fn '.' ext .
      /* Is it a ZIP file that is NOT present in d:\P390 ? */
      If ext = 'ZIP' & Stream(tpath'\'name,'C','QUERY EXISTS') = ''
         then do  /* Yes, unzip it and then erase the ZIP file */
         msg= 'Unzipping' name 'to temporary work area' temp_dir
         x=Lineout(Log,msg); x=Lineout(Log);
         zpath"PKUNZIP2 -o -d" temp_dir'\'name temp_dir"\ > " cmsg
         zrc=rc
         "COPY" Log"+"cmsg Log">NUL:"  /* append messages to Log */
         rc=SysFileDelete(cmsg)
         If zrc = 0 then Do
            rc=SysFileDelete(temp_dir'\'name) /* Delete ZIP source file */
            End; /* Unzip OK */
         Else do
            Say '** ERROR unzipping' name'. Check' log ' for messages.'
            msg='** ERROR unzipping' name'. See "(xnn)" messages, below.'
            x=Lineout(Log,msg); x=Lineout(Log);
            error = error+1  /* increment error but keep on going */
            End; /* error */
         End;  /* Unzip ZIP files */
      End; /* yes, a file */
   End; /* lines */

Call Stream list,'C','CLOSE' /* Must be erased - we use it */
rc=SysFileDelete(list)       /*  again later. */

/*--------------------------------------------------------------------*/
/* Update CONFIG.AWS (if a new one was shipped in fixpack)            */
/*--------------------------------------------------------------------*/
Call ChngSamp

/*--------------------------------------------------------------------*/
/* Make a list of the files to archive and then copy                  */
/*--------------------------------------------------------------------*/
rc=SysFileDelete(back_new) /* Place to remember NEW files for REGRESS time */

"DIR /N" temp_dir ">" list
copylist = '';
Do While Lines(list)
   w = Linein(list)            /* Read a line from the DIR results */
   If Datatype(word(w,3),'N') & Substr(w,1,3)<>'   ' then do /* Is it a file line? */
      Parse upper var w date time size attr name .
      If Datatype(size,'W')=1 then nop         /* Yes, a real file */
         Else Iterate                          /* Not a file line  */
      copylist = name copylist                 /* Add to copy list */
      /* Is this a brand new file? (not currently in d:\P390) */
      If Stream(tpath'\'name,'C','QUERY EXISTS') = '' then do
         Call Lineout back_new,name
         End;  /* Remember new files */
      End; /* yes, a file */
   End; /* lines */

Call Stream list,'C','CLOSE'
rc=SysFileDelete(list)

If copylist = '' then do /* No files were found */
   msg='** ERROR: No files were expanded from' filename'.'
   x=Lineout(Log,msg); x=Lineout(Log);
   error = error+1
   Exit 6  /* QUIT */
   End; /* error */

Call Stream back_new,'C','CLOSE'  /* Close and         */
"ATTRIB +R" back_new              /* Protect this file */

/*--------------------------------------------------------------------*/
/* Archive replaced files first, then copy in new ones                */
/*--------------------------------------------------------------------*/
newmcd=0; i_mcd=0; /* Set if new ucode file(s) is included */
msg= '0A'x||Copies('-',54)||'0A'x /* Log separator */
x=Lineout(Log,msg); x=Lineout(Log);

msg= 'Backing up replaced files to ' back_dir
x=Lineout(Log,msg); x=Lineout(Log);

/* Process each file in the list */
copyi = Words(copylist)
Do k=1 to copyi
   filename = Word(copylist,k)

/* Archive current /P390 file */
   Parse var filename zzz '.' yyy .         /* Isolate file extention */
   If yyy = 'MCP' then do          /* Yes, this is a ucode patch file */
      backname = zzz'.MCD'        /* Backup the original *.MCD file   */
      i_mcd=i_mcd+1               /* Keep count of how many ucode files */
      newmcd.i_mcd = zzz          /* This causes us to run patch pgm later */
      End;
   Else backname=filename       /* This is the normal, non-ucode case */
   aa = Stream(tpath'\'backname,'C','QUERY EXISTS')
   If aa <> '' then do    /* Only backup file if older version exists */
      "XCOPY"  tpath'\'backname back_dir"\  > " cmsg
      xrc=rc
      "COPY" Log"+"cmsg Log">NUL:"  /* append messages to Log */
      rc=SysFileDelete(cmsg)
      If xrc <> 0 then Do
         Say '** ERROR backing up' tpath'\'backname'. See "SYSnnn" message displayed above.'
         msg='** ERROR backing up' tpath'\'backname'. See "SYSnnn" message displayed on the console.'
         x=Lineout(Log,msg); x=Lineout(Log);
         error = error+1
         Exit 7  /* Quit */
         End; /* error */
      End; /* Archive */

/* Install new /P390 files */
   "XCOPY"  temp_dir'\'filename tpath"\  > " cmsg
   xrc=rc
   "COPY" Log"+"cmsg Log">NUL:"  /* append messages to Log */
   rc=SysFileDelete(cmsg)
   If xrc <> 0 then Do
      Say '** ERROR installing' tpath'\'filename'. See "SYSnnn" message displayed above.'
      msg='** ERROR installing' tpath'\'filename'. See "SYSnnn" message displayed on the console.'
      x=Lineout(Log,msg); x=Lineout(Log);
      error = error+1
      Exit 8  /* Quit */
      End; /* error */

   End; /* Archive & Copy k times */


complete=complete+1       /* non-zero if we have completed this step */
msg= '0A'x||Copies('-',54)||'0A'x /* Log separator */
x=Lineout(Log,msg); x=Lineout(Log);
Say '';
msg='Replaced files have been backed up to' back_dir
Say msg; x=Lineout(Log,msg); x=Lineout(Log);
Say ''
msg= '0A'x||Copies('-',54)||'0A'x /* Log separator */
x=Lineout(Log,msg); x=Lineout(Log);

/*--------------------------------------------------------------------*/
/* Update the P/390 L.I.C. files, if necessary (skip for P/370)       */
/*--------------------------------------------------------------------*/
mcd_rc = 0             /* cumulative RC for MCD patching */
If i_mcd > 0 then      /* Set if any *.MCP files were loaded */
Do i = 1 to i_mcd      /* Repeat for each MCD file */
   Call P390LIC tpath'\'newmcd.i
   If result <> 0 then error = error + 1
   mcd_rc = result + mcd_rc
   End; /* i */
ll = Stream(tpath'\LEGAL.DOC','C','QUERY EXISTS')
If (mcd_rc = 0)&(ll <> '') then
   /* LIC was patched successfully, so update LEGAL.DOC, if it exists */
   Call UpdLegal

/*--------------------------------------------------------------------*/
/* Done. Cleanup by deleting the temporary files & subdirectory       */
/*--------------------------------------------------------------------*/
Say ''
msg='Install of fix package 'fix_level' has completed.'
Say msg; x=Lineout(Log,msg); x=Lineout(Log);

Do k=1 to copyi
   filename = Word(copylist,k)
   rc=SysFileDelete(temp_dir'\'filename)
   End
rc=SysRmDir(temp_dir)

/*--------------------------------------------------------------------*/
/* Create new folder and icons (if level = 2.1 or less)               */
/*--------------------------------------------------------------------*/
If card = 'P/390' & P390_level < newicon_level then do
   Say ''
   Say 'Do you want to install new P/390 icons? (Y | N)'
   parse upper value SysGetKey('NOECHO') with key
   If key<>'N' Then call Folder
   End  /* P/390 only */

/*--------------------------------------------------------------------*/
/*  E X I T  code                                                     */
/*--------------------------------------------------------------------*/
Exit:
If complete > 0 then do  /* Only say if we have actually done something */
   Say ''
   If error<>0 then Do
      If choice = 1 then
      msg=title 'installation is finished, but errors occurred.'
      If choice = 2 then
      msg=title 'regression is finished, but errors occurred.'
      Say msg; x=Lineout(Log,msg); x=Lineout(Log);
      Say '-----------------------------------------------------------'
      Say 'Check install log' log'.'
      End
   Else Do
   If choice = 1 then do
      msg=title 'installation is complete.'
      Say msg; x=Lineout(Log,msg); x=Lineout(Log);
      Say '---------------------------------------'
      msg=title 'file' serv_file ' has been installed on' date() time()
      x=Lineout(Log2,msg); x=Lineout(Log2); /* Flag completion in AWSERROR.LOG */
      End;
   If choice = 2 then do
      msg=title 'regression is complete.'
      Say msg; x=Lineout(Log,msg); x=Lineout(Log);
      Say '-------------------------------------'
      msg=title 'file' serv_file ' has been REGRESSED on' date() time()
      x=Lineout(Log2,msg); x=Lineout(Log2); /* Flag completion in AWSERROR.LOG */
      End;
    Say ''
    Say 'Shutdown and reboot OS/2 for the changes to take effect.'
    End; /* No errors */
End;

If choice = 1 then do
   Say ''
   Say 'If you wish to back off' title 'in the future,'
   Say 'then run' tpath'\REGRESS.'
   End;

Exit 0

/*------**********************----------------------------------------*/
/*----- REGRESS the fixes     ----------------------------------------*/
/*------**********************----------------------------------------*/
Regress:

/*--------------------------------------------------------------------*/
/* Check for a drive letter(s) passed as parameter to INSTALL         */
/*--------------------------------------------------------------------*/
   parse upper arg tletter .   /* P390 drive */
   parse var tletter tletter ':' .  /* strip off : if provided */

If x = 'P/370' | x = 'P370' then tletter = '';

If ssubd = '\P370\' then do  /* d:\P370\REGRESS was the command */
   card = 'P/370';subd = 'P370'; End;

Call GetP390  /* Find the P390 drive letter in CONFIG.SYS. Sets "dletter" */

If tletter='' then do
   Say '';
   Say 'What is the drive letter of the \'subd' subdirectory?'
   Say 'Type in the letter of the destination disk (To accept default = 'dletter', press ENTER).';
   parse upper value SysGetKey('NOECHO') with key
   If key='0D'x Then Do
                    tpath=dletter':\'subd
                    tletter=dletter;
                    end;
                Else Do
                    tpath=key':\'subd
                    tletter=key;
                    end;
   end
   Else tpath=tletter':\'subd

If (length(tletter)<>1 | Datatype(tletter,'U')<>1) Then do
   Say "Invalid parameter: '"tletter"'. It must be a valid OS/2 drive letter."
   Say '*** Nothing done. ***'
   Exit 1;
   End;

syslvl=tpath'\SYSLEVEL.AWS'
dd = Stream(syslvl,'C','QUERY EXISTS') /* Make sure d:\P390 subdirectory exists */
If dd = '' then do
   Say "Subdirectory '"tpath"' does not exist (or" tpath"\SYSLEVEL.AWS not found)."
   Say '*** Nothing done. ***'
   Exit 1
   End;

If beta = 'Y' then
     Say 'To remove service package' fix_level' (### BETA ###) from' tpath', type Y'
Else Say 'To remove service package' fix_level 'from' tpath', type Y'
Say '(any other key to EXIT).';
parse upper value SysGetKey('NOECHO') with key
If key<>'Y' Then do
   Say '*** Nothing done. ***'
   Exit
   End;

Call ChkPgm  /* check to see is any P/390 programs or CM/2 are running */

back_dir = tpath||back_dir  /* d:\P390\BACK000n */
back_new = back_dir'\P390.NEW'  /* List of NEW files that must deleted from d:\P390 */
Log = tpath'\'subd'SERV.LOG'  /* Log for Service Installation errors */
Log2 = tpath'\AWSERROR.LOG' /* Standard P/390 runtime error log */
list = tletter':\AWSTEMP.LST'  /* List of files to be copied */
cmsg  = tletter':\AWSTEMP.MSG' /* Output file for messages from XCOPY & PKUNZIP2 */

/* Start the message log entry */
msg='0D0A'x||'===== P390FIX regress started' Date() Time() '=============================='
x=Lineout(Log,msg); x=Lineout(Log);

/*--------------------------------------------------------------------*/
/*  Make a list of the backup files so we can later delete them       */
/*--------------------------------------------------------------------*/
"DIR /N" back_dir ">" list
If rc <> 0 then do
   Say ''
   msg='Backup directory' back_dir 'not found. 'title' regression can not be done.'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   Call Stream list,'C','CLOSE'
   rc=SysFileDelete(list)
   Exit 2
   End;

dellist = '';
Do While Lines(list)
   w = Linein(list)            /* Read a line from the DIR results */
   If Datatype(word(w,3),'N') & Substr(w,1,3)<>'   ' then do /* Is it a file line? */
      Parse upper var w date time size attr name .
      If Datatype(size,'W')=1 then nop         /* Yes, a real file */
         Else Iterate                          /* Not a file line  */
      dellist = name dellist                   /* Add to delete list */
      End;
   End; /* lines */

Call Stream list,'C','CLOSE'
rc=SysFileDelete(list)

If dellist = '' then do  /* Backup subdirectory was empty */
   Say ''
   msg='Backup subdirectory' back_dir 'is empty. Cannot regress' title'.'
   x=Lineout(Log,msg); x=Lineout(Log);
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   Exit 5
   End

msg='Removing service package 'fix_level'...'
Say msg; x=Lineout(Log,msg); x=Lineout(Log);

/*--------------------------------------------------------------------*/
/* First delete any brand NEW files that weren't in the previous level*/
/*--------------------------------------------------------------------*/
Do While Lines(back_new)
   name = Linein(back_new)      /* Get name of "NEW" P/390 file */
   rc=SysFileDelete(tpath'\'name) /* Delete it so regression is clean */
   End; /* lines */
Call Stream back_new,'C','CLOSE'   /* close the file */
"ATTRIB -R" back_new           /* unprotect file so it can be deleted */
rc=SysFileDelete(back_new)        /* delete it */

/*--------------------------------------------------------------------*/
/*  Copy backup files back into /P390 subdirectory                    */
/*--------------------------------------------------------------------*/
"XCOPY"  back_dir"\*.*" tpath"\  > " cmsg  /* regress old files */
xrc=rc

"COPY" Log"+"cmsg Log">NUL:"  /* append messages to Log */
rc=SysFileDelete(cmsg)
If xrc <> 0 then Do
   msg='** ERROR copying files from' back_dir 'to' tpath
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   error = error+1
   End; /* error */

/*--------------------------------------------------------------------*/
/* Done. Cleanup by deleting the backup files & subdirectory          */
/*--------------------------------------------------------------------*/
"DEL" back_dir"\*.* /N /F"  /* Delete everything in backup subdir */
rc=SysRmDir(back_dir)       /* And remove it */

complete = complete+1
Say ''
msg='Fix package 'fix_level' has been removed.'
Say msg; x=Lineout(Log,msg); x=Lineout(Log);

Signal Exit  /* Go to common exit */


/*------***************************-----------------------------------*/
/*----- S U B R O U T I N E S       ----------------------------------*/
/*------***************************-----------------------------------*/
/*---------------------------------------------------------------------------*/
/* Check to see what level of OS/2 is installed                       */
/*---------------------------------------------------------------------------*/
ChkOS2:
/* Find the boot drive  */
Bdrive=filespec('DRIVE',value('COMSPEC',,'OS2ENVIRONMENT'))
syslvl=Bdrive'\OS2\INSTALL\SYSLEVEL.OS2'
file=charin(syslvl,1,200)           /* Check version of OS/2  */
type =  Substr(file,87,2)
level =  Left(c2x(Substr(file,41,2)),2) /* Check only first 2 digits */
os2rel = left(level,1); os2ver = Substr(level,2,2)
return;

/*--------------------------------------------------------------------*/

GetP390:
/*---------------------------------------*/
/* Find what drive P/390 programs are on */
/*---------------------------------------*/
/* Find the boot drive  */
Bdrive=filespec('DRIVE',value('COMSPEC',,'OS2ENVIRONMENT'))
config=Bdrive'\CONFIG.SYS'

/* Read in CONFIG.SYS file one line at a time */
Do i=1 by 1 While Lines(config)
   cline = Linein(config)
   Parse upper var cline rem .
   If Strip(rem) = 'REM' then iterate
   Parse upper var cline . 'SET PATH=' ppath
   If ppath <> '' then leave /* Found the line we want */
   End;
Call Stream config,'C','CLOSE'
If ppath = '' then do  /* If we can't locate CONFIG.SYS, take default */
   dletter='D'
   Return
   End;

/*                                                             */
/*  Extract drive letter from first d:\P390; statement on line */
/*                                                             */
pp390 = Pos(':\'subd';',ppath)
If pp390 = 0 then do  /* Can't find one */

   If subd <> 'P370' then do  /* They didn't tell us they were P/370 */
      pp390 = Pos(':\P370;',ppath) /* So we'll check ourselves */
      If pp390 > 0 then do  /* P390 not found but P370 was */
         Say 'The P390 subdirectory was not found in CONFIG.SYS "SET PATH" statement.'
         Say 'If you are a Personal/370 user, please invoke this program again:'
         Say '     'cmdname' P370'
         Exit 5
         End
      End

   dletter='D' /* Can't find either P390 or P370 - assume default */
   Return
   End;

dletter = Substr(ppath,pp390-1,1)  /* Grab P390 drive letter */
If (length(dletter)<>1 | Datatype(dletter,'U')<>1) Then dletter = 'D';

Return;

/*--------------------------------------------------------------------*/

ChkP390:
/*---------------------------------------------------------------------------*/
/* Check to see what level of P/390 is installed                      */
/*---------------------------------------------------------------------------*/
syslvl=tpath'\SYSLEVEL.AWS'
dd = Stream(syslvl,'C','QUERY EXISTS') /* Make sure d:\P390 subdirectory exists */
If dd = '' then do
   Say "Subdirectory '"tpath"' does not exist (or" tpath"\SYSLEVEL.AWS not found)."
   Say '*** Nothing done. ***'
   Exit 1
   End;

file=charin(syslvl,1,200)           /* Check version of P/390 X.YY.Z */
Call Stream syslvl,'C','CLOSE'
num1  = c2x(Substr(file,41,2))
num2  = c2x(Substr(file,150,1))
P390rel = Substr(num1,1,1)                     /* X.  .   */
P390lvl = Substr(num1,2,1)||Substr(num1,4,1)   /*  .YY.   */

If num2 = 'B1' then do  /* A beta fix level is installed */
   Say 'Current' card 'program level is' P390rel'.'P390lvl'.'x2c(e1)
   Say 'You cannot install fixpack' fix_level 'on this base because it is a BETA fixpack.'
   Say 'You must back off the BETA by typing:' tpath'\REGRESS.'
   Say '*** Nothing done. ***'
   Exit 2
   End
   /* Note: To create a "Beta" SYSLEVEL.AWS, replace the X'01' byte at offset X'96' with X'B1'  */
   /*       This is ASCII for a grey block (), but SYSLEVEL.EXE displays it as a beta ()  */

Else P390mod = Substr(num2,2,1)                     /*  .  .Z  */

P390_level = P390rel||P390lvl||P390mod
If Substr(num1,2,1) = '0' then P390lvl = Substr(num1,4,1) /* Strip leading zero */
P390_lvl = P390rel'.'P390lvl'.'P390mod

Select;

When P390_level < Base_level then do
   Say 'Current' card 'program level is' P390rel'.'P390lvl'.'P390mod'.'
   Say 'You cannot install fixpack' fix_level 'on this base.'
   Say 'The required base is' base_lvl 'or above.'
   Say '*** Nothing done. ***'
   Exit 2
   End;

When P390_level = '2030' then nop; /* Special case 2.3.0 &  */
                                   /* 2.3.1 for this        */
When P390_level = '2031' then nop; /* fix pack ONLY !!      */

When P390_level >= Fix_level then do
   Say 'Current' card 'program level is' P390_lvl
   Say 'There is no need to install fixpack' fix_level 'on this base.'
   Say '*** Nothing done. ***'
   Exit 2
   End;

Otherwise;  /* OK to update */

End; /* select */

If tletter <> dletter then
   Say 'Warning: 'tpath' may not be first in the "SET PATH=" statement of CONFIG.SYS.'

Return;

/*--------------------------------------------------------------------*/

ChkPgm:
/*--------------------------------------------------------------------*/
/* Check to see if either P/390 code or our CM DLLs are running       */
/*--------------------------------------------------------------------*/

/* Check the P/370 CM interface DLLs  */
y.1=Stream(tpath'\awsdftn.dll','C','OPEN') /* Is it running */
y.2=Stream(tpath'\awsdfts.dll','C','OPEN') /* Is it running */
y.3=Stream(tpath'\awsntca.dll','C','OPEN') /* Is it running */
y.4=Stream(tpath'\awsstca.dll','C','OPEN') /* Is it running */
z.1=Stream(tpath'\awsdftn.dll','C','CLOSE')
z.2=Stream(tpath'\awsdfts.dll','C','CLOSE')
z.3=Stream(tpath'\awsntca.dll','C','CLOSE')
z.4=Stream(tpath'\awsstca.dll','C','CLOSE')
If y.1='NOTREADY:32' | y.2='NOTREADY:32'|,
   y.3='NOTREADY:32' | y.4='NOTREADY:32'
   then do
   Say '********************** ERROR *******************************'
   Say 'The Communications Manager 3270 DFT sessions must be STOPPED'
   Say 'before you can run the' cmdname 'program.'
   Say '*** Nothing done ***'
   Exit 13
   end

/* Check the P/370 I/O subsystem */
y=Stream(tpath'\awsutil.dll','C','OPEN') /* Is it running? */
z=Stream(tpath'\awsutil.dll','C','CLOSE')
If y='NOTREADY:32'  then do
   Say '********************** ERROR *****************************'
   Say 'The' card 'programs on drive' tpath 'may be running.';
   Say 'You must select END' card 'icon and then rerun' cmdname
   Say ''
   Say 'If this still fails, then re-boot OS/2 and try again.'
   Say '*** Nothing done ***'
   y=Stream(tpath'\awsutil.dll','C','CLOSE')
   Exit 13
   end

/* Check for other P/370 programs */
n.1='MANOPS.EXE'; n.2='AWSCNF.EXE'; n.3='AWSTRACE.EXE';
Do i=1 to 3
   y.i=Stream(tpath'\'n.i,'C','OPEN') /* Is it running? */
   z.i=Stream(tpath'\'n.i,'C','CLOSE')
   If y.i='NOTREADY:32'  then do
      Say '********************** ERROR *****************************'
      Say 'The' n.i 'program on drive' tpath 'is running.';
      Say 'You must stop this program and then rerun' cmdname
      Say '*** Nothing done ***'
      Exit 13
      end
   End;  /* check other pgms */
Return;

/*--------------------------------------------------------------------*/

P390LIC:

/*--------------------------------------------------------------------*/
/*    P/390 L.I.C patch subroutine                                    */
/*--------------------------------------------------------------------*/
"@ECHO OFF"
subtitle = 'P/390 L.I.C.'
/*                                                                    */
/* Check the input parameters                                         */
/*                                                                    */
Parse upper arg parm1 .
If parm1 = '?' /*  Help  */
   then do;
Say 'Correct Form is:                                                       '
Say '                  P390LIC d:\path\licname                              '
Say '                                                                       '
Say 'This program will update "licname.MCD" using patch file "licname.MCP"'
Say 'that is located in the same OS/2 subdirectory.'
Say '                                                                       '
        Return
        end

/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

If parm1 = '' then do

Say ''; Say subtitle 'update program';
Say '---------------------------';
   Say 'Enter the drive, path and name of the L.I.C file that is to be updated:'
   Say '   (e.g. D:\P390\AWS3900.MCD)'
   parse upper pull parm1
   If parm1 = '' Then Do
      Say '*** Nothing done ***'
      Return 1
      End
   End; /* parm1 null */


lpath = Filespec('Drive',parm1)||Filespec('Path',parm1)
lname = Filespec('Name',parm1)
Parse var lname licname '.' .    /* e.g. licname = AWS3900 */
If Substr(licname,6,1) = '0' then mode = 'S/370 mode';
                             Else mode = 'ESA/390 mode';

/*--------------------------------------------------------------------*/
/*  Check for necessary files                                         */
/*--------------------------------------------------------------------*/
patchfile = lpath||licname'.MCP'
licfile = lpath||licname'.MCD'
ee = Stream(patchfile,'C','QUERY EXISTS')
ff = Stream(licfile,'C','QUERY EXISTS')
If ee = '' then do
   msg='***' patchfile 'not found. 'subtitle' update cannot be done. ***'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   Return 1
   End
If ff = '' then do
   If card = 'P/370' then Return 1  /* If no P/390 LIC is found and the user has a P/370, return quietly */
   msg='***' licfile 'not found. 'subtitle' update cannot be done. ***'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   Return 1
   End

/*--------------------------------------------------------------------*/
/*  Check L.I.C. headers                                              */
/*--------------------------------------------------------------------*/
lic_header=Charin(licfile,1,12)         /* read headers */
patch_header=Charin(patchfile,1,12)
Call Stream licfile,'C','CLOSE'
Call Stream patchfile,'C','CLOSE'

If Substr(lic_header,1,5) <> '\P390' |,
   Substr(lic_header,7,1) <> 'V'     |,
   Substr(lic_header,10,1) <> '.'    then do
   msg=licfile 'is not a valid' subtitle 'file.'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   msg='***' subtitle 'file cannot be updated. ***'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   Return 2
   End

If Substr(patch_header,1,5) <> '\P390' |,
   Substr(patch_header,7,1) <> 'V'     |,
   Substr(patch_header,10,1) <> '.'    then do
   msg=patchfile 'is not a valid' subtitle 'file.'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   msg='***' subtitle 'file cannot be updated. ***'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   Return 2
   End

If Substr(patch_header,6,1) <> Substr(lic_header,6,1) then do
   msg=licname 'and' patchname 'are not the same mode (e.g. 370 or ESA).'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   msg='***' subtitle 'file cannot be updated. ***'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   Return 3
   End

/*--------------------------------------------------------------------*/
/*  Check L.I.C. levels                                               */
/*--------------------------------------------------------------------*/
lic_level = Substr(lic_header,8,5)
patch_level = Substr(patch_header,8,5)

If (Substr(lic_level,1,2) = '00') |,
   (Substr(lic_level,1,2) = '01' & Substr(lic_level,4,2) = '00') then do
   msg=licfile 'is not at GA level (version 1.01) or higher.'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   msg='***' subtitle 'file cannot be updated. ***'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   Return 3
   End

If Substr(lic_level,1,2) = Substr(patch_level,1,2) &,
   Substr(lic_level,4,2) = Substr(patch_level,4,2) then do
   msg=licfile 'has already been updated to version' patch_level
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   msg=subtitle 'file does not need updating.'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   Return 0  /* Don't set error counter - informational only */
   End

/*--------------------------------------------------------------------*/
/*  Update the L.I.C. file                                            */
/*--------------------------------------------------------------------*/
save_data=Charin(licfile,25,912)   /* Save unchanged data from original file */
Call Stream licfile,'C','CLOSE'    /* MUST close the file...  */

patch_data=Charin(patchfile,1,chars(patchfile)) /* Read entire patch file          */
Call Stream patchfile,'C','CLOSE'   /* MUST close the file...  */

new_data=overlay(save_data,patch_data,25) /* Replace unchanged data */
new_data=overlay('1A'x,new_data,13)       /* Insert an ASCII EOF */

/*--------------------------------------------------------------------*/
/* If level is earlier than 1.10 then must zap copyright date to 1996 */
/*--------------------------------------------------------------------*/
yroff = 614
If (Substr(lic_level,1,2) = '01' & Substr(lic_level,4,2) < '10') then do
   If Substr(new_data,yroff,1) <> '35'X Then do  /* Check old value */
      Say 'ERROR: Data at offset' yroff 'is incorrect',
          "(expected: '35'X, found: '"c2x(Substr(new_data,yroff,1))"'X.)"
      Say '       'subtitle 'update cannot be done.' licfile 'not changed.'
      Return 2
      End
   new_data=overlay('36'X,new_data,yroff) /* Replace unchanged data */
   End; /* Zap the copyright */

/*--------------------------------------------------------------------*/
/* Write out the new L.I.C file under a temporary name                */
/*--------------------------------------------------------------------*/
newfile = SysTempFileName(lpath||licname'.???')
Call Charout newfile,new_data      /* Write out the new L.I.C. file  */
Call Stream newfile,'C','CLOSE'    /* Close the file */

/*--------------------------------------------------------------------*/
/*  Check the CRC of the new L.I.C. file                              */
/*--------------------------------------------------------------------*/
exp_crc = '0000'   /* thanks to John Burr */
crc_temp = SysTempFileName(lpath||'TEMP.???')
"CRC2" newfile '>' crc_temp
If rc <> 0 then do
   msg='Required program "CRC2.EXE" was not found.'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   msg='We are not able to check the validity of the new L.I.C. file.'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   msg="The CRC of the new L.I.C. file should be X'"exp_crc"'."
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   End
Else do
   crc_mcd=linein(crc_temp)
   parse var crc_mcd . ":" "X'" new_crc "'" .
   If new_crc <> exp_crc then do
      msg='ERROR: The CRC code of the new L.I.C. file is incorrect.'
      Say msg; x=Lineout(Log,msg); x=Lineout(Log);
      msg=subtitle 'update has failed.' licfile '('mode') not changed.'
      Say msg; x=Lineout(Log,msg); x=Lineout(Log);
      rc=SysFileDelete(newfile)       /* Erase incorrect file */
      Call Stream crc_temp,'C','CLOSE'    /* Close the temp */
      rc=SysFileDelete(crc_temp)          /* Discard it */
      Return 4
      End;
   End;  /* CRC worked */
Call Stream crc_temp,'C','CLOSE'    /* Close the file */
rc=SysFileDelete(crc_temp)          /* Discard it */

/*--------------------------------------------------------------------*/
/*  Replace the old L.I.C. file with the new one                      */
/*--------------------------------------------------------------------*/
rc=SysFileDelete(licfile)       /* Erase old file */
If rc <> 0 then do
   msg='ERROR: Old L.I.C. file "'licfile'" cannot be replaced. Is it R/O?'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   msg=subtitle 'update has failed.' licfile '('mode') not changed.'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   rc=SysFileDelete(patchfile)       /* Erase patch file */
   Return 5
   End;

"RENAME" newfile filespec('Name',licfile) /* Replace old with new */
If rc <> 0 then do
   msg='ERROR: Old L.I.C. file "'licfile'" cannot be replaced. Is it R/O?'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   msg=subtitle 'update has failed.' licfile '('mode') not changed.'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   rc=SysFileDelete(patchfile)       /* Erase patch file */
   Return 5
   End;

msg=subtitle 'file' licfile '('mode') has been updated.'
Say msg; x=Lineout(Log,msg); x=Lineout(Log);

rc=SysFileDelete(patchfile)       /* Erase patch file */

Return 0
/*--------------------------------------------------------------------*/

QZIP:
/*--------------------------------------------------------------------*/
/* Determine the uncompressed size of a PKZIP file                    */
/*--------------------------------------------------------------------*/
/*  "PKUNZIP2 fn.zip -v"  yields the following data:

PKUNZIP (R) FAST!  Extract Utility  Ver 1.09-OS/2 Prot Mode  1-15-91
Copr. 1989-1991 PKWARE Inc. All Rights Reserved. PKUNZIP/h for help
PKUNZIP Reg. U.S. Pat. and Tm. Off.    IBM LICENSED VERSION

Searching ZIP: d:/path/fn.zip

 Length  Method   Size  Ratio   Date    Time   CRC-32  Attr  Name
 ------  ------   ----- -----   ----    ----   ------  ----  ----
6152192  Implode  79517  99%  03-27-95  16:20  970d841c --w  MAINT.2A4
   .        .       .
   .        .       .
   .        .       .
3080192  Implode  39917  99%  03-27-95  16:20  8207a9c7 --w  MAINT.7C4
 ------          ------  ---                                 -------
27320064         1644830  99%                                      17

This routine redirects this "view" output to a file and then searched
for the second '------' as the first token of a line.  The first
token of the very next line is the total size.
*/

zlist = tletter":\PKZ.SIZ" /* captured output from pkunzip */
zpath"PKUNZIP2 -v" filename ">" zlist
If rc = 0 then do
   dfound = 0               /* Counter of dashed-lines found */
   Do While Lines(zlist)
      z = Linein(zlist)
      Parse var z token1 .
      If dfound <> 2 then do  /* If we haven't found 2nd line yet */
         If token1 <> '------' then Iterate
         Else dfound = dfound + 1   /* Found a dashed line */
         Iterate
         End;
      Else do
         total = Strip(Word(z,1))    /* Just the digits of the size */
         Leave  /* size is found */
         End;
      End; /* search all lines */
   Call Stream zlist,'C','CLOSE'
   rc=SysFileDelete(zlist)
   If Datatype(total,'W') = 0 then do
      msg='** ERROR: size for' filename 'could not be determined.'
      Say msg; x=Lineout(Log,msg); x=Lineout(Log); /* Log message */
      error = error+1
      End;
   End;
Else do
   msg='** ERROR: size for' filename 'could not be determined.'
   Say msg; x=Lineout(Log,msg); x=Lineout(Log); /* Log message */
   error = error+1
   End;

Return;

/*--------------------------------------------------------------------*/

Folder:
/* ================================================================ */
/* Create P/370 or P/390 Program folder and icons                   */
/* ================================================================ */

'@ECHO ON'      /* Want to see all OS/2 commands executed */
/* Re-Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs
f=0

Call ChkOS2  /* Set variable os2rel = 2 or 3 */

Say ''
Say 'Making a' card 'Program folder.';
Say '=============================='
Say ''
/*--------------------------------*/
/* Create a P/370 or P/390 folder */
/*--------------------------------*/
classname='WPFolder'
location='<WP_DESKTOP>'
ititle=card
oid='OBJECTID=<'subd'1_FOLDER>;'
win='MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;'
icon='ICONVIEW=FLOWED;ICONFILE='tpath'\'subd'.ICO;'
setup=oid||win||icon
Call BldObj

If f<>0 then do
   Say 'Can not create new' card 'folder because'
   Say 'OS/2 desktop objectid 'subd'1_FOLDER already exists.'
   return 1
   end
Else do
   /* Place the program objects in the folder in order */
   /* IPL  370       */
   /* END 370        */
   /* CONFIGURATOR   */
   /* MANOPS         */
   /* AWSTRACE       */
   /* AWSSDUMP       */
/* Icons are named xxxx.ico for P/370 or xxxx9.ico for P/390 */
If card = 'P/390' then iii = '9'; else iii = '';
If os2rel='3' then do
   Call adddmp
   Call addtrc
   Call addman
   Call addcfg
   Call addend
   Call addipl
   End; /* OS/2 3.x add objects */
Else Do
   Call addipl
   Call addend
   Call addcfg
   Call addman
   Call addtrc
   Call adddmp
   End; /* OS/2 2.x add objects */
End; /* filling the folder */

Return 0

/*--------------------------------------------------------------------*/

Addipl:
   /*----------------------------------------------*/
   /*  Place the IPL program object into the folder */
   /*----------------------------------------------*/
   classname='WPProgram'
   ititle='IPL' card
   location='<'subd'1_FOLDER>'

   oid='OBJECTID=<'subd'1_IPL>;';
   pgmname='EXENAME='tpath'\IPL.CMD;';
   ptype='PROGTYPE=WINDOWABLEVIO;';
If iii = '9' then
   win='MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
Else
   win='MINIMIZED=YES;MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
   icon='ICONFILE='tpath'\IPL'iii'.ICO;'
   dir='STARTUPDIR='tpath';';
   close='NOAUTOCLOSE=;';
   /* parms='PARAMETERS='; */

   setup=ptype||pgmname||oid||win||icon||close||dir
   Call BldObj
Return;

Addend:
   /*------------------------------------------------*/
   /*  Place the END program object into the folder  */
   /*------------------------------------------------*/
   classname='WPProgram'
   ititle='End' card
   location='<'subd'1_FOLDER>'

   oid='OBJECTID=<'subd'1_END>;';
   pgmname='EXENAME='tpath'\AWSEND.CMD;';
   ptype='PROGTYPE=WINDOWABLEVIO;';
   win='MINIMIZED=YES;MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
   icon='ICONFILE='tpath'\AWSEND'iii'.ICO;'
   dir='STARTUPDIR='tpath';';
   close='NOAUTOCLOSE=;';
   /* parms='PARAMETERS='; */

   setup=ptype||pgmname||oid||win||icon||close||dir
   Call BldObj
Return;

Addcfg:
   /*--------------------------------------------------*/
   /*  Place the CONFIG program object into the folder */
   /*--------------------------------------------------*/
   classname='WPProgram'
   ititle=card 'Configuration'
   location='<'subd'1_FOLDER>'

   oid='OBJECTID=<'subd'1_CONFIG>;';
   pgmname='EXENAME='tpath'\AWSCFG.CMD;';
   ptype='PROGTYPE=WINDOWABLEVIO;';
   win='MAXIMIZED=YES;MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
   icon='ICONFILE='tpath'\AWSCFG'iii'.ICO;'
   dir='STARTUPDIR='tpath';';
   close='NOAUTOCLOSE=;';
   parms='PARAMETERS= S=1';

   setup=ptype||pgmname||oid||win||icon||close||dir||parms
   Call BldObj
Return;

Addman:
   /*--------------------------------------------------*/
   /*  Place the MANOPS program object into the folder */
   /*--------------------------------------------------*/
   classname='WPProgram'
   ititle=card 'Manual Operations'
   location='<'subd'1_FOLDER>'

   oid='OBJECTID=<'subd'1_MANOPS>;';
   pgmname='EXENAME='tpath'\MANOPS.EXE;';
   ptype='PROGTYPE=PM;';
   win='MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
   icon='ICONFILE='tpath'\MANOPS'iii'.ICO;'
   dir='STARTUPDIR='tpath';';
   close='NOAUTOCLOSE=;';
   /* parms='PARAMETERS=';*/

   setup=ptype||pgmname||oid||win||icon||close||dir
   Call BldObj
Return;

Addtrc:
   /*--------------------------------------------------*/
   /*  Place the TRACE program object into the folder */
   /*--------------------------------------------------*/
   classname='WPProgram'
   ititle=card 'I/O Trace'
   location='<'subd'1_FOLDER>'

   oid='OBJECTID=<'subd'1_TRACE>;';
   pgmname='EXENAME='tpath'\AWSTRACE.EXE;';
   ptype='PROGTYPE=PM;';
   win='MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
   icon='ICONFILE='tpath'\AWSTRCE'iii'.ICO;'
   dir='STARTUPDIR='tpath';';
   close='NOAUTOCLOSE=;';
   /* parms='PARAMETERS='; */

   setup=ptype||pgmname||oid||win||icon||close||dir
   Call BldObj
Return;

Adddmp:
   /*------------------------------------------------*/
   /*  Place the DUMP program object into the folder */
   /*------------------------------------------------*/
   classname='WPProgram'
   ititle=card' Snap Shot Dump'
   location='<'subd'1_FOLDER>'

   oid='OBJECTID=<'subd'1_DUMP>;';
   pgmname='EXENAME='tpath'\AWSSDUMP.EXE;';
   ptype='PROGTYPE=WINDOWABLEVIO;';
   win='MINIMIZED=YES;MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
   icon='ICONFILE='tpath'\AWSDUMP'iii'.ICO;'
   dir='STARTUPDIR='tpath';';
   close='NOAUTOCLOSE=;';
   /* parms='PARAMETERS='; */

   setup=ptype||pgmname||oid||win||icon||close||dir
   Call BldObj
Return;

/*---------------------------------------------------------------------------*/
/* Build Object */
/*---------------------------------------------------------------------------*/
BldObj:
call charout ,'Adding: 'ititle

result = SysCreateObject(classname, ititle, location, setup)

If result=1 Then call charout ,'... Object created.'
Else do
     call charout ,'... ERROR: Object not created.'
     f=f+1; /* count failures */
     end

Say '';
Return

/*--------------------------------------------------------------------*/
/* Change the drive letters in CONFIG.AWS sample file                 */
/*--------------------------------------------------------------------*/
ChngSamp:
"@ECHO OFF"                         /* Execute OS/2 commands quietly */
iaws = temp_dir'\CONFIG.AWS'        /* sample config location */
z = Stream(iaws,'C','QUERY EXISTS') /* Does it exist? */
If z = '' then return               /* return quietly */
oaws=SysTempFileName(temp_dir'\TEMP.???') /* temporary work file */
/*                                       */
/*  Read in CONFIG.AWS file              */
/*                                       */
config_aws=charin(iaws,1,99999);
If tpath = 'C:\P370' then return  /* No changes necessary, but need file */
                             /* in variable for UpConfig subroutine later */
lenc = length(config_aws)
Parse upper var config_aws zz
n=1

/*                                                                    */
/*  Search for C:\P370 and replace with drive letter and path         */
/*                                                                    */
Do until n>=lenc
   x=Pos('C:\P370',zz,n)  /* Search for C:\P370 **Do not alter this** */
   If x<> 0 then do
      config_aws=overlay(tpath,config_aws,x,7) /* replace with d:\P3n0  */
      n=x+7               /* skip past found string */
      end
   Else leave
   end
/*                                    */
/*  Write out the modified file       */
/*                                    */
x=charout(oaws,config_aws);
call lineout oaws           /* Close output file */
call lineout iaws           /* Close input file */
"COPY" oaws iaws "> "cmsg  /* Copy new file over the old file */
If rc <> 0 then
   "COPY" Log"+"cmsg Log">NUL:"  /* append messages to Log */
rc=SysFileDelete(cmsg)
rc=SysFileDelete(oaws)     /* Delete work file  */
Return;

/*--------------------------------------------------------------------*/
/* Update the L.I.C. level in LEGAL.DOC                               */
/*--------------------------------------------------------------------*/
UpdLegal:
ldoc = tpath'\LEGAL.DOC'
ldoc_tmp = SysTempFileName(tpath'\LEGAL.???')
/* Read in LEGAL.DOC file one line at a time */
Do i=1 by 1 While Lines(ldoc)
   lline = Linein(ldoc)
   Parse upper var lline . lic vers nn .
   If (lic = 'LIC') & (vers = 'VERSION')
      Then Call Lineout ldoc_tmp,nline
      Else Call Lineout ldoc_tmp,lline
   End;
Call Stream ldoc,'C','CLOSE'
Call Stream ldoc_tmp,'C','CLOSE'
"COPY" ldoc back_dir "> " cmsg /* Save old file */
"COPY" ldoc_tmp ldoc "> " cmsg /* Copy new file over the old file */
If rc <> 0 then
   "COPY" Log"+"cmsg Log">NUL:"  /* append messages to Log */
rc=SysFileDelete(cmsg)
rc=SysFileDelete(ldoc_tmp)     /* Delete work file  */
Return;

/*------***************************-----------------------------------*/
/*----- E R R O R   R O U T I N E S ----------------------------------*/
/*------***************************-----------------------------------*/

NodiskT:
Say ''
Say 'Destination disk' tletter': does not exist.  Check parameters and rerun.'
Exit 3

NoSpace:
ndigits=Length(total);
tdigits=Length(tfree);
tfree=Right(tfree,Max(ndigits,tdigits));
Say ''
msg='** ERROR: Not enough space on drive 'tletter' to install' title 'files.'
Say msg; x=Lineout(Log,msg);
msg=total  'bytes ('Trunc(total/1048576,1) 'MB) are needed on drive 'tletter'. There are only'
Say msg; x=Lineout(Log,msg);
msg=tfree' bytes ('Trunc(tfree/1048576,1) 'MB) available.'
Say msg; x=Lineout(Log,msg);
Say ''
Say 'Free up enough space on drive 'tletter 'and then rerun' cmdname'.'
Say ''
Exit 6
