/* Abend Processing routine for P/390                       4/24/98   */
/* This routine is automatically invoked when a P/390 process abends  */
/* It collects the abend data (traces, snap dump) into a SAVERAM file */
/* The files to be collected are listed in AWSABEND.LST.              */
trace o
parse arg msg
parse arg . 'NAME' id;

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/*---------------------------------------------------------------------*/
/* Add the files we want to capture to awsabend.lst and                */
/* Stop trace spooling before snap dump to avoid junk in the dump      */
/*---------------------------------------------------------------------*/
call lineout 'AWSABEND.LST',' dummy';   /* In case no CR from preceding entry */
pd=Stream('C:\PDUMP.*','C','QUERY EXISTS')
If pd <> '' then
         call lineout 'AWSABEND.LST','C:\PDUMP.*'   /* take all pdumps */
call Stream 'AWSABEND.LST','C','CLOSE'     /* close the file */
'AWSTRCSP /STOP'         ;
/*---------------------------------------------------------------------*/
/* Get a Snap Dump                                                     */
/*---------------------------------------------------------------------*/
'AWSSDUMP'
dumpno=rc;
if dumpno<16
   then do;
            snap = 'AWSSNAP'||right(d2x(dumpno),1)||'.DMP';
            ram  = 'AWSSNAP'||right(d2x(dumpno),1)||'.RAM';
        end;
   else do;
            snap='';
            ram = 'AWSSNAPZ.RAM';
        end;
/******
if id<>''
   then 'start' awspopup 16385 '"The' id 'component of the P/390 abended"'
*****/
/*---------------------------------------------------------------------*/
/* Get the ICETRACE                                                    */
/*---------------------------------------------------------------------*/

"CALL ICETRACE * > NUL:"

/*---------------------------------------------------------------------*/
/* Zip everything up into a SAVERAM file                               */
/*---------------------------------------------------------------------*/

'SAVERAM2 AWSABEND.LST' ram '/L';

/* Save one generation of PDUMPs */
If pd <> '' then do
   "XCOPY C:\PDUMP.* C:\PDUMPOLD.* > NUL:"
   "@ERASE C:\PDUMP.* 2> NUL:"
   End
exit 1;
