/* P/370 & P/390  LIC Installation program                8/12/96 JAH    */

trace o
/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/*  Determine if this is a P/370 or P/390         */
title = 'Personal/370'
card = 'P/370'
spath = 'P370'
/* Find out where INSTALL.CMD is located */
Parse upper source . . sspec
sdrive = Filespec('Drive',sspec)
If sdrive = 'A:' |  sdrive = 'B:' then Do
 info = SysDriveInfo(sdrive)
 Parse var info . . . label
 If Left(Strip(label),4)='P390' then
 Do
  title = 'PC Server S/390'
  card  = 'P/390'
  spath = 'P390'
  End
 End

Call SysCls

/* check for a drive letter passed as parameter to INSTALL */
/* The P/390 INSTALL calls us with this parameter, so skip the first prompt */
parse upper arg letter ':' dpath  .
letter = Strip(letter)

If letter='' then do
 Say ''; Say title 'Licensed Internal Code Installation';
 say ''; Say 'To continue with installation press Y';
 Say '(any other key to EXIT).';
 parse upper value SysGetKey('NOECHO') with key
 If key<>'Y' Then Exit 1
 Say '';
 Say 'Type in the letter of the drive where the 'card' programs are located:';
 Say '(Default = C )';
 parse upper value SysGetKey('NOECHO') with key
 If key='0D'x Then Do
    path='C:\'spath;
    letter='C';
    end;
 Else Do
    If Datatype(key,'M')=0 then Exit 1
    path=key':\'spath;
    letter=key;
    end;
 end
Else path=letter':\'spath;

info = SysDriveInfo(letter':')
If info = '' then do
 Say ''
 Say 'Destination disk' letter': does not exist. Check parameters and rerun INSTALL.'
 Exit 3
 End

Say ''
Say 'Installing' card 'Licenced Internal Code on drive' path;
Say '========================================================';

d1=0
Disk_1:
info = SysDriveInfo(sdrive)
Parse var info . . . label
If label <> spath||' DIAG' then do
 If d1=0 then do
  Say ''
  Say 'Make sure the Advanced Diagnostics and Option diskette';
  Say 'is in drive' sdrive 'and then press ENTER to copy Licenced Internal Code.';
  Say '(any other key to EXIT)';
  end
 Else do
 Call Beep 600,250
 Say ''
 Say 'Incorrect diskette inserted.'
 Say 'Please verify that the "Advanced Diagnostics and Option diskette"';
 Say 'is inserted in drive' sdrive 'and then press ENTER.'
 Say '(any other key to EXIT)';
 end

 parse upper value SysGetKey('NOECHO') with key
 If key<>'0D'x Then Exit 1
 d1=1
 Signal Disk_1
 end

Say ''
If d1=1 then
Say 'COPYING' card 'Licenced Internal Code from' sdrive 'to' path '...';
   "XCOPY"  sdrive"\*.MCD " path"\";
If spath = 'P390' then do
 "@ECHO OFF";
 "COPY"  sdrive"\LEGAL.DOC " path"\";
 "TYPE " path"\LEGAL.DOC";
 Say '---------------------------------------------------------------------------'
 Say ''
 End;

Say title 'Licenced Internal Code installation complete,'
Say 'UNLESS you received any error messages.';

Exit 0
