/******************************************************************************/
/* Sample using the P/370 REXX Interface (P370REXX.DLL)                       */
/*                                                                            */
/* Author: Helmut Roth                                                        */
/******************************************************************************/
  PARSE ARG function parms
  PARSE UPPER VAR function function
  /*--------------------------------------------------------------------------*/
  /* supported functions                                                      */
  /*--------------------------------------------------------------------------*/
  functions  =  'CombufRead              CombufWrite                ',
                'ControlStoreAddressRead                            ',
                'Iointerrupt             installedStoragesizeinbytes',
                'KeyarrayRead            Manualrequest              ',
                'MemoryRead              MemoryWrite                ',
                'MemoryReadEbcdic        MemoryWriteEbcdic          ',
                'PCSRead                 PCSWrite                   ',
                'VirtualMemoryRead       VirtualMemoryWrite         ',
                'VirtualMemoryReadEbcdic VirtualMemoryWriteEbcdic   ',
                'Refreshwindow           setActivewindow            ',
                'setwindowBaseaddress    Virtualaddress2Realaddress '
  /*--------------------------------------------------------------------------*/
  /* poor man's help                                                          */
  /*--------------------------------------------------------------------------*/
  valid_function = 'NO'
  DO WHILE functions <> ''
    PARSE VAR functions f functions
    /*------------------------------------------------------------------------*/
    /* handle abbreviations                                                   */
    /*------------------------------------------------------------------------*/
    abbr = ''
    DO I = 1 TO LENGTH(f)
      IF DATATYPE(SUBSTR(f,I,1), 'Uppercase') THEN abbr = abbr || SUBSTR(f,I,1)
      IF DATATYPE(SUBSTR(f,I,1), 'Number   ') THEN abbr = abbr || SUBSTR(f,I,1)
    END
    PARSE UPPER VAR f f
    IF function = abbr THEN function = f
    /*------------------------------------------------------------------------*/
    IF function <> f THEN ITERATE
    valid_function = 'YES'
    LEAVE
  END
  IF valid_function = 'NO'
  THEN DO
    SAY "                                                                      "
    SAY "Supported commands:                                                   "
    SAY "                                                                      "
    SAY "P370 CombufRead                 HexAddress HexBytecount           [CardNumber]"
    SAY "P370 CombufWrite                HexAddress HexData                [CardNumber]"
    SAY "P370 ControlStoreAddressRead                                      [CardNumber]"
    SAY "P370 installedStoragesizeinbytes                                  [CardNumber]"
    SAY "P370 Iointerrupt                                                  [CardNumber]"
    SAY "P370 KeyarrayRead               HexAddress HexBytecount           [CardNumber]"
    SAY "P370 Manualrequest                                                [CardNumber]"
    SAY "P370 MemoryRead                 HexAddress HexBytecount           [CardNumber]"
    SAY "P370 MemoryWrite                HexAddress HexData                [CardNumber]"
    SAY "P370 MemoryReadEbcdic           HexAddress HexBytecount           [CardNumber]"
    SAY "P370 MemoryWriteEbcdic          HexAddress 'String'               [CardNumber]"
    SAY "P370 PCSRead                                                      [CardNumber]"
    SAY "P370 PCSWrite                   HexData                           [CardNumber]"
    SAY "P370 VirtualMemoryRead          HexAddress HexBytecount [CR0 CR1] [CardNumber]"
    SAY "P370 VirtualMemoryWrite         HexAddress HexData      [CR0 CR1] [CardNumber]"
    SAY "P370 VirtualMemoryReadEbcdic    HexAddress HexBytecount [CR0 CR1] [CardNumber]"
    SAY "P370 VirtualMemoryWriteEbcdic   HexAddress 'String'     [CR0 CR1] [CardNumber]"
    SAY "P370 Virtualaddress2Realaddress HexAddress [CR0 CR1]              [CardNumber]"
    SAY "P370 Refreshwindow              WindowNumber                          "
    SAY "P370 setActivewindow            WindowNumber                          "
    SAY "P370 setwindowBaseaddress       WindowNumber HexAddress               "
    SAY "                                                                      "
    SAY "WindowNumbers range from 0 to 15.                                     "
    SAY "CR0 and CR1 must be specified with 8 hex digits each.                 "
    SAY "The capital letters and numbers of a command are a valid abbreviation."
    SAY "If you have any questions, please feel free to ask Helmut Roth.       "
    RETURN 4711
       END
  /*--------------------------------------------------------------------------*/
  /* register the P370REXX functions                                          */
  /*--------------------------------------------------------------------------*/
  function_and_entry_names =,
                  'CombufRead                  P370CombufRead                 ',
                  'CombufWrite                 P370CombufWrite                ',
                  'ControlStoreAddressRead     P370ControlStoreAddressRead    ',
                  'Iointerrupt                 P370IOInterrupt                ',
                  'installedStoragesizeinbytes P370InstalledStorageSizeInBytes',
                  'KeyarrayRead                P370KeyarrayRead               ',
                  'Manualrequest               P370ManualRequest              ',
                  'MemoryRead                  P370MemoryRead                 ',
                  'MemoryWrite                 P370MemoryWrite                ',
                  'A2EX                        P370Ascii2EbcdicHex            ',
                  'EX2A                        P370EbcdicHex2Ascii            ',
                  'PCSRead                     P370PCSRead                    ',
                  'PCSWrite                    P370PCSWrite                   ',
                  'Refreshwindow               P370RefreshWindow              ',
                  'setActivewindow             P370SetActiveWindow            ',
                  'setwindowBaseaddress        P370SetWindowBaseAddress       ',
                  'VirtualAddress2Realaddress  P370VirtualAddress2Realaddress ',
                  'V2R                         P370VirtualAddress2Realaddress '
  DO WHILE function_and_entry_names <> ''
    PARSE VAR function_and_entry_names function_name entry_name,
              function_and_entry_names
    CALL RxFuncDrop function_name
    CALL RxFuncAdd  function_name, 'P370REXX', entry_name
  END
  /*--------------------------------------------------------------------------*/
  /* invoke the P370REXX function                                             */
  /*--------------------------------------------------------------------------*/
  BUFFER_SIZE = 2048
  SELECT
  WHEN POS('MEMORY', function) > 0 THEN DO
    /*------------------------------------------------------------------------*/
    /* extract mode                                                           */
    /*------------------------------------------------------------------------*/
    ebcdic  = 0
    virtual = 0
    write   = 0
    IF POS('EBCDIC' , function) > 0 THEN ebcdic  = 1
    IF POS('VIRTUAL', function) > 0 THEN virtual = 1
    IF POS('WRITE'  , function) > 0 THEN write   = 1
    /*------------------------------------------------------------------------*/
    /* extract CR0, CR1 and P370CardNumber                                    */
    /*------------------------------------------------------------------------*/
    IF write
    THEN IF ebcdic
         THEN DO
                IF POS("'", parms) = 0
                THEN DO
                       SAY 'ERROR: You must imbed the ascii string into quotes'
                       EXIT 4711
                     END
                PARSE VAR parms HexAddress "'"AsciiString"'" p2 p3 P370CardNumber .
                HexAddress = STRIP(HexAddress)
                p2         = STRIP(p2)
              END
         ELSE PARSE VAR parms HexAddress HexData           p2 p3 P370CardNumber .
    ELSE      PARSE VAR parms HexAddress HexByteCount      p2 p3 P370CardNumber .
    IF p2 <> ''
    THEN IF LENGTH(p2) = 1
         THEN P370CardNumber = p2
         ELSE IF LENGTH(p3) > 1
              THEN DO
                     CR0 = p2
                     CR1 = p3
                   END
              ELSE DO
                     CR1 = p2
                     P370CardNumber = p3
                   END
    /*------------------------------------------------------------------------*/
    /* switch processor card                                                  */
    /*------------------------------------------------------------------------*/
    IF P370CardNumber <> '' THEN dy = CombufRead('50', '4', P370CardNumber)
    /*------------------------------------------------------------------------*/
    /* use CR0 and CR1 defaults if necessary                                  */
    /*------------------------------------------------------------------------*/
    IF CR0 = 'CR0' THEN CR0 = CombufRead('50', '4')
    IF CR1 = 'CR1' THEN CR1 = CombufRead('54', '4')
    /*------------------------------------------------------------------------*/
    /* do the actual read/write                                               */
    /*------------------------------------------------------------------------*/
    Address    = X2D(HexAddress)
    IF write
    THEN IF ebcdic
         THEN TotalCount = LENGTH(AsciiString)
         ELSE IF LENGTH(HexData)//2 = 0
              THEN TotalCount = LENGTH(HexData)/2
              ELSE DO
                     SAY 'ERROR: cannot write odd number of nibbles'
                     EXIT 4711
                   END
    ELSE TotalCount = X2D(HexByteCount)
    IF Address + TotalCount > X2D(1000000)
    THEN DO
           SAY 'ERROR: access must be within 16 MBytes'
           EXIT 4711
         END
    Count      = MIN(TotalCount, BUFFER_SIZE - (Address // BUFFER_SIZE))
    DO UNTIL TotalCount = 0
      IF virtual & (DATATYPE(V2R(D2X(Address),CR0,CR1), 'X') = 0)
      THEN DO
             SAY 'ERROR: Invalid virtual address' D2X(Address)
             EXIT 4711
           END
      SELECT
       WHEN ebcdic = 0 & virtual = 0 & write = 0
        THEN dy=CHAROUT(,     MemoryRead(    D2X(Address)         ,D2X(Count)))
       WHEN ebcdic = 1 & virtual = 0 & write = 0
        THEN dy=CHAROUT(,EX2A(MemoryRead(    D2X(Address)         ,D2X(Count))))
       WHEN ebcdic = 0 & virtual = 1 & write = 0
        THEN dy=CHAROUT(,     MemoryRead(V2R(D2X(Address),CR0,CR1),D2X(Count)))
       WHEN ebcdic = 1 & virtual = 1 & write = 0
        THEN dy=CHAROUT(,EX2A(MemoryRead(V2R(D2X(Address),CR0,CR1),D2X(Count))))
       WHEN ebcdic = 0 & virtual = 0 & write = 1
        THEN dy=CHAROUT(,     MemoryWrite(   D2X(Address),,
                         LEFT(Hexdata,Count*2)))
       WHEN ebcdic = 1 & virtual = 0 & write = 1
        THEN dy=CHAROUT(,EX2A(MemoryWrite(   D2X(Address),,
                         A2EX(LEFT(AsciiString,Count)))))
       WHEN ebcdic = 0 & virtual = 1 & write = 1
        THEN dy=CHAROUT(,     MemoryWrite(V2R(D2X(Address),CR0,CR1),,
                         LEFT(Hexdata, Count*2)))
       WHEN ebcdic = 1 & virtual = 1 & write = 1
        THEN dy=CHAROUT(,EX2A(MemoryWrite(V2R(D2X(Address),CR0,CR1),,
                         A2EX(LEFT(AsciiString,Count)))))
      END
      IF write THEN
        IF ebcdic THEN AsciiString = SUBSTR(AsciiString, 1 +   Count)
                  ELSE Hexdata     = SUBSTR(Hexdata    , 1 + 2*Count)
      Address    = Address   + Count
      TotalCount = TotalCount - Count
      Count      = MIN(TotalCount, BUFFER_SIZE)
    END
    dy = CHAROUT()
  END
  WHEN function = 'VIRTUALADDRESS2REALADDRESS' THEN DO
    CR0            = CombufRead('50', '4')
    CR1            = CombufRead('54', '4')
    PARSE VAR parms HexAddress p2 p3 P370CardNumber
    IF p2 <> ''
    THEN IF LENGTH(p2) = 1
         THEN P370CardNumber = p2
         ELSE IF LENGTH(p3) > 1
              THEN DO
                     CR0 = p2
                     CR1 = p3
                   END
              ELSE DO
                     CR1 = p2
                     P370CardNumber = p3
                   END
    IF P370CardNumber <> '' THEN P370CardNumber = ','P370CardNumber
    INTERPRET,
    SAY Virtualaddress2Realaddress'('HexAddress','CR0','CR1 P370CardNumber')'
  END
  OTHERWISE
           PARSE VAR parms HexAddress HexByteCount_HexData P370CardNumber
           IF P370CardNumber  <> '' THEN P370CardNumber = ','P370CardNumber
           IF HexByteCount_HexData  <> '' THEN HexByteCount_HexData = ',',
                                               HexByteCount_HexData
           INTERPRET,
           SAY function'('HexAddress HexByteCount_HexData P370CardNumber')'
  END

  RETURN 0
