/* Check IRQs */
Numeric digits 12
dev='MEMRY$'               /* Name of DD */

Parse UPPER arg p1 .

/* Be sure user has installed our companion device driver: */

p=stream(dev,'C','query exists')
If substr(p,1,5) <> '\DEV\' then Do
   Say dev 'device not installed'
   Say '(Be sure AWSPOSDD.SYS is specified in CONFIG.SYS.)'
   Exit 100
End

new='FLAT'                 /* Want flat DS value */
Call ReadMem
flatDS = c2x(substr(p,2,1)) || c2x(substr(p,1,1))

new='IDTR'                 /* Want IDT value */
Call ReadMem

Ilimit = c2x(substr(p,2,1)) || c2x(substr(p,1,1))
Ibase  =          c2x(substr(p,6,1)) || c2x(substr(p,5,1))
Ibase  = Ibase || c2x(substr(p,4,1)) || c2x(substr(p,3,1))

/* desc = 'IDT limit='Ilimit'; IDT base='Ibase  */
/* Say desc                                     */

/* IRQs 0-7 are mapped to INTs 50-57 */
/* Each interrupt vector is 8 bytes long */

IRQ0 = x2d(50) * 8         /* Offset to IRQ0 */
IRQ0 = x2d(Ibase) + IRQ0   /* Address of IRQ0 interrupt vector */
IRQ0 = d2c(IRQ0)           /* Back to hex */

new = 'LINR'               /* Linear address request */
new = new || substr(IRQ0,4,1) || substr(IRQ0,3,1)
new = new || substr(IRQ0,2,1) || substr(IRQ0,1,1)
Call ReadMem               /* Read 32-bits */
IRQ0value = p
Call ReadAgn               /* Read 32-bits */
IRQ0value = IRQ0value || p

/* Extract the IRQ0 handler address from the IRQ0 interrupt gate: */

IRQ0base = substr(IRQ0value,1,2) || substr(IRQ0value,7,2)
new = 'LINR'               /* Linear address request */
new = new || IRQ0base
Call ReadMem               /* Read 32-bits */
IRQ0IH = p
Call ReadAgn               /* Read 32-bits */
IRQ0IH = IRQ0IH || p
Call ReadAgn               /* Read 32-bits */
IRQ0IH = IRQ0IH || p
Call ReadAgn               /* Read 32-bits */
IRQ0IH = IRQ0IH || p
Call ReadAgn               /* Read 32-bits */
IRQ0IH = IRQ0IH || p
Call ReadAgn               /* Read 32-bits */
IRQ0IH = IRQ0IH || p
Call ReadAgn               /* Read 32-bits */
IRQ0IH = IRQ0IH || p
Call ReadAgn               /* Read 32-bits */
IRQ0IH = IRQ0IH || p

/* Find the first MOV immediate to EBX (opcode = x'BB'). */
/* The operand should be the address of the kernel value AIRQI. */

ix = pos('BB'x,IRQ0IH)
If ix = 0 then Do
   Say 'Cannot locate AIRQI'
   Exit 201
End

ix = ix + 1                /* Pointer is immediate data following opcode */
AIRQI = substr(IRQ0IH,ix,4)

new = 'LINR'               /* Linear address request */
new = new || AIRQI
Call SetAddr               /* Set up for sequential reads */

Do int = 0 to 31           /* For each possible interrupt level, */
   Call AIRQentry          /* Format a response */
End

Exit 0                     /* All done */

SetAddr:
/* We're probably a bit paranoid on the length stuff here. */
/* Could just use our worst case (8) and not verify return value. */

Select
When substr(new,1,4) = 'CURR' then len=8
When substr(new,1,4) = 'IDTR' then len=6
When substr(new,1,4) = 'GDTR' then len=6
When substr(new,1,4) = 'FLAT' then len=2
When substr(new,1,4) = 'PRT1' then len=1
When substr(new,1,4) = 'PRT2' then len=2
Otherwise
   len=4
End

p = charout(dev,new)       /* Output the address */
p = stream(dev,'D')        /* Did it go OK?   */

If substr(p,1,5) <> 'READY' then Do
   Say 'Memry device status:  'p
   Exit 101
End

Return

ReadMem:
Call SetAddr

ReadAgn:
p = charin(dev,,len)       /* Get memry info */

If length(p) <> len then Do
   Say 'Unexpected data length returned'
   Exit 102
End

q = stream(dev,'D')

If substr(q,1,5) <> 'READY' then Do
   Say 'Memry device status:  'q
   Exit 103
End

Return

AIRQentry:

Call ReadAgn               /* Read 32-bits */
AIRQe = p
Call ReadAgn               /* Read 32-bits */
AIRQe = AIRQe || p

If int <> c2d(substr(AIRQe,5,1)) then Do
   Say 'Invalid format for AIRQI entries'
   Exit 202
End

DIRQ = substr(AIRQe,1,4)   /* Pointer to DD IHs */

new = 'CURR'               /* Get our current state */
Call ReadMem               /* Read 32-bits */
Save1 = p                  /* Save to restore later */

msgpfx = 'IRQ' format(int,2)

Do while DIRQ <> x2c('00000000')
   new = 'LINR'            /* Linear address request */
   new = new || DIRQ
   Call ReadMem            /* Read 32-bits */
   DIRQe = p
   Call ReadAgn            /* Read 32-bits */
   DIRQe = DIRQe || p
   Call ReadAgn            /* Read 32-bits */
   DIRQe = DIRQe || p
   Call ReadAgn            /* Read 32-bits */
   DIRQe = DIRQe || p

   If int <> c2d(substr(DIRQe,11,1)) then Do
      Say 'Invalid format for DIRQ entries'
      Exit 203
   End

   ih=             c2x(substr(DIRQe,08,1)) || c2x(substr(DIRQe,07,1))
   ih=ih || ':' || c2x(substr(DIRQe,06,1)) || c2x(substr(DIRQe,05,1))
   ds=             c2x(substr(DIRQe,10,1)) || c2x(substr(DIRQe,09,1))

   If ds <> flatDS then Do /* Hack to avoid Trap E reading invalid page */
      /* DD name is at DS:000A, for 8 bytes */
      new = 'VIRT'         /* Virtual 16:16 address request */
      new = new || x2c('0A00') || substr(DIRQe,09,2)
      Call ReadMem         /* Read 32-bits */
      DDname = p
      Call ReadAgn         /* Read 32-bits */
      DDname = DDname || p
   End
   else Do                 /* Show kernel for any flat DS IRQ IHs */
      DDname = 'kernel  '
   End

   Say msgpfx DDname 'IH='ih

   DIRQ = substr(DIRQe,1,4)   /* Pointer to next DD IHs */
   msgpfx = '   ' '  '     /* Indent multiple DD entries */
End

new = Save1                /* Get our saved state */
Call SetAddr               /* Set up to resume */

Return
