/*    P/370 devmap upgrade program.                   JAH  9/1/94     */
/*    - Translate control unit names in a devmap.                     */
/*    - Globally or selectively modify disk drive letter/path         */
/*                                                                    */
/* 9/1/94  JAH First released version                                 */
/* 2/15/96 JAH Add more DASD types                                    */
/*                                                                    */

'@ECHO OFF';
trace o
dasdlist='3370 3310 0671 9332 9335 9336 FB-5 3330 3350 3375 3380 3390 9345'
                /* Only 4 chars tested  ---+          */
/*                                                                    */
/* Check the input parameters                                         */
/*                                                                    */
Parse upper arg m d n .
If m = '?' /*  Help  */
   then do;
Say 'Correct Form is:                                                       '
Say '                  RDEVMAP [c:\path\devmap.1vm]  D=d [n]                '
Say '                                                D=d:\old\ n:\new\      '
Say '                                                                       '
Say 'If the devmap location is not specified, the current devmap (as kept by AWSPROF'
Say 'in OS2.INI) is used. If a devmap is specified, then that devmap will be'
Say 'modified and made the current devmap. The old devmap file will be saved'
Say 'c:\path\devmap.2VM.                                                    '
Say '                                                                       '
Say 'D=d is used during installation to globally change the drive letter of all DASD'
Say 'devices and DMKRIO.ASM, DMKSYS.ASM, USER.DIR, and DEVMAP.1VM in devmap. '
Say '                                                                       '
Say 'D=d n  option is used to change only drive letter "d" to drive letter "n" '
Say 'every time it occurs. Use this form if you have, e.g. added a hard disk'
Say 'and need to change all the subdirectories on a given drive.            '
Say '                                                                       '
Say 'If two paths are specified, then a selective replacement occurs:       '
Say '    d:\old\    the drive and path to be searched for and changed.      '
Say '    n:\new\    the drive and path that will replace d:\old\            '
        Exit
        end

If substr(m,1,2)='D='
   then do;
        parse upper arg . 'D='d n .
        m = ''
        end
   else parse var d 'D='d .

/*                           */
/*   Process Disk parameters */
/*                           */
If d <> '' then do
  If n='' then do   /* Must only be a single letter or letter + colon */
/*
    If Length(d)>1 & (Filespec('P',d)<>'' | Filespec('N',d)<>'') Then do
*/
    If Length(d)>2 | (Length(d)=2 & Substr(d,2,1)<>':') then do
       Say 'Incorrect parameter:' d
       exit 1
       End;
    newdrive=Left(d,1)  /* Globally replace drive letter only */
    olddrive=''
    end;
  Else do;
     newdrive=''; olddrive='';
     If (length(d)=1 & length(n)=1) |,
        ((length(d)=2 & substr(d,2,1)=':') &,
         (length(n)=2 & substr(n,2,1)=':')),
     Then do;  /* Selectively replace drive letter */
        olddrive=d;
        newdrive=n;
        end;

     Else do;  /* Selectively replace full path */
     /* Make sure the parameters are exactly in the form d:\path\    */
        If (Substr(d,2,1)<>':')|(Substr(n,2,1)<>':') then do
           Say 'Incorrect parameters:' d n
           exit 1
           end
        old=Strip(d,'T','\')||'\'
        old_d=Filespec('Drive',old)
        old_p='\'||Strip(Filespec('Path',old),'L','\')
        old=old_d||old_p
        Lold=Length(old)   /* d:\oldpath\  */
        new=Strip(n,'T','\')||'\'
        new_d=Filespec('Drive',new)
        new_p='\'||Strip(Filespec('Path',new),'L','\')
        new=new_d||new_p
        Lnew=Length(new)   /* d:\newpath\  */
        end;
     end;
  End; /* Disk parameters */

/*                                         */
/*   Read DEVMAP location out of OS2.INI   */
/*                                         */
  'awsprof /q >awsdev.loc'
  ini=linein('awsdev.loc');
  call lineout 'awsdev.loc';
  'ERASE awsdev.loc'

If m='' /* User did NOT explicitly pass a devmap name on command line */
   then do;
        If ini='(Not Found)'
           then do;  /* A default DEVMAP location was never specified */

                say 'A default location for the DEVMAP.1VM configuration'
                say 'file has not been established.  Enter the location'
                say '"drive:\path\filename.ext" (e.g. C:\VM\DEVMAP.1VM )'
                say 'now, or enter a null line to exit'.
                pull m;
                if m=''
                   then do; /* no file, just exit */
                   Say 'A DEVMAP file was not specified. Nothing done.'
                        exit 10;
                        end;
                call setfile m;
                if result <>0
                   then do;
                   Say 'Error accessing OS2.INI. Nothing done.'
                        exit result;
                        end;
                end;
           Else m=ini;  /* Use the value read from OS2.INI */
        end;

/* A DEVMAP filename was explicitly specified on this command */
  else do;   /* so set the default location accordingly */
        call setfile m;
        if result<>0 then return result;
        If (ini<>'(Not Found)')&(m<>ini)
           then Say 'Default DEVMAP changed from' ini 'to' m'.'
        end;

/*                                                                 */
/*  Save a copy of the current DEVMAP                              */
/*                                                                 */
idev=m                  /* devmap location     */
z=linein(idev);       /* see if it exists   */
call lineout idev;    /* ...close it        */
If z = '' then Do
   Say 'DEVMAP file' idev 'not found. Nothing done.'
   Exit 20
   End;
Parse var idev name '.' ext
sdev=name'.2VM'         /* Saved copy of DEVMAP */
"COPY" idev sdev
Say 'The current DEVMAP file 'idev' has been saved as' sdev'.'


total=0
odev=name'.TMP'         /* temporary work file */
z=linein(odev);       /* see if it exists   */
call lineout odev;    /* ...close it        */
If z <> '' then "ERASE" odev

/* old manager names */   oldname='A743880 A743274 A742821 TFAMGR PCSERVER A742703 OS2ASYNC';
/* new manager names */   newname='AWS3880 AWS3274 AWS2821 AWSTFA AWSPCSRV AWS2703 AWS2703';

lc='abcdefghijlkmnopqrstuvwxyz'   /* upper/lower xlate tables */
uc='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
oldname=translate(oldname);       /* just make sure these are upper case */
newname=translate(newname);

/*                                   */
/*  Read DEVMAP one record at a time */
/*                                   */
do i=0 to 400;
   z=charin(idev,1+i*64,64);            /* read a line from devmap */
   if length(z)=0 then leave;             /* ..exit if we are done   */

/*                                       */
/* Process file names on password screen */
/*                                       */
   If ((i=1)|(i=2)|(i=3)|(i=4)) & (substr(z,2,1)=':') then do;
      If newdrive<>''
      Then do
         If (olddrive<>'') & (substr(z,1,Length(olddrive))<>olddrive) then nop;
         Else Do
            z=overlay(newdrive,z,1,1); /* Change drive letter only */
            total=total+1
            end
         End;

      If d<>'' & n<>'' then do /* Selectively change path */
         Lrec=Length(Filespec('D',z)||Filespec('P',z))
         If Substr(z,1,Lrec) = old then do     /* match */
            If Lold=Lnew
            Then do
               z=overlay(new,z,1,Lnew) /* same length */
               total=total+1
               end;
            Else do
               /* Find the end of the name (excluding blanks & nulls) */
               eblank=Pos(' ',z)
               enull=Pos('00'x,z)
               ename=Min(enull,eblank)
               If ename=0 then ename=Max(enull,eblank)
               old_name=Filespec('N',Substr(z,1,ename-1))||'00'x
               Loldline=Lold + Length(old_name) /* Total length of existing line     */
               Lnewline=Lnew + Length(old_name) /* Total length of proposed new line */
               If Lnewline <= 33 then do
                  If Lnew < Lold then Lnewline=Loldline
                  z=overlay(new||old_name,z,1,Lnewline)
                  total=total+1
                  end
               Else do  /* TOO long to fit */
                  Say ''
                  Say 'A filename would be longer than the allowed maximum of 33 characters:'
                  Say new||old_name 'is' Lnewline 'characters long.'
                  Signal Error
                  end;
               end; /* Diff length */
            end; /* Match */
         end;
      End;  /* password screen */

/*                               */
/*  Process Manager Names        */
/*                               */
   k=wordpos(substr(z,2,8),oldname)       /* look for a match */
   if k>0 then z=overlay(word(newname,k),z,2,8,' ');  /* substitute if we have one */
          else do;
               /* check for hidden or excluded manager names */
               k=wordpos(translate(substr(z,2,8)),oldname)
               if k>0
                  then z=overlay(translate(word(newname,k),lc,uc),z,2,8,' ');
               end;
/*                               */
/*  Process DASD records         */
/*                               */
  type=wordpos(substr(z,3,4),dasdlist)  /* non-zero is it is DASD */
   If (type > 0)&(newdrive<>'')     /* Global Drive letter update */
      then do;
      If substr(z,19,1)='*'              /* if it's commented out    */
         then nstart=20                  /* the drive letter is here */
         else nstart=19                  /* otherwise, it's here     */
      If (olddrive<>'') & (substr(z,nstart,Length(olddrive))<>olddrive) then nop;
      else do
         z=overlay(newdrive,z,nstart,1); /* Replace the drive letter */
         total=total+1
         end;
      End;

   If (type > 0)&(n<>'')            /*   Selective path update    */
      then do;
      If substr(z,19,1)='*'              /* if it's commented out    */
         then nstart=20                  /* the drive letter is here */
         Else nstart=19                  /* otherwise, it's here     */
      zz=Substr(z,nstart)
      Lrec=Length(Filespec('D',zz)||Filespec('P',zz))
      If Substr(zz,1,Lrec) = old then do /* match */
         If Lold=Lnew
         Then do  /* Same length */
            z=overlay(new,z,nstart,Lnew)
            total=total+1
            end;
         Else do /* Different length */
            /* Find the end of the name (excluding blanks & nulls) */
            eblank=Pos(' ',zz)
            enull=Pos('00'x,zz)
            ename=Min(enull,eblank)
            If ename=0 then ename=Max(enull,eblank)
            old_name=Filespec('N',Substr(zz,1,ename-1))||'00'x
            Loldline=Lold + Length(old_name) /* Total length of existing line     */
            Lnewline=Lnew + Length(old_name) /* Total length of proposed new line */
            If Lnewline <= 33 then do
               If Lnew < Lold then Lnewline=Loldline
               z=overlay(new||old_name,z,nstart,Lnewline)
               total=total+1
               end
            Else do  /* TOO long to fit */
               Say ''
               Say 'A filename would be longer than the allowed maximum of 33 characters:'
               Say new||old_name 'is' Lnewline 'characters long.'
               Signal Error
               end;
            end; /* Diff length */
         end; /* Match */

      End;

/*                                    */
/*  Write out the modified record     */
/*                                    */
   x=charout(odev,z);


End; /* Do i=0 to 400 */

/*                          */
/* If update was successful */
/*                          */
call lineout odev  /* Close file */
call lineout idev  /* Close file */
"COPY" odev idev  /* Copy new DEVMAP over the old DEVMAP */
"ERASE" odev
Say ''
Say idev 'has been updated.' total 'DASD records modified.'
Exit;

/*                              */
/* If update was NOT successful */
/*                              */
Error:
Say 'Update aborted. 'idev' not changed.'
Call lineout odev  /* Close file */
Call lineout idev  /* Close file */
"ERASE" odev
Exit 2

/*--------------------------------------------------------------------*/
Setfile:
/*--------------------------------------------------------------------*/
/* user wants to set a new devmap file.  Make sure its OK first. */
 z=charin(m,9,12);     /* read a line from devmap */
 call lineout m;       /* ...close it        */
 If z=''
    then do;
         say 'File' m 'not found. Nothing done.';
         return 20;
         end;
 If z<>'CONFIGURATOR'
    then do;
         say 'File' m 'is not a DEVMAP file. Nothing done.'
         return 30;
         end;
 'AWSPROF' m; /* set the devmap location in the OS2.INI file. */
Return rc;
