/*
TRCC370 <CCW|DEBUG>

TRCC370 takes a low level trace of S/370 channel emulator/A activity and
records it in the file C370.TRC.  The program runs continuously in an OS/2
window.  Press "ENTER" when you want to write a trace from its buffer into
the file.  Press ctl-break to end the program.

NOTE: The tbuf parameter on CHAN370.SYS in your CONFIG.SYS file should be
set to 2040 before using TRCC370.  That specifies the size of the trace buffer.
Do not set it to more less than 2040.

CCW is a higher level trace, but is often insufficient for problem
determination.  Skilled users may be able to examine the output and learn
something about the CCW's being sent and status received on the interface,
as well as some timing details.

DEBUG is a lower level trace, and generally can only be understood by the S/370
Channel Emulator/A developers.  This level is often needed for debugging
specific problems.  It contains more detail than the CCW trace, and therefore
wraps the buffer more quickly.  If lots of things are happening on the channel,
then you have to hit enter very quickly after the problem happens to preserve
a record of the it.
*/
arg lvl
if  \(lvl='CCW' | lvl='DEBUG')
   then do;
             do i=2 while(sourceline(i)<>'*/');
                say sourceline(i);
             end;
             exit 100;
        end;

'cd\p390'
if rc\=0 then 'cd\p370'
if rc\=0
   then do;
             say 'TRCC370 must be run from the P/370 or P/390 directory'
             exit 101;
        end;
'c370trc lvl='lvl 'mode=wrap file=c370.trc'
