/* Check for ISA WACs */
Numeric digits 12
dev='MEMRY$'               /* Name of DD */

wac.0 = 14                 /* Number of WAC instances to check */
/*   Port base ; Instance number                               */
wac.1  = '0680'; inst.1  = '0'
wac.2  = '0640'; inst.2  = '2'
wac.3  = '0620'; inst.3  = '3'
wac.4  = '05A0'; inst.4  = '4'
wac.5  = '0580'; inst.5  = '5'
wac.6  = '0540'; inst.6  = '6'
wac.7  = '0520'; inst.7  = '7'
wac.8  = '0280'; inst.8  = '8'
wac.9  = '0240'; inst.9  = '10'
wac.10 = '0220'; inst.10 = '11'
wac.11 = '01A0'; inst.11 = '12'
wac.12 = '0180'; inst.12 = '13'
wac.13 = '0140'; inst.13 = '14'
wac.14 = '0120'; inst.14 = '15'

irq.E0 = 'IRQ9'
irq.E1 = 'IRQ5'
irq.E2 = 'IRQ4'
irq.E3 = 'IRQ3'
irq.E4 = 'IRQ15'
irq.E5 = 'IRQ14'
irq.E6 = 'IRQ11'
irq.E7 = 'IRQ10'

eib.   = 'Not present'
eib.10 = 'RS-232'
eib.20 = 'V.35'
eib.40 = 'X.21'
eib.50 = 'RS-422'

Parse UPPER arg p1 .

/* Be sure user has installed our companion device driver: */

p=stream(dev,'C','query exists')
If substr(p,1,5) <> '\DEV\' then Do
   Say dev 'device not installed'
   Say '(Be sure AWSPOSDD.SYS is specified in CONFIG.SYS.)'
   Exit 100
End

fndcnt = 0                    /* Number of WACs found */

Do i = 1 to wac.0             /* For each possible instance, */
   new='PRT4'                 /* Want 32-bit port value */
   ISAid = d2x((x2d(wac.i) + x2d('18')),4)  /* Card ID port */
   new = new || x2c(substr(ISAid,3,2)) || x2c(substr(ISAid,1,2))
   Call ReadMem
   If p='SCA0' then Do        /* Is an ISA WAC here? */
      fndcnt = fndcnt + 1     /* Count the instances */

      new='PRT1'              /* Want 08-bit port value */
      IRQid = d2x((x2d(wac.i) + x2d('1D')),4)  /* IRQ port */
      new = new || x2c(substr(IRQid,3,2)) || x2c(substr(IRQid,1,2))
      Call ReadMem

      idx = c2x(substr(p,1,1))

      new='PRT2'              /* Want 16-bit port value */
      MEMid = d2x((x2d(wac.i) + x2d('1E')),4)  /* Memory port */
      new = new || x2c(substr(MEMid,3,2)) || x2c(substr(MEMid,1,2))
      Call ReadMem

      enbl = c2x(bitand(substr(p,1,1),'11'x))
      If enbl = '11' then Do  /* Memory window enabled? */
         meml = c2x(bitand(substr(p,1,1),'E0'x))
         memh = c2x(substr(p,2,1))
         mem = '00'||memh||meml||'00'
      End
      else Do
         mem = 'Disabled'
      End

      new='PRT1'              /* Want 08-bit port value */
      LSRid = d2x((x2d(wac.i) + x2d('14')),4)  /* Port A LSR */
      new = new || x2c(substr(LSRid,3,2)) || x2c(substr(LSRid,1,2))
      Call ReadMem

      EIBa = c2x(bitand(substr(p,1,1),'F0'x))

      new='PRT1'              /* Want 08-bit port value */
      LSRid = d2x((x2d(wac.i) + x2d('16')),4)  /* Port B LSR */
      new = new || x2c(substr(LSRid,3,2)) || x2c(substr(LSRid,1,2))
      Call ReadMem

      EIBb = c2x(bitand(substr(p,1,1),'F0'x))

      Say 'ISA WAC instance ' || inst.i || ' found:'
      Say ' I/O='wac.i', Mem='mem', 'irq.idx', A-EIB='eib.EIBa', B-EIB='eib.EIBb

      /* Read Zilog Z16C32 revision level for port A: */
      CCARid = d2x((x2d(wac.i) + x2d('04')),4)  /* Port A CCAR */
      Call WACRvsn
      AZ16 = revision

      /* Read Zilog Z16C32 revision level for port B: */
      CCARid = d2x((x2d(wac.i) + x2d('0C')),4)  /* Port B CCAR */
      Call WACRvsn
      BZ16 = revision

      Say ' A-Z16C32 revision='AZ16', B-Z16C32 revision='BZ16

      If AZ16 <> '4453' & ,
         AZ16 <> '4D40' & ,
         AZ16 <> '4D44' then Do
         Say ' Port A Zilog revision level has an unexpected value.'
      End

      If BZ16 <> '4453' & ,
         BZ16 <> '4D40' & ,
         BZ16 <> '4D44' then Do
         Say ' Port B Zilog revision level has an unexpected value.'
      End
   End
End

If fndcnt = 0 then Do
   Say 'No ISA WACs found'
End

Exit 0                     /* All done */

WACRvsn:
new='PRT2'                    /* Want 16-bit port value */
new = new || x2c(substr(CCARid,3,2)) || x2c(substr(CCARid,1,2))
new = new || x2c('0000')      /* Pad to next 32-bit boundary */
new = new || x2c('4E00')      /* TMCR address */
Call SetAddr

new='PRT2'                    /* Want 16-bit port value */
new = new || x2c(substr(CCARid,3,2)) || x2c(substr(CCARid,1,2))
new = new || x2c('0000')      /* Pad to next 32-bit boundary */
new = new || x2c('1F00')      /* IUSC level address */
Call SetAddr

new='PRT2'                    /* Want 16-bit port value */
new = new || x2c(substr(CCARid,3,2)) || x2c(substr(CCARid,1,2))
new = new || x2c('0000')      /* Pad to next 32-bit boundary */
new = new || x2c('0C00')      /* TMDR address */
Call SetAddr

new='PRT2'                    /* Want 16-bit port value */
new = new || x2c(substr(CCARid,3,2)) || x2c(substr(CCARid,1,2))
Call ReadMem

revision = c2x(substr(p,2,1)) || c2x(substr(p,1,1))

Return

SetAddr:
/* We're probably a bit paranoid on the length stuff here. */
/* Could just use our worst case (8) and not verify return value. */

Select
When substr(new,1,4) = 'CURR' then len=8
When substr(new,1,4) = 'IDTR' then len=6
When substr(new,1,4) = 'GDTR' then len=6
When substr(new,1,4) = 'PRT1' then len=1
When substr(new,1,4) = 'PRT2' then len=2
Otherwise
   len=4
End

p = charout(dev,new)       /* Output the address */
p = stream(dev,'D')        /* Did it go OK?   */

If substr(p,1,5) <> 'READY' then Do
   Say 'Memry device status:  'p
   Exit 101
End

Return

ReadMem:
Call SetAddr

ReadAgn:
p = charin(dev,,len)       /* Get memry info */

If length(p) <> len then Do
   Say 'Unexpected data length returned'
   Exit 102
End

q = stream(dev,'D')

If substr(q,1,5) <> 'READY' then Do
   Say 'Memry device status:  'q
   Exit 103
End

Return
