/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure;

import com.ibm.appsure.AppSureException;
import com.ibm.appsure.common.Application;
import com.ibm.appsure.common.Util;
import com.ibm.appsure.db.AppSureSQL;
import java.sql.Connection;

public class AppSure {
    private Connection dbConn = null;
    private Application application = null;
    private int processIndex = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startApp(Connection connection, String string) throws AppSureException {
        boolean bl = false;
        this.dbConn = connection;
        if (this.dbConn == null) throw new AppSureException("Could not connect to NULL database connection");
        this.application = new Application(string);
        if (!this.application.readFromDatabase(connection)) throw new AppSureException("Could not read application (" + string + ") from AppSure Database");
        if (!this.application.getMultipleInst()) {
            if (this.isAppRunning(string)) {
                return false;
            }
            boolean bl2 = true;
            bl = bl2;
        } else {
            bl = true;
        }
        if (!bl) return bl;
        this.processIndex = AppSureSQL.logApplicationRunning(this.dbConn, this.application.getAppCode());
        if (this.processIndex != -1) return bl;
        throw new AppSureException("Cannot create application process");
    }

    public boolean isAppRunning(String string) throws AppSureException {
        return AppSureSQL.isAppRunning(this.dbConn, string);
    }

    public boolean didAppRun(String string) throws AppSureException {
        return AppSureSQL.getLastFailure(this.dbConn, string).isSevZero();
    }

    public boolean shutDown(String string, String string2) throws AppSureException {
        boolean bl = false;
        int n = -1;
        AppSureSQL.logApplicationStopped(this.dbConn, this.processIndex, this.application.getAppCode());
        bl = this.logFailure(0, string, string2);
        return bl;
    }

    public boolean logFailure(int n, String string, String string2) throws AppSureException {
        int n2 = -1;
        boolean bl = false;
        string2 = this.obtainLogContents(string, string2);
        n2 = AppSureSQL.createLog(this.dbConn, this.application.getAppCode(), string2);
        if (n2 > 0) {
            bl = AppSureSQL.createFailure(this.dbConn, this.application.getAppCode(), n, n2);
        }
        return bl;
    }

    private String obtainLogContents(String string, String string2) throws AppSureException {
        if (string != null) {
            try {
                string2 = Util.readFile(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new AppSureException("Log File Contents could not be read from file " + string);
            }
        }
        if (string2 == null) {
            throw new AppSureException("Log File Contents could not be read from file " + string);
        }
        return string2;
    }
}

