/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.app;

import com.ibm.appsure.app.gui.InitWindow;
import com.ibm.appsure.app.gui.LogonDlg;
import com.ibm.appsure.app.gui.MainWindow;
import com.ibm.appsure.app.system.GUISystem;
import com.ibm.appsure.common.Log;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class AppSureTool {
    private static Connection dbConn = null;
    private Hashtable properties = null;

    public static void main(String[] stringArray) {
        new AppSureTool(stringArray);
    }

    private final boolean logonUser() {
        InitWindow initWindow = null;
        LogonDlg logonDlg = new LogonDlg();
        logonDlg.getResponse();
        initWindow = new InitWindow();
        initWindow.setText("Logging into AppSure Database");
        if (this.connectToDatabase(logonDlg.getUserId(), logonDlg.getPassword())) {
            new MainWindow();
            initWindow.dispose();
            return true;
        }
        return false;
    }

    private final void initializeProperties(String[] stringArray) {
        this.properties = new Hashtable();
        this.readProperties();
        this.processCommandLineArgs(stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readProperties() {
        Properties properties = new Properties();
        try {
            Enumeration<?> enumeration = null;
            properties.load(new FileInputStream(new File("AppSureTool.properties")));
            enumeration = properties.propertyNames();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                Object obj = enumeration.nextElement();
                this.properties.put(obj, ((Hashtable)properties).get(obj));
            }
        }
        catch (Exception exception) {
            System.err.println("Cannot find AppSureTool.properties file. Please make sure this file exists in the directory in which you executed the AppSure Monitor.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processCommandLineArgs(String[] stringArray) {
        try {
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return;
                }
                int n2 = stringArray[n].indexOf("=");
                if (n2 >= 0) {
                    String string = stringArray[n].substring(0, n2);
                    String string2 = stringArray[n].substring(n2 + 1);
                    this.properties.remove(string);
                    this.properties.put(string, string2);
                }
                ++n;
            }
        }
        catch (Exception exception) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean connectToDatabase(String string, String string2) {
        boolean bl = false;
        String string3 = (String)this.properties.get("Database");
        String string4 = (String)this.properties.get("DatabaseServer");
        String string5 = (String)this.properties.get("JDBCPortNumber");
        Log.log("Connecting to Database " + string3 + " on server " + string4 + " with port number " + string5);
        try {
            String string6 = "COM.ibm.db2.jdbc.net.DB2Driver";
            Class.forName(string6).newInstance();
            dbConn = DriverManager.getConnection("jdbc:db2://" + string4 + ":" + string5 + "/" + string3, string, string2);
            if (dbConn != null) return true;
            return false;
        }
        catch (Exception exception) {
            if (exception.toString().indexOf("username and/or") != -1) {
                GUISystem.printBox("Info", "The User Id or Password supplied is not correct");
                this.logonUser();
                return bl;
            }
            GUISystem.printBox("Error", "Cannot connect to the AppSure Database. Please check the log file for more information");
            Log.log("Cannot connect to database " + string3 + " on server " + string4 + " with port number " + string5);
            Log.log(exception);
            System.exit(-1);
        }
        return bl;
    }

    public static Connection getConnection() {
        return dbConn;
    }

    public AppSureTool(String[] stringArray) {
        this.initializeProperties(stringArray);
        new GUISystem();
        Log log = new Log(this.properties.get("LogFileHome") + "appsuremonitor.log");
        log.setLogFileMaxSize(Integer.parseInt("" + this.properties.get("MaxLogFileSize")));
        this.logonUser();
    }
}

