/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.app.gui;

import com.ibm.appsure.AppSureException;
import com.ibm.appsure.app.AppSureTool;
import com.ibm.appsure.app.shared.gui.ButtonPanel;
import com.ibm.appsure.app.shared.gui.DButton;
import com.ibm.appsure.app.shared.gui.MultiList;
import com.ibm.appsure.app.shared.util.WinUtil;
import com.ibm.appsure.app.system.GUISystem;
import com.ibm.appsure.common.Application;
import com.ibm.appsure.common.Failure;
import com.ibm.appsure.common.Log;
import com.ibm.appsure.common.LogFile;
import com.ibm.appsure.db.AppSureSQL;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AppSureCheckDlg
extends JFrame
implements ListSelectionListener,
Runnable,
ActionListener {
    private Vector failures = null;
    private Vector logs = null;
    private String[] logTitles = new String[]{"Log Index", "Time", "Keep"};
    private String[] failureTitles = new String[]{"Failure", "Notified", "Closed", "Working"};
    private Application application = null;
    private DButton pb_OK = new DButton("Ok");
    private MultiList cnr_LOGS = new MultiList(GUISystem.getFontUtil());
    private MultiList cnr_FAILURES = new MultiList(GUISystem.getFontUtil());
    private JTextArea mle_MAINLOG = new JTextArea();
    private JTextArea mle_FAILURE_LOG = new JTextArea();
    private DButton pb_WORK_ON = new DButton("Work On");
    private JCheckBox ck_KEEP = new JCheckBox("Keep");
    private JTextArea mle_RESOLUTION = new JTextArea();
    private JTabbedPane mainNotebook = new JTabbedPane();
    private JTabbedPane resolutionNotebook = new JTabbedPane();
    private DButton pb_CLOSE = new DButton("Close");
    private DButton pb_DELETE = new DButton("Delete");
    private ButtonPanel mainButtonBar = new ButtonPanel();
    private JScrollPane scr_LOGS = new JScrollPane(this.mle_MAINLOG);
    private ButtonPanel logButtonPanel = new ButtonPanel();

    private final void initialize() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.cnr_LOGS.setColumnHeadings(this.logTitles);
        this.cnr_FAILURES.setColumnHeadings(this.failureTitles);
        this.cnr_LOGS.setColumnWidth(0, 75);
        this.cnr_LOGS.setColumnWidth(1, 200);
        this.cnr_FAILURES.setColumnWidth(0, 350);
        this.cnr_FAILURES.setColumnWidth(1, 200);
        this.cnr_FAILURES.setColumnWidth(2, 200);
        this.cnr_FAILURES.setColumnWidth(3, 200);
        this.mle_RESOLUTION.setFont(this.pb_OK.getFont());
        this.pb_CLOSE.addActionListener(this);
        this.pb_WORK_ON.addActionListener(this);
        this.ck_KEEP.addActionListener(this);
        this.pb_DELETE.addActionListener(this);
        this.cnr_LOGS.addListSelectionListener(this);
        this.cnr_FAILURES.addListSelectionListener(this);
        this.pb_OK.addActionListener(this);
        jPanel2.setLayout(null);
        jPanel.setLayout(null);
        this.getContentPane().setLayout(null);
        jPanel.add(this.cnr_FAILURES);
        jPanel.add(this.pb_WORK_ON);
        jPanel.add(this.resolutionNotebook);
        jPanel.add(this.pb_CLOSE);
        jPanel2.add(this.cnr_LOGS);
        jPanel2.add(this.ck_KEEP);
        jPanel2.add(this.scr_LOGS);
        this.logButtonPanel.add(this.pb_DELETE);
        jPanel2.add(this.logButtonPanel);
        this.mainNotebook.addTab("Failures", jPanel);
        this.mainNotebook.addTab("Logs", jPanel2);
        this.resolutionNotebook.addTab("Log", new JScrollPane(this.mle_FAILURE_LOG));
        this.resolutionNotebook.addTab("Resolution", new JScrollPane(this.mle_RESOLUTION));
        this.mainButtonBar.add(this.pb_OK);
        this.getContentPane().add((Component)this.mainNotebook, "Center");
        this.getContentPane().add((Component)this.mainButtonBar, "South");
        GUISystem.setPropertiesOnPanel(this.getContentPane());
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 18;
        int n2 = 5;
        int n3 = 5;
        super.doLayout();
        dimension = this.getSize();
        this.mainNotebook.setBounds(5, 5, dimension.width - 10, dimension.height - 70);
        this.mainButtonBar.setBounds(5, dimension.height - 60, dimension.width - 10, 25);
        n3 = 5;
        dimension = new Dimension(dimension.width - 10, dimension.height - 100);
        this.cnr_LOGS.setBounds(n2, n3, dimension.width - n2 * 3, dimension.height / 2 - 50);
        this.ck_KEEP.setBounds(n2, n3 += dimension.height / 2 - 50 + 3, dimension.width - n2 * 3, n);
        this.scr_LOGS.setBounds(n2, n3 += n + 3, dimension.width - n2 * 3, dimension.height - n3 - 30);
        n3 += dimension.height - n3 - 30 + 5;
        this.logButtonPanel.setBounds(n2, n3, dimension.width - n2 * 2, 25);
        n3 = 5;
        this.cnr_FAILURES.setBounds(n2, n3, dimension.width - n2 * 3, dimension.height / 2 - 50);
        this.resolutionNotebook.setBounds(n2, n3 += dimension.height / 2 - 50 + 3, dimension.width - n2 * 3, dimension.height - n3 - 30);
        n3 += dimension.height - n3 - 30 + 5;
        this.pb_CLOSE.setBounds(n2, n3, 80, 25);
        this.pb_WORK_ON.setBounds(n2 + 85, n3, 85, 25);
        n3 += n + 3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_OK) {
            this.dispose();
            return;
        }
        if (actionEvent.getSource() == this.pb_WORK_ON) {
            return;
        }
        if (actionEvent.getSource() == this.ck_KEEP) {
            LogFile logFile = (LogFile)this.cnr_LOGS.getSelectedItem();
            if (logFile == null) return;
            logFile.setKeep(this.ck_KEEP.isSelected());
            try {
                logFile.writeToDatabase(AppSureTool.getConnection());
                return;
            }
            catch (AppSureException appSureException) {
                Log.log(appSureException);
                GUISystem.printBox("Error", "There was an error in the last action you took, please check the logs");
                return;
            }
        }
        if (actionEvent.getSource() != this.pb_DELETE) return;
        LogFile logFile = (LogFile)this.cnr_LOGS.getSelectedItem();
        if (logFile == null) return;
        logFile.setKeep(this.ck_KEEP.isSelected());
        try {
            logFile.updateRecStatus(3);
            logFile.writeToDatabase(AppSureTool.getConnection());
            this.cnr_LOGS.remove(logFile);
            return;
        }
        catch (AppSureException appSureException) {
            Log.log(appSureException);
            GUISystem.printBox("Error", "There was an error in the last action you took, please check the logs");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Connection connection = AppSureTool.getConnection();
        try {
            LogFile logFile;
            Failure failure = null;
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.LOGINDEX, B.DESCRIPTION, A.NOTIFIED, A.CLOSED, " + "       A.WORKING,  A.RESOLUTION " + "FROM APPSURE.FAILURE A, " + "     APPSURE.FAILURETYPE B " + "WHERE A.LOGINDEX IN (SELECT LOGINDEX FROM APPSURE.LOGS WHERE APPCODE = '" + this.application.getAppCode() + "') AND " + "      A.FAILURETYPE = B.FAILURETYPE " + "FOR FETCH ONLY");
            this.failures = new Vector(1);
            this.cnr_FAILURES.setData(this.failures);
            while (resultSet.next()) {
                logFile = new LogFile(resultSet.getInt(1));
                failure = new Failure();
                failure.setLogFile(logFile);
                failure.setFailureDescription(resultSet.getString(2).trim());
                failure.setNotified(resultSet.getString(3));
                failure.setClosed(resultSet.getString(4));
                failure.setWorking(resultSet.getString(5));
                failure.setResolution(resultSet.getString(6));
                this.failures.addElement(failure);
            }
            this.cnr_FAILURES.setData(this.failures);
            resultSet.close();
            resultSet = statement.executeQuery("SELECT LOGINDEX, LOGTIMESTAMP, KEEP " + "FROM APPSURE.LOGS " + "WHERE APPCODE = '" + this.application.getAppCode() + "' FOR FETCH ONLY");
            this.logs = new Vector(1);
            this.cnr_LOGS.setData(this.logs);
            while (resultSet.next()) {
                logFile = new LogFile(resultSet.getInt(1));
                logFile.setLogTimestamp(resultSet.getString(2));
                logFile.setKeep(resultSet.getString(3).equals("Y"));
                this.logs.addElement(logFile);
            }
            this.cnr_LOGS.setData(this.logs);
            return;
        }
        catch (Exception exception) {
            Log.log(exception);
            GUISystem.printBox("Info", "Cannot read Failures/Logs, Please check the log file for the application");
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.cnr_LOGS) {
            this.refreshLog();
        } else if (listSelectionEvent.getSource() == this.cnr_FAILURES) {
            this.refreshFailure();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void refreshLog() {
        LogFile logFile = (LogFile)this.cnr_LOGS.getSelectedItem();
        try {
            if (logFile == null) {
                this.mle_MAINLOG.setText("");
                this.ck_KEEP.setSelected(false);
                return;
            }
            if (logFile.getLogContents() == null) {
                AppSureSQL.readLogContents(AppSureTool.getConnection(), logFile);
            }
            if (logFile.getLogContents() == null) {
                this.mle_MAINLOG.setText("NO LOG FILE AVAILABLE");
            } else {
                this.mle_MAINLOG.setText(logFile.getLogContents());
            }
            this.ck_KEEP.setSelected(logFile.getKeep());
            return;
        }
        catch (AppSureException appSureException) {
            Log.log(appSureException);
            GUISystem.printBox("Error", "There was an error written to the log in the last action you took");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void refreshFailure() {
        Failure failure = (Failure)this.cnr_FAILURES.getSelectedItem();
        try {
            if (failure == null) {
                this.mle_FAILURE_LOG.setText("");
                this.mle_RESOLUTION.setText("");
                return;
            }
            String string = failure.getResolution();
            LogFile logFile = failure.getLogFile();
            if (logFile.getLogContents() == null) {
                AppSureSQL.readLogContents(AppSureTool.getConnection(), logFile);
            }
            if (string == null || string.length() == 0) {
                string = "Please enter the resolution here and press 'Save'";
            }
            this.mle_RESOLUTION.setText(string);
            if (logFile.getLogContents() == null) {
                this.mle_FAILURE_LOG.setText("NO LOG FILE AVAILABLE");
                return;
            }
            this.mle_FAILURE_LOG.setText(logFile.getLogContents());
            return;
        }
        catch (AppSureException appSureException) {
            Log.log(appSureException);
            GUISystem.printBox("Error", "There was an error written to the log in the last action you took");
        }
    }

    private final void saveFailure() {
        Failure failure = (Failure)this.cnr_FAILURES.getSelectedItem();
    }

    public AppSureCheckDlg(Frame frame, Application application) {
        super("AppSure - " + application.getName());
        this.application = application;
        this.initialize();
        ((Component)this).setSize(640, 480);
        WinUtil.centerWindow(this);
        ((Component)this).setVisible(true);
        new Thread(this).start();
    }
}

