/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.app.shared.gui;

import com.ibm.appsure.app.shared.gui.DPanel;
import com.ibm.appsure.app.shared.gui.PopButton;
import com.ibm.appsure.app.shared.gui.StraightLayoutMgr;
import com.ibm.appsure.app.shared.util.WinUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ButtonPanel
extends DPanel
implements Runnable,
MouseListener {
    private static final int BUTTONWIDTH = 15;
    private JPanel buttonPanel = null;
    private PopButton pb_LEFT = null;
    private PopButton pb_RIGHT = null;
    private boolean initialized = false;
    private int panelX = 0;
    private StraightLayoutMgr buttonPanelLayout = null;
    private int buttonPanelWidth = 0;
    private boolean scroll = false;
    private boolean scrollRight = true;
    private boolean continueThread = true;
    private boolean scrolling = false;
    private Component leftComponent = null;
    private int leftComponentIndex = 0;
    private Thread scrollThread = null;
    private Dimension preferredSize = new Dimension(100, 25);
    private Image backgroundImage = null;

    private final void init() {
        this.setLayout(null);
        this.buttonPanel = new JPanel();
        super.add(this.buttonPanel);
        this.pb_LEFT = new PopButton("<");
        super.add(this.pb_LEFT);
        this.pb_RIGHT = new PopButton(">");
        super.add(this.pb_RIGHT);
        this.pb_LEFT.addMouseListener(this);
        this.pb_RIGHT.addMouseListener(this);
        this.pb_LEFT.setBorderPainted(false);
        this.pb_RIGHT.setBorderPainted(false);
        this.pb_LEFT.setFocusPainted(false);
        this.pb_RIGHT.setFocusPainted(false);
        this.pb_LEFT.setOpaque(false);
        this.pb_RIGHT.setOpaque(false);
        this.buttonPanel.setOpaque(false);
        this.buttonPanelLayout = new StraightLayoutMgr();
        this.buttonPanel.setLayout(this.buttonPanelLayout);
        this.scrollThread = new Thread(this);
        this.scrollThread.start();
        this.initialized = true;
    }

    public void doLayout() {
        super.doLayout();
        if (this.initialized) {
            this.pb_LEFT.setBounds(this.width - 15 + 3, 0, 12, this.height / 2);
            this.pb_RIGHT.setBounds(this.width - 15 + 3, this.height / 2, 12, this.height / 2);
            this.buttonPanelWidth = this.buttonPanelLayout.minimumLayoutSize((Container)this.buttonPanel).width;
            if (this.width - 15 > this.buttonPanelWidth) {
                this.panelX = 0;
            }
            this.buttonPanel.setBounds(0 - this.panelX, 0, this.panelX + (this.width - 15), this.height);
            this.pb_LEFT.setVisible(this.buttonPanelWidth > this.width);
            this.pb_RIGHT.setVisible(this.buttonPanelWidth > this.width);
        }
    }

    public void remove(Component component) {
        this.buttonPanel.remove(component);
        this.buttonPanelLayout.removeLayoutComponent(component);
        this.buttonPanelWidth = this.buttonPanelLayout.minimumLayoutSize((Container)this.buttonPanel).width;
        this.buttonPanelLayout.layoutContainer(this);
        if (this.width - 15 > this.buttonPanelWidth) {
            this.panelX = 0;
        }
        this.buttonPanel.setBounds(0 - this.panelX, 0, this.panelX + (this.width - 15), this.height);
        this.repaint();
    }

    public void removeAll() {
        this.buttonPanel.removeAll();
        this.buttonPanelWidth = this.buttonPanelLayout.minimumLayoutSize((Container)this.buttonPanel).width;
    }

    public Component add(Component component) {
        int n = component.getPreferredSize().height;
        this.buttonPanel.add("", component);
        this.buttonPanelWidth = this.buttonPanelLayout.minimumLayoutSize((Container)this.buttonPanel).width;
        this.buttonPanelLayout.layoutContainer(this);
        component.invalidate();
        component.validate();
        if (n > this.preferredSize.height) {
            this.preferredSize.height = n;
        }
        return component;
    }

    public Component add(String string, Component component) {
        return this.add(component);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.scrolling) {
            this.scrollRight = mouseEvent.getSource() == this.pb_RIGHT;
            this.scroll = true;
            this.scrollThread.interrupt();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.scroll = false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.scrollRight = mouseEvent.getSource() == this.pb_RIGHT;
        this.scroll = true;
        this.scrollThread.interrupt();
        this.scrolling = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.scroll = false;
        this.scrolling = false;
    }

    public void run() {
        boolean bl = false;
        boolean bl2 = false;
        this.buttonPanelWidth = this.buttonPanelLayout.minimumLayoutSize((Container)this.buttonPanel).width;
        while (this.continueThread) {
            if (this.scroll) {
                this.panelX = this.scrollRight ? (this.panelX += 15) : (this.panelX -= 15);
                if (this.panelX <= 0) {
                    this.panelX = 0;
                } else if (0 - this.panelX + this.buttonPanelWidth < this.width - 15) {
                    this.panelX -= 15;
                } else {
                    this.buttonPanel.setBounds(0 - this.panelX, 0, this.panelX + (this.width - 15), this.height);
                }
                this.sleep(25);
                continue;
            }
            this.sleep(10000);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void sleep(int n) {
        try {
            Thread.sleep(n);
            return;
        }
        catch (Exception exception) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalize() {
        try {
            this.scrollThread.stop();
            super.finalize();
            return;
        }
        catch (Throwable throwable) {
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public void setBackground(Image image) {
        this.backgroundImage = image;
    }

    public void paintComponent(Graphics graphics) {
        if (this.backgroundImage == null) {
            super.paintComponent(graphics);
        } else {
            WinUtil.wallPaper(this, graphics, this.backgroundImage);
            this.paintChildren(graphics);
        }
    }

    public void setArrowImage(ImageIcon imageIcon, ImageIcon imageIcon2) {
        this.pb_LEFT.setText("");
        this.pb_LEFT.setIcon(imageIcon2);
        this.pb_RIGHT.setText("");
        this.pb_RIGHT.setIcon(imageIcon);
    }

    public ButtonPanel() {
        this.init();
    }
}

