/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.app.shared.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class DTree
extends JTree
implements Runnable,
MouseListener {
    private static final String THREAD_FIRECHANGED = "FireChanged";
    private static final String THREAD_FIREEXPANDED = "FireExpanded";
    private static final String THREAD_FIRECOLLAPSED = "FireCollapsed";
    private static final String THREAD_FIREWILLEXPANDED = "FireWillExpanded";
    private static final String THREAD_FIREWILLCOLLAPSED = "FireWillCollapsed";
    private static final String THREAD_FIREACTIONPERFORMED = "FireAction";
    private TreePath curPath = null;
    private TreeSelectionEvent event = null;
    private Vector actionListeners = null;
    private boolean mouseListenerAdded = false;

    public void fireTreeCollapsed(TreePath treePath) {
        this.curPath = treePath;
        new Thread((Runnable)this, THREAD_FIRECOLLAPSED).start();
    }

    public void fireTreeExpanded(TreePath treePath) {
        this.curPath = treePath;
        new Thread((Runnable)this, THREAD_FIREEXPANDED).start();
    }

    public void fireTreeWillCollapse(TreePath treePath) {
        this.curPath = treePath;
        new Thread((Runnable)this, THREAD_FIREWILLCOLLAPSED).start();
    }

    public void fireTreeWillExpand(TreePath treePath) {
        this.curPath = treePath;
        new Thread((Runnable)this, THREAD_FIREWILLEXPANDED).start();
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.event = treeSelectionEvent;
        new Thread((Runnable)this, THREAD_FIRECHANGED).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String string = Thread.currentThread().getName();
        try {
            if (string.equals(THREAD_FIRECHANGED)) {
                super.fireValueChanged(this.event);
                return;
            }
            if (string.equals(THREAD_FIREWILLEXPANDED)) {
                super.fireTreeWillExpand(this.curPath);
                return;
            }
            if (string.equals(THREAD_FIREWILLCOLLAPSED)) {
                super.fireTreeWillCollapse(this.curPath);
                return;
            }
            if (string.equals(THREAD_FIREEXPANDED)) {
                super.fireTreeExpanded(this.curPath);
                return;
            }
            if (string.equals(THREAD_FIRECOLLAPSED)) {
                super.fireTreeCollapsed(this.curPath);
                return;
            }
            if (!string.equals(THREAD_FIREACTIONPERFORMED)) return;
            this.fireActionPerformed();
            return;
        }
        catch (ExpandVetoException expandVetoException) {
            expandVetoException.printStackTrace();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            new Thread((Runnable)this, THREAD_FIREACTIONPERFORMED).start();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        this.actionListeners.addElement(actionListener);
        if (!this.mouseListenerAdded) {
            this.addMouseListener(this);
            this.mouseListenerAdded = true;
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionListeners != null) {
            this.actionListeners.removeElement(actionListener);
        }
    }

    private final void fireActionPerformed() {
        if (this.actionListeners != null) {
            int n = 0;
            int n2 = this.actionListeners.size();
            ActionEvent actionEvent = new ActionEvent(this, 0, this.toString());
            while (n < n2) {
                ((ActionListener)this.actionListeners.elementAt(n)).actionPerformed(actionEvent);
                ++n;
            }
        }
    }
}

