/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.app.shared.gui;

import com.ibm.appsure.app.shared.gui.DButton;
import com.ibm.nzna.shared.spell.JSpellErrorInfo;
import com.ibm.nzna.shared.spell.JSpellToolkit;
import com.ibm.nzna.shared.spell.SpellChecker;
import java.awt.Dimension;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.text.JTextComponent;

public class SpellCheckPanel
extends JPanel
implements ActionListener,
ItemListener,
Runnable {
    private static Dimension expandedPrefSize = new Dimension(360, 21);
    private static Dimension normPrefSize = new Dimension(80, 21);
    private boolean expanded = false;
    private Dimension prefSize = normPrefSize;
    private DButton pb_SPELLCHECK = new DButton("Spell Check");
    private DButton pb_NEXT = new DButton("Next");
    private DButton pb_REPLACE = new DButton("Replace");
    private DButton pb_LEARN = new DButton("Learn");
    private DButton pb_STOP = new DButton("Stop");
    private JComboBox cb_WORDS = new JComboBox();
    private JLabel st_WORDS = new JLabel("Words");
    private BevelBorder indentBorder = new BevelBorder(1);
    private TextComponent textComponent = null;
    private JTextComponent jTextComponent = null;
    private JSpellToolkit spellToolkit = SpellChecker.getToolkit();
    private JSpellErrorInfo errorInfo = null;
    private int posOffset = 0;

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 4;
        int n2 = 2;
        int n3 = 18;
        super.doLayout();
        if (this.expanded) {
            this.st_WORDS.setBounds(n, n2, 40, n3 - 2);
            this.cb_WORDS.setBounds(n += 40, n2, 100, n3 - 2);
            this.pb_REPLACE.setBounds(n += 100, n2, 60, n3 - 2);
            this.pb_NEXT.setBounds(n += 60, n2, 45, n3 - 2);
            this.pb_LEARN.setBounds(n += 45, n2, 60, n3 - 2);
            this.pb_STOP.setBounds(n += 60, n2, 50, n3 - 2);
            n += 50;
        } else {
            this.pb_SPELLCHECK.setBounds(0, 0, dimension.width, dimension.height);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_SPELLCHECK) {
            if (this.textComponent != null || this.jTextComponent != null) {
                this.expanded = true;
                this.prefSize = expandedPrefSize;
                this.invalidate();
                this.getParent().invalidate();
                this.st_WORDS.setVisible(true);
                this.cb_WORDS.setVisible(true);
                this.pb_STOP.setVisible(true);
                this.pb_LEARN.setVisible(true);
                this.pb_NEXT.setVisible(true);
                this.pb_SPELLCHECK.setVisible(false);
                this.setBorder(this.indentBorder);
                this.revalidate();
                if (this.textComponent != null) {
                    this.spellToolkit.initRawCheck(this.textComponent.getText());
                } else {
                    this.spellToolkit.initRawCheck(this.jTextComponent.getText());
                }
                this.posOffset = 0;
                new Thread(this).start();
            }
        } else if (actionEvent.getSource() == this.pb_STOP) {
            this.expanded = false;
            this.prefSize = normPrefSize;
            this.st_WORDS.setVisible(false);
            this.cb_WORDS.setVisible(false);
            this.pb_STOP.setVisible(false);
            this.pb_LEARN.setVisible(false);
            this.pb_NEXT.setVisible(false);
            this.pb_SPELLCHECK.setVisible(true);
            this.invalidate();
            this.getParent().invalidate();
            this.setBorder(null);
            this.revalidate();
        } else if (actionEvent.getSource() == this.pb_NEXT) {
            if (this.errorInfo.getWord() != null) {
                this.spellToolkit.addIgnore(this.errorInfo.getWord());
            }
            new Thread(this).start();
        } else if (actionEvent.getSource() == this.pb_REPLACE) {
            this.replaceText();
        } else if (actionEvent.getSource() == this.pb_LEARN) {
            if (this.errorInfo.getWord() != null) {
                this.spellToolkit.addLearned(this.errorInfo.getWord());
            }
            new Thread(this).start();
        }
    }

    private final void setEnableAll(boolean bl) {
        this.st_WORDS.setEnabled(bl);
        this.cb_WORDS.setEnabled(bl);
        this.pb_STOP.setEnabled(bl);
        this.pb_LEARN.setEnabled(bl);
        this.pb_NEXT.setEnabled(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.setEnableAll(false);
        this.errorInfo = this.spellToolkit.rawCheck();
        if (this.errorInfo != null) {
            this.remove(this.cb_WORDS);
            if (this.errorInfo.getSuggestions().length > 0) {
                try {
                    this.cb_WORDS = new JComboBox<String>(this.errorInfo.getSuggestions());
                }
                catch (Exception exception) {
                    this.cb_WORDS = new JComboBox();
                }
            } else {
                this.cb_WORDS = new JComboBox();
            }
            this.add(this.cb_WORDS);
            this.cb_WORDS.addItemListener(this);
            if (this.textComponent != null) {
                this.textComponent.select(this.errorInfo.getPosition() + this.posOffset, this.errorInfo.getEndPosition() + this.posOffset);
            } else {
                this.jTextComponent.select(this.errorInfo.getPosition() + this.posOffset, this.errorInfo.getEndPosition() + this.posOffset);
            }
        } else {
            this.expanded = false;
            this.prefSize = normPrefSize;
            this.st_WORDS.setVisible(false);
            this.cb_WORDS.setVisible(false);
            this.pb_STOP.setVisible(false);
            this.pb_LEARN.setVisible(false);
            this.pb_NEXT.setVisible(false);
            this.pb_SPELLCHECK.setVisible(true);
            this.invalidate();
            this.getParent().invalidate();
            this.setBorder(null);
        }
        this.setEnableAll(true);
        this.revalidate();
    }

    public void replaceText() {
        String string = null;
        String string2 = (String)this.cb_WORDS.getSelectedItem();
        string = this.textComponent != null ? this.textComponent.getText() : this.jTextComponent.getText();
        string = string2 != null ? string.substring(0, this.errorInfo.getPosition() + this.posOffset) + string2 + string.substring(this.errorInfo.getEndPosition()) : string.substring(0, this.errorInfo.getPosition() + this.posOffset) + string.substring(this.errorInfo.getEndPosition());
        if (this.textComponent != null) {
            this.textComponent.setText(string);
        } else {
            this.jTextComponent.setText(string);
            if (this.jTextComponent instanceof JComponent) {
                this.jTextComponent.revalidate();
            }
        }
        this.spellToolkit.initRawCheck(string);
        new Thread(this).start();
    }

    public void setTextComponent(TextComponent textComponent) {
        this.textComponent = textComponent;
    }

    public void setTextComponent(JTextComponent jTextComponent) {
        this.jTextComponent = jTextComponent;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.replaceText();
    }

    public SpellCheckPanel() {
        this.setLayout(null);
        this.add(this.pb_SPELLCHECK);
        this.add(this.pb_REPLACE);
        this.add(this.pb_NEXT);
        this.add(this.pb_LEARN);
        this.add(this.pb_STOP);
        this.add(this.cb_WORDS);
        this.add(this.st_WORDS);
        this.pb_SPELLCHECK.addActionListener(this);
        this.pb_REPLACE.addActionListener(this);
        this.pb_NEXT.addActionListener(this);
        this.pb_LEARN.addActionListener(this);
        this.pb_STOP.addActionListener(this);
    }
}

