/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.app.shared.util;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;

public class FontUtil
implements Serializable {
    private int currentCacheSize = 128;
    private int[] fontCharWidths = new int[this.currentCacheSize];
    private Font font = null;
    private FontMetrics fontMetrics = null;
    private int fontHeight = 0;
    private int fontAscent = 0;
    private int fontDescent = 0;
    private int fontAdvance = 0;
    private byte[] byteChars = new byte[1024];
    private int fontLeading = 0;

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.fontAscent = this.fontMetrics.getAscent();
        this.fontDescent = this.fontMetrics.getDescent();
        this.fontAdvance = this.fontMetrics.getMaxAdvance();
        this.fontLeading = this.fontMetrics.getLeading();
        int n = 0;
        while (n < this.currentCacheSize) {
            this.fontCharWidths[n] = 0;
            ++n;
        }
    }

    public int getYCentered(int n) {
        int n2 = (n - this.fontHeight) / 2;
        int n3 = n - n2 - this.fontDescent - this.fontLeading / 2;
        return n3;
    }

    public static int getYCentered(Font font, int n) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.getLeading();
        int n4 = fontMetrics.getDescent();
        int n5 = (n - n2) / 2;
        int n6 = n - n5 - n4 - n3 / 2;
        return n6;
    }

    public static int getCharWidth(FontUtil fontUtil, char c) {
        if (c > fontUtil.currentCacheSize - 1) {
            fontUtil.currentCacheSize = 65535;
            fontUtil.fontCharWidths = new int[fontUtil.currentCacheSize];
        }
        if (fontUtil.fontCharWidths[c] == 0) {
            fontUtil.fontCharWidths[c] = fontUtil.fontMetrics.charWidth(c);
            return fontUtil.fontCharWidths[c];
        }
        return fontUtil.fontCharWidths[c];
    }

    public int getCharsWidth(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            n3 += FontUtil.getCharWidth(this, cArray[n4]);
            ++n4;
        }
        return n3;
    }

    public void drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, Rectangle rectangle, int n4) {
        int n5;
        int n6;
        if (n == 0) {
            return;
        }
        FontUtil.validateArrayLength(this, n);
        int n7 = rectangle.x - n2;
        if (n7 < 0) {
            n7 = 0;
        }
        if ((n6 = rectangle.x + rectangle.width - n2) < (n5 = n4)) {
            n5 = n6;
        }
        boolean bl = false;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = n4;
        while (n8 < n - 1 && n7 - n11 > FontUtil.getCharWidth(this, cArray[n8])) {
            n12 = n11;
            n11 += FontUtil.getCharWidth(this, cArray[n8]);
            if (cArray[n8] > '\u00ff') {
                bl = true;
            }
            this.byteChars[n8] = (byte)cArray[n8];
            n9 = ++n8;
        }
        n7 = n11;
        n8 = n10 = n9;
        while (n8 < n && n11 + FontUtil.getCharWidth(this, cArray[n8]) < n4 && n11 < n5) {
            n11 += FontUtil.getCharWidth(this, cArray[n8]);
            if (cArray[n8] > '\u00ff') {
                bl = true;
            }
            this.byteChars[n8] = (byte)cArray[n8];
            n10 = n8++;
        }
        if (bl) {
            graphics.drawChars(cArray, n9, n10 - n9 + 1, n7 + n2, n3);
        } else {
            graphics.drawBytes(this.byteChars, n9, n10 - n9 + 1, n7 + n2, n3);
        }
    }

    public void drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
        if (n2 == 0) {
            return;
        }
        boolean bl = false;
        int n5 = 0;
        while (n5 < n2) {
            if (cArray[n5] > '\u00ff') {
                bl = true;
            }
            this.byteChars[n5] = (byte)cArray[n5];
            ++n5;
        }
        if (bl) {
            graphics.drawChars(cArray, n, n2, n3, n4);
        } else {
            graphics.drawBytes(this.byteChars, n, n2, n3, n4);
        }
    }

    public void drawCharsEtc(Graphics graphics, char[] cArray, int n, int n2, int n3, Rectangle rectangle, int n4) {
        int n5;
        boolean bl = false;
        if (n == 0) {
            return;
        }
        FontUtil.validateArrayLength(this, n);
        int n6 = -n2;
        if (rectangle != null) {
            n6 = rectangle.x - n2;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        int n7 = 0;
        n7 = rectangle != null ? rectangle.x + rectangle.width - n2 : n4 + 100 - n2;
        if (n7 < (n5 = n4)) {
            n5 = n7;
        }
        boolean bl2 = false;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = n4;
        while (n8 < n - 1 && n6 - n11 > FontUtil.getCharWidth(this, cArray[n8])) {
            n12 = n11;
            n11 += FontUtil.getCharWidth(this, cArray[n8]);
            if (cArray[n8] > '\u00ff') {
                bl2 = true;
            }
            this.byteChars[n8] = (byte)cArray[n8];
            n9 = ++n8;
        }
        n6 = n11;
        n8 = n10 = n9;
        while (n8 < n && n11 + FontUtil.getCharWidth(this, cArray[n8]) < n4 && n11 < n5) {
            n11 += FontUtil.getCharWidth(this, cArray[n8]);
            if (cArray[n8] > '\u00ff') {
                bl2 = true;
            }
            this.byteChars[n8] = (byte)cArray[n8];
            n10 = n8++;
        }
        int n14 = n8;
        while (n14 < n) {
            n11 += FontUtil.getCharWidth(this, cArray[n14]);
            if (cArray[n14] > '\u00ff') {
                bl2 = true;
            }
            this.byteChars[n14] = (byte)cArray[n14];
            if (n11 >= n4 && n14 > 1) {
                bl = true;
                this.byteChars[n14] = 46;
                this.byteChars[n14 - 1] = 46;
                this.byteChars[n14 - 2] = 46;
                break;
            }
            ++n14;
        }
        if (bl) {
            n8 = 0;
            n9 = 0;
            n10 = 0;
            n11 = 0;
            n12 = 0;
            n13 = n4;
            while (n8 < n - 1 && n6 - n11 > FontUtil.getCharWidth(this, (char)this.byteChars[n8])) {
                n12 = n11;
                n11 += FontUtil.getCharWidth(this, (char)this.byteChars[n8]);
                n9 = ++n8;
            }
            n6 = n11;
            n8 = n10 = n9;
            while (n8 <= n14 && n11 + FontUtil.getCharWidth(this, (char)this.byteChars[n8]) < n4 && n11 < n5) {
                n11 += FontUtil.getCharWidth(this, (char)this.byteChars[n8]);
                n10 = n8++;
            }
        }
        if (bl2) {
            graphics.drawChars(cArray, n9, n10 - n9 + 1, n6 + n2, n3);
        } else {
            graphics.drawBytes(this.byteChars, n9, n10 - n9 + 1, n6 + n2, n3);
        }
    }

    private static final void validateArrayLength(FontUtil fontUtil, int n) {
        if (n >= fontUtil.byteChars.length - 4) {
            fontUtil.byteChars = new byte[n * 2];
        }
    }

    public static void drawHotLinkString(Graphics graphics, String string, int n, int n2) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(graphics.getFont());
        graphics.drawString(string, n, n2);
        graphics.drawLine(n, n2 + 1, n + fontMetrics.stringWidth(string), n2 + 1);
    }

    public FontUtil() {
    }

    public FontUtil(Font font) {
        this.setFont(font);
    }
}

