/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.common;

import com.ibm.appsure.AppSureException;
import com.ibm.appsure.app.shared.gui.MultiListRow;
import com.ibm.appsure.common.AppSureEMailer;
import com.ibm.appsure.common.Contact;
import com.ibm.appsure.common.DatabaseObject;
import com.ibm.appsure.common.FailureType;
import com.ibm.appsure.common.Log;
import com.ibm.appsure.common.LogFile;
import com.ibm.appsure.db.AppSureSQL;
import java.sql.Connection;

public class Failure
extends DatabaseObject
implements MultiListRow {
    private String appCode = null;
    private String notified = null;
    private String working = null;
    private String closed = null;
    private String resolution = null;
    private int failureType = 0;
    private LogFile logFile;
    private String failureDescription = null;

    public String getNotified() {
        return this.notified;
    }

    public void setNotified(String string) {
        this.notified = string;
        this.updateRecStatus(1);
    }

    public String getWorking() {
        return this.working;
    }

    public void setWorking(String string) {
        this.working = string;
        this.updateRecStatus(1);
    }

    public String getClosed() {
        return this.closed;
    }

    public void setClosed(String string) {
        this.closed = string;
        this.updateRecStatus(1);
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String string) {
        this.resolution = string;
        this.updateRecStatus(1);
    }

    public int getFailureType() {
        return this.failureType;
    }

    public void setFailureType(int n) {
        this.failureType = n;
        this.updateRecStatus(1);
    }

    public String getAppCode() {
        return this.appCode;
    }

    public int readFromDatabase() {
        return 0;
    }

    public int saveToDatabase() {
        return 0;
    }

    public boolean isSevZero() {
        return this.failureType == 0;
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public void setLogFile(LogFile logFile) {
        this.logFile = logFile;
    }

    public void setFailureDescription(String string) {
        this.failureDescription = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendAlert(Connection connection, String string) throws AppSureException, Exception {
        try {
            FailureType failureType = AppSureSQL.readFailureType(connection, this.getFailureType());
            Contact contact = AppSureSQL.getContact(connection, string, 1);
            Contact contact2 = AppSureSQL.getContact(connection, string, 2);
            if (contact != null) {
                if (contact.getPerson() != null) {
                    AppSureEMailer.sendMail(contact.getPerson().getEmail(), string + " Failure. Reason:" + failureType.toString(), this.logFile.getLogContents());
                } else {
                    Log.log("Could not find Primary Contact eMail for appliction " + string);
                }
            } else {
                Log.log("Could not find Primary Contact for appliction " + string);
            }
            if (contact2 == null) {
                Log.log("   Could not find Primary Contact for appliction " + string);
                return;
            }
            if (contact2.getPerson() != null) {
                AppSureEMailer.sendMail(contact2.getPerson().getEmail(), string + " Failure. Reason:" + failureType.toString(), this.logFile.getLogContents());
                return;
            }
            Log.log("   Could not find Primary Contact eMail for appliction " + string);
            return;
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (AppSureException appSureException) {
            throw appSureException;
        }
    }

    public Object getColumnData(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.failureDescription;
                break;
            }
            case 1: {
                string = this.notified;
                break;
            }
            case 2: {
                string = this.closed;
                break;
            }
            case 3: {
                string = this.working;
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public Failure() {
        this.updateRecStatus(2);
    }
}

