/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.common;

import com.ibm.appsure.AppSureException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Log {
    private static String logFilename = "appsure.out";
    private static long logFileMaxSize = 1024L;

    public void setLogFileMaxSize(int n) {
        logFileMaxSize = n;
    }

    public static void log(String string) {
        Log.appendToFile(Log.getTimestamp() + "   " + string);
    }

    public static void log(Exception exception) {
        String string = Log.getTimestamp() + "   Exception Occurred\n-----------------------------------------------\n";
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        string = stringWriter.toString();
        Log.appendToFile(string);
    }

    public static void log(AppSureException appSureException) {
        String string = Log.getTimestamp() + "   AppSureException Occurred\n------------------------------------------------------\n";
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        appSureException.printStackTrace(printWriter);
        string = stringWriter.toString();
        Log.appendToFile(string);
    }

    private static final String getTimestamp() {
        String string = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-kk.mm.ss.000000");
        Date date = new Date();
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        string = simpleDateFormat.format(date);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void appendToFile(String string) {
        string = string + "\n";
        Log.checkAndTruncate(string.length());
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(logFilename, "rw");
            randomAccessFile.seek(randomAccessFile.length());
            randomAccessFile.write(string.getBytes());
            randomAccessFile.close();
            return;
        }
        catch (Exception exception) {
            System.err.println("Cannot write to log file " + logFilename + "\n" + string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void checkAndTruncate(int n) {
        File file = new File(logFilename);
        if (file.length() <= logFileMaxSize - (long)n) return;
        try {
            if ((long)n > file.length()) {
                Log.clearLog();
                return;
            }
            Log.saveFile(logFilename, Log.readFile(logFilename).substring(n));
            return;
        }
        catch (Exception exception) {
            System.err.println("Cannot truncate file");
            exception.printStackTrace();
        }
    }

    public static String readFile(String string) throws FileNotFoundException, IOException {
        String string2 = null;
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = 1024;
        byte[] byArray = new byte[n];
        boolean bl = false;
        int n2 = 0;
        string2 = "";
        while (n2 >= 0) {
            n2 = fileInputStream.read(byArray);
            if (n2 < 0) continue;
            string2 = string2 + new String(byArray, 0, n2);
        }
        fileInputStream.close();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveFile(String string, String string2) {
        boolean bl = false;
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public static void clearLog() {
        Log.saveFile(logFilename, "");
    }

    public static void skipLine() {
        Log.appendToFile("");
    }

    public Log(String string) {
        logFilename = string;
        Log.log("\n\n");
        Log.log("Application Started. " + Log.getTimestamp());
    }
}

