/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.db;

import com.ibm.appsure.AppSureException;
import com.ibm.appsure.common.Contact;
import com.ibm.appsure.common.Failure;
import com.ibm.appsure.common.FailureType;
import com.ibm.appsure.common.LogFile;
import com.ibm.appsure.common.Person;
import com.ibm.appsure.common.ProcessRec;
import com.ibm.appsure.common.RunTimeRec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class AppSureSQL {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAppRunning(Connection connection, String string) throws AppSureException {
        boolean bl = false;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT STARTTIME " + "FROM APPSURE.appProcess " + "WHERE APPCODE = '" + string + "' AND " + "STOPTIME IS NULL");
            bl = resultSet.next();
            resultSet.close();
            statement.close();
            return bl;
        }
        catch (SQLException sQLException) {
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int logApplicationRunning(Connection connection, String string) throws AppSureException {
        int n = -1;
        try {
            Statement statement = connection.createStatement();
            n = AppSureSQL.getNextProcessIndex(connection, string);
            statement.executeUpdate("INSERT INTO APPSURE.appProcess " + "values ( " + n + ", '" + string + "', CURRENT TIMESTAMP, NULL )");
            statement.close();
            return n;
        }
        catch (SQLException sQLException) {
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void logApplicationStopped(Connection connection, int n, String string) throws AppSureException {
        try {
            Statement statement = connection.createStatement();
            statement.executeUpdate("UPDATE APPSURE.APPPROCESS SET STOPTIME = CURRENT TIMESTAMP WHERE PROCESSINDEX = " + n);
            statement.close();
            return;
        }
        catch (SQLException sQLException) {
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int createLog(Connection connection, String string, String string2) throws AppSureException {
        int n = AppSureSQL.getNextLogIndex(connection);
        try {
            PreparedStatement preparedStatement = null;
            if (n <= 0) throw new AppSureException("Cannot create any log files. LogIndex corrupt");
            preparedStatement = connection.prepareStatement("INSERT INTO APPSURE.logs " + "values ( " + n + ", '" + string + "', ?, CURRENT TIMESTAMP, 'Y' )");
            preparedStatement.setBytes(1, string2.getBytes());
            preparedStatement.execute();
            preparedStatement.close();
            return n;
        }
        catch (SQLException sQLException) {
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int getNextLogIndex(Connection connection) {
        int n = 0;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT MAX(LOGINDEX) FROM APPSURE.LOGS");
            if (resultSet.next()) {
                n = resultSet.getInt(1) + 1;
            }
            resultSet.close();
            statement.close();
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean createFailure(Connection connection, String string, int n, int n2) throws AppSureException {
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = connection.prepareStatement("INSERT INTO APPSURE.failure " + "values ( " + n2 + ", " + n + ", NULL, NULL, NULL, '')");
            preparedStatement.execute();
            preparedStatement.close();
            return true;
        }
        catch (SQLException sQLException) {
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Failure getLastFailure(Connection connection, String string) throws AppSureException {
        Failure failure = new Failure();
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT LOGS.LOGINDEX,  LOGS.LOG,            LOGS.LOGTIMESTAMP, " + "       LOGS.KEEP,      FAILURE.FAILURETYPE, FAILURE.NOTIFIED, " + "       FAILURE.CLOSED, FAILURE.WORKING,     FAILURE.RESOLUTION " + "FROM APPSURE.LOGS LOGS, APPSURE.FAILURE FAILURE " + "WHERE LOGS.APPCODE = '" + string + "' AND " + "      FAILURE.LOGINDEX = LOGS.LOGINDEX AND " + "\tFAILURE.WORKING  IS NULL AND " + "\tFAILURE.CLOSED IS NULL");
            if (resultSet.next()) {
                LogFile logFile = new LogFile(resultSet.getInt(1));
                logFile.setLogContents(resultSet.getString(2));
                logFile.setLogTimestamp(resultSet.getString(3).trim());
                logFile.setKeep(resultSet.getString(4).equals("Y"));
                failure.setFailureType(resultSet.getInt(5));
                failure.setNotified(resultSet.getString(6));
                failure.setClosed(resultSet.getString(7));
                failure.setWorking(resultSet.getString(8));
                failure.setResolution(resultSet.getString(9));
                failure.setLogFile(logFile);
            }
            resultSet.close();
            statement.close();
            return failure;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int getNextProcessIndex(Connection connection, String string) throws AppSureException {
        int n = 0;
        Failure failure = new Failure();
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT MAX(PROCESSINDEX), MIN(PROCESSINDEX) " + "FROM APPSURE.APPPROCESS");
            if (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                int n3 = resultSet.getInt(2);
                n = n3 > 1 ? n3 - 1 : n2 + 1;
                if (n <= 0) {
                    n = n2 + 1;
                }
            } else {
                n = 1;
            }
            resultSet.close();
            statement.close();
            return n;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getProperty(Connection connection, String string, String string2) {
        String string3 = null;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT VALUE FROM APPSURE.PROPERTIES WHERE PROPERTY = '" + string + "'");
            if (resultSet.next()) {
                string3 = resultSet.getString(1).trim();
            }
            resultSet.close();
            statement.close();
            return string3;
        }
        catch (Exception exception) {
            return string2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector getUniqueApplications(Connection connection) throws Exception {
        Vector<String> vector = new Vector<String>(10);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT DISTINCT APPCODE FROM APPSURE.APPLICATION where APPCODE <> 'DEFAULT'");
        while (true) {
            if (!resultSet.next()) {
                resultSet.close();
                statement.close();
                return vector;
            }
            vector.addElement(resultSet.getString(1).trim());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FailureType readFailureType(Connection connection, int n) throws AppSureException {
        FailureType failureType = new FailureType(n);
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT FAILURETYPE, DESCRIPTION, EMAIL, PAGE, SEVERITY " + "FROM APPSURE.FAILURETYPE " + "WHERE FAILURETYPE = " + n);
            if (resultSet.next()) {
                failureType.setDescription(resultSet.getString(2).trim());
                failureType.setEmail(resultSet.getString(3).equals("Y"));
                failureType.setPage(resultSet.getString(4).equals("Y"));
                failureType.setSeverity(resultSet.getInt(5));
            }
            resultSet.close();
            statement.close();
            return failureType;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Contact getContact(Connection connection, String string, int n) throws AppSureException {
        Contact contact = null;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT PERSONINDEX, CONTACTTYPE " + "FROM APPSURE.CONTACT " + "WHERE APPCODE = '" + string + "' AND " + "      CONTACTTYPE = " + n);
            if (resultSet.next()) {
                contact = new Contact(string, resultSet.getInt(1), resultSet.getInt(2));
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new AppSureException(sQLException);
        }
        if (contact != null) {
            contact.setPerson(AppSureSQL.readPerson(connection, contact.getPersonIndex()));
        }
        return contact;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Person readPerson(Connection connection, int n) throws AppSureException {
        Person person = null;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT FIRST_NAME, LAST_NAME, EMAIL, PHONE, PAGER, PAGEREMAIL " + "FROM APPSURE.PERSON " + "WHERE PERSONINDEX = " + n);
            if (resultSet.next()) {
                person = new Person(n);
                person.setFirstName(resultSet.getString(1).trim());
                person.setLastName(resultSet.getString(2).trim());
                person.setEmail(resultSet.getString(3).trim());
                person.setPager(resultSet.getString(4).trim());
                person.setPagerEMail(resultSet.getString(5).trim());
            }
            resultSet.close();
            statement.close();
            return person;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector readApplicationRunTimes(Connection connection, String string, String string2, String string3) throws AppSureException {
        Vector<RunTimeRec> vector = new Vector<RunTimeRec>(1);
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT RUNINDEX, STARTTIME " + "FROM APPSURE.RUNTIME " + "WHERE APPCODE = '" + string + "' AND " + "      DAY     = '" + string2 + "'" + (string3 == null ? "" : "AND STARTTIME < '" + string3 + "'"));
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    statement.close();
                    return vector;
                }
                RunTimeRec runTimeRec = new RunTimeRec(resultSet.getInt(1));
                runTimeRec.setDay(string2);
                runTimeRec.setAppCode(string);
                runTimeRec.setStartTime(resultSet.getString(2).trim());
                vector.addElement(runTimeRec);
            }
        }
        catch (SQLException sQLException) {
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateNotifyTime(Connection connection, int n) throws AppSureException {
        try {
            Statement statement = connection.createStatement();
            statement.executeUpdate("UPDATE APPSURE.FAILURE SET NOTIFIED = CURRENT TIMESTAMP WHERE LOGINDEX = " + n);
            statement.close();
            return;
        }
        catch (SQLException sQLException) {
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAverageRunTimeMin(Connection connection, String string) throws AppSureException {
        int n = 0;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT AVERAGERUNTIMEMIN " + "FROM APPSURE.APPLICATION " + "WHERE APPCODE = '" + string + "'");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
            return n;
        }
        catch (SQLException sQLException) {
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector readApplicationOpenProcesses(Connection connection, String string) throws AppSureException {
        Vector<ProcessRec> vector = new Vector<ProcessRec>(1);
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT STARTTIME " + "FROM APPSURE.APPPROCESS " + "WHERE APPCODE = '" + string + "' AND " + "      STOPTIME IS NULL ");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    statement.close();
                    return vector;
                }
                ProcessRec processRec = new ProcessRec();
                processRec.setAppCode(string);
                processRec.setStartTime(resultSet.getString(1).trim());
                vector.addElement(processRec);
            }
        }
        catch (SQLException sQLException) {
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readLogContents(Connection connection, LogFile logFile) throws AppSureException {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT LOG " + "FROM APPSURE.LOGS " + "WHERE LOGINDEX = " + logFile.getLogIndex() + " FOR FETCH ONLY");
            if (resultSet.next()) {
                logFile.setLogContents(new String(resultSet.getBytes(1)));
            }
            resultSet.close();
            statement.close();
            return;
        }
        catch (SQLException sQLException) {
            throw new AppSureException(sQLException);
        }
    }
}

