/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.monitor;

import com.ibm.appsure.AppSureException;
import com.ibm.appsure.common.AppSureEMailer;
import com.ibm.appsure.common.CDate;
import com.ibm.appsure.common.Failure;
import com.ibm.appsure.common.Log;
import com.ibm.appsure.common.ProcessRec;
import com.ibm.appsure.common.RunTimeRec;
import com.ibm.appsure.common.Util;
import com.ibm.appsure.db.AppSureSQL;
import java.io.File;
import java.io.FileInputStream;
import java.net.ServerSocket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class AppSureMonitor
implements Runnable {
    private int sleepMinutes = 10;
    private Hashtable properties = null;
    private Connection dbConn = null;

    public static void main(String[] stringArray) {
        new AppSureMonitor(stringArray);
    }

    private final void initializeProperties(String[] stringArray) {
        this.properties = new Hashtable();
        this.readProperties();
        this.processCommandLineArgs(stringArray);
        this.sleepMinutes = Integer.parseInt("" + this.properties.get("SleepTime"));
        if (this.properties.get("SMTP") != null) {
            new AppSureEMailer((String)this.properties.get("SMTP"));
        } else {
            System.err.println("No SMTP Server specified. Application exiting. Please specify an SMTP server in the AppSureMonitor.properties file.\nFor example: SMTP=mySMTP.mydomain.com");
            System.exit(-1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readProperties() {
        Properties properties = new Properties();
        try {
            Enumeration<?> enumeration = null;
            properties.load(new FileInputStream(new File("AppSureMonitor.properties")));
            enumeration = properties.propertyNames();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                Object obj = enumeration.nextElement();
                this.properties.put(obj, ((Hashtable)properties).get(obj));
            }
        }
        catch (Exception exception) {
            System.err.println("Cannot find AppSureMonitor.properties file. Please make sure this file exists in the directory in which you executed the AppSure Monitor.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processCommandLineArgs(String[] stringArray) {
        try {
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return;
                }
                int n2 = stringArray[n].indexOf("=");
                if (n2 >= 0) {
                    String string = stringArray[n].substring(0, n2);
                    String string2 = stringArray[n].substring(n2 + 1);
                    this.properties.remove(string);
                    this.properties.put(string, string2);
                }
                ++n;
            }
        }
        catch (Exception exception) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean checkMultipleInstances() {
        int n = Integer.parseInt("" + this.properties.get("MonitorStartPortNum"));
        try {
            ServerSocket serverSocket = new ServerSocket(n);
            return true;
        }
        catch (Exception exception) {
            System.err.println("Cannot start due to port number " + n + " already being used. This might be an indication that the AppSure Monitor is already running");
            System.exit(0);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean connectToDatabase() {
        String string = (String)this.properties.get("Database");
        String string2 = (String)this.properties.get("DatabaseServer");
        String string3 = (String)this.properties.get("JDBCPortNumber");
        Log.log("Connecting to Database " + string + " on server " + string2 + " with port number " + string3);
        try {
            String string4 = "COM.ibm.db2.jdbc.net.DB2Driver";
            Object var5_6 = null;
            Class.forName(string4).newInstance();
            this.dbConn = DriverManager.getConnection("jdbc:db2://" + string2 + ":" + string3 + "/" + string, "dlentz", "m0seley");
            return true;
        }
        catch (Exception exception) {
            Log.log("Cannot connect to database " + string + " on server " + string2 + " with port number " + string3);
            Log.log(exception);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean bl = true;
        while (bl) {
            if (!this.verifyConnection()) {
                Log.log("Database Connection failed. Trying reconnect");
                bl = this.connectToDatabase();
            }
            Log.skipLine();
            Log.skipLine();
            Log.log("Monitor Checking Software");
            bl = this.checkAppSureSoftware();
            try {
                if (this.sleepMinutes != 1) {
                    Log.log("Monitor Sleeping for " + this.sleepMinutes + " Minutes");
                } else {
                    Log.log("Monitor Sleeping for " + this.sleepMinutes + " Minute");
                }
                Thread.currentThread();
                Thread.sleep(this.sleepMinutes * 60000);
            }
            catch (Exception exception) {
                Log.log("Monitor awoken with error");
                Log.log(exception);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean checkAppSureSoftware() {
        try {
            Vector vector = AppSureSQL.getUniqueApplications(this.dbConn);
            int n = 0;
            int n2 = vector.size();
            if (n2 <= 0) {
                Log.log("No Applications to check");
                return true;
            }
            String string = null;
            Log.log("Checking " + vector.size() + " Application(s)");
            while (true) {
                if (n >= n2) {
                    System.out.println("Done Check");
                    return true;
                }
                string = (String)vector.elementAt(n);
                this.checkApplication(string);
                ++n;
            }
        }
        catch (Exception exception) {
            Log.log("Exception caught while processing applications");
            Log.log(exception);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void checkApplication(String string) {
        Object var2_2 = null;
        try {
            Log.log("   Checking Application " + string);
            this.checkApplicationRuntime(string);
            this.checkApplicationFailure(string);
            return;
        }
        catch (AppSureException appSureException) {
            Log.log("***Cannot check application " + string + " due to exceptions");
            appSureException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            Log.log("***Cannot check application " + string + " due to exceptions");
            exception.printStackTrace();
        }
    }

    private final void checkApplicationFailure(String string) throws Exception, AppSureException {
        Failure failure = null;
        Log.log("      Checking " + string + " for failures");
        failure = AppSureSQL.getLastFailure(this.dbConn, string);
        if (failure != null) {
            if (!failure.isSevZero()) {
                if (failure.getNotified() == null) {
                    failure.sendAlert(this.dbConn, string);
                }
            } else {
                Log.log("      " + string + " ended without error");
            }
        } else {
            Log.log("      Could not find any failures");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void checkApplicationRuntime(String string) {
        Log.log("      Checking Application Run Time for " + string);
        try {
            int n = AppSureSQL.getAverageRunTimeMin(this.dbConn, string);
            Vector vector = AppSureSQL.readApplicationOpenProcesses(this.dbConn, string);
            if (vector == null) return;
            if (vector.size() <= 0) return;
            ProcessRec processRec = null;
            int n2 = 0;
            int n3 = vector.size();
            String string2 = new CDate(1).today();
            while (true) {
                if (n2 >= n3) {
                    return;
                }
                processRec = (ProcessRec)vector.elementAt(n2);
                int n4 = Util.getTimeDiff(string2, processRec.getStartTime());
                if (n4 > n) {
                    int n5 = AppSureSQL.createLog(this.dbConn, string, string + " is still running after " + n4 + " minute(s). The average run time for this application is " + n + "(minutes)");
                    AppSureSQL.createFailure(this.dbConn, string, 3, n5);
                    Log.log("      Application " + string + " is still running after " + n4 + " minute(s)");
                } else {
                    Log.log("      Application " + string + " is running in it's allotted time");
                }
                ++n2;
            }
        }
        catch (AppSureException appSureException) {
            Log.log("******Cannot Check Application Runtime for " + string);
            Log.log(appSureException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean verifyConnection() {
        boolean bl = false;
        try {
            Statement statement = this.dbConn.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * from APPSURE.PROPERTIES");
            bl = resultSet.next();
            resultSet.close();
            statement.close();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean checkApplicationStart(String string) {
        boolean bl = false;
        try {
            Vector vector = AppSureSQL.readApplicationRunTimes(this.dbConn, string, Util.getDay(), Util.getTime());
            if (vector == null) return bl;
            if (vector.size() <= 0) return bl;
            int n = 0;
            int n2 = vector.size();
            RunTimeRec runTimeRec = null;
            while (true) {
                if (n >= n2) {
                    return bl;
                }
                runTimeRec = (RunTimeRec)vector.elementAt(n);
                try {
                    bl = runTimeRec.didAppRun(this.dbConn);
                    if (!bl) {
                        int n3 = AppSureSQL.createLog(this.dbConn, string, "Application did not start at specified time of " + runTimeRec.getStartTime());
                        AppSureSQL.createFailure(this.dbConn, string, 2, n3);
                        Log.log("      Application " + string + " did not run at " + runTimeRec.getStartTime());
                    } else {
                        Log.log("      Application " + string + " ran at " + runTimeRec.getStartTime());
                    }
                }
                catch (Exception exception) {
                    Log.log("******Could not check Application Run Time for RunTimeIndex:" + runTimeRec.getRunTimeIndex());
                    Log.log(exception);
                }
                ++n;
            }
        }
        catch (AppSureException appSureException) {
            Log.log("******Cannot check Application Start. Exception:");
            Log.log(appSureException);
        }
        return bl;
    }

    AppSureMonitor(String[] stringArray) {
        this.initializeProperties(stringArray);
        if (this.checkMultipleInstances()) {
            Log log = new Log(this.properties.get("LogFileHome") + "appsuremonitor.log");
            log.setLogFileMaxSize(Integer.parseInt("" + this.properties.get("MaxLogFileSize")));
            if (this.connectToDatabase()) {
                new Thread(this).start();
            }
        }
    }
}

