/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.batch;

import com.ibm.appsure.AppSure;
import com.ibm.nzna.projects.batch.utils.BatchUtil;
import com.ibm.nzna.projects.common.quest.Constants;
import com.ibm.nzna.shared.batch.BatchLogSystem;
import com.ibm.nzna.shared.util.ResourceLoader;
import com.ibm.nzna.shared.util.StandardPropertyLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class BatchInit {
    public static BatchLogSystem logSystem = null;
    public static AppSure appSure = null;
    public static Constants tConstants = new Constants();
    public static long batchFatal = 0L;
    public static long batchError = 0L;
    public static long batchWarning = 0L;

    public static String getPlugins() throws IOException {
        return StandardPropertyLoader.getProperties().getProperty("plugins");
    }

    public static String getDbName() throws IOException {
        return StandardPropertyLoader.getProperties().getProperty("database.dbname");
    }

    public static String getDbServerName() throws IOException {
        return StandardPropertyLoader.getProperties().getProperty("database.server");
    }

    public static String getDbPort() throws IOException {
        return StandardPropertyLoader.getProperties().getProperty("database.port");
    }

    public static String getDbUserId() throws IOException {
        return StandardPropertyLoader.getProperties().getProperty("database.userid");
    }

    public static String getDbUserPasswd() throws IOException {
        return StandardPropertyLoader.getProperties().getProperty("database.password");
    }

    public static final int getBatchInserts() {
        try {
            String string = StandardPropertyLoader.getProperties().getProperty("batchInserts");
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public static final boolean getDebug() {
        try {
            String string = StandardPropertyLoader.getProperties().getProperty("debug");
            if (string != null && string.compareToIgnoreCase("Y") == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static final int getLogLevel() {
        try {
            String string = StandardPropertyLoader.getProperties().getProperty("logLevel");
            if (string != null && string.compareToIgnoreCase("D") == 0) {
                return 2001;
            }
            if (string != null && string.compareToIgnoreCase("I") == 0) {
                return 2002;
            }
            if (string != null && string.compareToIgnoreCase("W") == 0) {
                return 2003;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 2001;
    }

    public static String getLogdir() throws IOException {
        String string = StandardPropertyLoader.getProperties().getProperty("logdir");
        if (string == null) {
            string = "." + File.separator;
        }
        return BatchUtil.substitute(string, "/", File.separator);
    }

    public static String getCreateDbCommand() throws IOException {
        return StandardPropertyLoader.getProperties().getProperty("createDbCommand");
    }

    public static String getCommandDir() throws IOException {
        return StandardPropertyLoader.getProperties().getProperty("commandDir");
    }

    public static Vector getWebSiteNames() throws IOException {
        String string = StandardPropertyLoader.getProperties().getProperty("websites");
        Vector<String> vector = new Vector<String>();
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    public static String getXmlTemplate(String string) throws IOException {
        String string2 = "";
        string2 = string.compareTo("INFOTIPS") == 0 ? StandardPropertyLoader.getProperties().getProperty("infotips.xmltemplate") : (string.compareTo("IPARTNER") == 0 ? StandardPropertyLoader.getProperties().getProperty("ipartner.xmltemplate") : StandardPropertyLoader.getProperties().getProperty("esupport.xmltemplate"));
        byte[] byArray = new byte[8192];
        InputStream inputStream = ResourceLoader.getInputStream(string2 + "docgen_template.xml");
        int n = inputStream.read(byArray);
        String string3 = new String(byArray, 0, n);
        inputStream.close();
        return string3;
    }

    public static String getHtmlDocOutPath(String string) throws IOException {
        String string2 = "";
        string2 = string.compareTo("INFOTIPS") == 0 ? StandardPropertyLoader.getProperties().getProperty("infotips.html.outpath") : (string.compareTo("IPARTNER") == 0 ? StandardPropertyLoader.getProperties().getProperty("ipartner.html.outpath") : StandardPropertyLoader.getProperties().getProperty("esupport.html.outpath"));
        return BatchUtil.substitute(string2, "/", File.separator);
    }

    public static String getTempFilePath() throws IOException {
        String string = StandardPropertyLoader.getProperties().getProperty("tempPath");
        return BatchUtil.substitute(string, "/", File.separator);
    }

    public static String getGdbmFileOutPath(String string) throws IOException {
        String string2 = "";
        string2 = string.compareTo("INFOTIPS") == 0 ? StandardPropertyLoader.getProperties().getProperty("infotips.gdbm.outpath") : (string.compareTo("IPARTNER") == 0 ? StandardPropertyLoader.getProperties().getProperty("ipartner.gdbm.outpath") : (string.compareTo("ESUPPORT") == 0 ? StandardPropertyLoader.getProperties().getProperty("esupport.gdbm.outpath") : (string.compareTo("ESUPPORT_PROFILE") == 0 ? StandardPropertyLoader.getProperties().getProperty("esupport.profile.gdbm.outpath") : StandardPropertyLoader.getProperties().getProperty("esupport.gdbm.outpath"))));
        return BatchUtil.substitute(string2, "/", File.separator);
    }

    public static String getGdbmFile(int n) throws IOException {
        String string = "";
        switch (n) {
            case 1: {
                string = StandardPropertyLoader.getProperties().getProperty("techtips.gdbm.outpath");
                break;
            }
            case 2: {
                string = StandardPropertyLoader.getProperties().getProperty("bpartner.gdbm.outpath");
                break;
            }
            case 4: {
                string = StandardPropertyLoader.getProperties().getProperty("infotips.gdbm.outpath");
                break;
            }
            case 5: {
                string = StandardPropertyLoader.getProperties().getProperty("ipartner.gdbm.outpath");
                break;
            }
            case 9: {
                string = StandardPropertyLoader.getProperties().getProperty("esupport.profile.gdbm.outpath");
                break;
            }
            default: {
                string = StandardPropertyLoader.getProperties().getProperty("esupport.gdbm.outpath");
                break;
            }
        }
        return BatchUtil.substitute(string, "/", File.separator);
    }

    public static String getGdbmFileName() throws IOException {
        String string = StandardPropertyLoader.getProperties().getProperty("gdbmFile");
        if (string == null) {
            string = "db";
        }
        return string;
    }

    public static String getProfileDbFileName() throws IOException {
        String string = StandardPropertyLoader.getProperties().getProperty("profileDb");
        if (string == null) {
            string = "profile.db";
        }
        return string;
    }

    public static String getXmlDocOutPath(String string) throws IOException {
        String string2 = "";
        string2 = string.compareTo("INFOTIPS") == 0 ? StandardPropertyLoader.getProperties().getProperty("infotips.xml.outpath") : (string.compareTo("IPARTNER") == 0 ? StandardPropertyLoader.getProperties().getProperty("ipartner.xml.outpath") : StandardPropertyLoader.getProperties().getProperty("esupport.xml.outpath"));
        return BatchUtil.substitute(string2, "/", File.separator);
    }

    public static String getFtpHost(String string) throws IOException {
        try {
            if (string.compareTo("INFOTIPS") == 0) {
                return StandardPropertyLoader.getProperties().getProperty("infotips.ftp.host");
            }
            if (string.compareTo("IPARTNER") == 0) {
                return StandardPropertyLoader.getProperties().getProperty("ipartner.ftp.host");
            }
            return StandardPropertyLoader.getProperties().getProperty("esupport.ftp.host");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getXmlFtpHost(String string) throws IOException {
        return BatchInit.getFtpHost(string);
    }

    public static String getFtpHostDir(String string) throws IOException {
        if (string.compareTo("INFOTIPS") == 0) {
            return StandardPropertyLoader.getProperties().getProperty("infotips.ftp.hostdir");
        }
        if (string.compareTo("IPARTNER") == 0) {
            return StandardPropertyLoader.getProperties().getProperty("ipartner.ftp.hostdir");
        }
        return StandardPropertyLoader.getProperties().getProperty("esupport.ftp.hostdir");
    }

    public static String getXmlFtpHostDir(String string) throws IOException {
        if (string.compareTo("INFOTIPS") == 0) {
            return StandardPropertyLoader.getProperties().getProperty("infotips.ftp.xmlhostdir");
        }
        if (string.compareTo("IPARTNER") == 0) {
            return StandardPropertyLoader.getProperties().getProperty("ipartner.ftp.xmlhostdir");
        }
        return StandardPropertyLoader.getProperties().getProperty("esupport.ftp.xmlhostdir");
    }

    public static String getFtpUserId(String string) throws IOException {
        if (string.compareTo("INFOTIPS") == 0) {
            return StandardPropertyLoader.getProperties().getProperty("infotips.ftp.userid");
        }
        if (string.compareTo("IPARTNER") == 0) {
            return StandardPropertyLoader.getProperties().getProperty("ipartner.ftp.userid");
        }
        return StandardPropertyLoader.getProperties().getProperty("esupport.ftp.userid");
    }

    public static String getFtpPassword(String string) throws IOException {
        if (string.compareTo("INFOTIPS") == 0) {
            return StandardPropertyLoader.getProperties().getProperty("infotips.ftp.password");
        }
        if (string.compareTo("IPARTNER") == 0) {
            return StandardPropertyLoader.getProperties().getProperty("ipartner.ftp.password");
        }
        return StandardPropertyLoader.getProperties().getProperty("esupport.ftp.password");
    }

    public static String getHostImageDir(String string) throws IOException {
        if (string.compareTo("INFOTIPS") == 0) {
            return StandardPropertyLoader.getProperties().getProperty("infotips.ftp.imagedir");
        }
        if (string.compareTo("IPARTNER") == 0) {
            return StandardPropertyLoader.getProperties().getProperty("ipartner.ftp.imagedir");
        }
        return StandardPropertyLoader.getProperties().getProperty("esupport.ftp.imagedir");
    }

    public static String getLocalImageDir(String string) throws IOException {
        return Constants.getStrConst("IMAGELOC_" + string);
    }

    public static int getSiteType(String string) throws IOException {
        if ("ESUPPORT".compareToIgnoreCase(string) == 0) {
            return 3;
        }
        if ("INFOTIPS".compareToIgnoreCase(string) == 0) {
            return 4;
        }
        if ("IPARTNER".compareToIgnoreCase(string) == 0) {
            return 5;
        }
        if ("ESUPPORT_PROFILE".compareToIgnoreCase(string) == 0) {
            return 9;
        }
        return 3;
    }

    public static String getSiteName(int n) throws IOException {
        switch (n) {
            case 4: {
                return "INFOTIPS";
            }
            case 5: {
                return "IPARTNER";
            }
            case 3: {
                return "ESUPPORT";
            }
            case 9: {
                return "ESUPPORT_PROFILE";
            }
        }
        return "AllSite";
    }

    public static String getDocgenFullUpdate() throws IOException {
        String string = StandardPropertyLoader.getProperties().getProperty("fullUpdate");
        if (string == null) {
            return "false";
        }
        return string;
    }

    public static String getDocgenPublishNow() throws IOException {
        String string = StandardPropertyLoader.getProperties().getProperty("publishNow");
        if (string == null) {
            return "false";
        }
        return string;
    }

    public static int getLangInd() {
        return 1;
    }

    public static String getAppName(String string) throws IOException {
        String string2 = StandardPropertyLoader.getProperties().getProperty(string + ".AppName");
        if (string2 == null) {
            string2 = string;
            BatchUtil.logit("Property appName not found, using appNameKey", 2003, 0);
        }
        return string2;
    }

    public static long getAppMaxSleepTime(String string) throws IOException {
        String string2 = StandardPropertyLoader.getProperties().getProperty(string + ".maxsleep");
        long l = 3600000L;
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    public static int getAppRunTimeRec(String string) throws IOException {
        return 0;
    }
}

