/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.batch;

import com.ibm.appsure.AppSure;
import com.ibm.appsure.AppSureException;
import com.ibm.nzna.projects.batch.BatchInit;
import com.ibm.nzna.projects.batch.Constants;
import com.ibm.nzna.projects.batch.WebSite;
import com.ibm.nzna.projects.batch.event.BatchEvent;
import com.ibm.nzna.projects.batch.event.DocsEvent;
import com.ibm.nzna.projects.batch.exception.BatchException;
import com.ibm.nzna.projects.batch.intf.DocgenIntf;
import com.ibm.nzna.projects.batch.utils.BatchUtil;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentReader;
import com.ibm.nzna.shared.batch.Batch;
import com.ibm.nzna.shared.batch.BatchListener;
import com.ibm.nzna.shared.batch.BatchLogSystem;
import com.ibm.nzna.shared.db.Database;
import com.ibm.nzna.shared.db.DatabaseStatusListener;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.DatabaseSystemListener;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.StandardPropertyLoader;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public class Docgen
extends Batch
implements DatabaseStatusListener,
DatabaseSystemListener {
    private static boolean publishNow = false;
    public static String docgen_app_name = "";
    private Connection conn = null;
    private DatabaseSystem dbs = null;
    private Vector website = new Vector();

    public static boolean getPublishNow() throws IOException {
        String string = BatchInit.getDocgenPublishNow();
        publishNow = string != null && string.compareTo("true") == 0;
        return publishNow;
    }

    public boolean getFullUpdate() throws IOException {
        return BatchInit.getDocgenFullUpdate().compareTo("true") == 0;
    }

    public String getChangedTime(Connection connection) throws BatchException, SQLException, IOException {
        if (this.getFullUpdate()) {
            return "1980-01-01-00.00.00.000000";
        }
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT min(strconst) FROM tigris.constants WHERE constant = 'TS_DOCGEN_ESUPPORT'  OR   constant = 'TS_DOCGEN_IPARTNER'  OR   constant = 'TS_DOCGEN_INFOTIPS' FOR FETCH ONLY");
        if (resultSet.next()) {
            String string = resultSet.getString(1).trim();
            resultSet.close();
            statement.close();
            return string;
        }
        throw new BatchException("Get last docgen update timestamp error. ", 2004);
    }

    public void startDocgenBatch() throws Exception, AppSureException {
        super.startBatch();
        String string = BatchInit.getLogdir();
        if (Docgen.getPublishNow()) {
            docgen_app_name = BatchInit.getAppName("DocGenPubNow");
            BatchInit.logSystem = new BatchLogSystem(string + docgen_app_name, this);
            BatchUtil.logit("LogSystem created for application " + docgen_app_name, 2002, 0);
        } else {
            docgen_app_name = BatchInit.getAppName("DocGen");
            BatchInit.logSystem = new BatchLogSystem(string + docgen_app_name, this);
            BatchUtil.logit("LogSystem created for application " + docgen_app_name, 2002, 0);
        }
        this.dbs = new DatabaseSystem(Constants.debug, BatchInit.logSystem, true);
        DatabaseSystem.addStatusListener(this);
        DatabaseSystem.addDatabaseSystemListener(this);
        if (!DatabaseSystem.createConnection(1, BatchInit.getDbName(), BatchInit.getDbServerName(), BatchInit.getDbPort(), BatchInit.getDbUserId(), BatchInit.getDbUserPasswd())) {
            throw new BatchException("DocGen terminating. Database connection failed, \n" + "  Name: " + BatchInit.getDbName() + "\n" + "  Server: " + BatchInit.getDbServerName() + "\n" + "  Port: " + BatchInit.getDbPort() + "\n" + "  User: " + BatchInit.getDbUserId(), 2005);
        }
        BatchUtil.logit("DatabaseSystem connection created: \n" + "  Name: " + BatchInit.getDbName() + "\n" + "  Server: " + BatchInit.getDbServerName() + "\n" + "  Port: " + BatchInit.getDbPort() + "\n" + "  User: " + BatchInit.getDbUserId(), 2002, 0);
        this.conn = DatabaseSystem.getConnection(1);
        BatchInit.appSure = new AppSure();
        if (!BatchInit.appSure.startApp(this.conn, docgen_app_name)) {
            BatchUtil.logit("AppSure startApp() returned false for " + docgen_app_name + ". Maybe another instance is running.", 2003, 0);
            throw new AppSureException("AppSure startApp() docgen failed");
        }
        BatchUtil.logit("AppSure started for appcode " + docgen_app_name, 2002, 0);
        BatchUtil.logit("Checking if " + docgen_app_name + " is allowed to run", 2002, 0);
        if (!Docgen.isDocgenOkToRun(BatchInit.appSure)) {
            if (Docgen.getPublishNow()) {
                BatchUtil.logit("DocGen PublishNow stopped: Daily Docgen or Navgen not finished", 2002, 0);
            } else {
                BatchUtil.logit("DocGen stopped: Navgen not finished", 2003, 0);
            }
            this.stopBatch(0);
        }
        BatchUtil.logit(docgen_app_name + " is allowed to execute", 2002, 0);
        com.ibm.nzna.projects.common.quest.Constants.refreshConstants(BatchInit.logSystem);
        String string2 = "";
        Vector vector = BatchInit.getWebSiteNames();
        int n = 0;
        while (n < vector.size()) {
            String string3 = (String)vector.elementAt(n);
            this.website.add(new WebSite(this.conn, BatchInit.getSiteType(string3), string3, BatchInit.getLangInd()));
            string2 = string2 + string3 + " ";
            ++n;
        }
        if (this.website.size() == 0) {
            BatchUtil.logit("No website created ", 2003, 0);
        } else {
            BatchUtil.logit("Websites created for " + string2, 2002, 0);
        }
        if (this.initPlugin() == 0) {
            BatchUtil.logit("No loadable plugins found", 2003, 0);
        }
    }

    public void databaseAdded(Database database) {
    }

    public void databaseRemoved(Database database) {
    }

    public void methodAdded(Database database, SQLMethod sQLMethod) {
    }

    public void methodRemoved(Database database, SQLMethod sQLMethod) {
    }

    public void databaseStatusChange(int n, Database database) {
    }

    public void stopBatch(int n) {
        super.stopBatch();
        if (BatchInit.appSure != null) {
            try {
                BatchInit.appSure.shutDown(BatchLogSystem.getErrorFile(), null);
            }
            catch (AppSureException appSureException) {
                BatchUtil.logit("Appsure shut down failed: " + appSureException, 2004, 0);
                appSureException.printStackTrace();
            }
        }
        BatchUtil.logit("****************************************************", 2002, 0);
        BatchUtil.logit("*     " + docgen_app_name + " Error Stat ", 2002, 0);
        BatchUtil.logit("****************************************************", 2002, 0);
        BatchUtil.logit("Total Warnings: " + BatchInit.batchWarning, 2002, 0);
        BatchUtil.logit("Total Errors:   " + BatchInit.batchError, 2002, 0);
        BatchUtil.logit("Total Fatals:   " + BatchInit.batchFatal, 2002, 0);
        System.exit(n);
    }

    public int initPlugin() throws Exception {
        int n = 0;
        String string = BatchInit.getPlugins();
        BatchUtil.logit("Loading plugins for " + string, 2002, 0);
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = 0;
                while (n2 < this.website.size()) {
                    WebSite webSite = (WebSite)this.website.elementAt(n2);
                    if (string2.indexOf("XmlDocgen") == -1 || webSite.getSiteName().compareTo("ESUPPORT") == 0) {
                        try {
                            Object obj = Class.forName(string2).newInstance();
                            if (obj instanceof DocgenIntf && obj instanceof BatchListener) {
                                ((DocgenIntf)obj).init(webSite, this.conn);
                                this.addBatchListener((BatchListener)obj);
                                ++n;
                                BatchUtil.logit("  Added plugin " + string2 + " for " + webSite.getSiteName(), 2002, 0);
                            } else {
                                BatchUtil.logit("  Plugin " + string2 + " not loaded: not a docgen listener", 2002, 0);
                            }
                        }
                        catch (Exception exception) {
                            BatchUtil.logit("  Plugin " + string2 + " not loaded: " + exception, 2003, 0);
                        }
                    }
                    ++n2;
                }
            }
        } else {
            BatchUtil.logit("  No Docgen plugin found. Plugins not loaded ", 2002, 0);
        }
        return n;
    }

    public void fireBatchEvent(BatchEvent batchEvent) throws BatchException, IOException, SQLException {
        Vector vector = this.getBatchListeners();
        if (vector != null) {
            Object[] objectArray = vector.toArray();
            int n = 0;
            while (n < objectArray.length) {
                try {
                    if (objectArray[n] instanceof DocgenIntf) {
                        switch (batchEvent.getID()) {
                            case 1001: {
                                ((DocgenIntf)objectArray[n]).processDocs((DocsEvent)batchEvent);
                                break;
                            }
                            case 1002: {
                                ((DocgenIntf)objectArray[n]).finishDocs();
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    BatchUtil.logit("  Plugin " + objectArray[n].toString() + " failed to process event" + batchEvent.getID() + ". Exception: " + exception, 2004, 0);
                }
                ++n;
            }
        }
    }

    public static DocsEvent createDocsEvent(Connection connection, Object object, int n, int n2, int n3, int n4, int n5) throws Exception {
        Document document = new Document(n2);
        int n6 = 0;
        boolean bl = false;
        try {
            n6 = DocumentReader.readDocument(connection, document);
            BatchUtil.logit("Read document " + document.getFilename() + " docind " + n2 + " doctype " + n3, 2002, 0);
        }
        catch (Exception exception) {
            BatchUtil.logit("Reading document " + document.getFilename() + " docind " + n2 + " failed " + exception, 2004, 0);
            return null;
        }
        return new DocsEvent(object, n, document, n3, n4, n5);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isDocgenOkToRun(AppSure var0) throws IOException, AppSureException {
        var1_1 = BatchInit.getAppName("NavGen");
        var2_2 = BatchInit.getAppMaxSleepTime("DocGen");
        var4_3 = 0L;
        if (!Docgen.getPublishNow()) ** GOTO lbl26
        if (var0.isAppRunning(var1_1)) {
            BatchUtil.logit("  Navgen running ", 2002, 0);
            return false;
        }
        if (var0.isAppRunning(BatchInit.getAppName("DocGen"))) {
            BatchUtil.logit("  Docgen running ", 2002, 0);
            return false;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (var0.isAppRunning(var1_1)) {
                BatchUtil.logit("  DocGen waiting for Navgen finishing. Checking back in 30 seconds ...", 2002, 0);
            } else {
                BatchUtil.logit("  DocGen waiting for PublishNow finishing. Checking back in 30 seconds ...", 2002, 0);
            }
            if (var4_3 > var2_2) {
                BatchUtil.logit("DocGen max waiting " + var2_2 + " exceeded.", 2004, 0);
                return false;
            }
            try {
                Thread.sleep(30000L);
                var4_3 += 30000L;
                continue;
            }
            catch (InterruptedException var6_4) {
                BatchUtil.logit("DocGen waiting interrupted: " + var6_4, 2004, 0);
                return false;
            }
lbl26:
            // 2 sources

            ** while (var0.isAppRunning((String)var1_1) || var0.isAppRunning((String)BatchInit.getAppName((String)"DocGenPubNow")))
        }
lbl27:
        // 1 sources

        return true;
    }

    public void docgen_main(String[] stringArray) {
        try {
            String string = File.separator;
            new StandardPropertyLoader("com" + string + "ibm" + string + "nzna" + string + "properties" + string + "batch" + string + "docgen.properties", stringArray);
            this.startDocgenBatch();
            int n = 0;
            if (Docgen.getPublishNow()) {
                BatchUtil.logit("PublishNow publishing starts ", 2002, 0);
                Statement statement = this.conn.createStatement();
                Vector<String> vector = new Vector<String>();
                ResultSet resultSet = statement.executeQuery("SELECT distinct pnow.docind, d.doctypeind, d.docclassind, d.changedtime, d.webable, d.show, d.publish FROM tigris.documents d, tigris.publishnow pnow WHERE d.docind = pnow.docind FOR FETCH ONLY");
                while (resultSet.next()) {
                    DocsEvent docsEvent = Docgen.createDocsEvent(this.conn, this, 1001, resultSet.getInt(1), resultSet.getInt(2), resultSet.getInt(3), 0);
                    if (docsEvent == null) continue;
                    docsEvent.setChangedSince(BatchUtil.substitute(resultSet.getString(4).trim(), " ", "-"));
                    docsEvent.webable = resultSet.getString(5).compareToIgnoreCase("Y") == 0;
                    docsEvent.show = resultSet.getString(6).compareToIgnoreCase("Y") == 0;
                    docsEvent.publish = resultSet.getString(7).compareToIgnoreCase("Y") == 0;
                    this.fireBatchEvent(docsEvent);
                    vector.add(Integer.toString(resultSet.getInt(1)));
                    ++n;
                }
                this.fireBatchEvent(new DocsEvent(this, 1002, null, 0, 0, 0));
                BatchUtil.logit("Documents finished ", 2002, 0);
                if (n > 0) {
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        resultSet = statement.executeQuery("DELETE FROM tigris.publishnow pnow " + "WHERE pnow.docind = " + (String)vector.elementAt(n2));
                        ++n2;
                    }
                }
                resultSet.close();
                statement.close();
            } else {
                BatchUtil.logit("Document publishing starts for documents changed since " + this.getChangedTime(this.conn), 2002, 0);
                Statement statement = this.conn.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT distinct " + "d.docind, " + "d.doctypeind, " + "d.docclassind, " + "d.changedtime, " + "d.webable, " + "d.show, " + "d.publish " + "FROM tigris.documents d " + "WHERE  " + " d.changedtime > '" + this.getChangedTime(this.conn) + "' " + "FOR FETCH ONLY");
                while (resultSet.next()) {
                    DocsEvent docsEvent = Docgen.createDocsEvent(this.conn, this, 1001, resultSet.getInt(1), resultSet.getInt(2), resultSet.getInt(3), 0);
                    if (docsEvent != null) {
                        docsEvent.setChangedSince(BatchUtil.substitute(resultSet.getString(4).trim(), " ", "-"));
                        docsEvent.webable = resultSet.getString(5).compareToIgnoreCase("Y") == 0;
                        docsEvent.show = resultSet.getString(6).compareToIgnoreCase("Y") == 0;
                        docsEvent.publish = resultSet.getString(7).compareToIgnoreCase("Y") == 0;
                        this.fireBatchEvent(docsEvent);
                        ++n;
                    }
                    if (!Constants.debug || n != 10) continue;
                    BatchUtil.logit("Published first " + n + " documents", 2001, 0);
                    break;
                }
                this.fireBatchEvent(new DocsEvent(this, 1002, null, 0, 0, 0));
                BatchUtil.logit("Document publishing finished ", 2002, 0);
                resultSet.close();
                statement.close();
            }
        }
        catch (BatchException batchException) {
            BatchUtil.logit(docgen_app_name + " failed due to Application error. ", batchException, 2005, 0);
            batchException.printStackTrace();
            this.stopBatch(1);
        }
        catch (AppSureException appSureException) {
            BatchUtil.logit(docgen_app_name + " failed due to AppSure exception. " + appSureException, 2005, 0);
            appSureException.printStackTrace();
            this.stopBatch(2);
        }
        catch (SQLException sQLException) {
            BatchUtil.logit(docgen_app_name + " failed due to sql exception ", sQLException, 2005, 0);
            sQLException.printStackTrace();
            this.stopBatch(3);
        }
        catch (Exception exception) {
            BatchUtil.logit(docgen_app_name + " failed due to unknown exception ", exception, 2005, 0);
            exception.printStackTrace();
            this.stopBatch(4);
        }
        this.stopBatch(0);
    }

    public static void main(String[] stringArray) {
        Docgen docgen = new Docgen();
        docgen.docgen_main(stringArray);
    }
}

