/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.batch.plugin;

import com.ibm.nzna.projects.batch.BatchInit;
import com.ibm.nzna.projects.batch.BrandFamily;
import com.ibm.nzna.projects.batch.CategoryRec;
import com.ibm.nzna.projects.batch.Constants;
import com.ibm.nzna.projects.batch.Navgen;
import com.ibm.nzna.projects.batch.ProductDate;
import com.ibm.nzna.projects.batch.WebSite;
import com.ibm.nzna.projects.batch.event.BatchEvent;
import com.ibm.nzna.projects.batch.event.BrandFamilyEvent;
import com.ibm.nzna.projects.batch.event.DocCategoryEvent;
import com.ibm.nzna.projects.batch.event.DocsEvent;
import com.ibm.nzna.projects.batch.event.MkEvent;
import com.ibm.nzna.projects.batch.event.ProdEvent;
import com.ibm.nzna.projects.batch.exception.BatchException;
import com.ibm.nzna.projects.batch.exception.CreateDbCommandException;
import com.ibm.nzna.projects.batch.exception.WriteGdbmException;
import com.ibm.nzna.projects.batch.intf.NavgenIntf;
import com.ibm.nzna.projects.batch.plugin.BFMModelKey;
import com.ibm.nzna.projects.batch.plugin.BFMachineKey;
import com.ibm.nzna.projects.batch.plugin.BrandFamilyKey;
import com.ibm.nzna.projects.batch.plugin.BrandKey;
import com.ibm.nzna.projects.batch.plugin.BuildProfileDb;
import com.ibm.nzna.projects.batch.plugin.DocTypeCatKey;
import com.ibm.nzna.projects.batch.utils.BatchUtil;
import com.ibm.nzna.shared.batch.BatchListener;
import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.util.CDate;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class BuildDb2
implements BatchListener,
NavgenIntf {
    public static final int INDEX_NOT_FOUND = -100;
    public static final int ALL_CATEGORY = -1;
    public static final int HOTNEWS_DOCTYPE = -2;
    public static final String HOT_NEWS = "Hot news";
    public static final String FAQ = "Frequently asked questions";
    private static TreeSet prodSet = null;
    private static DocTypeCatKey hotNewsKey = new DocTypeCatKey(-2, -1);
    private static Vector rootHotnewsVec = null;
    private WebSite website = null;
    private Connection conn = null;
    private BrandFamily brandFamilies = null;
    private Vector allDocTypes = new Vector();
    private Object[] allDocCategories = null;
    private int prevDocInd = 0;
    private String prevMachine = "";
    private String tmspBefore = null;
    private String dbFileName = null;
    private int docIndCount = 0;
    private TreeSet docLessSet = null;

    public void logError(String string) {
    }

    public void logSevereError(String string) {
    }

    public void logSevereError(Exception exception) {
    }

    public void logProgress(String string, int n, int n2) {
    }

    public void batchStart() {
    }

    public void batchStop() {
    }

    public void stopNavgen(int n) throws BatchException {
        BatchUtil.logit("Navgen stopping for website " + this.website.getSiteName(), 2002, 0);
    }

    public void init(WebSite webSite, Connection connection) throws BatchException {
        this.website = webSite;
        this.conn = connection;
        this.allDocTypes = this.website.getDocTypes();
        boolean bl = false;
        int n = this.allDocTypes.size();
        int n2 = 0;
        while (n2 < n) {
            if (HOT_NEWS.compareTo(((CategoryRec)this.allDocTypes.elementAt(n2)).toString()) < 0) {
                this.allDocTypes.insertElementAt(new CategoryRec(-2, HOT_NEWS, 0), n2);
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            this.allDocTypes.add(new CategoryRec(-2, HOT_NEWS, 0));
        }
        Calendar calendar = Calendar.getInstance();
        this.tmspBefore = BatchUtil.getDb2Timestamp(calendar);
        try {
            this.dbFileName = BatchInit.getGdbmFile(this.website.getSiteType()) + BatchInit.getGdbmFileName();
        }
        catch (Exception exception) {
            BatchUtil.logit("Could not find db file name for websie " + this.website.getSiteName(), 2003, 0);
            this.dbFileName = "./db";
        }
        if (this.website.getSiteName().compareToIgnoreCase("INFOTIPS") != 0) {
            this.docLessSet = new TreeSet();
        } else {
            rootHotnewsVec = new Vector();
        }
        if (this.website.getSiteName().compareToIgnoreCase("ESUPPORT") == 0) {
            BatchUtil.logit("Saving static key-val for website " + this.website.getSiteName(), 2002, 0);
            this.defineStaticPages(connection);
            prodSet = new TreeSet();
        }
    }

    public void brandFamilySet(BatchEvent batchEvent) throws BatchException {
        this.brandFamilies = ((BrandFamilyEvent)batchEvent).getBrandFamilies();
    }

    public void docCategorySet(DocCategoryEvent docCategoryEvent) throws BatchException {
        this.allDocCategories = docCategoryEvent.getDocCategory().toArray();
        if (Constants.debug) {
            // empty if block
        }
    }

    public void processMk(MkEvent mkEvent) throws BatchException {
        if (mkEvent.mkKey != null && mkEvent.mkVal != null) {
            BuildDb2.writeGdbm(this.conn, mkEvent.mkKey, mkEvent.mkVal, this.dbFileName);
        }
    }

    public void finishDocs() throws BatchException, IOException, SQLException {
        BatchUtil.logit("Finished adding docs and start saving prod-docs for " + this.website.getSiteName(), 2002, 0);
        Set set = Navgen.prodDocsMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (this.website.getSiteName().compareTo("INFOTIPS") != 0 && prodSet != null && !prodSet.contains(k)) continue;
            if (k instanceof BFMModelKey) {
                BatchUtil.logit("Saving model key for " + this.website.getSiteName(), 2001, 0);
                this.saveModel(this.conn, (BFMModelKey)k);
                continue;
            }
            if (k instanceof BFMachineKey) {
                BatchUtil.logit("Saving machine key for " + this.website.getSiteName(), 2001, 0);
                this.saveMachine(this.conn, (BFMachineKey)k);
                continue;
            }
            if (k instanceof BrandFamilyKey) {
                BatchUtil.logit("Saving family key for " + this.website.getSiteName(), 2001, 0);
                this.saveFamily(this.conn, (BrandFamilyKey)k);
                continue;
            }
            if (k instanceof BrandKey) {
                BatchUtil.logit("Saving brand key for " + this.website.getSiteName(), 2001, 0);
                this.saveBrand(this.conn, (BrandKey)k);
                continue;
            }
            BatchUtil.logit("The prodDocsMap key " + k.toString() + " is not a bfmm type key. No action taken", 2003, 0);
        }
        BatchUtil.logit("Saving root key for " + this.website.getSiteName(), 2001, 0);
        this.saveRoot(this.conn, this.brandFamilies.getBrandSet());
    }

    private int findDocCatIndex(String string) {
        int n = 0;
        while (n < this.allDocCategories.length) {
            if (string.compareTo((String)this.allDocCategories[n]) == 0) {
                return n;
            }
            ++n;
        }
        return -100;
    }

    public void processDocs(DocsEvent docsEvent) throws BatchException, SQLException {
        Object object;
        Object object2;
        if (docsEvent.getDocClassind() < this.website.getMiniClassification()) {
            BatchUtil.logit("Docind " + docsEvent.getDocind() + " classified for " + this.website.getSiteName() + ". Not added", 2002, 0);
            this.docLessSet.add(docsEvent.getFilename());
            return;
        }
        BatchUtil.logit("Saving doc-3 key for " + this.website.getSiteName(), 2001, 0);
        this.saveFileName(this.conn, docsEvent);
        BatchUtil.logit("Saving doc-4 key for " + this.website.getSiteName(), 2001, 0);
        this.saveDocID(this.conn, docsEvent);
        BatchUtil.logit("Saving doc-5 key for " + this.website.getSiteName(), 2001, 0);
        this.saveDocID2(this.conn, docsEvent);
        if (this.website.getSiteName().compareToIgnoreCase("INFOTIPS") != 0) {
            return;
        }
        int n = docsEvent.getDocind();
        int n2 = docsEvent.getDocumentType();
        int n3 = -100;
        this.docIndCount = n;
        Vector vector = docsEvent.typevec;
        int n4 = 0;
        while (n4 < vector.size()) {
            object2 = (CategoryRec)vector.elementAt(n4);
            object = ((CategoryRec)object2).getCategoryLevel();
            if (((String)object).compareToIgnoreCase("doccategory") == 0 && (n3 = this.findDocCatIndex(((CategoryRec)object2).getDescript())) != -100) break;
            ++n4;
        }
        BatchUtil.logit("Adding docind " + n, 2002, 0);
        BatchUtil.logit("Obtained docCatInd " + n3 + " and docTypeInd " + n2 + " for docind " + n, 2001, 0);
        if (n3 == -100) {
            BatchUtil.logit("Document catInd not found for docind " + n, 2004, 0);
        } else if (n2 == 0) {
            BatchUtil.logit("Document typeInd not found for docind " + n, 2004, 0);
        }
        BatchUtil.logit("    ", 2001, 0);
        BatchUtil.logit("Starting adding doc to all levels: docind " + n + " . Size of typevec " + vector.size(), 2001, 0);
        DocTypeCatKey docTypeCatKey = new DocTypeCatKey(n2, n3);
        object2 = new DocTypeCatKey(n2, -1);
        object = new Vector();
        ((Vector)object).add(docTypeCatKey);
        ((Vector)object).add(object2);
        if (docsEvent.getHotNews()) {
            ((Vector)object).add(new DocTypeCatKey(-2, -1));
            rootHotnewsVec.add(docsEvent.getFilename());
        }
        String string = docsEvent.getFilename();
        int n5 = vector.size();
        int n6 = 0;
        while (n6 < n5) {
            int n7;
            Object object3;
            CategoryRec categoryRec = (CategoryRec)vector.elementAt(n6);
            String string2 = categoryRec.getCategoryLevel();
            int n8 = categoryRec.getInd();
            if (string2.compareTo("family") == 0) {
                BatchUtil.logit("Adding family for docind " + n, 2001, 0);
                object3 = this.brandFamilies.getBrandRec(n8);
                if (object3 != null) {
                    n7 = 0;
                    int n9 = ((CategoryRec)object3).getInd();
                    BrandFamilyKey brandFamilyKey = new BrandFamilyKey(n9, n8);
                    n7 += this.addLevelDoc((Vector)object, brandFamilyKey, docsEvent);
                    n7 += this.addLevelDoc((Vector)object, new BrandKey(n9), docsEvent);
                    n7 += this.addFamilyChildDoc((Vector)object, n9, n8, docsEvent);
                } else {
                    BatchUtil.logit("Brand not found for family " + n8 + " while process doc " + string, 2003, 0);
                }
            } else if (string2.compareTo("machine") == 0 || string2.compareTo("subcategory") == 0) {
                BatchUtil.logit("Adding machine/family type for docind " + n, 2001, 0);
                object3 = (BrandFamilyKey)Navgen.machineParentMap.get(new Integer(n8));
                if (object3 != null) {
                    n7 = 0;
                    BFMachineKey bFMachineKey = new BFMachineKey(((BrandFamilyKey)object3).brandInd, ((BrandFamilyKey)object3).familyInd, categoryRec.getDescript());
                    n7 += this.addLevelDoc((Vector)object, bFMachineKey, docsEvent);
                    n7 += this.addLevelDoc((Vector)object, object3, docsEvent);
                    n7 += this.addLevelDoc((Vector)object, new BrandKey(((BrandFamilyKey)object3).brandInd), docsEvent);
                    n7 += this.addMachineChildDoc((Vector)object, ((BrandFamilyKey)object3).brandInd, ((BrandFamilyKey)object3).familyInd, categoryRec.getDescript(), docsEvent);
                } else {
                    BatchUtil.logit("Brand, family not found for machine " + categoryRec.getDescript() + " (" + n8 + ") " + " while process doc " + string, 2003, 0);
                }
            } else if (string2.compareTo("model") == 0 || string2.compareTo("partnum") == 0) {
                BatchUtil.logit("Adding model/partnum for docind " + n, 2001, 0);
                object3 = (BFMachineKey)Navgen.modelParentMap.get(new Integer(n8));
                if (object3 != null) {
                    n7 = 0;
                    BFMModelKey bFMModelKey = new BFMModelKey(((BFMachineKey)object3).brandInd, ((BFMachineKey)object3).familyInd, ((BFMachineKey)object3).machine, categoryRec.getDescript());
                    n7 += this.addLevelDoc((Vector)object, bFMModelKey, docsEvent);
                    n7 += this.addLevelDoc((Vector)object, object3, docsEvent);
                    n7 += this.addLevelDoc((Vector)object, new BrandFamilyKey(((BFMachineKey)object3).brandInd, ((BFMachineKey)object3).familyInd), docsEvent);
                    n7 += this.addLevelDoc((Vector)object, new BrandKey(((BFMachineKey)object3).brandInd), docsEvent);
                } else {
                    BatchUtil.logit("Brand, family, machine not found for model " + categoryRec.getDescript() + " (" + n8 + ") " + "while process doc " + string, 2003, 0);
                }
            }
            ++n6;
        }
    }

    private int addLevelDoc(Vector vector, Object object, DocsEvent docsEvent) throws BatchException {
        int n = 0;
        if (object.toString().indexOf("-All") != -1) {
            BatchUtil.logit("  The docId " + docsEvent.getFilename() + " not added because it has a level of All " + object.toString(), 2001, 0);
            return n;
        }
        Hashtable hashtable = (Hashtable)Navgen.prodDocsMap.get(object);
        if (hashtable != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                ++n;
                DocTypeCatKey docTypeCatKey = (DocTypeCatKey)vector.elementAt(n2);
                Vector vector2 = (Vector)hashtable.get(docTypeCatKey);
                if (vector2 == null) {
                    Vector<String> vector3 = new Vector<String>();
                    vector3.add(docsEvent.getFilename());
                    hashtable.put(docTypeCatKey, vector3);
                } else if (!vector2.contains(docsEvent.getFilename())) {
                    vector2.add(docsEvent.getFilename());
                }
                ++n2;
            }
        } else {
            BatchUtil.logit("Document " + docsEvent.getFilename() + " associated to the level " + object.toString() + " having no corresponding product. Not added.", 2003, 0);
        }
        return n;
    }

    private int addFamilyChildDoc(Vector vector, int n, int n2, DocsEvent docsEvent) throws BatchException {
        int n3 = 0;
        BrandFamilyKey brandFamilyKey = new BrandFamilyKey(n, n2);
        TreeSet treeSet = (TreeSet)Navgen.familyChildMap.get(brandFamilyKey);
        if (treeSet != null) {
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                CategoryRec categoryRec = (CategoryRec)iterator.next();
                BFMachineKey bFMachineKey = new BFMachineKey(n, n2, categoryRec.getDescript());
                n3 += this.addLevelDoc(vector, bFMachineKey, docsEvent);
                n3 += this.addMachineChildDoc(vector, n, n2, categoryRec.toString(), docsEvent);
            }
        } else {
            BatchUtil.logit("No child found in familyChildMap for bfKey " + brandFamilyKey.toString(), 2003, 0);
        }
        return n3;
    }

    private int addMachineChildDoc(Vector vector, int n, int n2, String string, DocsEvent docsEvent) throws BatchException {
        int n3 = 0;
        BFMachineKey bFMachineKey = new BFMachineKey(n, n2, string);
        TreeSet treeSet = (TreeSet)Navgen.machineChildMap.get(bFMachineKey);
        if (treeSet != null) {
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                CategoryRec categoryRec = (CategoryRec)iterator.next();
                BFMModelKey bFMModelKey = new BFMModelKey(n, n2, string, categoryRec.getDescript());
                n3 += this.addLevelDoc(vector, bFMModelKey, docsEvent);
            }
        } else {
            BatchUtil.logit("No child found in machineChildMap for bfmKey " + bFMachineKey.toString(), 2003, 0);
        }
        return n3;
    }

    public void finishProd() throws BatchException {
        BatchUtil.logit("Finishing process prod ", 2002, 0);
        if (this.website.getSiteName().compareTo("ESUPPORT") == 0) {
            BatchUtil.logit("Start saving profile key-val ", 2002, 0);
            BuildProfileDb buildProfileDb = new BuildProfileDb(this.conn, 9, this);
            buildProfileDb.saveBrandDisplay();
            buildProfileDb.saveBrandKeys(Navgen.brandSet, Navgen.brandChildMap, Navgen.familyChildMap, Navgen.machineChildMap, Navgen.productMap);
        }
    }

    public boolean isValid(WebSite webSite, ProdEvent prodEvent) {
        if (webSite.getSiteName().compareToIgnoreCase("INFOTIPS") == 0) {
            return true;
        }
        if (prodEvent.datesvec != null) {
            int n = 0;
            while (n < prodEvent.datesvec.size()) {
                ProductDate productDate = (ProductDate)prodEvent.datesvec.elementAt(n);
                if (productDate.typedateind == 2) {
                    CDate cDate;
                    String string;
                    String string2;
                    BatchUtil.logit("actual anno=" + productDate.actual_announce, 2001, 0);
                    if (productDate.actual_announce.compareToIgnoreCase("NULL") != 0 && CDate.compareDate(string2 = CDate.addDaysToDate(string = (cDate = new CDate()).getDate(10), 1, 10), productDate.actual_announce, 10) >= 0) {
                        return true;
                    }
                }
                ++n;
            }
        }
        BatchUtil.logit("Can not find information to valid Product " + prodEvent.getProductInd() + " for " + webSite.getSiteName() + ". Not published", 2003, 0);
        return false;
    }

    public void processProd(ProdEvent prodEvent) throws BatchException {
        String string;
        String string2;
        BatchUtil.logit("Processing product " + prodEvent.getProductInd() + " for " + this.website.getSiteName(), 2002, 0);
        if (prodSet != null && this.website.getSiteName().compareTo("ESUPPORT") == 0) {
            prodSet.add(new BrandKey(prodEvent.brandInd));
            prodSet.add(new BrandFamilyKey(prodEvent.brandInd, prodEvent.familyInd));
            prodSet.add(new BFMachineKey(prodEvent.brandInd, prodEvent.familyInd, prodEvent.machine));
            prodSet.add(new BFMModelKey(prodEvent.brandInd, prodEvent.familyInd, prodEvent.machine, prodEvent.model));
        }
        boolean bl = false;
        if (prodEvent.brand.indexOf("IBM Options") != -1) {
            bl = true;
        }
        if (prodEvent.machine != "All" && prodEvent.model != "All" && !bl) {
            string2 = prodEvent.machine + '-' + prodEvent.model;
            string = "realpage" + "\\0" + prodEvent.brand + '|' + prodEvent.family + '|' + prodEvent.machine + '|' + prodEvent.model + "\\0" + "family" + "\\0" + prodEvent.family + "\\0";
            BuildDb2.writeGdbm(this.conn, string2, string, this.dbFileName);
        }
        if (!(prodEvent.machine == "All" || bl || this.prevMachine.length() != 0 && this.prevMachine.compareTo(prodEvent.machine) == 0)) {
            string2 = prodEvent.machine;
            string = "realpage" + "\\0" + prodEvent.brand + '|' + prodEvent.family + '|' + prodEvent.machine + "\\0";
            BuildDb2.writeGdbm(this.conn, string2, string, this.dbFileName);
            this.prevMachine = prodEvent.machine;
        }
    }

    private int getDocTypeCat(Hashtable hashtable, Vector vector, TreeMap treeMap, TreeMap treeMap2, Object object) {
        int n = 0;
        BatchUtil.logit("GetDocTypeCat(): level key is " + ((BrandKey)object).toString(), 2001, 0);
        BrandKey brandKey = new BrandKey(((BrandKey)object).brandInd);
        Vector vector2 = null;
        int n2 = 0;
        while (n2 < this.allDocTypes.size()) {
            CategoryRec categoryRec = (CategoryRec)this.allDocTypes.elementAt(n2);
            String string = categoryRec.toString();
            if (string.compareTo(HOT_NEWS) == 0) {
                vector2 = (Vector)hashtable.get(hotNewsKey);
                if (vector2 != null) {
                    vector.add(string);
                }
            } else {
                Object object2;
                Vector<Object> vector3 = new Vector<Object>();
                boolean bl = false;
                int n3 = 0;
                while (n3 < this.allDocCategories.length) {
                    object2 = (String)this.allDocCategories[n3];
                    DocTypeCatKey docTypeCatKey = new DocTypeCatKey(categoryRec.getInd(), n3);
                    Vector vector4 = (Vector)hashtable.get(docTypeCatKey);
                    if (vector4 != null) {
                        bl = true;
                        vector3.add(object2);
                        treeMap2.put(new String("docs." + string + "." + (String)object2), vector4);
                        ++n;
                    }
                    ++n3;
                }
                if (bl) {
                    vector.add(string);
                }
                if (vector3.size() > 0) {
                    vector3.add(0, "All");
                    DocTypeCatKey docTypeCatKey = new DocTypeCatKey(categoryRec.getInd(), -1);
                    object2 = (Vector)hashtable.get(docTypeCatKey);
                    if (object2 != null) {
                        treeMap2.put(new String("docs." + string + ".All"), object2);
                    }
                    treeMap.put(new String("docs." + string), vector3);
                }
            }
            ++n2;
        }
        if (vector2 != null) {
            treeMap.put(new String("docs.Hot news"), vector2);
        }
        return n;
    }

    private String buildDocString(TreeMap treeMap, Object object) {
        Vector vector = new Vector();
        TreeMap treeMap2 = new TreeMap();
        TreeMap treeMap3 = new TreeMap();
        Hashtable hashtable = (Hashtable)treeMap.get(object);
        String string = new String();
        if (this.getDocTypeCat(hashtable, vector, treeMap2, treeMap3, object) == 0) {
            BatchUtil.logit("No docs found for the levelKey " + object.toString(), 2001, 0);
        } else {
            Vector vector2;
            Object k;
            Set set = treeMap2.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                k = iterator.next();
                vector2 = (Vector)treeMap2.get(k);
                if (((String)k).compareTo("docs.Hot news") == 0) {
                    if (this.docLessSet != null) {
                        string = string + (String)k + "\\0" + BatchUtil.getValidLists(vector2, this.docLessSet, "{", ".html}", " ") + "\\0";
                        continue;
                    }
                    string = string + (String)k + "\\0" + BatchUtil.getLists(vector2, "{", ".html}", " ") + "\\0";
                    continue;
                }
                string = string + (String)k + "\\0" + BatchUtil.getLists(vector2, "{", "}", " ") + "\\0";
            }
            set = treeMap3.keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                k = iterator.next();
                vector2 = (Vector)treeMap3.get(k);
                string = this.docLessSet != null ? string + (String)k + "\\0" + BatchUtil.getValidLists(vector2, this.docLessSet, "{", ".html}", " ") + "\\0" : string + (String)k + "\\0" + BatchUtil.getLists(vector2, "{", ".html}", " ") + "\\0";
            }
            string = string + "doc_types" + "\\0" + BatchUtil.getLists(vector, "{", "}", " ") + "\\0";
        }
        return string;
    }

    public void saveBrand(Connection connection, BrandKey brandKey) throws WriteGdbmException {
        CategoryRec categoryRec = this.brandFamilies.getBrand(brandKey.brandInd);
        TreeSet treeSet = this.brandFamilies.getBrandFamilySet(brandKey.brandInd);
        if (categoryRec != null) {
            String string = categoryRec.toString();
            String string2 = BatchUtil.substitute(string, "IBM ", "");
            string2 = BatchUtil.substitute(string2, " ", "-");
            string2 = string2.toLowerCase();
            String string3 = string;
            String string4 = "title" + "\\0" + string + "\\0" + "template" + "\\0" + "techinfo" + "\\0" + "look" + "\\0" + string2 + "\\0" + "brand" + "\\0" + string + "\\0" + "mktg_suffix" + "\\0" + this.techtipsHack(string) + "\\0";
            if (treeSet != null) {
                String string5 = "family";
                String string6 = BatchUtil.getLists(treeSet, "{", "}", " ");
                string4 = string4 + "child_prompt" + "\\0" + string5 + "\\0" + "children" + "\\0" + string6 + "\\0";
            } else {
                BatchUtil.logit("No family found for brand " + string, 2003, 0);
            }
            string4 = string4 + this.buildDocString(Navgen.prodDocsMap, brandKey);
            BuildDb2.writeGdbm(connection, string3, string4, this.dbFileName);
        } else {
            BatchUtil.logit(" No gdbm data written for Type8 key: no brand found for BrandKey " + brandKey.brandInd, 2003, 0);
        }
    }

    public void saveFamily(Connection connection, BrandFamilyKey brandFamilyKey) throws WriteGdbmException {
        CategoryRec categoryRec = this.brandFamilies.getBrand(brandFamilyKey.brandInd);
        CategoryRec categoryRec2 = this.brandFamilies.getBrandFamily(brandFamilyKey.brandInd, brandFamilyKey.familyInd);
        if (categoryRec != null) {
            String string = categoryRec.toString();
            String string2 = categoryRec2.toString();
            String string3 = BatchUtil.substitute(string, "IBM ", "");
            string3 = BatchUtil.substitute(string3, " ", "-");
            string3 = string3.toLowerCase();
            String string4 = string + '|' + string2;
            String string5 = "title" + "\\0" + string + "\\0" + "subtitle" + "\\0" + string2 + "\\0" + "template" + "\\0" + "techinfo" + "\\0" + "look" + "\\0" + string3 + "\\0" + "brand" + "\\0" + string + "\\0" + "mktg_suffix" + "\\0" + this.techtipsHack(string) + "\\0";
            TreeSet treeSet = (TreeSet)Navgen.familyChildMap.get(brandFamilyKey);
            if (treeSet != null) {
                String string6 = "machine type";
                String string7 = BatchUtil.getLists(treeSet, "{", "}", " ");
                string5 = string5 + "child_prompt" + "\\0" + string6 + "\\0" + "children" + "\\0" + string7 + "\\0";
            } else {
                BatchUtil.logit("No machine child found for brand-family: " + string + "-" + string2, 2003, 0);
            }
            string5 = string5 + this.buildDocString(Navgen.prodDocsMap, brandFamilyKey);
            BuildDb2.writeGdbm(connection, string4, string5, this.dbFileName);
        } else {
            BatchUtil.logit(" No gdbm data written for Type9 key: no brand found for BrandKey " + brandFamilyKey.brandInd, 2003, 0);
        }
    }

    public void saveMachine(Connection connection, BFMachineKey bFMachineKey) throws WriteGdbmException {
        CategoryRec categoryRec = this.brandFamilies.getBrand(bFMachineKey.brandInd);
        CategoryRec categoryRec2 = this.brandFamilies.getBrandFamily(bFMachineKey.brandInd, bFMachineKey.familyInd);
        String string = bFMachineKey.machine;
        if (categoryRec != null) {
            String string2 = categoryRec.toString();
            String string3 = categoryRec2.toString();
            String string4 = BatchUtil.substitute(string2, "IBM ", "");
            string4 = BatchUtil.substitute(string4, " ", "-");
            string4 = string4.toLowerCase();
            String string5 = string2 + '|' + string3 + '|' + string;
            String string6 = "title" + "\\0" + string3 + "\\0" + "subtitle" + "\\0" + string + "\\0" + "template" + "\\0" + "techinfo" + "\\0" + "look" + "\\0" + string4 + "\\0" + "brand" + "\\0" + string2 + "\\0" + "mktg_suffix" + "\\0" + this.techtipsHack(string2) + "\\0";
            TreeSet treeSet = (TreeSet)Navgen.machineChildMap.get(bFMachineKey);
            if (treeSet != null) {
                String string7 = "model";
                String string8 = BatchUtil.getLists(treeSet, "{", "}", " ");
                string6 = string6 + "child_prompt" + "\\0" + string7 + "\\0" + "children" + "\\0" + string8 + "\\0";
            } else {
                BatchUtil.logit("No model found for brand|family|machine: " + string2 + "|" + string3 + "|" + string, 2003, 0);
            }
            string6 = string6 + this.buildDocString(Navgen.prodDocsMap, bFMachineKey);
            BuildDb2.writeGdbm(connection, string5, string6, this.dbFileName);
        } else {
            BatchUtil.logit(" No gdbm data written for Type10 key: no brand found for BrandKey " + bFMachineKey.brandInd, 2003, 0);
        }
    }

    public void saveModel(Connection connection, BFMModelKey bFMModelKey) throws WriteGdbmException {
        CategoryRec categoryRec = this.brandFamilies.getBrand(bFMModelKey.brandInd);
        CategoryRec categoryRec2 = this.brandFamilies.getBrandFamily(bFMModelKey.brandInd, bFMModelKey.familyInd);
        String string = bFMModelKey.machine;
        String string2 = bFMModelKey.model;
        if (categoryRec != null) {
            String string3 = categoryRec.toString();
            String string4 = categoryRec2.toString();
            String string5 = BatchUtil.substitute(string3, "IBM ", "");
            string5 = BatchUtil.substitute(string5, " ", "-");
            string5 = string5.toLowerCase();
            String string6 = string3 + '|' + string4 + '|' + string + '|' + string2;
            String string7 = "title" + "\\0" + string4 + "\\0" + "subtitle" + "\\0" + (String)Navgen.productMap.get(bFMModelKey) + "\\0" + "mtmdl" + "\\0" + string + "-" + string2 + "\\0" + "template" + "\\0" + "techinfo" + "\\0" + "look" + "\\0" + string5 + "\\0" + "brand" + "\\0" + string3 + "\\0" + "mktg_suffix" + "\\0" + this.techtipsHack(string3) + "\\0";
            string7 = string7 + this.buildDocString(Navgen.prodDocsMap, bFMModelKey);
            BuildDb2.writeGdbm(connection, string6, string7, this.dbFileName);
        } else {
            BatchUtil.logit(" No gdbm data written for Type7 key: no brand found for BrandKey " + bFMModelKey.brandInd, 2003, 0);
        }
    }

    public void saveRoot(Connection connection, TreeSet treeSet) throws WriteGdbmException {
        String string = BatchUtil.getLists(treeSet, "{", "}", " ");
        String string2 = "root";
        String string3 = "title" + "\\0" + "Welcome" + "\\0" + "template" + "\\0" + "welcome" + "\\0" + "child_prompt" + "\\0" + "brand" + "\\0" + "look" + "\\0" + "welcome" + "\\0" + "children" + "\\0" + string + "\\0";
        if (this.website.getSiteName().compareTo("ESUPPORT") != 0 && rootHotnewsVec != null && rootHotnewsVec.size() > 0) {
            string3 = this.docLessSet != null ? string3 + "doc_types" + "\\0" + "{Hot news}" + "\\0" + "docs.Hot news" + "\\0" + BatchUtil.getValidLists(rootHotnewsVec, this.docLessSet, "{", ".html}", " ") + "\\0" : string3 + "doc_types" + "\\0" + "{Hot news}" + "\\0" + "docs.Hot news" + "\\0" + BatchUtil.getLists(rootHotnewsVec, "{", ".html}", " ") + "\\0";
        }
        BuildDb2.writeGdbm(connection, string2, string3, this.dbFileName);
    }

    public void saveDocID(Connection connection, DocsEvent docsEvent) throws WriteGdbmException {
        String string;
        String string2 = string = docsEvent.getFilename();
        String string3 = "realpage" + "\\0" + string + ".html" + "\\0";
        BuildDb2.writeGdbm(connection, string2, string3, this.dbFileName);
    }

    public void saveDocID2(Connection connection, DocsEvent docsEvent) throws WriteGdbmException {
        String string = docsEvent.getFilename();
        String string2 = BatchUtil.substitute(string, "-", "");
        String string3 = "realpage" + "\\0" + string + ".html" + "\\0";
        BuildDb2.writeGdbm(connection, string2, string3, this.dbFileName);
    }

    public void saveFileName(Connection connection, DocsEvent docsEvent) throws WriteGdbmException, SQLException {
        String string = docsEvent.getReleaseDate();
        String string2 = docsEvent.getFilename() + ".html";
        String string3 = "title" + "\\0" + docsEvent.getTitle() + "\\0" + "date" + "\\0" + string + "\\0" + "faq" + "\\0" + (docsEvent.getFaq() ? "Yes" : "No") + "\\0" + "news" + "\\0" + (docsEvent.getHotNews() ? "Yes" : "No") + "\\0";
        BuildDb2.writeGdbm(connection, string2, string3, this.dbFileName);
    }

    public boolean createDbFile(String string) throws BatchException, IOException {
        try {
            Runtime runtime = Runtime.getRuntime();
            String string2 = "./";
            if (BatchInit.getCommandDir().length() > 0) {
                string2 = BatchInit.getCommandDir();
            }
            String string3 = string2 + BatchInit.getCreateDbCommand() + " -U " + BatchInit.getDbUserId() + " -P " + BatchInit.getDbUserPasswd() + " -D " + BatchInit.getDbName() + " -w " + string + " -O " + BatchInit.getGdbmFileOutPath(string);
            BatchUtil.logit("Creating db file for website " + string, 2002, 0);
            BatchUtil.logit("The command is " + string3, 2002, 0);
            Process process = runtime.exec(string3);
            BatchUtil.logit("Waiting for the process to finish " + string2 + BatchInit.getCreateDbCommand(), 2002, 0);
            int n = process.waitFor();
            String string4 = "DbGen error log message: ";
            String string5 = "DbGen log message: ";
            int n2 = 20480;
            byte[] byArray = new byte[20480];
            if (n == 0) {
                int n3 = process.getInputStream().read(byArray);
                if (n3 > 0 && n3 < 20480) {
                    string5 = string5 + new String(byArray, 0, n3);
                }
                BatchUtil.logit("DbGen finished normally. rc=" + n + " \n" + string5, 2002, 0);
                return true;
            }
            int n4 = process.getErrorStream().read(byArray);
            string4 = string4 + new String(byArray, 0, n4);
            n4 = process.getInputStream().read(byArray);
            if (n4 > 0 && n4 < 20480) {
                string5 = string5 + new String(byArray, 0, n4);
            }
            BatchUtil.logit("DbGen erro: rc=" + n + "\n" + string4 + "\n" + string5, 2004, 0);
        }
        catch (Exception exception) {
            throw new CreateDbCommandException("Error in executing DbGen: " + exception, 2004);
        }
        return false;
    }

    public void deleteGdbmEntries(Connection connection, int n) throws BatchException {
        try {
            int n2;
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT count(*) FROM navgen.gdbm g " + "WHERE g.siteind = " + n);
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
                if (n2 > 0) {
                    BatchUtil.logit("There are " + n2 + " to delete for website " + n, 2002, 0);
                    resultSet = statement.executeQuery("DELETE FROM navgen.gdbm g " + "WHERE g.siteind = " + n);
                } else {
                    BatchUtil.logit("Nothing to delete for website " + n, 2002, 0);
                }
            }
            if (n == 3 && (resultSet = statement.executeQuery("SELECT count(*) FROM navgen.gdbm g WHERE g.siteind = 9")).next()) {
                n2 = resultSet.getInt(1);
                if (n2 > 0) {
                    BatchUtil.logit("There are " + n2 + " to delete for profile", 2002, 0);
                    resultSet = statement.executeQuery("DELETE FROM navgen.gdbm g WHERE g.siteind = 9");
                } else {
                    BatchUtil.logit("Nothing to delete for profile", 2002, 0);
                }
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new BatchException("Failed to delete entries in navgen.gdbm for website " + n + sQLException, 2003);
        }
    }

    public void ftpDbFile(String string) throws BatchException, IOException {
        Ftp ftp = new Ftp();
        String string2 = BatchInit.getFtpHost(string);
        String string3 = BatchInit.getFtpHostDir(string);
        String string4 = BatchInit.getGdbmFileOutPath(string);
        String string5 = BatchInit.getFtpUserId(string);
        BatchUtil.logit("Ftp db file at " + string4, 2002, 0);
        Vector<String> vector = new Vector<String>();
        if (string.compareTo("ESUPPORT_PROFILE") == 0) {
            vector.add(BatchInit.getProfileDbFileName());
        } else {
            vector.add(BatchInit.getGdbmFileName());
        }
        BatchUtil.ftpFiles(string2, string3, string4, string5, BatchInit.getFtpPassword(string), "image", "put", vector);
    }

    public void finishProcess(BatchEvent batchEvent) throws BatchException, IOException {
        String string = this.website.getSiteName();
        boolean bl = true;
        if (bl) {
            this.ftpDbFile(string);
            if (string.compareTo("ESUPPORT") == 0) {
                this.ftpDbFile("ESUPPORT_PROFILE");
            }
            try {
                Statement statement = this.conn.createStatement();
                ResultSet resultSet = statement.executeQuery("UPDATE tigris.constants SET strconst = '" + this.tmspBefore + "' " + " WHERE constant = 'TS_BUILDDB2_" + string + "'");
                resultSet.close();
            }
            catch (SQLException sQLException) {
                throw new BatchException("Failed to update TS_BUILDDB2 constants for website " + string + sQLException, 2003);
            }
        } else {
            BatchUtil.logit("Failed to create db file for " + this.website + ". Timestamp has not been updated", 2005, 0);
        }
    }

    public void defineStaticPages(Connection connection) throws WriteGdbmException {
        String[] stringArray = new String[]{"buildhelp", "help", "profile", "search", "searchhelp", "submit_profile", "tmshelp", "hottips", "helpcenter", "logon", "resetpw", "submit_passwd", "helpwwhc"};
        int n = 0;
        while (n < 13) {
            String string = stringArray[n];
            String string2 = "template" + "\\0" + stringArray[n] + "\\0";
            BuildDb2.writeGdbm(connection, string, string2, this.dbFileName);
            ++n;
        }
    }

    public String techtipsHack(String string) {
        if (string.compareTo("IBM Aptiva") == 0) {
            return "aptiva";
        }
        if (string.compareTo("IBM Monitors") == 0) {
            return "mon";
        }
        if (string.compareTo("IBM Options") == 0) {
            return "obi";
        }
        if (string.compareTo("IBM PC") == 0) {
            return "pc";
        }
        if (string.compareTo("IBM PC Server") == 0) {
            return "pcsrv";
        }
        if (string.compareTo("IBM ThinkPad") == 0) {
            return "tp";
        }
        if (string.compareTo("Ambra") == 0) {
            return "amb";
        }
        return "";
    }

    public static native int writeDb(String var0, String var1, String var2);

    public static void writeGdbm(Connection connection, String string, String string2, String string3) throws WriteGdbmException {
        BatchUtil.logit("INSERT INTO db file VALUES (" + "'" + string + "'," + string3 + ",'" + string2 + "')", 2001, 0);
        int n = BuildDb2.writeDb(string3, string, string2);
        if (n != 0) {
            throw new WriteGdbmException("rc = " + n + ". Writing to db file " + string3 + " failed " + " with \n\tkey: " + string + "\n\tvalue: " + string2, 0);
        }
    }

    private void logLargeDoc(String string) {
        if (this.docIndCount > 33000) {
            BatchUtil.logit(string, 2002, 0);
        }
    }

    static {
        String string = System.getProperty("java.library.path");
        System.out.println("the libpath is " + string);
        BatchUtil.logit("Loading libwriteDb.so ", 2002, 0);
        System.loadLibrary("writeDb");
    }
}

