/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.batch.plugin;

import com.ibm.nzna.projects.batch.BatchInit;
import com.ibm.nzna.projects.batch.CategoryRec;
import com.ibm.nzna.projects.batch.exception.WriteGdbmException;
import com.ibm.nzna.projects.batch.intf.NavgenIntf;
import com.ibm.nzna.projects.batch.plugin.BFMModelKey;
import com.ibm.nzna.projects.batch.plugin.BFMachineKey;
import com.ibm.nzna.projects.batch.plugin.BrandFamilyKey;
import com.ibm.nzna.projects.batch.plugin.BrandKey;
import com.ibm.nzna.projects.batch.plugin.BuildDb2;
import com.ibm.nzna.projects.batch.utils.BatchUtil;
import java.sql.Connection;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;

public class BuildProfileDb {
    public static final String OPTION_BRAND = "IBM Options";
    private int website = 100;
    private Connection conn = null;
    private NavgenIntf navgen = null;
    private String dbFileName = null;
    private String[][] brandNameDefs = new String[][]{{"IBM Aptiva", "Aptiva PS/1"}, {"IBM PC", "Business PCs"}, {"IBM ThinkPad", "Notebooks and PC Companions"}, {"IBM PC Server", "Servers"}, {"IBM IntelliStation", "IntelliStation"}, {"IBM Network Station", "Network Station thin client"}, {"IBM NetVista", "NetVista"}, {"IBM NetVista thin client", "NetVista thin client"}, {"Ambra", "Ispirati"}, {"IBM Monitors", "Monitors"}};
    private Hashtable hProfileBrands = new Hashtable();

    public void buildProfileBrandsTable() {
        BatchUtil.logit("Create profile Brands table for website " + this.website, 2002, 0);
        int n = 0;
        while (n < this.brandNameDefs.length) {
            this.hProfileBrands.put(new String(this.brandNameDefs[n][0]), new String(this.brandNameDefs[n][1]));
            ++n;
        }
    }

    public void saveBrandDisplay() throws WriteGdbmException {
        BatchUtil.logit("Save brand display for website " + this.website, 2002, 0);
        int n = 0;
        while (n < this.brandNameDefs.length) {
            BuildDb2.writeGdbm(this.conn, this.brandNameDefs[n][0], this.brandNameDefs[n][1], this.dbFileName);
            ++n;
        }
    }

    private String getBrandKeysAsArray() {
        String string = "new Array(";
        int n = 0;
        while (n < this.brandNameDefs.length) {
            string = string + "\"" + this.brandNameDefs[n][0] + '|' + this.brandNameDefs[n][1] + "\"";
            if (n < this.brandNameDefs.length - 1) {
                string = string + ",";
            }
            ++n;
        }
        string = string + ");";
        return string;
    }

    private String getSetAsArray(Collection collection) {
        return "new Array(" + BatchUtil.getLists(collection, "\"", "\"", ",") + ");";
    }

    private String getOptionSelectionList(BFMachineKey bFMachineKey, TreeSet treeSet, TreeMap treeMap) {
        boolean bl = treeSet.size() == 1;
        String string = "";
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            CategoryRec categoryRec = (CategoryRec)iterator.next();
            BFMModelKey bFMModelKey = new BFMModelKey(bFMachineKey.brandInd, bFMachineKey.familyInd, bFMachineKey.machine, categoryRec.getDescript());
            string = bl ? string + "<option value=\"" + categoryRec.getDescript() + "\" selected>" : string + "<option value=\"" + categoryRec.getDescript() + "\">";
            string = string + categoryRec + "&nbsp;&nbsp;&nbsp; " + (String)treeMap.get(bFMModelKey) + "</option>\n";
        }
        return string;
    }

    public void saveBrandKeys(TreeSet treeSet, TreeMap treeMap, TreeMap treeMap2, TreeMap treeMap3, TreeMap treeMap4) throws WriteGdbmException {
        Object object;
        Object object2;
        BatchUtil.logit("Save brand keys for website " + this.website, 2002, 0);
        String string = "";
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            object2 = (CategoryRec)iterator.next();
            BatchUtil.logit("Saving for brand " + ((CategoryRec)object2).getDescript(), 2001, 0);
            if (((CategoryRec)object2).getDescript().compareTo(OPTION_BRAND) == 0) {
                this.saveOptionKeys((CategoryRec)object2, treeMap, treeMap2, treeMap3, treeMap4);
                continue;
            }
            if (this.hProfileBrands.get(((CategoryRec)object2).getDescript()) == null || !treeMap.containsKey(object = new BrandKey(((CategoryRec)object2).getInd()))) continue;
            TreeSet treeSet2 = (TreeSet)treeMap.get(object);
            string = string + "families[\"" + ((CategoryRec)object2).getDescript() + "\"] = " + this.getSetAsArray(treeSet2) + "\n";
            String string2 = "";
            Iterator iterator2 = treeSet2.iterator();
            while (iterator2.hasNext()) {
                Object object3;
                Object object4;
                CategoryRec categoryRec = (CategoryRec)iterator2.next();
                BrandFamilyKey brandFamilyKey = new BrandFamilyKey(((CategoryRec)object2).getInd(), categoryRec.getInd());
                if (!treeMap2.containsKey(brandFamilyKey)) continue;
                TreeSet treeSet3 = (TreeSet)treeMap2.get(brandFamilyKey);
                string2 = string2 + "var machines = " + this.getSetAsArray(treeSet3) + "\n" + "var models = new Array();\n";
                String string3 = "";
                Iterator iterator3 = treeSet3.iterator();
                while (iterator3.hasNext()) {
                    object4 = (CategoryRec)iterator3.next();
                    object3 = new BFMachineKey(((CategoryRec)object2).getInd(), categoryRec.getInd(), ((CategoryRec)object4).getDescript());
                    if (!treeMap3.containsKey(object3)) continue;
                    TreeSet treeSet4 = (TreeSet)treeMap3.get(object3);
                    string3 = string3 + "models[\"" + ((CategoryRec)object4).getDescript() + "\"] = " + this.getSetAsArray(treeSet4) + "\n";
                    Iterator iterator4 = treeSet4.iterator();
                    while (iterator4.hasNext()) {
                        CategoryRec categoryRec2 = (CategoryRec)iterator4.next();
                        String string4 = ((CategoryRec)object2).getDescript() + '|' + categoryRec.getDescript() + '|' + ((CategoryRec)object4).getDescript() + '|' + categoryRec2.getDescript();
                        String string5 = (String)treeMap4.get(new BFMModelKey(((CategoryRec)object2).getInd(), categoryRec.getInd(), ((CategoryRec)object4).getDescript(), categoryRec2.getDescript()));
                        BuildDb2.writeGdbm(this.conn, string4, string5, this.dbFileName);
                    }
                }
                object4 = ((CategoryRec)object2).getDescript() + '|' + categoryRec.getDescript();
                object3 = string2 + string3;
                BuildDb2.writeGdbm(this.conn, (String)object4, (String)object3, this.dbFileName);
            }
        }
        object2 = "BRANDS";
        object = "var brands = " + this.getBrandKeysAsArray() + "\n" + "var families = new Array();\n" + string;
        BuildDb2.writeGdbm(this.conn, (String)object2, (String)object, this.dbFileName);
    }

    public void saveOptionKeys(CategoryRec categoryRec, TreeMap treeMap, TreeMap treeMap2, TreeMap treeMap3, TreeMap treeMap4) throws WriteGdbmException {
        BatchUtil.logit("Save option keys for website " + this.website, 2001, 0);
        BrandKey brandKey = new BrandKey(categoryRec.getInd());
        TreeSet treeSet = (TreeSet)treeMap.get(brandKey);
        String string = "";
        String string2 = "";
        String string3 = "";
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            CategoryRec categoryRec2 = (CategoryRec)iterator.next();
            BrandFamilyKey brandFamilyKey = new BrandFamilyKey(categoryRec.getInd(), categoryRec2.getInd());
            if (!treeMap2.containsKey(brandFamilyKey)) continue;
            TreeSet treeSet2 = (TreeSet)treeMap2.get(brandFamilyKey);
            string3 = string3 + "subcat[\"" + categoryRec2.getDescript() + "\"] = " + this.getSetAsArray(treeSet2) + "\n";
            Iterator iterator2 = treeSet2.iterator();
            while (iterator2.hasNext()) {
                CategoryRec categoryRec3 = (CategoryRec)iterator2.next();
                BFMachineKey bFMachineKey = new BFMachineKey(categoryRec.getInd(), categoryRec2.getInd(), categoryRec3.getDescript());
                if (!treeMap3.containsKey(bFMachineKey)) continue;
                TreeSet treeSet3 = (TreeSet)treeMap3.get(bFMachineKey);
                string = categoryRec2.getDescript() + '|' + categoryRec3.getDescript();
                string2 = this.getOptionSelectionList(bFMachineKey, treeSet3, treeMap4);
                BuildDb2.writeGdbm(this.conn, string, string2, this.dbFileName);
                Iterator iterator3 = treeSet3.iterator();
                while (iterator3.hasNext()) {
                    CategoryRec categoryRec4 = (CategoryRec)iterator3.next();
                    string = categoryRec2.getDescript() + '|' + categoryRec3.getDescript() + '|' + categoryRec4.getDescript();
                    String string4 = (String)treeMap4.get(new BFMModelKey(categoryRec.getInd(), categoryRec2.getInd(), categoryRec3.getDescript(), categoryRec4.getDescript()));
                    BuildDb2.writeGdbm(this.conn, string, string4, this.dbFileName);
                }
            }
        }
        string = "OPTIONS";
        string2 = "var categories = " + this.getSetAsArray(treeSet) + "\n" + "var subcat = new Array();\n" + string3;
        BuildDb2.writeGdbm(this.conn, string, string2, this.dbFileName);
    }

    public BuildProfileDb() {
    }

    public BuildProfileDb(Connection connection, int n, NavgenIntf navgenIntf) {
        this.website = n;
        this.conn = connection;
        this.navgen = navgenIntf;
        try {
            this.dbFileName = BatchInit.getGdbmFile(9) + BatchInit.getProfileDbFileName();
        }
        catch (Exception exception) {
            BatchUtil.logit("Could not find db file name for profile. Use ./db.tmp ", 2002, 0);
            this.dbFileName = "./profile.db";
        }
        this.buildProfileBrandsTable();
    }
}

