/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.batch.utils;

import com.ibm.nzna.projects.batch.BatchInit;
import com.ibm.nzna.projects.batch.CategoryRec;
import com.ibm.nzna.projects.batch.exception.BatchException;
import com.ibm.nzna.projects.batch.exception.BatchFtpException;
import com.ibm.nzna.projects.batch.exception.DeleteFileException;
import com.ibm.nzna.projects.batch.exception.OutputDocException;
import com.ibm.nzna.projects.batch.plugin.DocTypeCatKey;
import com.ibm.nzna.shared.ftp.FTP.Ftp;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class BatchUtil {
    public static String substitute(String string, String string2, String string3) {
        int n = 0;
        int n2 = -1;
        int n3 = string2.length();
        String string4 = new String();
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            string4 = string4 + string.substring(n, n2);
            string4 = string4 + string3;
            n = n2 + string2.length();
        }
        if (n < string.length() - 1) {
            string4 = string4 + string.substring(n, string.length());
        }
        return string4;
    }

    public static String getCurrTime(String string) {
        Calendar calendar = Calendar.getInstance();
        String string2 = Integer.toString(calendar.get(1));
        String string3 = new String();
        String string4 = new String();
        int n = calendar.get(2) + 1;
        string3 = n <= 9 ? "0" + Integer.toString(n) : Integer.toString(n);
        n = calendar.get(5);
        string4 = n <= 9 ? "0" + Integer.toString(n) : Integer.toString(n);
        if (string.compareToIgnoreCase("m-d-y") == 0) {
            return string3 + "-" + string4 + "-" + string2;
        }
        if (string.compareToIgnoreCase("y-m-d") == 0) {
            return string2 + "-" + string3 + "-" + string4;
        }
        if (string.compareToIgnoreCase("d-m-y") == 0) {
            return string4 + "-" + string3 + "-" + string2;
        }
        return string3 + "-" + string4 + "-" + string2;
    }

    public static String getCurrTime(int n) {
        Calendar calendar = Calendar.getInstance();
        switch (n) {
            case 1: {
                return Integer.toString(calendar.get(1));
            }
            case 2: {
                int n2 = calendar.get(2) + 1;
                if (n2 <= 9) {
                    return "0" + Integer.toString(n2);
                }
                return Integer.toString(n2);
            }
            case 5: {
                int n3 = calendar.get(5);
                if (n3 <= 9) {
                    return "0" + Integer.toString(n3);
                }
                return Integer.toString(n3);
            }
        }
        return Integer.toString(calendar.get(1));
    }

    public static String getDb2Timestamp(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        int n7 = calendar.get(14);
        return Integer.toString(n) + "-" + BatchUtil.getTwoDigitIntAsString(n2) + "-" + BatchUtil.getTwoDigitIntAsString(n3) + "-" + BatchUtil.getTwoDigitIntAsString(n4) + "." + BatchUtil.getTwoDigitIntAsString(n5) + "." + BatchUtil.getTwoDigitIntAsString(n6) + "." + BatchUtil.getMilliSecAsString(n7);
    }

    public static String jstampToDb2Timestamp(Timestamp timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        return BatchUtil.getDb2Timestamp(calendar);
    }

    public static String db2stampTojstamp(String string) {
        String string2 = string.substring(0, 10) + " " + string.substring(11, 19).replace('.', ':') + ".";
        String string3 = string.substring(20, 26);
        int n = 0;
        while (n < string3.length()) {
            if (string3.charAt(n) != '0') break;
            ++n;
        }
        if (n == 6) {
            return string2 + "0";
        }
        return string2 + string3.substring(n, 6);
    }

    public static String getCompTime(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            return string4 + "-" + string2 + "-" + string3;
        }
        return string;
    }

    public static String getTwoDigitIntAsString(int n) {
        if (n <= 9) {
            return "0" + Integer.toString(n);
        }
        return Integer.toString(n);
    }

    public static String getMilliSecAsString(int n) {
        String string = Integer.toString(n);
        int n2 = string.length();
        int n3 = 0;
        while (n3 < 6 - n2) {
            string = "0" + string;
            ++n3;
        }
        return string;
    }

    public static String getLists(Object object, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Collection) {
            int n = 0;
            int n2 = ((Collection)object).size();
            Iterator iterator = ((Collection)object).iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                stringBuffer.append(string + iterator.next().toString() + string2);
                if (n < n2 - 1) {
                    stringBuffer.append(string3);
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static String getValidLists(Vector vector, TreeSet treeSet, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (vector instanceof Collection) {
            int n = 0;
            int n2 = vector.size();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                String string4 = iterator.next().toString();
                if (!treeSet.contains(string4)) {
                    stringBuffer.append(string + string4 + string2);
                    if (n < n2 - 1) {
                        stringBuffer.append(string3);
                    }
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static String getTreeMapContent(TreeMap treeMap) {
        Set set = treeMap.keySet();
        String string = "\nThe treemap Key Set =  " + BatchUtil.getLists(set, "{", "}", " ");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Set set2;
            Object k = iterator.next();
            Object v = treeMap.get(k);
            if (v instanceof Set) {
                set2 = (Set)treeMap.get(k);
                string = string + "\nTreeMap Set =  " + BatchUtil.getLists(set2, "{", "}", " ");
                continue;
            }
            if (v instanceof String) {
                string = string + "\nTreeMap String =  " + (String)v;
                continue;
            }
            if (!(v instanceof Hashtable)) continue;
            string = string + "\nTreeMap hastable with treemap key: " + k.toString();
            set2 = ((Hashtable)v).keySet();
            string = string + "\n\tHastable docCatTypeKey set = " + BatchUtil.getLists(set2, "[", "]", " ");
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                DocTypeCatKey docTypeCatKey = (DocTypeCatKey)iterator2.next();
                TreeSet treeSet = (TreeSet)((Hashtable)v).get(docTypeCatKey);
                string = string + "\n\tHastable DocIds = " + BatchUtil.getLists(treeSet, "(", ")", " ");
            }
        }
        return string;
    }

    public static String getHashtableContent(Hashtable hashtable) {
        String string = "Hastable: ";
        Set set = hashtable.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DocTypeCatKey docTypeCatKey = (DocTypeCatKey)iterator.next();
            Vector vector = (Vector)hashtable.get(docTypeCatKey);
            string = string + "\n\tKey = " + docTypeCatKey.toString() + " DocIds = " + BatchUtil.getLists(vector, "(", ")", " ");
        }
        return string;
    }

    public static String findDescript(Vector vector, int n) {
        int n2 = 0;
        while (n2 < vector.size()) {
            CategoryRec categoryRec;
            Object e = vector.elementAt(n2);
            if (e instanceof CategoryRec && n == (categoryRec = (CategoryRec)vector.elementAt(n2)).getInd()) {
                return categoryRec.getDescript();
            }
            ++n2;
        }
        return null;
    }

    public static void createDoc(String string, String string2) throws BatchException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new OutputDocException("Error creating doc " + string + ": " + exception, 2004);
        }
    }

    public static int deleteDocs(String string, Vector vector) throws BatchException {
        int n = 0;
        String string2 = "";
        try {
            int n2 = 0;
            while (n2 < vector.size()) {
                string2 = string + (String)vector.elementAt(n2);
                File file = new File(string2);
                if (file.exists()) {
                    file.delete();
                    ++n;
                    BatchUtil.logit("\nDeleted file " + string2, 2001, 0);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new DeleteFileException("Error deleting file " + string2 + ": " + exception, 2003);
        }
        return n;
    }

    public static int ftpFiles(String string, String string2, String string3, String string4, String string5, String string6, String string7, Vector vector) throws BatchFtpException {
        int n;
        block13: {
            if (string.length() == 0) {
                BatchUtil.logit("The ftp host name is not specified. Files not ftped", 2002, 0);
                return 0;
            }
            BatchUtil.logit("Host: " + string, 2002, 0);
            BatchUtil.logit("Host Dir: " + string2, 2002, 0);
            BatchUtil.logit("Local Dir: " + string3, 2002, 0);
            BatchUtil.logit("User id: " + string4, 2002, 0);
            n = 0;
            Ftp ftp = new Ftp();
            ftp.setHost(string);
            ftp.setUser(string4);
            ftp.setPassword(string5);
            try {
                BatchUtil.logit("Connecting...", 2002, 0);
                ftp.connect();
                ftp.login();
                ftp.command("SITE umask 000");
                BatchUtil.logit("Connected to " + string, 2002, 0);
                if (string6.compareToIgnoreCase("ascii") == 0) {
                    ftp.setType('A');
                    BatchUtil.logit("Transfer type set to ASCII", 2002, 0);
                } else {
                    ftp.setType('I');
                    BatchUtil.logit("Transfer type set to IMAGE", 2002, 0);
                }
                if (!ftp.isConnected()) break block13;
                ftp.cd(string2);
                BatchUtil.logit("Changed to Remote dir: " + string2, 2002, 0);
                int n2 = 0;
                while (n2 < vector.size()) {
                    String string8 = string3 + (String)vector.elementAt(n2);
                    if (string7.compareToIgnoreCase("put") == 0) {
                        try {
                            ftp.put(string8);
                            BatchUtil.logit("Put file " + string8, 2001, 0);
                            ++n;
                        }
                        catch (Exception exception) {
                            BatchUtil.logit("Error in PUT file " + string8, exception, 2004, 0);
                        }
                    } else {
                        try {
                            ftp.get((String)vector.elementAt(n2), string8);
                            BatchUtil.logit("Get file " + string8, 2001, 0);
                            ++n;
                        }
                        catch (Exception exception) {
                            BatchUtil.logit("Error in GET file " + string8, exception, 2004, 0);
                        }
                    }
                    ++n2;
                }
                ftp.disconnect();
            }
            catch (FileNotFoundException fileNotFoundException) {
                BatchUtil.logit("Host or local file/dir not found", fileNotFoundException, 2004, 0);
            }
            catch (Exception exception) {
                BatchUtil.logit("Ftp Error: ", exception, 2004, 0);
            }
        }
        return n;
    }

    public static String getLabel(int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        int n3 = calendar.get(11);
        String string = BatchUtil.getTwoDigitIntAsString(calendar.get(12));
        String string2 = BatchUtil.getTwoDigitIntAsString(calendar.get(13));
        switch (n) {
            case 2001: {
                return "D" + n3 + string + string2 + " ";
            }
            case 2002: {
                return "I" + n3 + string + string2 + " ";
            }
            case 2003: {
                return "W" + n3 + string + string2 + " ";
            }
            case 2004: {
                return "E" + n3 + string + string2 + " ";
            }
            case 2005: {
                return "F" + n3 + string + string2 + " ";
            }
        }
        return "X" + n3 + string + string2 + " ";
    }

    public static void logit(String string, int n, int n2) {
        if (n < BatchInit.getLogLevel()) {
            return;
        }
        String string2 = BatchUtil.getLabel(n, n2);
        if (n >= 2001) {
            System.out.println(string2 + string);
        }
        if (n >= 2005) {
            BatchInit.logSystem.logSevereError(string2 + string);
            ++BatchInit.batchFatal;
        } else if (n >= 2004) {
            BatchInit.logSystem.logError(string2 + string);
            ++BatchInit.batchError;
        } else if (n >= 2003) {
            BatchInit.logSystem.logProgress(string2 + string, 0, 0);
            ++BatchInit.batchWarning;
        } else if (n >= 2002) {
            BatchInit.logSystem.logProgress(string2 + string, 0, 0);
        } else {
            BatchInit.logSystem.logProgress(string2 + string, 0, 0);
        }
    }

    public static void logit(String string, Exception exception, int n, int n2) {
        if (n < BatchInit.getLogLevel()) {
            return;
        }
        String string2 = BatchUtil.getLabel(n, n2);
        if (n >= 2001) {
            exception.printStackTrace();
        }
        if (n >= 2005) {
            BatchInit.logSystem.logSevereError(string2 + string);
            BatchInit.logSystem.logSevereError(exception);
            ++BatchInit.batchFatal;
        } else if (n >= 2004) {
            BatchInit.logSystem.logSevereError(string2 + string);
            BatchInit.logSystem.logSevereError(exception);
            ++BatchInit.batchError;
        }
    }
}

