/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest;

import com.ibm.nzna.projects.common.quest.LocaleGeoRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeRec;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class LocaleRec
extends PersistentRec
implements Serializable {
    private boolean worldWide = false;
    private Vector geoVec = null;

    private void createGeoVec() {
        if (TypeList.getInstance() != null) {
            Vector vector = TypeList.getInstance().getTypeList(6);
            int n = 0;
            int n2 = 0;
            try {
                n2 = vector.size();
                this.geoVec = new Vector(n2);
                while (n < n2) {
                    if (((TypeGeoRec)vector.elementAt(n)).getInd() != 6) {
                        this.geoVec.addElement(new LocaleGeoRec((TypeGeoRec)vector.elementAt(n++)));
                        continue;
                    }
                    ++n;
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        }
    }

    private void createGeoVec(Connection connection) throws SQLException {
        TypeGeoRec typeGeoRec = null;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT GEOIND, DESCRIPT FROM TIGRIS.TYPEGEOGRAPHY FOR FETCH ONLY");
        this.geoVec = new Vector(5);
        while (resultSet.next()) {
            if (resultSet.getInt(1) == 6) continue;
            typeGeoRec = new TypeGeoRec(resultSet.getInt(1), resultSet.getString(2).trim());
            typeGeoRec.getCountryVec(connection);
            this.geoVec.addElement(new LocaleGeoRec(typeGeoRec));
        }
        resultSet.close();
        statement.close();
    }

    public int geoCount() {
        int n = 0;
        try {
            LocaleGeoRec localeGeoRec = null;
            int n2 = 0;
            int n3 = this.geoVec.size();
            while (n2 < n3) {
                localeGeoRec = (LocaleGeoRec)this.geoVec.elementAt(n2);
                if (localeGeoRec.isAll() || localeGeoRec.countryCount() > 0) {
                    ++n;
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return n;
    }

    public int countryCount() {
        int n = 0;
        try {
            LocaleGeoRec localeGeoRec = null;
            int n2 = 0;
            int n3 = this.geoVec.size();
            while (n2 < n3) {
                localeGeoRec = (LocaleGeoRec)this.geoVec.elementAt(n2);
                n += localeGeoRec.countryCount();
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return n;
    }

    private LocaleGeoRec localeGeoRecFromGeo(TypeGeoRec typeGeoRec) {
        int n = 0;
        int n2 = this.geoVec.size();
        LocaleGeoRec localeGeoRec = null;
        while (n < n2 && localeGeoRec == null) {
            if (((LocaleGeoRec)this.geoVec.elementAt(n)).equals(typeGeoRec)) {
                localeGeoRec = (LocaleGeoRec)this.geoVec.elementAt(n);
            }
            ++n;
        }
        return localeGeoRec;
    }

    private LocaleGeoRec localeGeoRecFromGeo(int n) {
        int n2 = 0;
        int n3 = this.geoVec.size();
        LocaleGeoRec localeGeoRec = null;
        while (n2 < n3 && localeGeoRec == null) {
            if (((LocaleGeoRec)this.geoVec.elementAt(n2)).getTypeGeoRec().getInd() == n) {
                localeGeoRec = (LocaleGeoRec)this.geoVec.elementAt(n2);
            }
            ++n2;
        }
        return localeGeoRec;
    }

    private void validateWorldWide() {
        int n = 0;
        int n2 = this.geoVec.size();
        boolean bl = true;
        while (n < n2 && bl) {
            bl = ((LocaleGeoRec)this.geoVec.elementAt(n++)).isAll();
        }
        if (!bl) {
            n = 0;
            while (n < n2 && !bl) {
                boolean bl2 = bl = ((LocaleGeoRec)this.geoVec.elementAt(n++)).getTypeGeoRec().getInd() == 6;
            }
        }
        this.worldWide = bl;
    }

    public void addCountry(TypeCountryCodeRec typeCountryCodeRec) {
        LocaleGeoRec localeGeoRec;
        if (typeCountryCodeRec != null && (localeGeoRec = this.localeGeoRecFromGeo(typeCountryCodeRec.getGeoInd())) != null) {
            this.updateRecStatus(1);
            localeGeoRec.addCountry(typeCountryCodeRec);
            if (localeGeoRec.isAll()) {
                this.validateWorldWide();
            }
        }
    }

    public void removeCountry(TypeCountryCodeRec typeCountryCodeRec) {
        LocaleGeoRec localeGeoRec;
        if (typeCountryCodeRec != null && (localeGeoRec = this.localeGeoRecFromGeo((TypeGeoRec)TypeList.getInstance().objectFromInd(typeCountryCodeRec.getGeoInd(), 6))) != null) {
            this.updateRecStatus(1);
            localeGeoRec.removeCountry(typeCountryCodeRec);
            this.worldWide = false;
        }
    }

    public void removeGeography(TypeGeoRec typeGeoRec) {
        LocaleGeoRec localeGeoRec = this.localeGeoRecFromGeo(typeGeoRec);
        this.updateRecStatus(1);
        localeGeoRec.removeAll();
        this.worldWide = false;
    }

    public void addGeography(TypeGeoRec typeGeoRec) {
        LocaleGeoRec localeGeoRec = this.localeGeoRecFromGeo(typeGeoRec);
        this.updateRecStatus(1);
        localeGeoRec.associateAll();
        this.validateWorldWide();
    }

    public void addGeography(int n) {
        this.addGeography((TypeGeoRec)TypeList.getInstance().objectFromInd(n, 6));
    }

    public void addCountry(int n) {
        this.addCountry((TypeCountryCodeRec)TypeList.getInstance().objectFromInd(n, 3));
    }

    public boolean isWorldWide() {
        this.validateWorldWide();
        return this.worldWide;
    }

    public Vector getCountryList() {
        Vector vector = null;
        this.validateWorldWide();
        if (this.worldWide) {
            vector = TypeList.getInstance().getTypeList(3);
        } else {
            LocaleGeoRec localeGeoRec = null;
            Vector vector2 = null;
            int n = 0;
            int n2 = this.geoVec.size();
            int n3 = 0;
            int n4 = 0;
            vector = new Vector(100, 10);
            while (n < n2) {
                localeGeoRec = (LocaleGeoRec)this.geoVec.elementAt(n);
                if (localeGeoRec.countryCount() > 0 && (vector2 = localeGeoRec.getCountryList()) != null) {
                    n3 = 0;
                    n4 = vector2.size();
                    while (n3 < n4) {
                        vector.addElement(vector2.elementAt(n3++));
                    }
                }
                ++n;
            }
        }
        return vector;
    }

    public Vector getSingleCountryList() {
        Vector vector = null;
        LocaleGeoRec localeGeoRec = null;
        Vector vector2 = null;
        int n = 0;
        int n2 = this.geoVec.size();
        int n3 = 0;
        int n4 = 0;
        vector = new Vector(100, 10);
        while (n < n2) {
            localeGeoRec = (LocaleGeoRec)this.geoVec.elementAt(n);
            if (!localeGeoRec.isAll() && localeGeoRec.countryCount() > 0 && (vector2 = localeGeoRec.getCountryList()) != null) {
                n3 = 0;
                n4 = vector2.size();
                while (n3 < n4) {
                    vector.addElement(vector2.elementAt(n3++));
                }
            }
            ++n;
        }
        return vector;
    }

    public void setWorldWide(boolean bl) {
        if (bl) {
            int n = 0;
            int n2 = this.geoVec.size();
            boolean bl2 = true;
            while (n < n2 && bl2) {
                ((LocaleGeoRec)this.geoVec.elementAt(n++)).associateAll();
            }
            this.updateRecStatus(1);
            this.worldWide = true;
        } else {
            int n = 0;
            int n3 = this.geoVec.size();
            boolean bl3 = true;
            while (n < n3 && bl3) {
                ((LocaleGeoRec)this.geoVec.elementAt(n++)).removeAll();
            }
            n = 0;
            while (n < n3) {
                if (((LocaleGeoRec)this.geoVec.elementAt(n)).getTypeGeoRec().getInd() == 6) {
                    this.geoVec.removeElementAt(n);
                    n = n3;
                }
                ++n;
            }
            this.worldWide = false;
        }
    }

    public Vector getGeoListContainingAll() {
        Vector<TypeGeoRec> vector = new Vector<TypeGeoRec>(6);
        try {
            int n = 0;
            int n2 = this.geoVec.size();
            while (n < n2) {
                if (((LocaleGeoRec)this.geoVec.elementAt(n)).isAll()) {
                    vector.addElement(((LocaleGeoRec)this.geoVec.elementAt(n)).getTypeGeoRec());
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return vector;
    }

    public Object clone() {
        LocaleRec localeRec = new LocaleRec(this);
        return localeRec;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof LocaleRec) {
            LocaleRec localeRec = (LocaleRec)object;
            bl = this.worldWide && localeRec.isWorldWide() ? true : localeRec.countryCount() == this.countryCount();
        }
        return bl;
    }

    public String getLocaleList() {
        String string = "";
        if (this.isWorldWide()) {
            string = "WorldWide";
        } else {
            Vector vector = this.getCountryList();
            if (vector != null && vector.size() > 0) {
                int n = 0;
                int n2 = vector.size();
                string = "";
                while (n < n2) {
                    string = string + ((TypeCountryCodeRec)vector.elementAt(n++)).toString() + ", ";
                }
                string = string.substring(0, string.length() - 2);
            }
        }
        return string;
    }

    public String toOut() {
        TypeRec typeRec;
        int n;
        int n2;
        String string = "Locale Information\n";
        Vector vector = this.getSingleCountryList();
        Vector vector2 = this.getGeoListContainingAll();
        string = string + "Number of Countries:   " + this.countryCount() + "\n";
        string = string + "Number of Geographies: " + this.geoCount() + "\n";
        if (vector != null && vector.size() > 0) {
            n2 = 0;
            n = vector.size();
            typeRec = null;
            string = string + "Countries:            ";
            while (n2 < n) {
                typeRec = (TypeCountryCodeRec)vector.elementAt(n2);
                string = string + typeRec.toString() + "(" + typeRec.getInd() + ")";
                if (n2 < n - 1) {
                    string = string + ",";
                }
                ++n2;
            }
            string = string + "\n";
        }
        if (vector2 != null && vector2.size() > 0) {
            n2 = 0;
            n = vector2.size();
            typeRec = null;
            string = string + "Geos with ALL Assoc.: ";
            while (n2 < n) {
                typeRec = (TypeGeoRec)vector2.elementAt(n2);
                string = string + ((TypeGeoRec)typeRec).toString() + "(" + typeRec.getInd() + ")";
                if (n2 < n - 1) {
                    string = string + ",";
                }
                ++n2;
            }
            string = string + "\n";
        }
        return string;
    }

    public LocaleRec() {
        if (this.geoVec == null) {
            this.createGeoVec();
        }
    }

    public LocaleRec(Connection connection) throws SQLException {
        this.createGeoVec(connection);
    }

    public LocaleRec(LocaleRec localeRec) {
        if (localeRec != null) {
            this.worldWide = localeRec.worldWide;
            this.updateRecStatus(0);
            this.updateRecStatus(localeRec.getRecStatus());
            if (localeRec.geoVec != null) {
                int n = 0;
                int n2 = localeRec.geoVec.size();
                this.geoVec = new Vector(n2);
                while (n < n2) {
                    this.geoVec.addElement(localeRec.geoVec.elementAt(n++));
                }
            }
        }
    }
}

