/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.doc;

import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.common.quest.doc.DocumentGraphic;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.util.LogSystem;
import java.util.Vector;

public class DocReadTest {
    private String databaseName = null;
    private String server = null;
    private String userId = null;
    private String password = null;
    private String portNumber = null;
    private int docInd = 0;

    public static void main(String[] stringArray) {
        new LogSystem(1, "DocReadTest.out");
        new DocReadTest(stringArray);
    }

    private static final void printDocument(Document document) {
        int n;
        Vector vector;
        System.out.println("TITLE:         " + document.getTitle());
        System.out.println("NOTES UID:     " + document.getUniversalNotesId());
        if (document.getDocumentBody() != null) {
            System.out.println("BODY LENGTH:   " + document.getDocumentBody().toString().length());
        } else {
            System.out.println("BODY LENGTH:   NO BODY");
        }
        System.out.println("DBUSER:        " + document.getLastTouchedBy());
        System.out.println("CHANGEDTIME:   " + document.getLastTouched());
        System.out.println("WEBABLE:       " + document.getWebable());
        System.out.println("WEBONLY:       " + document.getWebOnly());
        System.out.println("FAXABLE:       " + document.getFaxable());
        System.out.println("EMAILABLE:     " + document.getEMailable());
        System.out.println("EMAILABLEDATE: " + document.getEMailableDate());
        if (document.getCategory() != null) {
            System.out.println("CATEGORIES:    " + document.getCategory().size() + " Categories associated");
        } else {
            System.out.println("CATEGORIES:    NONE");
        }
        if (document.getFileAttachments() != null) {
            vector = document.getFileAttachments();
            System.out.println("FILE ATTACHMENTS:\n------------------\n");
            n = 0;
            while (n < vector.size()) {
                System.out.println("File:" + ((DocumentFile)vector.elementAt(n)).getFilename() + "\n   Location:" + ((DocumentFile)vector.elementAt(n)).getLocation());
                System.out.println("   Size:" + ((DocumentFile)vector.elementAt(n)).getSize());
                ++n;
            }
            System.out.println("");
        }
        if (document.getGraphics() != null) {
            vector = document.getGraphics();
            System.out.println("GRAPHICS:\n------------------\n");
            n = 0;
            while (n < vector.size()) {
                System.out.println("Filename:" + ((DocumentGraphic)vector.elementAt(n)).getFilename());
                ++n;
            }
            System.out.println("");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocReadTest(String[] stringArray) {
        try {
            this.databaseName = stringArray[0];
            this.server = stringArray[1];
            this.portNumber = stringArray[2];
            this.userId = stringArray[3];
            this.password = stringArray[4];
            this.docInd = new Integer(stringArray[5]);
        }
        catch (Exception exception) {
            System.out.println("Usage:\njava com.ibm.nzna.projects.common.quest.doc.DocReader <databaseName> <serverName> <portNumber> <userId> <password> <doc indicator>");
            System.exit(0);
        }
        try {
            DatabaseSystem databaseSystem = new DatabaseSystem(false, null, false);
            System.out.print("Connecting to Quest...");
            if (!DatabaseSystem.createConnection(1, this.databaseName, this.server, this.portNumber, this.userId, this.password)) {
                System.out.println("Could not connect to " + this.databaseName + " on " + this.server + " on port " + this.portNumber);
                return;
            }
            System.out.println("Done");
            int n = this.docInd;
            while (true) {
                if (n >= this.docInd + 5) {
                    return;
                }
                System.out.print("Reading Document :" + n);
                Document document = new Document(n);
                long l = System.currentTimeMillis();
                int n2 = document.readFromDatabase();
                if (n2 == 0) {
                    System.out.println("Done");
                } else if (n2 == 100) {
                    System.out.println("Could not find document");
                } else {
                    System.out.println("Error");
                }
                System.out.println("Total Time Taken:" + (System.currentTimeMillis() - l) + "(ms)");
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Could not connect to " + this.databaseName + " on " + this.server + " on port " + this.portNumber);
        }
    }
}

