/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.doc;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.doc.DocumentBody;
import com.ibm.nzna.projects.common.quest.doc.DocumentComment;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.common.quest.doc.DocumentProperty;
import com.ibm.nzna.projects.common.quest.doc.DocumentPropertyListener;
import com.ibm.nzna.projects.common.quest.doc.DocumentQueryText;
import com.ibm.nzna.projects.common.quest.doc.DocumentReader;
import com.ibm.nzna.projects.common.quest.doc.DocumentStatus;
import com.ibm.nzna.projects.common.quest.doc.DocumentUndoableEdit;
import com.ibm.nzna.projects.common.quest.doc.DocumentWriter;
import com.ibm.nzna.projects.common.quest.product.ProductRow;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;

public class Document
extends PersistentRec
implements Serializable {
    static final long serialVersionUID = 1000000L;
    public static final int METRIC_NOTAPPLICABLE = 0;
    public static final int METRIC_SYSTEMSUPPORTDISK = 1;
    public static final int METRIC_RETAINTIP = 2;
    public static final int METRIC_FEEDBACK = 3;
    public static final int METRIC_EDITORINPUT = 4;
    public static final int METRIC_CMVC = 5;
    public static final int METRIC_RICK = 6;
    public static final int TITLE = 1;
    public static final int BRAND = 2;
    public static final int FAMILY = 3;
    public static final int MACHINE = 4;
    public static final int MODEL = 5;
    public static final int PART_NUMBER = 6;
    public static final int FILE_ATTACHMENTS = 7;
    public static final int FAQ = 8;
    public static final int FAXABLE = 9;
    public static final int ADDITIONAL_INFO = 10;
    public static final int AUTHORITY = 11;
    public static final int APPLICABLE_BRAND = 12;
    public static final int APPLICABLE_FAMILY = 13;
    public static final int APPLICABLE_MACHINE = 14;
    public static final int APPLICABLE_SUBCATEGORY = 16;
    public static final int SUBCATEGORY = 17;
    public static final int CATEGORY = 18;
    public static final int CREATE_DATE = 19;
    public static final int DESCRIPTION = 20;
    public static final int BODY = 21;
    public static final int CLASS = 22;
    public static final int LINKS = 23;
    public static final int TYPE = 24;
    public static final int EMAILABLE = 25;
    public static final int EMAILABLEDATE = 26;
    public static final int EMAILCOMMENTS = 27;
    public static final int FILENAME = 28;
    public static final int GRAPHICS = 29;
    public static final int HOTNEWSDATE = 30;
    public static final int KNOWLEDGEBASE = 31;
    public static final int LASTTOUCHEDBY = 32;
    public static final int LASTTOUCHEDON = 33;
    public static final int LOCALE = 34;
    public static final int LOCKED = 35;
    public static final int METRIC = 36;
    public static final int MONTHS_TO_REVIEW = 37;
    public static final int OWNER = 38;
    public static final int PUBLICATION_TYPE = 39;
    public static final int QUERY_TEXT = 40;
    public static final int RECYCLED = 41;
    public static final int REFERRING_LINKS = 42;
    public static final int RELEASE_DATE = 43;
    public static final int SOURCE = 44;
    public static final int STATUS = 45;
    public static final int URL = 46;
    public static final int VERSION = 47;
    public static final int WEBABLE = 48;
    public static final int WEBONLY = 49;
    public static final int UNDO_BFTMSP_CHANGE = 50;
    public static final int UNDO_ADD_FILE = 51;
    public static final int UNDO_REMOVE_FILE = 52;
    private Vector undoableEdits = null;
    private boolean undoEnabled = false;
    private boolean fireEventEnabled = true;
    protected int docInd = 0;
    private String title = null;
    private String owner = null;
    private boolean maintLock = false;
    private boolean recycled = false;
    private String source = null;
    private boolean locked = false;
    private String filename = null;
    private Vector commentHistory = null;
    private String partNumber = null;
    private String lastTouchedBy = null;
    private String description = null;
    private String lastTouched = null;
    private DocumentQueryText queryText = null;
    private DocumentBody body = null;
    private boolean webable = true;
    private boolean webOnly = false;
    private boolean faxable = false;
    private boolean hotNews = false;
    private String hotNewsDate = null;
    private boolean eMailable = false;
    private String eMailableDate = null;
    private boolean faq = false;
    private boolean knowledgeBase = false;
    private int monthsToReview = 12;
    private String eMailComments = "";
    private String additionalInfo = null;
    private int docClass = 1;
    private int documentType = 4;
    private int publicationType = 0;
    private int metric = 0;
    private int authority = 0;
    private DocumentStatus status = null;
    private Vector graphics = null;
    private Vector fileAttachments = null;
    private Vector categories = null;
    private Vector properties = null;
    private Vector documentLinks = null;
    private Vector referringDocumentLinks = null;
    private LocaleRec locale = null;
    private Vector brands = null;
    private Vector families = null;
    private Vector machines = null;
    private Vector models = null;
    protected boolean brandUpdated = false;
    protected boolean familyUpdated = false;
    protected boolean machineUpdated = false;
    protected boolean modelUpdated = false;
    private Vector appliedFamilies = null;
    private Vector appliedBrands = null;
    private Vector appliedMachines = null;
    private Vector appliedSubCategories = null;
    private Vector listeners = null;

    public final void setDocumentLinks(Vector vector) {
        this.documentLinks = vector;
        this.firePropertyChanged(23);
    }

    public final Vector getDocumentLinks() {
        if (this.documentLinks != null) {
            return (Vector)this.documentLinks.clone();
        }
        return new Vector();
    }

    public final void setReferringDocumentLinks(Vector vector) {
        this.referringDocumentLinks = vector;
        this.firePropertyChanged(42);
    }

    public final Vector getReferringDocumentLinks() {
        if (this.referringDocumentLinks != null) {
            return (Vector)this.referringDocumentLinks.clone();
        }
        return new Vector();
    }

    public final int getDocInd() {
        return this.docInd;
    }

    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(String string) throws IllegalArgumentException {
        int n = 254;
        if (this.title == null) {
            this.title = "";
        }
        if (string != null && string.length() <= n) {
            if (this.title == null || !this.title.equals(string)) {
                this.addUndo(1, this.title);
                this.title = string.trim();
                this.updateRecStatus(1);
                this.firePropertyChanged(1);
            }
        } else {
            throw new IllegalArgumentException("TITLE cannot be NULL or longer than " + n + " characters");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setOwner(String string) throws IllegalArgumentException {
        int n = 8;
        if (string != null) {
            if (string.length() > n) throw new IllegalArgumentException("OWNER cannot be NULL or longer than " + n + " characters. Current Length:" + string.length());
            if (this.owner != null && this.owner.equals(string)) return;
            this.addUndo(38, this.owner);
            this.owner = string.trim();
            this.updateRecStatus(1);
            this.firePropertyChanged(38);
            return;
        } else {
            this.owner = "";
        }
    }

    public final String getOwner() {
        return this.owner;
    }

    public final void setSource(String string) throws IllegalArgumentException {
        if (this.source == null) {
            this.source = "";
        }
        if (string != null) {
            if (!this.source.equals(string)) {
                this.addUndo(44, this.source);
                this.source = string.trim();
                this.firePropertyChanged(44);
                this.updateRecStatus(1);
            }
        } else {
            this.source = null;
        }
    }

    public final String getSource() {
        return this.source;
    }

    public final void setFilename(String string) {
        if (this.filename == null) {
            if (string != null) {
                this.filename = string.trim();
                this.firePropertyChanged(28);
            } else {
                this.filename = null;
            }
        }
    }

    protected void generateFilename() {
        if (this.filename == null || this.filename.length() == 0) {
            this.filename = "MIGR-" + this.docInd;
            this.updateRecStatus(1);
        }
    }

    public final String getFilename() {
        return this.filename;
    }

    public final String getLastTouchedBy() {
        return this.lastTouchedBy;
    }

    public final void setLastTouchedBy(String string) throws IllegalArgumentException {
        int n = 8;
        if (string != null && string.length() <= n) {
            if (this.lastTouchedBy == null || !this.lastTouchedBy.equals(string)) {
                this.lastTouchedBy = string.trim();
                this.updateRecStatus(1);
                this.firePropertyChanged(32);
            }
        } else {
            throw new IllegalArgumentException("Last Touched By cannot be NULL or longer than " + n + " characters. Tried to set " + string);
        }
    }

    public final String getLastTouched() {
        return this.lastTouched;
    }

    protected final void setLastTouched(String string) {
        if (string != null) {
            this.lastTouched = string.trim();
            this.firePropertyChanged(33);
        } else {
            this.lastTouched = null;
        }
    }

    public final DocumentQueryText getQueryText() {
        return this.queryText;
    }

    public final void setQueryText(DocumentQueryText documentQueryText) throws IllegalArgumentException {
        if (documentQueryText == null) {
            throw new IllegalArgumentException("QUERYTEXT cannot be NULL");
        }
        this.addUndo(40, this.queryText);
        this.queryText = documentQueryText;
        this.firePropertyChanged(40);
    }

    public final DocumentBody getDocumentBody() {
        return this.body;
    }

    public final void setDocumentBody(DocumentBody documentBody) {
        this.addUndo(21, this.body);
        this.body = documentBody;
        this.firePropertyChanged(21);
    }

    public final void setWebable(boolean bl) {
        this.addUndo(48, new Boolean(this.webable));
        if (this.webable != bl) {
            this.webable = bl;
            this.updateRecStatus(1);
            this.firePropertyChanged(48);
        }
    }

    public final void setWebOnly(boolean bl) {
        this.addUndo(49, new Boolean(this.webOnly));
        if (this.webOnly != bl) {
            this.webOnly = bl;
            this.updateRecStatus(1);
            this.firePropertyChanged(49);
        }
    }

    public final boolean getWebable() {
        return this.webable;
    }

    public final boolean getWebOnly() {
        return this.webOnly;
    }

    public final void setFaxable(boolean bl) {
        this.addUndo(9, new Boolean(this.faxable));
        if (this.faxable != bl) {
            this.faxable = bl;
            this.updateRecStatus(1);
            this.firePropertyChanged(9);
        }
    }

    public final boolean getFaxable() {
        return this.faxable;
    }

    public final void setHotNewsDate(String string) {
        this.addUndo(30, this.hotNewsDate);
        this.hotNewsDate = string;
        boolean bl = this.hotNews = string != null;
        if (string != null) {
            if (string.charAt(2) != '/' && string.charAt(2) != '-') {
                string = CDate.createDate(CDate.parse(string, 7, 10), CDate.parse(string, 8, 10), CDate.parse(string, 9, 10), 0, 0, 0, 2);
            }
            this.hotNewsDate = string.trim();
            this.firePropertyChanged(30);
        }
    }

    public final boolean getHotNews() {
        return this.hotNews;
    }

    public final String getHotNewsDate() {
        return this.hotNewsDate;
    }

    public final void setEMailable(boolean bl) {
        this.addUndo(25, new Boolean(this.eMailable));
        if (this.eMailable != bl) {
            this.eMailable = bl;
            this.updateRecStatus(1);
            this.firePropertyChanged(25);
        }
    }

    public final boolean getEMailable() {
        return this.eMailable;
    }

    public final void setEMailableDate(String string) {
        this.addUndo(26, this.eMailableDate);
        if (string == null) {
            this.eMailableDate = string;
            this.eMailable = false;
            this.updateRecStatus(1);
            this.firePropertyChanged(26);
        } else {
            if (string.charAt(2) != '-' && string.charAt(2) != '/') {
                string = CDate.createDate(CDate.parse(string, 7, 10), CDate.parse(string, 8, 10), CDate.parse(string, 9, 10), 0, 0, 0, 2);
            }
            this.eMailableDate = string;
            this.updateRecStatus(1);
            this.firePropertyChanged(26);
        }
    }

    public final String getEMailableDate() {
        return this.eMailableDate;
    }

    public final void setFaq(boolean bl) {
        this.addUndo(8, new Boolean(this.faq));
        if (this.faq != bl) {
            this.faq = bl;
            this.updateRecStatus(1);
            this.firePropertyChanged(8);
        }
    }

    public final boolean getFaq() {
        return this.faq;
    }

    public final void setKnowledgeBase(boolean bl) {
        this.addUndo(31, new Boolean(this.knowledgeBase));
        if (this.knowledgeBase != bl) {
            this.knowledgeBase = bl;
            this.updateRecStatus(1);
            this.firePropertyChanged(31);
        }
    }

    public final boolean getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public final void setMonthsToReview(int n) {
        this.addUndo(37, new Integer(this.monthsToReview));
        if (this.monthsToReview != n) {
            this.monthsToReview = n;
            this.updateRecStatus(1);
            this.firePropertyChanged(37);
        }
    }

    public final int getMonthsToReview() {
        return this.monthsToReview;
    }

    public final void setEMailComments(String string) throws IllegalArgumentException {
        int n = 1000;
        if (string != null) {
            if (string.length() <= n) {
                if (this.eMailComments == null || !this.eMailComments.equals(string)) {
                    this.addUndo(27, this.eMailComments);
                    this.eMailComments = string.trim();
                    this.updateRecStatus(1);
                    this.firePropertyChanged(27);
                }
            } else {
                throw new IllegalArgumentException("SUMMARY cannot be NULL or longer than " + n + " characters");
            }
        }
    }

    public final String getEMailComments() {
        return this.eMailComments;
    }

    public final void setDocumentClass(int n) {
        if (this.docClass != n) {
            this.addUndo(22, new Integer(this.docClass));
            this.docClass = n;
            this.updateRecStatus(1);
            this.firePropertyChanged(22);
        }
    }

    public final int getDocumentClass() {
        return this.docClass;
    }

    public final void setDocumentType(int n) {
        if (this.documentType != n) {
            this.addUndo(24, new Integer(this.documentType));
            this.documentType = n;
            this.updateRecStatus(1);
            this.firePropertyChanged(24);
        }
    }

    public final int getDocumentType() {
        return this.documentType;
    }

    public final void setPublicationType(int n) throws IllegalArgumentException {
        if (n != this.publicationType) {
            this.addUndo(39, new Integer(this.publicationType));
            this.publicationType = n;
            this.updateRecStatus(1);
            this.firePropertyChanged(39);
        }
    }

    public final int getPublicationType() {
        return this.publicationType;
    }

    public final void setMetric(int n) {
        if (this.metric != n) {
            this.addUndo(36, new Integer(this.metric));
            this.metric = n;
            this.updateRecStatus(1);
            this.firePropertyChanged(36);
        }
    }

    public final int getMetric() {
        return this.metric;
    }

    public final void setAuthority(int n) {
        if (this.authority != n) {
            this.authority = n;
            this.updateRecStatus(1);
            this.firePropertyChanged(11);
        }
    }

    public final int getAuthority() {
        return this.authority;
    }

    public final void setStatus(DocumentStatus documentStatus) {
        this.addUndo(45, this.status);
        this.status = documentStatus;
        this.firePropertyChanged(45);
    }

    public final DocumentStatus getStatus() {
        return this.status;
    }

    public final Vector getGraphics() {
        Vector vector = null;
        if (this.graphics != null) {
            vector = (Vector)this.graphics.clone();
        }
        return vector;
    }

    public final void setGraphics(Vector vector) {
        this.graphics = vector;
        this.firePropertyChanged(29);
    }

    public final Vector getFileAttachments() {
        Vector vector = null;
        if (this.fileAttachments != null) {
            vector = (Vector)this.fileAttachments.clone();
        }
        return vector;
    }

    public final void setFileAttachments(Vector vector) {
        this.addUndo(7, this.fileAttachments);
        this.fileAttachments = vector;
        this.firePropertyChanged(7);
    }

    public final void setCategory(Vector vector) {
        if (vector != null) {
            this.addUndo(18, this.categories);
        } else {
            this.addUndo(18, new Vector(1));
        }
        this.categories = (Vector)vector.clone();
        this.updateRecStatus(1);
        this.firePropertyChanged(18);
    }

    public final Vector getCategory() {
        if (this.categories != null) {
            return (Vector)this.categories.clone();
        }
        return null;
    }

    public void generateKeys() {
        if (this.docInd == 0) {
            this.docInd = Counter.getCounter(LogSystem.getInstance(), "DOCIND");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readFromDatabase() {
        String string = "readFromDatabase";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        int n = 0;
        Connection connection = sQLMethod.getConnection();
        try {
            n = DocumentReader.readDocument(connection, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        sQLMethod.close();
        return n;
    }

    public final String getPartNumber() {
        return this.partNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setPartNumber(String string) throws IllegalArgumentException {
        if (string != null) {
            if (string.length() > 50) throw new IllegalArgumentException("Part Number cannot exceed 50 bytes");
            this.addUndo(6, this.partNumber);
            this.partNumber = string.trim();
            this.updateRecStatus(1);
            this.firePropertyChanged(6);
            return;
        } else {
            this.partNumber = null;
            this.updateRecStatus(1);
        }
    }

    public final String getAdditionalInfo() {
        return this.additionalInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setAdditionalInfo(String string) throws IllegalArgumentException {
        if (string != null) {
            if (string.length() > Short.MAX_VALUE) throw new IllegalArgumentException("Additional Information cannot exceed 32,767 bytes");
            this.addUndo(10, this.additionalInfo);
            this.additionalInfo = string.trim();
            this.updateRecStatus(1);
            this.firePropertyChanged(10);
            return;
        } else {
            this.additionalInfo = null;
            this.updateRecStatus(1);
        }
    }

    public final boolean getLocked(String string) {
        if (string != null && this.lastTouchedBy != null) {
            return this.locked && this.lastTouchedBy.equals(string);
        }
        return this.locked;
    }

    public final void setReleaseDate(String string) {
        if (string != null) {
            DocumentProperty documentProperty = this.getProperty(3);
            this.addUndo(43, documentProperty.getValue());
            documentProperty.setValue(CDate.createDate(CDate.parse(string, 7, 2), CDate.parse(string, 8, 2), CDate.parse(string, 9, 2), 0, 0, 0, 10));
            this.firePropertyChanged(43);
        }
    }

    public final String getReleaseDate() {
        return this.getProperty(3).getValue();
    }

    public final void setURL(String string) {
        if (string != null) {
            DocumentProperty documentProperty = this.getProperty(7);
            this.addUndo(46, documentProperty.getValue());
            documentProperty.setValue(string);
            this.firePropertyChanged(46);
        }
    }

    public final String getURL() {
        return this.getProperty(7).getValue();
    }

    public final void setVersion(String string) {
        if (string != null) {
            DocumentProperty documentProperty = this.getProperty(8);
            this.addUndo(47, documentProperty.getValue());
            documentProperty.setValue(string);
            this.firePropertyChanged(47);
        }
    }

    public final String getVersion() {
        return this.getProperty(8).getValue();
    }

    public final void setDescription(String string) {
        int n = 0;
        int n2 = string.length();
        String string2 = null;
        int n3 = 1;
        DocumentProperty documentProperty = null;
        this.addUndo(20, this.getDescription());
        this.removeProperty(2);
        boolean bl = true;
        while (bl) {
            if (n + 254 > n2) {
                string2 = string.substring(n);
                bl = false;
            } else {
                string2 = string.substring(n, n + 254);
                n += 254;
            }
            documentProperty = new DocumentProperty(this.getDocInd());
            documentProperty.setPropertyInd(2);
            documentProperty.setOrderNum(n3);
            documentProperty.setValue(string2);
            this.addProperty(documentProperty);
            ++n3;
        }
        this.description = string;
        this.firePropertyChanged(20);
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setCreateDate(String string) {
        if (string != null) {
            DocumentProperty documentProperty = this.getProperty(5);
            documentProperty.setValue(CDate.createDate(CDate.parse(string, 7, 2), CDate.parse(string, 8, 2), CDate.parse(string, 9, 2), 0, 0, 0, 10));
            this.firePropertyChanged(19);
        }
    }

    public final String getCreateDate() {
        return this.getProperty(5).getValue();
    }

    protected void setUniversalNotesId(String string) {
        if (string != null) {
            DocumentProperty documentProperty = this.getProperty(1);
            documentProperty.setValue(string);
        }
    }

    public final String getUniversalNotesId() {
        return this.getProperty(1).getValue();
    }

    private final DocumentProperty getProperty(int n) {
        Integer n2 = new Integer(n);
        DocumentProperty documentProperty = null;
        int n3 = 0;
        if (this.properties != null) {
            int n4 = this.properties.size();
            while (n3 < n4 && documentProperty == null) {
                if (((DocumentProperty)this.properties.elementAt(n3)).equals(n2)) {
                    documentProperty = (DocumentProperty)this.properties.elementAt(n3);
                }
                ++n3;
            }
        }
        if (documentProperty == null) {
            documentProperty = new DocumentProperty(this.docInd);
            documentProperty.setPropertyInd(n);
            if (this.properties == null) {
                this.properties = new Vector(10);
            }
            this.properties.addElement(documentProperty);
        }
        return documentProperty;
    }

    public void initializeProperties(Document document) {
        this.docInd = document.docInd;
        this.title = document.title;
        this.owner = document.owner;
        this.source = document.source;
        this.locked = document.locked;
        this.filename = document.filename;
        this.partNumber = document.partNumber;
        this.lastTouchedBy = document.lastTouchedBy;
        this.maintLock = document.maintLock;
        this.description = document.description;
        this.lastTouched = document.lastTouched;
        this.queryText = document.queryText;
        this.webable = document.webable;
        this.webOnly = document.webOnly;
        this.faxable = document.faxable;
        this.hotNews = document.hotNews;
        this.hotNewsDate = document.hotNewsDate;
        this.eMailable = document.eMailable;
        this.eMailableDate = document.eMailableDate;
        this.faq = document.faq;
        this.knowledgeBase = document.knowledgeBase;
        this.monthsToReview = document.monthsToReview;
        this.eMailComments = document.eMailComments;
        this.additionalInfo = document.additionalInfo;
        this.docClass = document.docClass;
        this.documentType = document.documentType;
        this.publicationType = document.publicationType;
        this.metric = document.metric;
        this.authority = document.authority;
        if (document.commentHistory != null) {
            this.commentHistory = (Vector)document.commentHistory.clone();
        }
        if (document.status != null) {
            this.status = new DocumentStatus(this.docInd, document.status.getStatus(), document.status.getStatusDate());
        }
        if (document.body != null) {
            this.body = (DocumentBody)document.body.clone();
        }
        if (document.locale != null) {
            this.locale = document.getLocale();
        }
        if (document.graphics != null) {
            this.graphics = (Vector)document.graphics.clone();
        }
        if (document.fileAttachments != null) {
            this.fileAttachments = (Vector)document.fileAttachments.clone();
        }
        if (document.categories != null) {
            this.categories = (Vector)document.categories.clone();
        }
        if (document.properties != null) {
            this.properties = (Vector)document.properties.clone();
        }
        if (document.documentLinks != null) {
            this.documentLinks = (Vector)document.documentLinks.clone();
        }
        if (document.referringDocumentLinks != null) {
            this.referringDocumentLinks = (Vector)document.referringDocumentLinks.clone();
        }
        if (document.appliedBrands != null) {
            this.appliedBrands = (Vector)document.appliedBrands.clone();
        }
        if (document.appliedFamilies != null) {
            this.appliedFamilies = (Vector)document.appliedFamilies.clone();
        }
        if (document.appliedMachines != null) {
            this.appliedMachines = (Vector)document.appliedMachines.clone();
        }
        if (document.appliedSubCategories != null) {
            this.appliedSubCategories = (Vector)document.appliedSubCategories.clone();
        }
        if (document.brands != null) {
            this.brands = (Vector)document.brands.clone();
        }
        if (document.families != null) {
            this.families = (Vector)document.families.clone();
        }
        if (document.machines != null) {
            this.machines = (Vector)document.machines.clone();
        }
        if (document.models != null) {
            this.models = (Vector)document.models.clone();
        }
        if (document instanceof DocumentDraft) {
            this.docInd = ((DocumentDraft)document).getExistingDocInd();
        }
        this.forceRecStatus(document.getRecStatus());
    }

    protected void forceRecStatus(int n) {
        this.updateRecStatus(0);
        this.updateRecStatus(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeToDatabase() {
        int n = -1;
        try {
            this.generateKeys();
            this.generateFilename();
            return DocumentWriter.writeToDatabase(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public final LocaleRec getLocale() {
        if (this.locale == null) {
            this.locale = new LocaleRec();
        }
        return (LocaleRec)this.locale.clone();
    }

    public final void setLocale(LocaleRec localeRec) {
        if (this.locale != null) {
            this.addUndo(34, this.locale);
        } else {
            this.addUndo(34, new LocaleRec());
        }
        this.locale = localeRec;
        this.firePropertyChanged(34);
    }

    public void addFileAttachment(DocumentFile documentFile) {
        if (this.fileAttachments == null) {
            this.fileAttachments = new Vector(1);
        }
        this.fileAttachments.addElement(documentFile);
    }

    public void removeFileAttachment(DocumentFile documentFile) {
        if (this.fileAttachments != null) {
            documentFile.updateRecStatus(3);
        }
    }

    public final void setRecycled(boolean bl) {
        this.recycled = bl;
        this.updateRecStatus(0);
        this.firePropertyChanged(41);
    }

    public final boolean getRecycled() {
        return this.recycled;
    }

    public final Vector getBrands() {
        return this.brands;
    }

    public final Vector getFamilies() {
        return this.families;
    }

    public final Vector getMachines() {
        return this.machines;
    }

    public final Vector getModels() {
        return this.models;
    }

    public final void setBrands(Vector vector) {
        this.addBFTMUndo();
        this.brands = vector;
        this.brandUpdated = true;
        this.firePropertyChanged(2);
    }

    public final void setFamilies(Vector vector) {
        this.addBFTMUndo();
        this.families = vector;
        this.familyUpdated = true;
        this.firePropertyChanged(3);
    }

    public final void setMachines(Vector vector) {
        this.addBFTMUndo();
        this.machines = vector;
        this.machineUpdated = true;
        this.firePropertyChanged(4);
    }

    public final void setModels(Vector vector) {
        this.addBFTMUndo();
        this.models = vector;
        this.modelUpdated = true;
        this.firePropertyChanged(5);
    }

    public final Vector getApplicableBrands() {
        return this.appliedBrands;
    }

    public final Vector getApplicableFamilies() {
        return this.appliedFamilies;
    }

    public final Vector getApplicableMachines() {
        return this.appliedMachines;
    }

    public final Vector getApplicableSubCategories() {
        return this.appliedSubCategories;
    }

    public final void setApplicableBrands(Vector vector) {
        this.appliedBrands = vector;
        this.firePropertyChanged(12);
    }

    public final void setApplicableMachines(Vector vector) {
        this.appliedMachines = vector;
        this.firePropertyChanged(14);
    }

    public final void setApplicableFamilies(Vector vector) {
        this.appliedFamilies = vector;
        this.firePropertyChanged(13);
    }

    public final void setApplicableSubCategories(Vector vector) {
        this.appliedSubCategories = vector;
        this.firePropertyChanged(16);
    }

    public void addDocumentPropertyListener(DocumentPropertyListener documentPropertyListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.addElement(documentPropertyListener);
    }

    public void removeDocumentPropertyListener(DocumentPropertyListener documentPropertyListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(documentPropertyListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    protected void firePropertyChanged(int n) {
        if (this.listeners != null && this.fireEventEnabled) {
            Document document = this;
            if (document == null) {
                throw null;
            }
            document.new FireThread(this, n, this.listeners);
        }
    }

    public void addProduct(TypeCategoryRec typeCategoryRec) {
        this.addProduct(typeCategoryRec, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addProduct(TypeCategoryRec typeCategoryRec, boolean bl) {
        if (typeCategoryRec == null) return;
        if (!typeCategoryRec.getCategoryLevel().equals("model")) {
            if (!typeCategoryRec.getCategoryLevel().equals("partnum")) return;
        }
        if (this.models == null) {
            this.models = new Vector(1);
        }
        try {
            if (this.models.contains(typeCategoryRec)) return;
            TypeCategoryRec typeCategoryRec2 = null;
            TypeCategoryRec typeCategoryRec3 = null;
            TypeCategoryRec typeCategoryRec4 = null;
            typeCategoryRec2 = typeCategoryRec.getCategoryLevel().equals("partnum") ? TypeCategory.getParentCategory(typeCategoryRec, "subcategory") : TypeCategory.getParentCategory(typeCategoryRec, "machine");
            typeCategoryRec3 = TypeCategory.getParentCategory(typeCategoryRec, "family");
            typeCategoryRec4 = TypeCategory.getParentCategory(typeCategoryRec, "brand");
            this.models.addElement(typeCategoryRec);
            if (this.appliedBrands == null) {
                this.appliedBrands = new Vector(1);
            }
            if (!this.appliedBrands.contains(typeCategoryRec4)) {
                this.appliedBrands.addElement(typeCategoryRec4);
            }
            if (this.appliedFamilies == null) {
                this.appliedFamilies = new Vector(1);
            }
            if (!this.appliedFamilies.contains(typeCategoryRec3)) {
                this.appliedFamilies.addElement(typeCategoryRec3);
            }
            if (typeCategoryRec2.getCategoryLevel().equals("machine")) {
                if (this.appliedMachines == null) {
                    this.appliedMachines = new Vector(1);
                }
                if (!this.appliedMachines.contains(typeCategoryRec2)) {
                    this.appliedMachines.addElement(typeCategoryRec2);
                }
            } else {
                if (this.appliedSubCategories == null) {
                    this.appliedSubCategories = new Vector(1);
                }
                if (!this.appliedSubCategories.contains(typeCategoryRec2)) {
                    this.appliedSubCategories.addElement(typeCategoryRec2);
                }
            }
            if (!bl) return;
            this.firePropertyChanged(5);
            this.firePropertyChanged(12);
            this.firePropertyChanged(13);
            this.firePropertyChanged(14);
            this.firePropertyChanged(16);
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    public void addProducts(Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                this.addProduct((TypeCategoryRec)vector.elementAt(n), false);
                ++n;
            }
            this.firePropertyChanged(5);
            this.firePropertyChanged(12);
            this.firePropertyChanged(13);
            this.firePropertyChanged(14);
            this.firePropertyChanged(16);
        }
    }

    public void addProductRows(Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            ProductRow productRow = null;
            while (n < n2) {
                productRow = (ProductRow)vector.elementAt(n);
                this.addProduct(productRow.getModel(), false);
                ++n;
            }
            this.firePropertyChanged(5);
            this.firePropertyChanged(12);
            this.firePropertyChanged(13);
            this.firePropertyChanged(14);
            this.firePropertyChanged(16);
        }
    }

    public Object clone() {
        Document document = new Document(this.getDocInd());
        document.initializeProperties(this);
        return document;
    }

    public void setPropertyChangeEnabled(boolean bl) {
        this.fireEventEnabled = bl;
    }

    public void enableUndo(boolean bl) {
        this.undoEnabled = bl;
    }

    public void writeToMemory() {
        this.undoableEdits = null;
    }

    public Vector getUndoableEdits() {
        return this.undoableEdits;
    }

    protected void addUndo(int n, Object object) {
        if (this.undoEnabled && object != null) {
            if (this.undoableEdits == null) {
                this.undoableEdits = new Vector(1);
            }
            this.undoableEdits.addElement(new DocumentUndoableEdit(n, object));
        }
    }

    private final void addBFTMUndo() {
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
        if (this.brands != null) {
            hashtable.put("BRANDS", this.brands);
        }
        if (this.families != null) {
            hashtable.put("FAMILIES", this.families);
        }
        if (this.machines != null) {
            hashtable.put("MACHINES", this.machines);
        }
        if (this.models != null) {
            hashtable.put("MODELS", this.models);
        }
    }

    public TypeCategoryRec getFirstAvailBrand() {
        TypeCategoryRec typeCategoryRec = null;
        if (this.brands != null && this.brands.size() > 0) {
            typeCategoryRec = (TypeCategoryRec)this.brands.elementAt(0);
        } else if (this.appliedBrands != null && this.appliedBrands.size() > 0) {
            typeCategoryRec = (TypeCategoryRec)this.appliedBrands.elementAt(0);
        }
        return typeCategoryRec;
    }

    protected void setDocInd(int n) {
        this.docInd = n;
    }

    protected void clearFilename() {
        this.filename = null;
    }

    public DocumentUndoableEdit undo() {
        DocumentUndoableEdit documentUndoableEdit = null;
        if (this.undoableEdits != null && this.undoableEdits.size() > 0) {
            boolean bl = this.undoEnabled;
            int n = this.undoableEdits.size() - 1;
            documentUndoableEdit = (DocumentUndoableEdit)this.undoableEdits.elementAt(n);
            this.undoEnabled = false;
            documentUndoableEdit.undo(this);
            this.undoEnabled = bl;
            this.undoableEdits.removeElementAt(n);
        }
        return documentUndoableEdit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkOut(String string) {
        if (this.docInd != 0) {
            SQLMethod sQLMethod = new SQLMethod(1, "Document.checkOut ( " + string + " )", 5);
            try {
                Statement statement = sQLMethod.createStatement();
                statement.executeUpdate("UPDATE TIGRIS.DOCUMENTS SET MAINTLOCK = 'Y' WHERE DOCIND = " + this.docInd);
                statement.executeUpdate("DELETE FROM TIGRIS.DOCPROPERTIES WHERE DOCIND = " + this.docInd + " AND " + "PROPERTYIND = " + 9);
                statement.executeUpdate("INSERT INTO TIGRIS.DOCPROPERTIES " + "(DOCIND, PROPERTYIND, ORDERNUM, VALUE, DBUSER, CHANGEDTIME) " + "values " + "(" + this.docInd + ", " + 9 + ", 0, '" + string + "', 'QUEST', CURRENT TIMESTAMP)");
                statement.close();
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                sQLMethod.rollBack();
            }
            sQLMethod.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkIn() {
        if (this.docInd != 0) {
            SQLMethod sQLMethod = new SQLMethod(1, "Document.checkIn ()", 5);
            try {
                Statement statement = sQLMethod.createStatement();
                statement.executeUpdate("UPDATE TIGRIS.DOCUMENTS SET MAINTLOCK = 'N' WHERE DOCIND = " + this.docInd);
                statement.executeUpdate("DELETE FROM TIGRIS.DOCPROPERTIES WHERE DOCIND = " + this.docInd + " AND " + "PROPERTYIND = " + 9);
                statement.close();
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                sQLMethod.rollBack();
            }
            sQLMethod.close();
        }
    }

    public boolean isCheckedOut() {
        return this.maintLock;
    }

    public String getCheckedOutBy() {
        DocumentProperty documentProperty = this.getProperty(9);
        if (documentProperty != null) {
            return documentProperty.getValue();
        }
        return null;
    }

    protected void setMaintLock(String string) {
        this.maintLock = string.equals("Y");
    }

    protected void setCheckedOutBy(String string) {
        if (string != null) {
            DocumentProperty documentProperty = this.getProperty(9);
            documentProperty.setValue(string);
        }
    }

    public Vector getProperties() {
        return this.properties;
    }

    private final void removeProperty(int n) {
        if (this.properties != null && this.properties.size() > 0) {
            int n2 = 0;
            int n3 = this.properties.size();
            while (n2 < n3) {
                if (((DocumentProperty)this.properties.elementAt(n2)).getPropertyInd() == n) {
                    this.properties.removeElementAt(n2);
                    --n3;
                    continue;
                }
                ++n2;
            }
        }
    }

    public void addProperty(DocumentProperty documentProperty) {
        if (this.properties == null) {
            this.properties = new Vector(1);
        }
        this.properties.addElement(documentProperty);
    }

    public Vector getCommentHistory() {
        return this.commentHistory;
    }

    protected void addCommentToHistory(DocumentComment documentComment) {
        if (this.commentHistory == null) {
            this.commentHistory = new Vector(1);
        }
        this.commentHistory.addElement(documentComment);
    }

    public String getCommentHistoryAsText() {
        Vector vector = this.getCommentHistory();
        String string = "";
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                string = string + ((DocumentComment)vector.elementAt(n)).getComment() + "\n\n";
                ++n;
            }
        }
        return string;
    }

    public Document() {
        this.updateRecStatus(2);
    }

    public Document(int n) {
        this.docInd = n;
        this.updateRecStatus(1);
    }

    public class FireThread
    implements Runnable {
        int property = 0;
        Vector listeners = null;
        Document document = null;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            int n = 0;
            int n2 = this.listeners.size();
            while (n < n2) {
                try {
                    ((DocumentPropertyListener)this.listeners.elementAt(n)).documentChanged(this.document, this.property);
                }
                catch (Exception exception) {
                }
                ++n;
            }
        }

        public FireThread(Document document2, int n, Vector vector) {
            this.document = document2;
            this.property = n;
            this.listeners = vector;
            new Thread(this).start();
        }
    }
}

