/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.doc;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.doc.CreateDocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraftWriter;
import com.ibm.nzna.projects.common.quest.doc.DocumentStatus;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class DocumentDraft
extends Document
implements Serializable {
    static final long serialVersionUID = 1000000L;
    public static final int COMMENTS = 100;
    public static final int REQUESTOR = 101;
    public static final int WORK_REQUIRED = 102;
    private String startDate = null;
    private String stopDate = null;
    private String requestor = null;
    private String comments = "";
    private String originalComments = "";
    private int existingDocInd = 0;
    private int workRequired = 0;
    private boolean template = false;

    public int writeToDatabase() {
        try {
            this.generateKeys();
            this.generateFilename();
            return DocumentDraftWriter.writeToDatabase(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static CreateDocumentDraft createDraft(int n) {
        CreateDocumentDraft createDocumentDraft = null;
        DocumentDraft documentDraft = null;
        int n2 = DocumentDraft.draftExists(n);
        block0 : switch (n2) {
            case 0: {
                Document document = new Document(n);
                int n3 = document.readFromDatabase();
                if (n3 == 0) {
                    documentDraft = new DocumentDraft();
                    documentDraft.initializeProperties(document);
                    createDocumentDraft = new CreateDocumentDraft(4, 0, documentDraft);
                    break;
                }
                LogSystem.log(1, "DocumentDraft.createDraft ( " + n + " ): Could not read Existing Document. Return Code:" + n3);
                createDocumentDraft = new CreateDocumentDraft(0, 0, null);
                break;
            }
            case -1: {
                LogSystem.log(1, "DocumentDraft.createDraft ( " + n + " ): Could not find Draft Document.");
                createDocumentDraft = new CreateDocumentDraft(0, 0, null);
                documentDraft = null;
                break;
            }
            default: {
                int n4 = 0;
                documentDraft = new DocumentDraft(n2);
                n4 = documentDraft.readFromDatabase();
                switch (n4) {
                    case 0: {
                        documentDraft.forceRecStatus(0);
                        if (documentDraft.getRecycled()) {
                            createDocumentDraft = new CreateDocumentDraft(2, 0, documentDraft);
                            break block0;
                        }
                        createDocumentDraft = new CreateDocumentDraft(1, 0, documentDraft);
                        break block0;
                    }
                    case 100: {
                        LogSystem.log(1, "DocumentDraft.createDraft ( " + n + " ): Wierd, found draft " + n2 + " for existing document, but can't read it! rc 100");
                        documentDraft = null;
                        createDocumentDraft = new CreateDocumentDraft(0, 0, null);
                        break block0;
                    }
                }
                LogSystem.log(1, "DocumentDraft.createDraft ( " + n + " ): Read Draft Document " + n2 + ". rc:" + n4);
                createDocumentDraft = new CreateDocumentDraft(5, n4, null);
                documentDraft = null;
                break;
            }
        }
        if (createDocumentDraft == null) {
            LogSystem.log(1, "DocumentDraft.createDraft ( " + n + " ) could not figure out what to do");
            createDocumentDraft = new CreateDocumentDraft(0, 0, null);
        }
        return createDocumentDraft;
    }

    public static CreateDocumentDraft createDraft(Document document) {
        CreateDocumentDraft createDocumentDraft = null;
        DocumentDraft documentDraft = null;
        int n = document.getDocInd();
        int n2 = DocumentDraft.draftExists(n);
        block0 : switch (n2) {
            case 0: {
                documentDraft = new DocumentDraft();
                documentDraft.initializeProperties(document);
                documentDraft.setStartDate(new CDate(2).today());
                documentDraft.existingDocInd = n;
                documentDraft.docInd = 0;
                documentDraft.setWorkRequired(2);
                documentDraft.updateRecStatus(0);
                documentDraft.updateRecStatus(2);
                createDocumentDraft = new CreateDocumentDraft(4, 0, documentDraft);
                break;
            }
            case -1: {
                LogSystem.log(1, "DocumentDraft.createDraft ( " + n + " ): Could not find Draft Document.");
                createDocumentDraft = new CreateDocumentDraft(0, 0, null);
                documentDraft = null;
                break;
            }
            default: {
                int n3 = 0;
                documentDraft = new DocumentDraft(n2);
                n3 = documentDraft.readFromDatabase();
                switch (n3) {
                    case 0: {
                        documentDraft.forceRecStatus(0);
                        if (documentDraft.getRecycled()) {
                            createDocumentDraft = new CreateDocumentDraft(2, 0, documentDraft);
                            break block0;
                        }
                        createDocumentDraft = new CreateDocumentDraft(1, 0, documentDraft);
                        break block0;
                    }
                    case 100: {
                        LogSystem.log(1, "DocumentDraft.createDraft ( " + n + " ): Wierd, found draft " + n2 + " for existing document, but can't read it! rc 100");
                        documentDraft = null;
                        createDocumentDraft = new CreateDocumentDraft(0, 0, null);
                        break block0;
                    }
                }
                LogSystem.log(1, "DocumentDraft.createDraft ( " + n + " ): Read Draft Document " + n2 + ". rc:" + n3);
                createDocumentDraft = new CreateDocumentDraft(5, n3, null);
                documentDraft = null;
                break;
            }
        }
        if (createDocumentDraft == null) {
            LogSystem.log(1, "DocumentDraft.createDraft ( " + n + " ) could not figure out what to do");
            createDocumentDraft = new CreateDocumentDraft(0, 0, null);
        }
        return createDocumentDraft;
    }

    public static int draftExists(int n) {
        SQLMethod sQLMethod = new SQLMethod(1, "draftExists (" + n + ")", 5);
        int n2 = -1;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DOCIND " + "FROM QUEST.DOCUMENTS " + "WHERE STOPDATE IS NULL AND " + "      EXISTINGDOCIND = " + n + " " + "FOR FETCH ONLY");
            n2 = resultSet.next() ? resultSet.getInt(1) : 0;
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return n2;
    }

    public void setWorkRequired(int n) {
        super.firePropertyChanged(102);
        this.addUndo(102, new Integer(n));
        this.workRequired = n;
    }

    public int getWorkRequired() {
        return this.workRequired;
    }

    public void generateKeys() {
        if (this.docInd == 0) {
            this.docInd = Counter.getCounter(LogSystem.getInstance(), "DOCREQIND");
        }
        if (this.existingDocInd == 0) {
            this.existingDocInd = Counter.getCounter(LogSystem.getInstance(), "DOCIND");
        }
        if (this.getFilename() == null || this.getFilename().length() == 0) {
            this.setFilename("MIGR-" + this.existingDocInd);
        }
    }

    protected void setStartDate(String string) {
        this.startDate = string != null ? string.trim() : new CDate(2).today();
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStopDate(String string) {
        if (string != null) {
            this.stopDate = string.trim();
        }
    }

    public void setRequestor(String string) {
        this.requestor = string != null ? string.trim() : "";
        this.addUndo(101, this.requestor);
        this.firePropertyChanged(101);
    }

    public String getRequestor() {
        return this.requestor;
    }

    public String getStopDate() {
        return this.stopDate;
    }

    public void setComments(String string) {
        if (string != null) {
            this.addUndo(100, this.comments);
            this.comments = string.trim();
            this.firePropertyChanged(100);
        }
    }

    public String getOriginalComments() {
        return this.originalComments;
    }

    protected void setOriginalComments(String string) {
        this.originalComments = string;
    }

    public String getComments() {
        return this.comments;
    }

    protected void setExistingDocInd(int n) {
        this.existingDocInd = n;
    }

    public int getExistingDocInd() {
        return this.existingDocInd;
    }

    public int readFromDatabase() {
        int n;
        SQLMethod sQLMethod;
        block6: {
            String string = "readFromDatabase";
            sQLMethod = new SQLMethod(1, string, 5);
            n = 0;
            if (sQLMethod != null) {
                try {
                    CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.DocDraftReader", 3);
                    callableStatement.setInt(1, this.getDocInd());
                    callableStatement.registerOutParameter(2, -4);
                    callableStatement.registerOutParameter(3, -4);
                    LogSystem.log(1, "Reading Document:" + this.getDocInd());
                    callableStatement.execute();
                    StoredProcRec storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
                    if (storedProcRec != null && storedProcRec.error) {
                        LogSystem.beginLogSection("DocumentReader Returned Error");
                        LogSystem.log(1, "sqlCode:   " + storedProcRec.sqlCode);
                        LogSystem.log(1, "userError: " + storedProcRec.userError);
                        LogSystem.log(1, "errorStr:  " + storedProcRec.errorStr);
                        LogSystem.log(1, "error:     " + storedProcRec.error);
                        try {
                            n = new Integer(storedProcRec.sqlCode);
                        }
                        catch (Exception exception) {
                            LogSystem.log(1, "Cannot translate retRec.sqlCode to Integer for RC");
                        }
                        LogSystem.endLogSection();
                        break block6;
                    }
                    int n2 = this.getDocInd();
                    this.initializeProperties((DocumentDraft)StoredProcUtil.getObjectFromStatement(callableStatement, 2));
                    this.docInd = n2;
                    n = 0;
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(1, exception, false);
                    n = -1;
                }
            }
        }
        sQLMethod.close();
        return n;
    }

    public void initializeProperties(Document document) {
        super.initializeProperties(document);
        if (document instanceof DocumentDraft) {
            DocumentDraft documentDraft = (DocumentDraft)document;
            this.startDate = documentDraft.startDate;
            this.stopDate = documentDraft.stopDate;
            this.requestor = documentDraft.requestor;
            this.comments = documentDraft.comments;
            this.template = documentDraft.template;
            this.existingDocInd = documentDraft.existingDocInd;
            this.workRequired = documentDraft.workRequired;
            this.originalComments = documentDraft.originalComments;
        } else {
            this.existingDocInd = document.getDocInd();
        }
    }

    public void setTemplate(boolean bl) {
        this.template = bl;
    }

    public boolean getTemplate() {
        return this.template;
    }

    public Object clone() {
        DocumentDraft documentDraft = new DocumentDraft(this.getDocInd());
        documentDraft.initializeProperties(this);
        return documentDraft;
    }

    public void createNew() {
        this.setDocInd(0);
        this.existingDocInd = 0;
        this.clearFilename();
        this.generateKeys();
        if (this.getStatus() != null) {
            this.getStatus().setDocInd(this.getExistingDocInd());
        }
        this.updateRecStatus(0);
        this.updateRecStatus(2);
        this.workRequired = 1;
    }

    public void checkOut(String string) {
        if (this.existingDocInd != 0) {
            super.checkOut(string);
        }
        if (this.docInd != 0) {
            SQLMethod sQLMethod = new SQLMethod(1, "Document.checkOut ( " + string + " )", 5);
            try {
                Statement statement = sQLMethod.createStatement();
                statement.executeUpdate("UPDATE QUEST.DOCUMENTS SET MAINTLOCK = 'Y' WHERE DOCIND = " + this.docInd);
                statement.executeUpdate("DELETE FROM QUEST.DOCPROPERTIES WHERE DOCIND = " + this.docInd + " AND " + "PROPERTYIND = " + 9);
                statement.executeUpdate("INSERT INTO QUEST.DOCPROPERTIES " + "(DOCIND, PROPERTYIND, ORDERNUM, VALUE, DBUSER, CHANGEDTIME) " + "values " + "(" + this.docInd + ", " + 9 + ", 0, '" + string + "', 'QUEST', CURRENT TIMESTAMP)");
                statement.close();
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                sQLMethod.rollBack();
            }
            sQLMethod.close();
        }
    }

    public void checkIn() {
        if (this.existingDocInd != 0) {
            super.checkIn();
        }
        if (this.docInd != 0) {
            SQLMethod sQLMethod = new SQLMethod(1, "Document.checkIn ()", 5);
            try {
                Statement statement = sQLMethod.createStatement();
                statement.executeUpdate("UPDATE QUEST.DOCUMENTS SET MAINTLOCK = 'N' WHERE DOCIND = " + this.docInd);
                statement.executeUpdate("DELETE FROM QUEST.DOCPROPERTIES WHERE DOCIND = " + this.docInd + " AND " + "PROPERTYIND = " + 9);
                statement.close();
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                sQLMethod.rollBack();
            }
            sQLMethod.close();
        }
    }

    public DocumentDraft(int n) {
        super(n);
        if (n == 0) {
            this.setWorkRequired(1);
            this.setStatus(new DocumentStatus(n, 10, new CDate(2).today()));
            this.setStartDate(new CDate(2).today());
        }
    }

    public DocumentDraft(DocumentDraft documentDraft) {
        this.initializeProperties(documentDraft);
        this.docInd = 0;
        this.existingDocInd = 0;
        this.template = false;
        this.clearFilename();
        this.updateRecStatus(0);
        this.updateRecStatus(2);
        this.setStartDate(new CDate(2).today());
    }

    public DocumentDraft() {
        this.setDocumentClass(1);
        this.setWorkRequired(1);
        this.setStatus(new DocumentStatus(0, 10, new CDate(2).today()));
        this.setStartDate(new CDate(2).today());
    }
}

