/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.doc;

import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentBody;
import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.common.quest.doc.DocumentQueryText;
import com.ibm.nzna.projects.common.quest.doc.DocumentStatus;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class DocumentUndoableEdit
implements Serializable {
    private int propertyInd = 0;
    private Object data = null;

    public String toString() {
        return "Document Undo - " + this.getPresentationName() + "\n   Property:" + this.propertyInd + "\n   data:" + this.data;
    }

    public boolean canRedo() {
        return false;
    }

    public void die() {
        this.data = null;
    }

    public String getPresentationName() {
        return this.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        return "";
    }

    public String getUndoPresentationName() {
        String string = null;
        switch (this.propertyInd) {
            case 1: {
                string = "Title Change";
                break;
            }
            case 50: {
                string = "BFTMSP Change";
                break;
            }
            case 51: {
                string = "Add File";
                break;
            }
            case 52: {
                string = "Remove File";
                break;
            }
            case 8: {
                string = "FAQ Change";
                break;
            }
            case 9: {
                string = "Faxable Change";
                break;
            }
            case 10: {
                string = "Additional Info Change";
                break;
            }
            case 11: {
                string = "Authority Change";
                break;
            }
            case 18: {
                string = "Category Change";
                break;
            }
            case 20: {
                string = "Description Change";
                break;
            }
            case 21: {
                string = "Body Change";
                break;
            }
            case 22: {
                string = "Classification Change";
                break;
            }
            case 24: {
                string = "Type Change";
                break;
            }
            case 25: {
                string = "eMailable Change";
                break;
            }
            case 26: {
                string = "eMailable Date Change";
                break;
            }
            case 27: {
                string = "eMail Comments Change";
                break;
            }
            case 30: {
                string = "Hot News Date Change";
                break;
            }
            case 31: {
                string = "Online Assistant Change";
                break;
            }
            case 34: {
                string = "Location Change";
                break;
            }
            case 36: {
                string = "Metric Change";
                break;
            }
            case 37: {
                string = "Months To Review Change";
                break;
            }
            case 38: {
                string = "Owner Change";
                break;
            }
            case 39: {
                string = "Publication Type Change";
                break;
            }
            case 40: {
                string = "Query Text Change";
                break;
            }
            case 43: {
                string = "Release Date Change";
                break;
            }
            case 44: {
                string = "Source Change";
                break;
            }
            case 45: {
                string = "Status Change";
                break;
            }
            case 46: {
                string = "URL Change";
                break;
            }
            case 47: {
                string = "Version Change";
                break;
            }
            case 48: {
                string = "Webable Change";
                break;
            }
            case 49: {
                string = "Web Only Change";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public void undo(Document document) {
        switch (this.propertyInd) {
            case 1: {
                System.out.println("UNdoing title. Setting new title to " + this.data);
                document.setTitle((String)this.data);
                break;
            }
            case 50: {
                Vector vector = (Vector)((Hashtable)this.data).get("BRANDS");
                Vector vector2 = (Vector)((Hashtable)this.data).get("FAMILIES");
                Vector vector3 = (Vector)((Hashtable)this.data).get("MACHINES");
                Vector vector4 = (Vector)((Hashtable)this.data).get("MODELS");
                document.setBrands(vector);
                document.setModels(vector4);
                document.setFamilies(vector2);
                document.setMachines(vector3);
                break;
            }
            case 51: {
                document.addFileAttachment((DocumentFile)this.data);
                break;
            }
            case 52: {
                document.removeFileAttachment((DocumentFile)this.data);
                break;
            }
            case 8: {
                document.setFaq((Boolean)this.data);
                break;
            }
            case 9: {
                document.setFaxable((Boolean)this.data);
                break;
            }
            case 10: {
                document.setAdditionalInfo((String)this.data);
                break;
            }
            case 18: {
                System.out.println("Undoing Category. Size:" + ((Vector)this.data).size());
                document.setCategory((Vector)this.data);
                break;
            }
            case 20: {
                document.setDescription((String)this.data);
                break;
            }
            case 21: {
                document.setDocumentBody((DocumentBody)this.data);
                break;
            }
            case 22: {
                document.setDocumentClass((Integer)this.data);
                break;
            }
            case 24: {
                document.setDocumentType((Integer)this.data);
                break;
            }
            case 25: {
                document.setEMailable((Boolean)this.data);
                break;
            }
            case 26: {
                document.setEMailableDate((String)this.data);
                break;
            }
            case 27: {
                document.setEMailComments((String)this.data);
                break;
            }
            case 30: {
                document.setHotNewsDate((String)this.data);
                break;
            }
            case 31: {
                document.setKnowledgeBase((Boolean)this.data);
                break;
            }
            case 34: {
                System.out.println("Undoing locale. Country Count:" + ((LocaleRec)this.data).countryCount());
                document.setLocale((LocaleRec)this.data);
                break;
            }
            case 36: {
                document.setMetric((Integer)this.data);
                break;
            }
            case 37: {
                document.setMonthsToReview((Integer)this.data);
                break;
            }
            case 38: {
                document.setOwner((String)this.data);
                break;
            }
            case 39: {
                document.setPublicationType((Integer)this.data);
                break;
            }
            case 40: {
                document.setQueryText((DocumentQueryText)this.data);
                break;
            }
            case 43: {
                document.setReleaseDate((String)this.data);
                break;
            }
            case 44: {
                document.setSource((String)this.data);
                break;
            }
            case 45: {
                document.setStatus((DocumentStatus)this.data);
                break;
            }
            case 46: {
                document.setURL((String)this.data);
                break;
            }
            case 47: {
                document.setVersion((String)this.data);
                break;
            }
            case 48: {
                document.setWebable((Boolean)this.data);
                break;
            }
            case 49: {
                document.setWebOnly((Boolean)this.data);
                break;
            }
        }
    }

    public boolean isSignificant() {
        return true;
    }

    public void redo() {
    }

    public boolean canUndo() {
        return true;
    }

    public DocumentUndoableEdit(int n, Object object) {
        this.propertyInd = n;
        this.data = object;
    }
}

