/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.doc;

import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.common.quest.doc.DocumentGraphic;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.util.LogSystem;
import java.util.Vector;

public class DraftReadTest {
    private String databaseName = null;
    private String server = null;
    private String userId = null;
    private String password = null;
    private String portNumber = null;
    private int docInd = 0;

    public static void main(String[] stringArray) {
        new LogSystem(1, "DraftReadTest.out");
        new DraftReadTest(stringArray);
    }

    private static final void printDocument(DocumentDraft documentDraft) {
        int n;
        Vector vector;
        System.out.println("DOCIND:        " + documentDraft.getDocInd());
        System.out.println("TITLE:         " + documentDraft.getTitle());
        System.out.println("Start Date:    " + documentDraft.getStartDate());
        System.out.println("Stop Date:     " + documentDraft.getStopDate());
        if (documentDraft.getDocumentBody() != null) {
            System.out.println("BODY LENGTH:   " + documentDraft.getDocumentBody().toString().length());
        } else {
            System.out.println("BODY LENGTH:   NO BODY");
        }
        System.out.println("DBUSER:        " + documentDraft.getLastTouchedBy());
        System.out.println("CHANGEDTIME:   " + documentDraft.getLastTouched());
        System.out.println("WEBABLE:       " + documentDraft.getWebable());
        System.out.println("WEBONLY:       " + documentDraft.getWebOnly());
        System.out.println("FAXABLE:       " + documentDraft.getFaxable());
        System.out.println("EMAILABLE:     " + documentDraft.getEMailable());
        System.out.println("EMAILABLEDATE: " + documentDraft.getEMailableDate());
        if (documentDraft.getCategory() != null) {
            System.out.println("CATEGORIES:    " + documentDraft.getCategory().size() + " Categories associated");
        } else {
            System.out.println("CATEGORIES:    NONE");
        }
        if (documentDraft.getFileAttachments() != null) {
            vector = documentDraft.getFileAttachments();
            System.out.println("FILE ATTACHMENTS:\n------------------\n");
            n = 0;
            while (n < vector.size()) {
                System.out.println("File:" + ((DocumentFile)vector.elementAt(n)).getFilename() + "\n   Location:" + ((DocumentFile)vector.elementAt(n)).getLocation());
                System.out.println("   Size:" + ((DocumentFile)vector.elementAt(n)).getSize());
                ++n;
            }
            System.out.println("");
        }
        if (documentDraft.getGraphics() != null) {
            vector = documentDraft.getGraphics();
            System.out.println("GRAPHICS:\n------------------\n");
            n = 0;
            while (n < vector.size()) {
                System.out.println("Filename:" + ((DocumentGraphic)vector.elementAt(n)).getFilename());
                ++n;
            }
            System.out.println("");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DraftReadTest(String[] stringArray) {
        try {
            this.databaseName = stringArray[0];
            this.server = stringArray[1];
            this.portNumber = stringArray[2];
            this.userId = stringArray[3];
            this.password = stringArray[4];
            this.docInd = new Integer(stringArray[5]);
        }
        catch (Exception exception) {
            System.out.println("Usage:\njava com.ibm.nzna.projects.common.quest.doc.DocReader <databaseName> <serverName> <portNumber> <userId> <password> <doc indicator>");
            System.exit(0);
        }
        try {
            DatabaseSystem databaseSystem = new DatabaseSystem(false, null, false);
            if (!DatabaseSystem.createConnection(1, this.databaseName, this.server, this.portNumber, this.userId, this.password)) {
                System.out.println("Could not connect to " + this.databaseName + " on " + this.server + " on port " + this.portNumber);
                return;
            }
            int n = this.docInd;
            while (true) {
                if (n >= this.docInd + 5) {
                    return;
                }
                DocumentDraft documentDraft = new DocumentDraft(n);
                long l = System.currentTimeMillis();
                int n2 = documentDraft.readFromDatabase();
                if (n2 == 0) {
                    DraftReadTest.printDocument(documentDraft);
                } else if (n2 == 100) {
                    System.out.println("Could not find document");
                } else {
                    System.out.println("Error");
                }
                System.out.println("Total Time Taken:" + (System.currentTimeMillis() - l) + "(ms)");
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Could not connect to " + this.databaseName + " on " + this.server + " on port " + this.portNumber);
        }
    }
}

